/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class ProcedureList
extends List
implements CommandListener {
    PCalc calc;
    Displayable parent;
    Procedure proc;

    ProcedureList(PCalc pCalc, Displayable displayable, Procedure procedure) {
        super(procedure.name + " procedures", 3);
        this.calc = pCalc;
        this.parent = displayable;
        this.proc = procedure;
        Procedure procedure2 = procedure;
        while (true) {
            for (int i = 0; i < procedure2.subprocs.length; ++i) {
                String string = procedure2 == procedure || procedure == procedure2.subprocs[i] ? procedure2.subprocs[i].name : procedure2.name + '.' + procedure2.subprocs[i].name;
                this.append(string, null);
            }
            if (procedure2.top == null) break;
            procedure2 = procedure2.top;
        }
        this.append(procedure2.name, null);
        this.setCommandListener(this);
        this.addCommand(PCalc.ADD_CMD);
        this.addCommand(PCalc.EDIT_CMD);
        this.addCommand(PCalc.RENAME_CMD);
        this.addCommand(PCalc.DELETE_CMD);
        this.addCommand(PCalc.DONE_CMD);
        Display.getDisplay((MIDlet)pCalc).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        int n;
        if (command == PCalc.DONE_CMD) {
            Display.getDisplay((MIDlet)this.calc).setCurrent(this.parent);
        } else if (command == PCalc.ADD_CMD) {
            if (this.proc.subprocs.length < 256) {
                new AddProcedure(this.calc, this, this.proc);
            } else {
                this.calc.showError("Limit for maximal number of subprocedures is reached", (Displayable)this);
            }
        } else if (command == PCalc.RENAME_CMD) {
            if (n >= this.proc.subprocs.length) {
                this.calc.showError("Only self subprocedures can be renamed", (Displayable)this);
            } else {
                new RenameProcedure(this.calc, this, this.proc, n);
            }
        } else if (command == PCalc.DELETE_CMD) {
            if (n >= this.proc.subprocs.length) {
                this.calc.showError("Only self subprocedures can be removed", (Displayable)this);
            } else if (this.proc.subprocs[n].subprocs.length != 0) {
                this.calc.showError("Procedure with subprocedures can not be removed", (Displayable)this);
            } else if (!this.proc.removeSubproc(n)) {
                this.calc.showError("Procedure is used", (Displayable)this);
            } else {
                this.delete(n);
            }
        } else {
            Procedure procedure = this.proc;
            for (n = this.getSelectedIndex(); n >= procedure.subprocs.length; n -= procedure.subprocs.length) {
                if (procedure.top == null) {
                    new EditProcedure(this.calc, this.parent, procedure);
                    return;
                }
                procedure = procedure.top;
            }
            new EditProcedure(this.calc, this.parent, procedure.subprocs[n]);
        }
    }
}

