/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

class JMove {
    byte ep;
    byte from;
    byte target;
    byte captured;
    byte promoted;
    byte castled;
    byte cap_num;
    static int current;
    static int[] start;
    static int[] num_moves;
    static JMove[] move_table;
    static int[] move_ordering_table;
    static int max_moves_used;
    static byte[] s_mate;
    static byte[] s_mate_t;
    static byte[][] Book_openings;
    static int nr_of_openings;
    static boolean[] Book_validOpening;
    static String Book_nameOpening;
    static JMove Book_openingMove;
    static boolean Book_HaveValidOpenings;
    static byte Book_moveIndex;
    static int nr_book_moves;
    static byte[] bookMoves;
    static int uniqueOpening;
    static int first_nr_appearances;
    static int second_nr_appearances;
    static int third_nr_appearances;
    static int nr_to_moves;
    static byte[] toMoves;
    static int to_first;
    static int to_second;
    static int to_third;
    static int[] rep_history;
    static short[] history_h;
    static byte[] fifty_history;

    JMove() {
    }

    static int push_table() {
        JMove.start[JMove.current + 1] = start[current] + num_moves[current];
        return start[++current];
    }

    static void add_moves(int n) {
        int n2 = current;
        num_moves[n2] = num_moves[n2] + n;
        if (start[current] + num_moves[current] > max_moves_used) {
            max_moves_used = start[current] + num_moves[current];
        }
    }

    static void pop_table() {
        JMove.num_moves[JMove.current] = 0;
        --current;
    }

    static JMove moves(int n) {
        return move_table[start[current] + n];
    }

    static long move_ordering(int n) {
        return move_ordering_table[start[current] + n];
    }

    static int start_index() {
        return start[current];
    }

    void Copy(JMove jMove) {
        this.ep = jMove.ep;
        this.from = jMove.from;
        this.target = jMove.target;
        this.captured = jMove.captured;
        this.promoted = jMove.promoted;
        this.castled = jMove.castled;
        this.cap_num = jMove.cap_num;
    }

    public static boolean RecordStore(boolean bl) {
        int n = 0;
        boolean bl2 = true;
        RecordStore recordStore = null;
        try {
            int n2;
            byte[] byArray;
            recordStore = RecordStore.openRecordStore((String)"CM_Settings", (boolean)true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            if (bl) {
                byte[] byArray2 = new byte[16];
                byte by = (byte)(cGame.stats & 3);
                by = (byte)(by + (byte)((cGame.soundType & 3) << 2));
                by = (byte)(by + (byte)((cGame.layout ? 1 : 0) << 4));
                by = (byte)(by + (byte)((cGame.whiteOnTop ? 1 : 0) << 5));
                by = (byte)(by + (byte)((cGame.bHintsAreOn ? 1 : 0) << 6));
                by = (byte)(by + (byte)((cGame.bShowLastMove ? 1 : 0) << 7));
                byArray2[n++] = by;
                byArray2[n++] = (byte)(cGame.recordScoreQuiz >> 56 & 0xFFL);
                byArray2[n++] = (byte)(cGame.recordScoreQuiz >> 48 & 0xFFL);
                byArray2[n++] = (byte)(cGame.recordScoreQuiz >> 40 & 0xFFL);
                byArray2[n++] = (byte)(cGame.recordScoreQuiz >> 32 & 0xFFL);
                byArray2[n++] = (byte)(cGame.recordScoreQuiz >> 24 & 0xFFL);
                byArray2[n++] = (byte)(cGame.recordScoreQuiz >> 16 & 0xFFL);
                byArray2[n++] = (byte)(cGame.recordScoreQuiz >> 8 & 0xFFL);
                byArray2[n++] = (byte)(cGame.recordScoreQuiz & 0xFFL);
                n = JMove.saveGameInfo(byArray2, n);
                if (recordEnumeration.hasNextElement()) {
                    int n3 = recordEnumeration.nextRecordId();
                    recordStore.setRecord(n3, byArray2, 0, byArray2.length);
                } else {
                    recordStore.addRecord(byArray2, 0, byArray2.length);
                }
            } else if (recordEnumeration.hasNextElement() && (byArray = recordStore.getRecord(n2 = recordEnumeration.nextRecordId())) != null && byArray.length >= 16) {
                byte by = byArray[n++];
                cGame.stats = by & 3;
                cGame.soundType = (byte)(by >> 2 & 3);
                cGame.layout = (by >> 4 & 1) == 1;
                cGame.whiteOnTop = (by >> 5 & 1) == 1;
                cGame.bHintsAreOn = (by >> 6 & 1) == 1;
                cGame.bShowLastMove = (by >> 7 & 1) == 1;
                for (int i = 0; i < 8; ++i) {
                    cGame.recordScoreQuiz = (cGame.recordScoreQuiz << 8) + (long)(byArray[n++] & 0xFF);
                }
                n = JMove.loadGameInfo(byArray, n, false);
            }
            recordEnumeration.destroy();
            recordEnumeration = null;
        }
        catch (Exception exception) {
            bl2 = false;
        }
        try {
            if (recordStore != null) {
                recordStore.closeRecordStore();
            }
            recordStore = null;
        }
        catch (Exception exception) {
            bl2 = false;
        }
        System.gc();
        return bl2;
    }

    static int setPagesAndRows(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = 22;
        int n5 = 0;
        if (byArray == null) {
            return n5;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < byArray.length && byArray[n3] != 0; ++n3) {
            if (byArray[n3] == 13) {
                stringBuffer.append(' ');
                continue;
            }
            if (byArray[n3] == 10) continue;
            stringBuffer.append((char)byArray[n3]);
        }
        String string = stringBuffer.toString();
        stringBuffer = null;
        System.gc();
        System.out.print(string);
        System.out.println(" ");
        int n6 = 0;
        int n7 = -1;
        int n8 = -1;
        n7 = string.indexOf(32, n6);
        while (n7 != -1) {
            n8 = string.indexOf(32, n7 + 1);
            String string2 = n8 == -1 ? string.substring(n6) : string.substring(n6, n8);
            System.out.println(string2);
            if (bl) {
                cGame._sprFont2.UpdateStringSize(string2);
            } else {
                cGame._sprFont1.UpdateStringSize(string2);
            }
            if (cSprite._text_w > n) {
                byArray[n7] = 37;
                n6 = n7 + 1;
                if ((n4 += 11) > n2) {
                    byArray[n7] = 36;
                    ++n5;
                    n4 = 22;
                }
                n7 = n8;
                continue;
            }
            n7 = n8;
        }
        return n5 + 1;
    }

    static void updateResult(int n) {
        if (n == 0) {
            cGame.result = cGame.in_check() ? (cGame.white_to_move == 1 ? 2 : 3) : 1;
        } else {
            if (cGame.is_draw()) {
                cGame.result = 5;
            }
            if (JMove.insufficientMaterial()) {
                cGame.result = 6;
            }
            if (cGame.fifty > 100) {
                cGame.result = 4;
            }
        }
    }

    static String comp_to_coord(JMove jMove) {
        String string = new String();
        byte by = jMove.promoted;
        byte by2 = jMove.from;
        byte by3 = jMove.target;
        if (cGame.rank(by2) < 1 || cGame.rank(by2) > 8 || cGame.file(by2) < 1 || cGame.file(by2) > 8 || cGame.rank(by3) < 1 || cGame.rank(by3) > 8 || cGame.file(by3) < 1 || cGame.file(by3) > 8) {
            string = "xxxx";
            return string;
        }
        String string2 = "" + cGame.rank(by2);
        String string3 = "" + cGame.rank(by3);
        int n = 97;
        char c = (char)(cGame.file(by2) + n - 1);
        char c2 = (char)(cGame.file(by3) + n - 1);
        string = by == 0 ? string + c + string2 + c2 + string3 : (by == 3 || by == 4 ? string + c + string2 + c2 + string3 + 'c' : (by == 7 || by == 8 ? string + c + string2 + c2 + string3 + 't' : (by == 11 || by == 12 ? string + c + string2 + c2 + string3 + 'a' : string + c + string2 + c2 + string3 + 'd')));
        return string;
    }

    static void clean_cg_memory() {
        cGame.cg_string_pos = null;
        cGame.cg_offset = null;
        cGame.cg_white = null;
        cGame.cg_black = null;
        cGame.cg_result = null;
        cGame.cg_event = null;
        cGame.cg_site = null;
        cGame.cg_round = null;
        cGame.cg_date = null;
        System.gc();
    }

    static boolean insufficientMaterial() {
        JMove.s_mate_t[1] = 0;
        JMove.s_mate_t[0] = 0;
        for (int i = 1; i <= cGame.num_pieces; ++i) {
            int n = cGame.pieces[i];
            if (n == 0) continue;
            byte by = cGame.board[n];
            int n2 = by & 1;
            s_mate_t[n2] = (byte)(s_mate_t[n2] + s_mate[by]);
        }
        return s_mate_t[0] < 2 && s_mate_t[1] < 2;
    }

    static void drawParagraph(String string, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n2;
        int n7 = 0;
        String string2 = string;
        String string3 = string;
        while (n7 != -1) {
            n7 = string.indexOf(37, n5);
            if (n7 != -1) {
                string2 = null;
                string2 = string.substring(n5, n7);
                string3 = string.substring(n5, n5 + 1);
                if (string2.compareTo("~") == 0) {
                    string2 = cGame.GetString(120) + ": " + cGame._szVersion;
                }
                if (string3.compareTo("$") == 0) {
                    cGame._sprFont2.DrawString(cGame._g, string2, n, n6, n4);
                } else {
                    cGame._sprFont1.DrawString(cGame._g, string2, n, n6, n4);
                }
                n5 = n7 + 1;
            } else {
                string2 = string.substring(n5);
                if (string2 != null) {
                    if (string2.compareTo("~") == 0) {
                        string2 = cGame.GetString(120) + ": " + cGame._szVersion;
                    }
                    cGame._sprFont1.DrawString(cGame._g, string2, n, n6, n4);
                }
                n5 = n7 + 1;
            }
            if (string2.length() > 5) {
                n6 += n3;
                continue;
            }
            n6 += n3 / 2;
        }
    }

    static void drawMoveOutline(int n, int n2) {
        JMove jMove = cGame.int2mov(n);
        cGame._g.setColor(n2);
        int n3 = jMove.from / 12 - 2;
        int n4 = jMove.from - 12 * (n3 + 2) - 2;
        if (cGame.whiteOnTop) {
            n3 = 7 - n3;
            n4 = 7 - n4;
        }
        cGame._g.drawRect(8 + n4 * 14, 12 + (7 - n3) * 14, 13, 13);
        n3 = jMove.target / 12 - 2;
        n4 = jMove.target - 12 * (n3 + 2) - 2;
        if (cGame.whiteOnTop) {
            n3 = 7 - n3;
            n4 = 7 - n4;
        }
        cGame._g.drawRect(8 + n4 * 14, 12 + (7 - n3) * 14, 13, 13);
        jMove = null;
    }

    static int getPagesNo(byte[] byArray) {
        int n = 0;
        if (byArray == null || byArray.length == 0) {
            return 0;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 36 || i == byArray.length - 1) continue;
            ++n;
        }
        return n + 1;
    }

    static void deleteLevel(int n) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)cGame.GetString(86), (boolean)true);
            recordStore.deleteRecord(n);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void Book_Load() {
        try {
            InputStream inputStream = "a".getClass().getResourceAsStream("/book1.bin");
            nr_of_openings = (inputStream.read() & 0xFF) + ((inputStream.read() & 0xFF) << 8);
            Book_openings = new byte[nr_of_openings][];
            Book_validOpening = new boolean[nr_of_openings];
            int n = 2;
            for (int i = 0; i < nr_of_openings; ++i) {
                int n2 = (inputStream.read() & 0xFF) + ((inputStream.read() & 0xFF) << 8);
                n += 2;
                JMove.Book_openings[i] = new byte[n2 * 2];
                inputStream.read(Book_openings[i]);
                n += n2 * 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    static void Restart_Book() {
        if (cGame.lostMovesListCount != 0) {
            Book_HaveValidOpenings = false;
            Book_HaveValidOpenings = false;
            for (int i = 0; i < Book_validOpening.length; ++i) {
                JMove.Book_validOpening[i] = false;
            }
            cGame.bDisableShowBook = false;
            return;
        }
        Book_HaveValidOpenings = true;
        Book_openingMove = null;
        Book_moveIndex = 0;
        Book_nameOpening = "";
        for (int i = 0; i < Book_validOpening.length; ++i) {
            JMove.Book_validOpening[i] = true;
        }
        uniqueOpening = -1;
        cGame.bDisableShowBook = false;
        JMove.ConstructBookMoves();
    }

    static void AdvanceBookIndex() {
        Book_moveIndex = (byte)(Book_moveIndex + 2);
        for (int i = 0; i < Book_openings.length; ++i) {
            if (Book_moveIndex < Book_openings[i].length) continue;
            JMove.Book_validOpening[i] = false;
        }
    }

    static void ConstructBookMoves() {
        int n;
        int n2;
        nr_book_moves = 0;
        first_nr_appearances = -1;
        second_nr_appearances = -1;
        third_nr_appearances = -1;
        for (n2 = 0; n2 < Book_openings.length; ++n2) {
            int n3;
            if (!Book_validOpening[n2]) continue;
            n = Book_openings[n2][Book_moveIndex];
            for (n3 = 0; n3 < nr_book_moves; ++n3) {
                if (bookMoves[n3 * 2] != n) continue;
                int n4 = n3 * 2 + 1;
                bookMoves[n4] = (byte)(bookMoves[n4] + 1);
                break;
            }
            if (n3 != nr_book_moves) continue;
            JMove.bookMoves[n3 * 2] = n;
            JMove.bookMoves[n3 * 2 + 1] = 1;
            ++nr_book_moves;
        }
        for (n2 = 0; n2 < nr_book_moves; ++n2) {
            n = bookMoves[n2 * 2 + 1];
            if (first_nr_appearances >= n) continue;
            first_nr_appearances = n;
        }
        for (n2 = 0; n2 < nr_book_moves; ++n2) {
            n = bookMoves[n2 * 2 + 1];
            if (second_nr_appearances >= n || n == first_nr_appearances) continue;
            second_nr_appearances = n;
        }
        for (n2 = 0; n2 < nr_book_moves; ++n2) {
            n = bookMoves[n2 * 2 + 1];
            if (third_nr_appearances >= n || n == first_nr_appearances || n == second_nr_appearances) continue;
            third_nr_appearances = n;
        }
    }

    static void ConstructToMoves() {
        int n;
        int n2;
        nr_to_moves = 0;
        to_first = -1;
        to_second = -1;
        to_third = -1;
        for (n2 = 0; n2 < Book_openings.length; ++n2) {
            int n3;
            if (!Book_validOpening[n2] || Book_moveIndex >= Book_openings[n2].length || Book_openings[n2][Book_moveIndex] != cGame.selectedFrom) continue;
            n = Book_openings[n2][Book_moveIndex + 1];
            for (n3 = 0; n3 < nr_to_moves; ++n3) {
                if (toMoves[n3 * 2] != n) continue;
                int n4 = n3 * 2 + 1;
                toMoves[n4] = (byte)(toMoves[n4] + 1);
                break;
            }
            if (n3 != nr_to_moves) continue;
            JMove.toMoves[n3 * 2] = n;
            JMove.toMoves[n3 * 2 + 1] = 1;
            ++nr_to_moves;
        }
        for (n2 = 0; n2 < nr_to_moves; ++n2) {
            n = toMoves[n2 * 2 + 1];
            if (to_first >= n) continue;
            to_first = n;
        }
        for (n2 = 0; n2 < nr_to_moves; ++n2) {
            n = toMoves[n2 * 2 + 1];
            if (to_first >= n) continue;
            to_second = n;
        }
        for (n2 = 0; n2 < nr_to_moves; ++n2) {
            n = toMoves[n2 * 2 + 1];
            if (to_third >= n) continue;
            to_third = n;
        }
    }

    static JMove Book_tryMakeMove(JMove jMove) {
        if (!Book_HaveValidOpenings) {
            return null;
        }
        Book_openingMove = null;
        if (cGame.turn == cGame.humanColor || cGame.gameType == 1) {
            int n = -1;
            int n2 = -1;
            JMove jMove2 = new JMove();
            jMove2.Copy(jMove);
            int n3 = 0;
            for (int i = 0; i < Book_openings.length; ++i) {
                if (!Book_validOpening[i]) continue;
                if (jMove2.from != Book_openings[i][Book_moveIndex] || jMove2.target != Book_openings[i][Book_moveIndex + 1]) {
                    if (cGame.quickAdvice) continue;
                    JMove.Book_validOpening[i] = false;
                    continue;
                }
                Book_HaveValidOpenings = true;
                n2 = i;
                ++n3;
                if (Book_moveIndex != Book_openings[i].length - 2) continue;
                n = i;
            }
            if (n3 == 0) {
                if (!cGame.quickAdvice) {
                    Book_HaveValidOpenings = false;
                }
                return cGame.dummy;
            }
            if (!cGame.quickAdvice) {
                JMove.AdvanceBookIndex();
            }
            if (n3 == 1) {
                if (uniqueOpening == -1) {
                    if (!cGame.bDisableShowBook) {
                        Book_nameOpening = cGame.GetString(164 + n2);
                    }
                    uniqueOpening = n2;
                }
            } else if (n != -1 && !cGame.bDisableShowBook) {
                Book_nameOpening = cGame.GetString(164 + n);
            }
        } else {
            int n;
            int n4;
            int n5 = -1;
            int n6 = 0;
            for (n4 = 0; n4 < Book_openings.length; ++n4) {
                if (Book_moveIndex >= Book_openings[n4].length) {
                    JMove.Book_validOpening[n4] = false;
                }
                if (!Book_validOpening[n4]) continue;
                ++n6;
            }
            if (n6 == 0) {
                if (!cGame.quickAdvice) {
                    Book_HaveValidOpenings = false;
                }
                return cGame.dummy;
            }
            n4 = Math.abs(cGame._rnd.nextInt()) % n6;
            for (n = 0; n < Book_openings.length; ++n) {
                if (!Book_validOpening[n]) continue;
                if (n4 == 0) {
                    n4 = n;
                    break;
                }
                --n4;
            }
            for (n = 0; n < Book_openings.length; ++n) {
                if (!Book_validOpening[n]) continue;
                if (Book_openings[n4][Book_moveIndex] != Book_openings[n][Book_moveIndex] || Book_openings[n4][Book_moveIndex + 1] != Book_openings[n][Book_moveIndex + 1]) {
                    if (cGame.quickAdvice) continue;
                    --n6;
                    JMove.Book_validOpening[n] = false;
                    continue;
                }
                if (Book_moveIndex != Book_openings[n].length - 2) continue;
                n5 = n;
            }
            JMove.push_table();
            n = cGame.gen(JMove.start_index(), 0);
            JMove.add_moves(n);
            for (int i = 0; i < n; ++i) {
                if (Book_openings[n4][Book_moveIndex] != JMove.moves((int)i).from || Book_openings[n4][Book_moveIndex + 1] != JMove.moves((int)i).target) continue;
                Book_openingMove = JMove.moves(i);
                break;
            }
            JMove.pop_table();
            if (Book_openingMove != null) {
                if (uniqueOpening == -1) {
                    if (n6 == 1) {
                        if (!cGame.bDisableShowBook) {
                            Book_nameOpening = cGame.GetString(164 + n4);
                        }
                        uniqueOpening = n4;
                    } else if (n5 != -1 && !cGame.bDisableShowBook) {
                        Book_nameOpening = cGame.GetString(164 + n5);
                    }
                }
                if (!cGame.quickAdvice) {
                    JMove.AdvanceBookIndex();
                }
            } else {
                n4 = -1;
            }
        }
        return Book_openingMove;
    }

    static boolean acceptDraw(int n) {
        if (cGame.maxdepth == 0) {
            return cGame.movesListCount > 0 && cGame.lostMovesListCount == 0;
        }
        int n2 = cGame.white_to_move;
        int n3 = cGame.maxdepth;
        if (cGame.maxdepth > 2) {
            --cGame.maxdepth;
        }
        cGame.timeForUpdateMax = 1000L;
        cGame.countUntilCheckTimeMax = 50L;
        cGame.white_to_move = n == 0 ? 0 : 1;
        cGame.inThink = true;
        cGame.comp_move.Copy(cGame.think());
        cGame.inThink = false;
        cGame.maxdepth = n3;
        cGame.white_to_move = n2;
        if (cGame.force_mode) {
            cGame.force_mode = false;
            return false;
        }
        return cGame.last_root_score < -200L;
    }

    static String addExtraMoveInfo(String string, JMove jMove) {
        String string2 = string.substring(0);
        string = jMove.captured != 13 && jMove.captured != 0 ? string2.substring(0, 2) + "x" + string2.substring(2) : string2.substring(0, 2) + "-" + string2.substring(2);
        if (cGame.result == 2 || cGame.result == 3) {
            string = string + "#";
        } else if (cGame.in_check()) {
            string = string + "+";
        }
        return string;
    }

    static int saveGameInfo(byte[] byArray, int n) {
        byte by = cGame.turn;
        by = (byte)(by | cGame.maxdepth << 1);
        by = (byte)(by | cGame.humanColor << 4);
        by = (byte)(by | cGame.gameType << 5);
        byArray[n++] = by;
        byArray[n++] = (byte)(cGame.secondsToMove & 0xFF);
        byArray[n++] = (byte)(cGame.secondsToMove >> 8 & 0xFF);
        byArray[n++] = (byte)(cGame.secondsToMove >> 16 & 0xFF);
        byArray[n++] = (byte)(cGame.secondsToMove >> 24 & 0xFF);
        byArray[n++] = (byte)cGame.crtSecsPos;
        byArray[n++] = (byte)cGame.maxdepth_intermediar;
        return n;
    }

    static int loadGameInfo(byte[] byArray, int n, boolean bl) {
        byte by = byArray[n++];
        if (bl) {
            cGame.turn = (byte)(by & 1);
        }
        cGame.maxdepth = by >> 1 & 7;
        cGame.humanColor = (byte)(by >> 4 & 1);
        cGame.gameType = (byte)(by >> 5 & 3);
        cGame.secondsToMove = byArray[n++] & 0xFF;
        cGame.secondsToMove |= byArray[n++] << 8 & 0xFF00;
        cGame.secondsToMove |= byArray[n++] << 16 & 0xFF0000;
        cGame.secondsToMove |= byArray[n++] << 24 & 0xFF000000;
        cGame.crtSecsPos = byArray[n++];
        cGame.maxdepth_intermediar = byArray[n++];
        return n;
    }

    static {
        int n;
        current = 0;
        start = new int[20];
        num_moves = new int[20];
        move_table = new JMove[350];
        move_ordering_table = new int[350];
        for (n = 0; n < move_table.length; ++n) {
            JMove.move_table[n] = new JMove();
        }
        for (n = 0; n < 20; ++n) {
            JMove.num_moves[n] = 0;
            JMove.start[n] = 0;
        }
        max_moves_used = 0;
        s_mate = new byte[]{0, 4, 4, 1, 1, 0, 0, 4, 4, 4, 4, 1, 1, 0};
        s_mate_t = new byte[]{0, 0};
        Book_nameOpening = "";
        nr_book_moves = 0;
        bookMoves = new byte[200];
        uniqueOpening = -1;
        nr_to_moves = 0;
        toMoves = new byte[200];
        rep_history = new int[320];
        history_h = new short[4096];
        fifty_history = new byte[320];
    }
}

