/*
 * Decompiled with CFR 0.152.
 */
package hello;

public class numeric {
    static void triangularize(int n, float[][] mat) {
        for (int i = 1; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                float a = mat[i - 1][i - 1] / mat[j][i - 1];
                for (int k = i - 1; k < n; ++k) {
                    mat[j][k] = mat[i - 1][k] - mat[j][k] * a;
                }
            }
        }
    }

    static void triangularize(int n, float[][] mat, float[] b) {
        for (int i = 1; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                numeric.pivot(i - 1, n, mat, b);
                if (mat[j][i - 1] == 0.0f) continue;
                float a = mat[i - 1][i - 1] / mat[j][i - 1];
                for (int k = i - 1; k < n; ++k) {
                    mat[j][k] = mat[i - 1][k] - mat[j][k] * a;
                }
                b[j] = b[i - 1] - b[j] * a;
            }
        }
    }

    static void pivot(int d, int n, float[][] mat, float[] b) {
        int row = n;
        for (int i = n + 1; i < d; ++i) {
            if (!(Math.abs(mat[i][n]) > Math.abs(mat[n][n]))) continue;
            row = i;
        }
        if (row != n) {
            float[] newRow = new float[mat[0].length];
            for (int i = 0; i < mat[0].length; ++i) {
                newRow[i] = mat[n][i];
                mat[n][i] = mat[row][i];
                mat[row][i] = newRow[i];
            }
            float _b = b[n];
            b[n] = b[row];
            b[row] = _b;
        }
    }

    static void diagonalize(int n, float[][] mat, float[] b) {
        numeric.triangularize(n, mat, b);
        for (int i = n - 2; i >= 0; --i) {
            for (int j = i; j >= 0; --j) {
                float a = mat[i + 1][i + 1] / mat[j][i + 1];
                for (int k = n - 1; k >= 0; --k) {
                    mat[j][k] = mat[i + 1][k] - mat[j][k] * a;
                }
                b[j] = b[i + 1] - b[j] * a;
            }
        }
    }

    static void transpose(int row, int col, float[][] mat1, float[][] mat2) {
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                mat2[j][i] = mat1[i][j];
            }
        }
    }

    static float[][] multiply(float[][] mat1, float[][] mat2) {
        int row = mat1.length;
        int col = mat1[0].length;
        int row2 = mat2.length;
        int col2 = mat2[0].length;
        float[][] mat = new float[row][col2];
        for (int k = 0; k < col2; ++k) {
            for (int i = 0; i < row; ++i) {
                for (int j = 0; j < col; ++j) {
                    float[] fArray = mat[i];
                    int n = k;
                    fArray[n] = fArray[n] + mat1[i][j] * mat2[j][k];
                }
            }
        }
        return mat;
    }

    static float[][] inverse(int n, float[][] mat) {
        int k;
        float a;
        int j;
        int i;
        float[][] mat2 = new float[n][n];
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                mat2[i][j] = i == j ? 1.0f : 0.0f;
            }
        }
        for (i = 1; i < n; ++i) {
            for (j = i; j < n; ++j) {
                a = mat[i - 1][i - 1] / mat[j][i - 1];
                for (k = 0; k < n; ++k) {
                    mat[j][k] = mat[i - 1][k] - mat[j][k] * a;
                    mat2[j][k] = mat2[i - 1][k] - mat2[j][k] * a;
                }
            }
        }
        for (i = n - 2; i >= 0; --i) {
            for (j = i; j >= 0; --j) {
                a = mat[i + 1][i + 1] / mat[j][i + 1];
                for (k = n - 1; k >= 0; --k) {
                    mat[j][k] = mat[i + 1][k] - mat[j][k] * a;
                    mat2[j][k] = mat2[i + 1][k] - mat2[j][k] * a;
                }
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                mat2[i][j] = mat2[i][j] / mat[i][i];
            }
        }
        return mat2;
    }
}

