/*
 * Decompiled with CFR 0.152.
 */
package com.dvidearts.dvj2me;

import com.dvidearts.dvj2me.dvCustomFont;
import com.dvidearts.dvj2me.dvGameBase;
import com.dvidearts.dvj2me.dvPoint;
import com.dvidearts.dvj2me.dvSprite;
import com.dvidearts.dvj2me.dvUtil;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class dvTouchKeyboard {
    public static final byte VKEY_BACKSPACE = 49;
    private final byte VK_BORDER_OFFSET = (byte)2;
    private final byte VK_MAX_NAME_SIZE = (byte)10;
    private final byte VKEYBOARD_NORMAL;
    private final byte VKEYBOARD_HIDDEN;
    private final byte VKEYBOARD_SLIDEIN = (byte)2;
    private final byte VKEYBOARD_SLIDEOUT = (byte)3;
    private final byte VKM_ALLKEYS;
    private final byte VKM_NUMBERSONLY;
    private short caretPos;
    private short numchars;
    private short cursor;
    private short lastkey;
    private short textboxX;
    private short textboxY;
    private short gridcellW;
    private short gridcellH;
    private byte numRows;
    private byte numCols;
    private short[] gridx;
    private short[] gridy;
    private short[] textbox;
    private short[] wiggle;
    private byte currfrm;
    private dvCustomFont cf;
    private String temp;
    private Image imgKey;
    private Image imgCaret;
    private int vcenter;
    private int hcenter;
    private int xspacing;
    private int yspacing;
    private int slide_speed;
    private int org_vcenter;
    private byte state;
    private dvSprite sprTextbox;
    private byte mode;
    private short shiftLastRow;
    private dvGameBase game;

    public dvTouchKeyboard(dvGameBase g, dvCustomFont cfont, int xCenter, int yCenter) {
        this.VKEYBOARD_NORMAL = 0;
        this.VKEYBOARD_HIDDEN = 1;
        this.VKM_ALLKEYS = 0;
        this.VKM_NUMBERSONLY = 1;
        this.game = g;
        this.temp = "";
        this.cf = cfont;
        this.caretPos = 0;
        this.numchars = 0;
        this.cursor = 0;
        this.textboxX = 0;
        this.textboxY = 0;
        this.gridcellW = (short)(this.cf.getWidth() + 1);
        this.gridcellH = this.cf.getHeight();
        this.numRows = (byte)5;
        this.numCols = (byte)10;
        this.shiftLastRow = 0;
        this.gridx = new short[this.numCols];
        this.gridy = new short[this.numRows];
        this.wiggle = new short[this.numCols * this.numRows];
        this.textbox = new short[10];
        this.imgKey = null;
        this.imgCaret = null;
        this.sprTextbox = null;
        this.currfrm = 0;
        this.hcenter = xCenter;
        this.org_vcenter = this.vcenter = yCenter;
        this.xspacing = 11;
        this.yspacing = 24;
        this.state = 0;
        this.mode = 0;
        this.slide_speed = 0;
        this.updateX();
        this.updateY();
        this.reset();
    }

    public void free() {
        this.gridx = null;
        this.gridy = null;
        this.wiggle = null;
        this.textbox = null;
        this.imgKey = null;
        this.imgCaret = null;
        this.sprTextbox = null;
    }

    public boolean isHidden() {
        return this.state == 1;
    }

    public boolean isAnimating() {
        return this.state != 0 && this.state != 1;
    }

    public void setMode(byte eMode) {
        this.mode = eMode;
    }

    public void slideIn(int speed) {
        if (this.isAnimating() || this.state == 0) {
            return;
        }
        this.slide_speed = speed;
        this.state = (byte)2;
        this.vcenter = this.game.dvGetHeight() + this.getHeight() / 2;
        this.updateY();
    }

    public void slideOut(int speed) {
        if (this.isAnimating() || this.state == 1) {
            return;
        }
        this.slide_speed = speed;
        this.state = (byte)3;
        this.vcenter = this.org_vcenter;
        this.updateY();
    }

    public void hide() {
        this.state = 1;
        this.vcenter = this.game.dvGetHeight() + this.getHeight() / 2;
        this.updateY();
        int i = 0;
        int row = 0;
        while (row < this.numRows) {
            int col = 0;
            while (col < this.numCols) {
                this.wiggle[i] = 0;
                ++i;
                ++col;
            }
            ++row;
        }
    }

    public void show() {
        this.state = 0;
        this.vcenter = this.org_vcenter;
        this.updateY();
    }

    public void setHorizontalCenter(int hc) {
        this.hcenter = hc;
        this.updateX();
    }

    public void setVerticalCenter(int vc) {
        this.org_vcenter = this.vcenter = vc;
        this.updateY();
    }

    public int getVerticalCenter() {
        return this.vcenter;
    }

    public int getHorizontalCenter() {
        return this.hcenter;
    }

    public int getWidth() {
        return this.gridcellW * this.numCols + this.xspacing * (this.numCols - 1);
    }

    public int getHeight() {
        return this.gridcellH * this.numRows + this.yspacing * (this.numRows - 1) + this.gridcellH * 2;
    }

    public void setHorizontalSpacing(int xs) {
        this.xspacing = xs;
        this.updateX();
    }

    public void setVerticalSpacing(int ys) {
        this.yspacing = ys;
        this.updateY();
    }

    public void setKey(String filename) {
        this.imgKey = null;
        try {
            this.imgKey = Image.createImage((String)filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCaretImage(String filename) {
        this.imgCaret = null;
        try {
            this.imgCaret = Image.createImage((String)filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTextboxImage(String filename, int iw, int ih) {
        if (this.sprTextbox != null) {
            this.sprTextbox.free();
            this.sprTextbox = null;
        }
        try {
            this.sprTextbox = new dvSprite(Image.createImage((String)filename), iw, ih);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public short lastKey() {
        return this.lastkey;
    }

    public boolean click(dvPoint point) {
        if (this.state != 0) {
            return false;
        }
        boolean shiftit = false;
        boolean do_it = false;
        short newrow = 0;
        short newcol = 0;
        int spaces = 0;
        int numVisibleKeys = 0;
        int row = 0;
        while (row < this.numRows) {
            int col = 0;
            while (col < this.numCols) {
                if (numVisibleKeys > 49) {
                    row = this.numRows;
                    col = this.numCols;
                    break;
                }
                ++numVisibleKeys;
                if (this.mode == 1 && row * this.numCols + col == 49) {
                    spaces += 9;
                }
                newcol = (short)(spaces % this.numCols);
                newrow = (short)(spaces / this.numCols);
                if (shiftit && row == this.numRows - 1) {
                    newcol = (short)(newcol + this.shiftLastRow);
                }
                if (!this.processKey(row, col)) {
                    do_it = false;
                } else if (this.imgKey == null) {
                    if (dvUtil.dvClickRect(point, this.gridx[newcol], this.gridy[newrow], this.gridcellW, this.gridcellH)) {
                        do_it = true;
                    }
                    ++spaces;
                } else {
                    if (dvUtil.dvClickRect(point, this.gridx[newcol] + this.cf.sprite.getWidth() / 2 - this.imgKey.getWidth() / 2, this.gridy[newrow] + this.cf.sprite.getHeight() / 2 - this.imgKey.getHeight() / 2, this.imgKey.getWidth(), this.imgKey.getHeight())) {
                        do_it = true;
                    }
                    ++spaces;
                }
                if (do_it) {
                    this.lastkey = this.cursor = (short)(row * this.numCols + col);
                    this.wiggle[newrow * this.numCols + newcol] = 20;
                    this.updateCursor();
                    this.selectCharacter();
                    row = this.numRows;
                    col = this.numCols;
                    return true;
                }
                ++col;
            }
            ++row;
        }
        return false;
    }

    public void reset() {
        this.currfrm = 0;
        this.cursor = 0;
        this.caretPos = this.numchars;
        if (this.caretPos > 9) {
            this.caretPos = (short)9;
        }
        int i = 0;
        int row = 0;
        while (row < this.numRows) {
            int col = 0;
            while (col < this.numCols) {
                this.wiggle[i] = 0;
                ++i;
                ++col;
            }
            ++row;
        }
    }

    public String getTextboxValue() {
        return this.keyMapToString(this.textbox, this.numchars).trim();
    }

    public String getEncodedTextboxValue() {
        return this.keyMapToStringEncoded(this.textbox, this.numchars).trim();
    }

    public void clearTextbox() {
        this.numchars = 0;
        this.caretPos = 0;
    }

    public void paint(Graphics g) {
        this.update();
        if (this.state == 1) {
            return;
        }
        boolean shiftit = false;
        int amt = 0;
        this.cf.sprite.setFrame(0);
        short newrow = 0;
        short newcol = 0;
        int spaces = 0;
        int row = 0;
        while (row < this.numRows) {
            int col = 0;
            while (col < this.numCols) {
                if (this.processKey(row, col)) {
                    if (this.mode == 1 && row * this.numCols + col == 49) {
                        spaces += 9;
                    }
                    newcol = (short)(spaces % this.numCols);
                    newrow = (short)(spaces / this.numCols);
                    if (shiftit && row == this.numRows - 1) {
                        newcol = (short)(newcol + this.shiftLastRow);
                    }
                    amt = 0;
                    int tmpIndex = newrow * this.numCols + newcol;
                    if (this.wiggle[tmpIndex] > 0) {
                        amt = this.wiggle[tmpIndex] / 2;
                        if (this.wiggle[tmpIndex] % 2 == 0) {
                            amt *= -1;
                        }
                        int n = tmpIndex;
                        this.wiggle[n] = (short)(this.wiggle[n] - 1);
                    }
                    if (this.imgKey != null) {
                        g.drawImage(this.imgKey, this.gridx[newcol] + this.cf.sprite.getWidth() / 2 - this.imgKey.getWidth() / 2, amt + this.gridy[newrow] + this.cf.sprite.getHeight() / 2 - this.imgKey.getHeight() / 2, 20);
                    }
                    this.cf.sprite.setPosition(this.gridx[newcol], amt + this.gridy[newrow]);
                    this.cf.sprite.paint(g);
                    ++spaces;
                }
                this.cf.sprite.nextFrame();
                if (this.cf.sprite.getFrame() == 0 || this.cf.sprite.getFrame() > 49) {
                    row = this.numRows;
                    col = this.numCols;
                    break;
                }
                ++col;
            }
            ++row;
        }
        if (this.sprTextbox != null) {
            int tmpY = this.textboxY + this.cf.getHeight() / 2 - this.sprTextbox.getHeight() / 2;
            this.sprTextbox.setFrame(0);
            this.sprTextbox.setPosition(this.textboxX - this.sprTextbox.getWidth(), tmpY);
            this.sprTextbox.paint(g);
            this.sprTextbox.setFrame(1);
            int n = 0;
            while (n < 10) {
                this.sprTextbox.setPosition(this.textboxX + n * this.cf.getWidth(), tmpY);
                this.sprTextbox.paint(g);
                ++n;
            }
            this.sprTextbox.setFrame(2);
            this.sprTextbox.setPosition(this.textboxX + 10 * this.cf.getWidth(), tmpY);
            this.sprTextbox.paint(g);
        }
        this.cf.drawString(g, this.getTextboxValue(), this.textboxX, this.textboxY);
        if (this.sprTextbox == null) {
            g.setColor(255, 255, 255);
            g.drawRect(this.textboxX - 2, this.textboxY - 2, this.cf.getWidth() * 10 + 4, this.cf.getHeight() + 4);
        }
        if (this.currfrm != 0 && this.currfrm != 5) {
            if (this.imgCaret != null) {
                g.drawImage(this.imgCaret, this.textboxX + this.caretPos * this.cf.getWidth() + this.cf.getWidth() / 2 - this.imgCaret.getWidth() / 2, this.textboxY + this.cf.getHeight() / 2 - this.imgCaret.getHeight() / 2, 20);
            } else {
                g.setColor(255, 0, 0);
                g.drawRect(this.textboxX + this.caretPos * this.cf.getWidth(), this.textboxY + this.cf.getHeight(), (int)this.cf.getWidth(), 1);
            }
        }
    }

    public void setTextboxValue(String text) {
        if (text == null) {
            return;
        }
        int len = text.length();
        if (len > 10) {
            len = 10;
        }
        this.textbox = null;
        this.textbox = this.StringToKeyMap(text, len);
        this.caretPos = this.numchars = (short)len;
        if (this.caretPos > 9) {
            this.caretPos = (short)9;
        }
    }

    private void updateX() {
        this.gridx[0] = (short)(this.hcenter - this.getWidth() / 2);
        int i = 0;
        while (i < this.numCols - 1) {
            this.gridx[i + 1] = (short)(this.gridx[i] + this.gridcellW + this.xspacing);
            ++i;
        }
        this.textboxX = (short)(this.hcenter - this.cf.getWidth() * 10 / 2);
    }

    private void updateY() {
        this.gridy[this.numRows - 1] = (short)(this.vcenter + this.getHeight() / 2);
        int i = this.numRows - 1;
        while (i > 0) {
            this.gridy[i - 1] = (short)(this.gridy[i] - this.gridcellH - this.yspacing);
            --i;
        }
        this.textboxY = (short)(this.gridy[0] - (this.cf.getHeight() + this.gridcellH));
    }

    private void update() {
        this.currfrm = (byte)(this.currfrm + 1);
        if (this.currfrm > 9) {
            this.currfrm = 0;
        }
        switch (this.state) {
            case 2: {
                if (this.vcenter > this.org_vcenter) {
                    this.vcenter -= this.slide_speed;
                    if (this.vcenter <= this.org_vcenter) {
                        this.show();
                    }
                }
                this.updateY();
                break;
            }
            case 3: {
                if (this.vcenter <= this.game.dvGetHeight() + this.getHeight() / 2) {
                    this.vcenter += this.slide_speed;
                    if (this.vcenter > this.game.dvGetHeight() + this.getHeight() / 2) {
                        this.hide();
                    }
                }
                this.updateY();
            }
        }
    }

    private void updateCursor() {
    }

    private void selectCharacter() {
        if (this.cursor == 49) {
            this.numchars = (short)(this.numchars - 1);
            if (this.numchars < 0) {
                this.numchars = 0;
            }
            this.caretPos = this.numchars;
        } else {
            if (this.numchars == 10) {
                this.numchars = (short)(this.numchars - 1);
            }
            this.textbox[this.numchars] = this.cursor;
            this.numchars = (short)(this.numchars + 1);
            if (this.numchars >= 10) {
                this.numchars = (short)10;
            }
            this.caretPos = this.numchars;
            if (this.caretPos > 9) {
                this.caretPos = (short)9;
            }
        }
    }

    private boolean processKey(int irow, int icol) {
        switch (this.mode) {
            case 0: {
                return true;
            }
            case 1: {
                int pos = irow * this.numCols + icol;
                if (pos != 49 && (pos <= 25 || pos >= 36)) break;
                return true;
            }
        }
        return false;
    }

    private String keyMapToString(short[] values, int size) {
        this.temp = "";
        int i = 0;
        while (i < size) {
            this.temp = String.valueOf(this.temp) + this.cf.getAscii(values[i]);
            ++i;
        }
        return this.temp;
    }

    private String keyMapToStringEncoded(short[] values, int size) {
        this.temp = "";
        int i = 0;
        while (i < size) {
            this.temp = String.valueOf(this.temp) + this.cf.getEncoded(values[i]);
            ++i;
        }
        return this.temp;
    }

    private short[] StringToKeyMap(String string, int maxsize) {
        if (string == null) {
            string = "";
        }
        short[] ret = new short[maxsize];
        int i = 0;
        while (i < string.length()) {
            ret[i] = this.cf.getValue(string.charAt(i));
            ++i;
        }
        return ret;
    }
}

