/*
 * Decompiled with CFR 0.152.
 */
package fi.darkwood.ability;

import fi.darkwood.Ability;
import fi.darkwood.Creature;
import fi.darkwood.Game;
import fi.darkwood.ui.component.MessageLog;
import java.util.Random;

public abstract class HealSpell
extends Ability {
    protected static Random a = new Random(System.currentTimeMillis());

    public HealSpell(String string, String string2, int n) {
        super(string, string2, n);
    }

    public int getAbilityRank() {
        return 1;
    }

    public boolean effect(Creature object) {
        Creature creature;
        if (!((Creature)object).isReadyToAct(this.getAbilitySlot())) {
            return false;
        }
        if (((Creature)object).mana < this.getManaCost()) {
            if (((Creature)object).getId() == Game.player.getId()) {
                MessageLog.getInstance().addMessage("Not enough energy!");
            }
            return false;
        }
        ((Creature)object).reduceMana(this.getManaCost());
        ((Creature)object).addAbilityCooldown(this.getCooldownInRounds(), this.getAbilitySlot());
        Creature creature2 = null;
        Object object2 = Game.player.room.getCreatures().elements();
        while (object2.hasMoreElements()) {
            creature = (Creature)object2.nextElement();
            if (Game.player.isHostile(creature) || !creature.isAlive()) continue;
            creature2 = creature;
            break;
        }
        creature = creature2;
        object2 = object;
        object = this;
        int n = ((HealSpell)object).getHealEffect(((Creature)object2).willpower);
        creature.heal(n);
        creature2.addAbilityEffect(this.getTargetVisualEffect());
        Game.party.sendVisualEffect(creature2.getId(), this.getTargetVisualEffect());
        return true;
    }

    public String getDescription() {
        return "Heals around " + this.getHealEffect(Game.player.willpower) + " hit points for " + this.getManaCost() + " mana.";
    }

    public abstract int getHealEffect(int var1);

    public abstract int getManaCost();
}

