/*
 * Decompiled with CFR 0.152.
 */
package fi.darkwood;

import fi.darkwood.Ability;
import fi.darkwood.Creature;
import fi.darkwood.DarkwoodGraphics;
import fi.darkwood.Equipment;
import fi.darkwood.Game;
import fi.darkwood.Humanoid;
import fi.darkwood.Logger;
import fi.darkwood.Monster;
import fi.darkwood.Quest;
import fi.darkwood.ability.AbilityTables;
import fi.darkwood.ability.cleric.Heal;
import fi.darkwood.ability.cleric.HealingAura;
import fi.darkwood.ability.cleric.HolyBolt;
import fi.darkwood.ability.cleric.Weakness;
import fi.darkwood.ability.mage.FireBall;
import fi.darkwood.ability.mage.Ignite;
import fi.darkwood.ability.mage.MeteorStrike;
import fi.darkwood.ability.mage.Polymorph;
import fi.darkwood.ability.warrior.Enrage;
import fi.darkwood.ability.warrior.MightyBlow;
import fi.darkwood.ability.warrior.ShieldWall;
import fi.darkwood.ability.warrior.Strike;
import fi.darkwood.initialEquipment.ClericChest;
import fi.darkwood.initialEquipment.MageChest;
import fi.darkwood.initialEquipment.PlainStaff;
import fi.darkwood.initialEquipment.WarriorChest;
import fi.darkwood.initialEquipment.WarriorWeapon;
import fi.darkwood.initialEquipment.WoodenClub;
import fi.darkwood.network.CharacterSerializer;
import fi.darkwood.ui.component.CombatText;
import fi.darkwood.ui.component.MessageLog;
import java.util.Date;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Player
extends Humanoid {
    public int characterClass;
    private int a;
    public int totalExperience;
    public Ability[] activeAbilities = new Ability[4];
    public int healingPotions = 0;
    public int[] trainedStats = new int[4];
    public Vector completedQuests = new Vector();
    public Quest currentQuest = null;
    public String[] dateWhenGainedLevel = new String[32];
    private int c = 0;
    public String startZone = "";

    public Player(String string, String string2, String string3, int n, int n2, int n3) {
        super(string, string2, string3, n, n2);
        this.characterClass = n3;
        for (int i = 0; i < 4; ++i) {
            this.trainedStats[i] = 0;
        }
        this.setIdleAnimationFrameSequence();
    }

    public void rest() {
        if (this.mana >= this.maxMana) {
            return;
        }
        int n = (int)((double)this.maxMana * 0.05);
        if (this.mana + n > this.maxMana) {
            n = this.maxMana - this.mana;
        }
        this.mana += n;
        MessageLog.getInstance().addMessage("You regain " + n + " energy!");
    }

    public void setIdleAnimationFrameSequence() {
        int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        if (this.characterClass == 2) {
            nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        }
        if (this.characterClass == 1) {
            nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        }
        this.getSprite().setFrameSequence(nArray);
        this.setFrameOffset(0);
    }

    public void setAbilityInvokeAnimationFrameSequence() {
        int[] nArray = new int[]{11, 12, 13, 14, 15};
        this.setFramesLeftToResetAnimation(6);
        this.setFrameOffset(11);
        if (this.characterClass == 2) {
            nArray = new int[]{11, 12, 13, 14, 15, 16};
            this.setFramesLeftToResetAnimation(7);
            this.setFrameOffset(11);
        }
        if (this.characterClass == 1) {
            nArray = new int[]{10, 11, 12, 13, 14, 15};
            this.setFramesLeftToResetAnimation(7);
            this.setFrameOffset(10);
        }
        this.getSprite().setFrameSequence(nArray);
    }

    public void initNewCharacter() {
        Equipment equipment;
        this.strength = 0;
        this.dexterity = 0;
        this.constitution = 0;
        this.willpower = 0;
        this.a();
        this.updateMaxHealthAndMana();
        this.updateAbilities();
        this.health = this.maxHealth;
        this.mana = this.maxMana;
        this.healingPotions = 2;
        Object object = this;
        if (((Player)object).characterClass == 0) {
            equipment = new WarriorWeapon();
            ((Humanoid)object).equip(equipment);
            equipment = new WarriorChest();
            ((Humanoid)object).equip(equipment);
        }
        if (((Player)object).characterClass == 2) {
            equipment = new WoodenClub();
            ((Humanoid)object).equip(equipment);
            equipment = new ClericChest();
            ((Humanoid)object).equip(equipment);
        }
        if (((Player)object).characterClass == 1) {
            equipment = new PlainStaff();
            ((Humanoid)object).equip(equipment);
            equipment = new MageChest();
            ((Humanoid)object).equip(equipment);
        }
        object = new Date();
        this.dateWhenGainedLevel[0] = Long.toString(((Date)object).getTime());
    }

    private void a() {
        if (this.characterClass == 0) {
            this.strength += 12;
            this.dexterity += 9;
            this.constitution += 11;
            this.willpower += 8;
            return;
        }
        if (this.characterClass == 2) {
            this.strength += 10;
            this.dexterity += 10;
            this.constitution += 10;
            this.willpower += 10;
            return;
        }
        if (this.characterClass == 1) {
            this.strength += 8;
            this.dexterity += 9;
            this.constitution += 11;
            this.willpower += 12;
        }
    }

    public void updateAbilities() {
        int n = this.level - 1;
        this.activeAbilities[0] = null;
        this.activeAbilities[1] = null;
        this.activeAbilities[2] = null;
        this.activeAbilities[3] = null;
        if (this.characterClass == 0) {
            if (false | AbilityTables.ABILITY_LEVELS[n][0] > 0) {
                this.activeAbilities[0] = new Strike();
            }
            if (false | AbilityTables.ABILITY_LEVELS[n][1] > 0) {
                this.activeAbilities[1] = new Enrage();
            }
            if (false | AbilityTables.ABILITY_LEVELS[n][2] > 0) {
                this.activeAbilities[2] = new MightyBlow();
            }
            if (false | AbilityTables.ABILITY_LEVELS[n][3] > 0) {
                this.activeAbilities[3] = new ShieldWall();
            }
        } else if (this.characterClass == 2) {
            if (AbilityTables.ABILITY_LEVELS[n][0] > 0) {
                this.activeAbilities[0] = new Heal();
            }
            if (AbilityTables.ABILITY_LEVELS[n][1] > 0) {
                this.activeAbilities[1] = new HolyBolt();
            }
            if (AbilityTables.ABILITY_LEVELS[n][2] > 0) {
                this.activeAbilities[2] = new Weakness();
            }
            if (AbilityTables.ABILITY_LEVELS[n][3] > 0) {
                this.activeAbilities[3] = new HealingAura();
            }
        } else if (this.characterClass == 1) {
            if (AbilityTables.ABILITY_LEVELS[n][0] > 0) {
                this.activeAbilities[0] = new FireBall();
            }
            if (AbilityTables.ABILITY_LEVELS[n][1] > 0) {
                this.activeAbilities[1] = new Ignite();
            }
            if (AbilityTables.ABILITY_LEVELS[n][2] > 0) {
                this.activeAbilities[2] = new Polymorph();
            }
            if (AbilityTables.ABILITY_LEVELS[n][3] > 0) {
                this.activeAbilities[3] = new MeteorStrike();
            }
        }
        for (int i = 0; i < 4; ++i) {
            if (this.activeAbilities[i] == null) continue;
            this.activeAbilities[i].setLevel(AbilityTables.ABILITY_LEVELS[n][i]);
            this.activeAbilities[i].setAbilitySlot(i);
        }
    }

    public void awardKill(Creature creature) {
        int n = creature.getExperienceWorth();
        this.textEvents.addElement(new CombatText((Creature)this, "exp " + n, System.currentTimeMillis(), DarkwoodGraphics.FONT_ARIAL10_LIGHTBLUE));
        if (this != Game.player) {
            return;
        }
        this.awardExp(n);
        if (this.currentQuest != null) {
            this.currentQuest.awardKillRequirement(creature);
        }
    }

    public void awardExp(int n) {
        if (this.a()) {
            return;
        }
        if (this.c > 0) {
            if (this.c < n) {
                n -= this.c;
                this.c = 0;
            } else {
                this.c -= n;
                n = 0;
            }
        }
        this.experience += n;
        this.totalExperience += n;
        if (this.experience > this.getExpRequiredForNextLevel()) {
            this.experience -= this.getExpRequiredForNextLevel();
            Player player = this;
            player.textEvents.addElement(new CombatText((Creature)player, "LEVEL UP", System.currentTimeMillis(), DarkwoodGraphics.FONT_ARIAL10_LIGHTBLUE));
            ++player.level;
            MessageLog.getInstance().addMessage("You gain a level!");
            Display.getDisplay((MIDlet)Game.gameMidlet).vibrate(500);
            player.updateStats();
            player.updateAbilities();
            if (AbilityTables.checkAbilityChange(player.level) != -1) {
                Ability ability = player.activeAbilities[AbilityTables.checkAbilityChange(player.level)];
                MessageLog.getInstance().addMessage("New ability: " + ability.name + " [" + ability.getLevel() + "]");
            }
            player.a();
            player.dateWhenGainedLevel[player.level] = Long.toString(new Date().getTime());
        }
        Logger.getInstance().debug("Exp:" + n + " / " + this.getExpRequiredForNextLevel());
    }

    private boolean a() {
        if (this.level >= 30) {
            this.experience = 0;
            return true;
        }
        return false;
    }

    public void updateStats() {
        super.updateStats();
        this.a();
        this.strength += this.trainedStats[0];
        this.dexterity += this.trainedStats[1];
        this.constitution += this.trainedStats[2];
        this.willpower += this.trainedStats[3];
        this.updateMaxHealthAndMana();
        super.restartBuffs();
    }

    public void updateMaxHealthAndMana() {
        this.maxHealth = this.constitution * 7 + (this.strength + this.dexterity + this.willpower);
        this.maxMana = this.willpower * 10;
    }

    public String sendInformation() {
        return "Player:" + this.getId() + "," + CharacterSerializer.createXmlString(this);
    }

    public boolean hates(Creature creature) {
        return creature instanceof Monster;
    }

    public String playerClassString() {
        String string = "undefined";
        switch (this.characterClass) {
            case 0: {
                string = "Warrior";
                break;
            }
            case 1: {
                string = "Mage";
                break;
            }
            case 2: {
                string = "Cleric";
            }
        }
        return string;
    }

    public int getAvailableStatPoints() {
        int n;
        int n2 = 0;
        for (n = 0; n < 4; ++n) {
            n2 += this.trainedStats[n];
        }
        n = (this.level - 1) * 6;
        return n - n2;
    }

    public int getId() {
        return this.a;
    }

    public void setGlobalCharacterId(int n) {
        this.a = n;
    }

    public void invokeActiveAbility(int n) {
        if (this.activeAbilities[n] != null) {
            this.activeAbilities[n].invoke(Game.player);
        }
    }

    public void resetDeathPenalty() {
        this.c = this.getExpRequiredForNextLevel() / 10;
    }

    public void setDeathPenaltyExpBuffer(int n) {
        this.c = n;
    }

    public int getDeathPenaltyExpBuffer() {
        return this.c;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Player)object;
        return this.a == ((Player)object).a;
    }

    public int hashCode() {
        int n = 85 + this.a;
        return n;
    }
}

