/*
 * Decompiled with CFR 0.152.
 */
package GameFiles.Instances;

import GameFiles.Instances.Instance;

public class World
extends Instance {
    private byte[][][] villageArray;
    private short[][] VillagePositionTable;
    private byte[][][] DungeonArray;
    private short[][] DungeonPositionTable;
    private byte[][][] RuinArray;
    private short[][] RuinPositionTable;

    public World() {
        super((short)0, null, "\u043f\u0443\u0441\u0442\u043e\u0442\u0430");
    }

    public World(short s, byte[][] byArray, byte[][][] byArray2, short[][] sArray, byte[][][] byArray3, short[][] sArray2, byte[][][] byArray4, short[][] sArray3, String string) {
        super(s, byArray, string);
        this.VillagePositionTable = sArray;
        this.villageArray = byArray2;
        this.DungeonArray = byArray3;
        this.DungeonPositionTable = sArray2;
        this.RuinArray = byArray4;
        this.RuinPositionTable = sArray3;
        this.symbol = new char[]{'-', '^', '*', '\"', '~', '-', 'V', ' ', 'R', 'D', '%', '@'};
        this.symbolDescription = new String[]{"\u0412\u044b \u0438\u0434\u0435\u0442\u0435 \u043f\u043e \u0437\u0435\u043b\u0435\u043d\u043e\u043c\u0443 \u043b\u0443\u0433\u0443", "\u0412\u044b \u0432\u0437\u043e\u0431\u0440\u0430\u043b\u0438\u0441\u044c \u043d\u0430 \u0433\u043e\u0440\u0443", "\u0412\u044b \u0438\u0434\u0435\u0442\u0435 \u043f\u043e \u0441\u0442\u0440\u0430\u0448\u043d\u043e\u043c\u0443 \u0442\u0435\u043c\u043d\u043e\u043c\u0443 \u043b\u0435\u0441\u0443", "\u0412\u044b \u0438\u0434\u0435\u0442\u0435 \u043f\u043e \u043a\u043b\u0430\u0434\u0431\u0438\u0449\u0443", "\u0412\u044b \u043f\u043b\u044b\u0432\u0435\u0442\u0435 \u0432 \u0447\u0438\u0441\u0442\u043e\u0439 \u0432\u043e\u0434\u0435", "\u0412\u044b \u0438\u0434\u0435\u0442\u0435 \u043f\u043e \u0436\u0430\u0440\u043a\u043e\u0439 \u043f\u0443\u0441\u0442\u044b\u043d\u0435", "\u0414\u0435\u0440\u0435\u0432\u043d\u044f", "\u041f\u0435\u0449\u0435\u0440\u0430", "\u0420\u0443\u0438\u043d\u044b", "\u041f\u043e\u0434\u0437\u0435\u043c\u0435\u043b\u044c\u0435", "\u041f\u0443\u0441\u0442\u043e\u0442\u0430", "\u0421\u0430\u043c"};
        this.clip = new char[0];
        this.colorTable = new int[]{65280, 0xC1CDCD, 25600, 7048739, 2003199, 0xFFFF00, 0xB22222, 0xB22222, 0xB22222, 0xB22222, 0xB22222, 0xFFFFFF};
    }

    public void setMap(byte[][] byArray) {
        this.map = byArray;
    }

    public void setID(int n) {
        this.ID = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setVillageArray(byte[][][] byArray) {
        this.villageArray = byArray;
    }

    public short[][] getVillagePositionTable() {
        return this.VillagePositionTable;
    }

    public void setVillagePositionTable(short[][] sArray) {
        this.VillagePositionTable = sArray;
    }

    public byte[][][] getVillageArray() {
        return this.villageArray;
    }

    public String getSymbolDescription(byte by, int n, int n2) {
        int n3;
        int n4;
        if (this.symbolDescription[by].equals("\u0414\u0435\u0440\u0435\u0432\u043d\u044f")) {
            for (n4 = 0; n4 < this.VillagePositionTable.length; ++n4) {
                if (this.VillagePositionTable[n4][0] != n || this.VillagePositionTable[n4][1] != n2) continue;
                for (n3 = 0; n3 < this.villageArray.length; ++n3) {
                    if (this.GenerateID(this.villageArray[n3]) != this.VillagePositionTable[n4][2]) continue;
                    return "\u042d\u0442\u043e \u0434\u0435\u0440\u0435\u0432\u043d\u044f" + this.RebuildName(this.villageArray[n3]);
                }
            }
        }
        if (this.symbolDescription[by].equals("\u041f\u043e\u0434\u0437\u0435\u043c\u0435\u043b\u044c\u0435")) {
            for (n4 = 0; n4 < this.DungeonPositionTable.length; ++n4) {
                if (this.DungeonPositionTable[n4][0] != n || this.DungeonPositionTable[n4][1] != n2) continue;
                for (n3 = 0; n3 < this.DungeonArray.length; ++n3) {
                    if (this.GenerateID(this.DungeonArray[n3]) != this.DungeonPositionTable[n4][2]) continue;
                    return "\u042d\u0442\u043e \u043f\u043e\u0434\u0437\u0435\u043c\u0435\u043b\u044c\u0435" + this.RebuildName(this.DungeonArray[n3]);
                }
            }
        }
        if (this.symbolDescription[by].equals("\u0420\u0443\u0438\u043d\u044b")) {
            for (n4 = 0; n4 < this.RuinPositionTable.length; ++n4) {
                if (this.RuinPositionTable[n4][0] != n || this.RuinPositionTable[n4][1] != n2) continue;
                for (n3 = 0; n3 < this.RuinArray.length; ++n3) {
                    if (this.GenerateID(this.RuinArray[n3]) != this.RuinPositionTable[n4][2]) continue;
                    return "\u042d\u0442\u043e \u0440\u0443\u0438\u043d\u044b" + this.RebuildName(this.RuinArray[n3]);
                }
            }
        }
        if (this.symbolDescription[by].equals("\u041f\u0443\u0441\u0442\u043e\u0442\u0430")) {
            return "\u0412\u044b \u0432\u0438\u0434\u0438\u0442\u0435 \u0442\u0440\u0435\u0449\u0438\u043d\u044b \u0432 \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438";
        }
        return this.symbolDescription[by];
    }

    private String RebuildName(byte[][] byArray) {
        char[] cArray = new char[]{'A', 'E', 'I', 'O', 'U', 'Y'};
        char[] cArray2 = new char[]{'B', 'C', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Z'};
        boolean bl = false;
        String string = "";
        if (byArray[0][0] % 2 == 0) {
            bl = true;
        }
        for (int i = 0; i < 7; ++i) {
            string = bl ? (i == 0 ? string + cArray[Math.abs(byArray[i][0]) % (cArray.length - 1)] : string + Character.toLowerCase(cArray[Math.abs(byArray[i][0]) % (cArray.length - 1)])) : (i == 0 ? string + cArray2[Math.abs(byArray[i][0]) % (cArray2.length - 1)] : string + Character.toLowerCase(cArray2[Math.abs(byArray[i][0]) % (cArray2.length - 1)]));
            bl = !bl;
        }
        return string;
    }

    public byte[][] GetVillageOnPosition(int n, int n2) {
        for (int i = 0; i < this.VillagePositionTable.length; ++i) {
            if (this.VillagePositionTable[i][0] != n || this.VillagePositionTable[i][1] != n2) continue;
            for (int j = 0; j < this.villageArray.length; ++j) {
                if (this.GenerateID(this.villageArray[j]) != this.VillagePositionTable[i][2]) continue;
                return this.villageArray[j];
            }
        }
        return null;
    }

    public byte[][] GetDungeonOnPosition(int n, int n2) {
        for (int i = 0; i < this.DungeonPositionTable.length; ++i) {
            if (this.DungeonPositionTable[i][0] != n || this.DungeonPositionTable[i][1] != n2) continue;
            for (int j = 0; j < this.DungeonArray.length; ++j) {
                if (this.GenerateID(this.DungeonArray[j]) != this.DungeonPositionTable[i][2]) continue;
                return this.DungeonArray[j];
            }
        }
        return null;
    }

    public byte[][] GetRuinOnPosition(int n, int n2) {
        for (int i = 0; i < this.RuinPositionTable.length; ++i) {
            if (this.RuinPositionTable[i][0] != n || this.RuinPositionTable[i][1] != n2) continue;
            for (int j = 0; j < this.RuinArray.length; ++j) {
                if (this.GenerateID(this.RuinArray[j]) != this.RuinPositionTable[i][2]) continue;
                return this.RuinArray[j];
            }
        }
        return null;
    }

    public byte GetRuinFilledOnPosition(int n, int n2) {
        for (int i = 0; i < this.RuinPositionTable.length; ++i) {
            if (this.RuinPositionTable[i][0] != n || this.RuinPositionTable[i][1] != n2) continue;
            return (byte)this.RuinPositionTable[i][3];
        }
        return 0;
    }

    public byte GetDungeonFilledOnPosition(int n, int n2) {
        for (int i = 0; i < this.DungeonPositionTable.length; ++i) {
            if (this.DungeonPositionTable[i][0] != n || this.DungeonPositionTable[i][1] != n2) continue;
            return (byte)this.DungeonPositionTable[i][3];
        }
        return 0;
    }

    public void SetRuinFilledOnPosition(int n, int n2, byte by) {
        for (int i = 0; i < this.RuinPositionTable.length; ++i) {
            if (this.RuinPositionTable[i][0] != n || this.RuinPositionTable[i][1] != n2) continue;
            this.RuinPositionTable[i][3] = by;
        }
    }

    public void SetDungeonFilledOnPosition(int n, int n2, byte by) {
        for (int i = 0; i < this.DungeonPositionTable.length; ++i) {
            if (this.DungeonPositionTable[i][0] != n || this.DungeonPositionTable[i][1] != n2) continue;
            this.DungeonPositionTable[i][3] = by;
        }
    }

    private short GenerateID(byte[][] byArray) {
        short s = 0;
        for (int i = 0; i < byArray.length; ++i) {
            for (int j = 0; j < byArray[0].length; ++j) {
                s = (short)(s + byArray[i][j]);
            }
        }
        return s;
    }

    public boolean IsVillage(byte by) {
        return this.symbolDescription[by].equals("\u0414\u0435\u0440\u0435\u0432\u043d\u044f");
    }

    public boolean IsVoid(byte by) {
        return this.symbolDescription[by].equals("\u041f\u0443\u0441\u0442\u043e\u0442\u0430");
    }

    public boolean IsDungeon(byte by) {
        return this.symbolDescription[by].equals("\u041f\u043e\u0434\u0437\u0435\u043c\u0435\u043b\u044c\u0435");
    }

    public boolean IsRuin(byte by) {
        return this.symbolDescription[by].equals("\u0420\u0443\u0438\u043d\u044b");
    }

    public void UpdateFilled(int n) {
        int n2;
        for (n2 = 0; n2 < this.DungeonPositionTable.length; ++n2) {
            short[] sArray = this.DungeonPositionTable[n2];
            sArray[3] = (short)(sArray[3] + n);
        }
        for (n2 = 0; n2 < this.RuinPositionTable.length; ++n2) {
            short[] sArray = this.RuinPositionTable[n2];
            sArray[3] = (short)(sArray[3] + n);
        }
    }

    public byte[][][] getRuinArray() {
        return this.RuinArray;
    }

    public byte[][][] getDungeonArray() {
        return this.DungeonArray;
    }

    public short[][] getDungeonPositionTable() {
        return this.DungeonPositionTable;
    }

    public short[][] getRuinPositionTable() {
        return this.RuinPositionTable;
    }
}

