/*
 * Decompiled with CFR 0.152.
 */
package GameFiles.Character;

import GameFiles.ItemList;
import GameFiles.Items.Item;

public class InventoryArray
extends ItemList {
    Item[] EquipedArray = new Item[5];
    private short intelligenceEffect = 0;
    private short attackSkillEffect = 0;
    private short defenceSkillEffect = 0;
    private short healthEffect = 0;
    private short strenghtEffect = 0;
    private short defenceEffect = 0;
    private short totalWeight = 0;

    public InventoryArray(int n) {
        super(n);
    }

    public Item[] GetType(int n) {
        int n2 = 0;
        for (int i = 0; i < this.internalArray.length; ++i) {
            if (this.internalArray[i].getType() != n) continue;
            ++n2;
        }
        Item[] itemArray = new Item[n2];
        int n3 = 0;
        for (int i = 0; i < this.internalArray.length; ++i) {
            if (this.internalArray[i].getType() != n) continue;
            itemArray[n3] = this.internalArray[i];
            ++n3;
        }
        return itemArray;
    }

    public boolean AddItemToEquipedInventory(Item item, int n) {
        Item item2 = null;
        for (int i = 0; i < this.internalArray.length; ++i) {
            if (this.internalArray[i] == null || item != this.internalArray[i]) continue;
            item2 = this.RemoveItem(this.internalArray[i]);
        }
        if (item2 != null && n < this.EquipedArray.length && n > -1) {
            if (this.EquipedArray[n] == null) {
                this.EquipedArray[n] = item2;
                this.UpdateEffects();
                return true;
            }
            if (this.EquipedArray[n] != null) {
                this.RemoveItemFromEquipedInventory(n);
                this.EquipedArray[n] = item2;
                this.UpdateEffects();
                return true;
            }
            System.out.println("EqError");
            return false;
        }
        System.out.println("EqError");
        return false;
    }

    public boolean RemoveItemFromEquipedInventory(int n) {
        if (n < this.EquipedArray.length && n > -1) {
            for (int i = 0; i < this.EquipedArray.length && this.EquipedArray[n] != null; ++i) {
                if (i != n) continue;
                this.AddItem(this.EquipedArray[i]);
                this.EquipedArray[i] = null;
                this.UpdateEffects();
                return true;
            }
        }
        return false;
    }

    public short GetTotalInventoryWeight() {
        int n;
        short s = 0;
        for (n = 0; n < this.internalArray.length; ++n) {
            if (this.internalArray[n] == null) continue;
            s = (short)(s + this.internalArray[n].getWeight());
        }
        for (n = 0; n < this.EquipedArray.length; ++n) {
            if (this.EquipedArray[n] == null) continue;
            s = (short)(s + this.EquipedArray[n].getWeight());
        }
        return s;
    }

    public Item[] getEquipedArray() {
        return this.EquipedArray;
    }

    private short GetEquipedHealtEffect() {
        short s = 0;
        for (int i = 0; i < this.EquipedArray.length; ++i) {
            if (this.EquipedArray[i] == null) continue;
            s = (short)(s + this.EquipedArray[i].getHealthEffect());
        }
        return s;
    }

    private short GetEquipedAttackSkillEffect() {
        short s = 0;
        for (int i = 0; i < this.EquipedArray.length; ++i) {
            if (this.EquipedArray[i] == null) continue;
            s = (short)(s + this.EquipedArray[i].getAttackSkillEffect());
        }
        return s;
    }

    private short GetEquipedDefenceSkillEffect() {
        short s = 0;
        for (int i = 0; i < this.EquipedArray.length; ++i) {
            if (this.EquipedArray[i] == null) continue;
            s = (short)(s + this.EquipedArray[i].getDefenceSkillEffect());
        }
        return s;
    }

    private short GetEquipedIntelligenceEffect() {
        short s = 0;
        for (int i = 0; i < this.EquipedArray.length; ++i) {
            if (this.EquipedArray[i] == null) continue;
            s = (short)(s + this.EquipedArray[i].getIntelligenceEffect());
        }
        return s;
    }

    private short GetEquipedStrenghtEffect() {
        short s = 0;
        for (int i = 0; i < this.EquipedArray.length; ++i) {
            if (this.EquipedArray[i] == null) continue;
            s = (short)(s + this.EquipedArray[i].getStrenghtEffect());
        }
        return s;
    }

    private short GetEquipedDefenceEffect() {
        short s = 0;
        for (int i = 0; i < this.EquipedArray.length; ++i) {
            if (this.EquipedArray[i] == null) continue;
            s = (short)(s + this.EquipedArray[i].getDefenceEffect());
        }
        return s;
    }

    private void UpdateEffects() {
        this.attackSkillEffect = this.GetEquipedAttackSkillEffect();
        this.defenceSkillEffect = this.GetEquipedDefenceSkillEffect();
        this.intelligenceEffect = this.GetEquipedIntelligenceEffect();
        this.healthEffect = this.GetEquipedHealtEffect();
        this.strenghtEffect = this.GetEquipedStrenghtEffect();
        this.defenceEffect = this.GetEquipedDefenceEffect();
        this.totalWeight = this.GetTotalInventoryWeight();
    }

    public void AddItem(Item item) {
        super.AddItem(item);
        this.UpdateEffects();
    }

    public Item RemoveItem(Item item) {
        Item item2 = super.RemoveItem(item);
        this.UpdateEffects();
        return item2;
    }

    public Item RemoveItem(int n) {
        Item item = super.RemoveItem(n);
        this.UpdateEffects();
        return item;
    }

    public short getDefence() {
        return this.defenceEffect;
    }

    public short getAttackSkillEffect() {
        return this.attackSkillEffect;
    }

    public short getDefenceSkillEffect() {
        return this.defenceSkillEffect;
    }

    public short getHealthEffect() {
        return this.healthEffect;
    }

    public short getIntelligenceEffect() {
        return this.intelligenceEffect;
    }

    public short getStrenghtEffect() {
        return this.strenghtEffect;
    }

    public short getTotalWeight() {
        return this.totalWeight;
    }

    public Item[] GetUsableItems() {
        Item[] itemArray = new Item[this.EquipedArray.length];
        for (int i = 0; i < this.EquipedArray.length; ++i) {
            if (this.EquipedArray[i] == null || this.EquipedArray[i].getType() != 1) continue;
            itemArray[i] = this.EquipedArray[i];
        }
        return itemArray;
    }

    public void DeleteFromEquipedArray(int n) {
        if (n < this.EquipedArray.length && n > -1) {
            this.EquipedArray[n] = null;
        }
        this.UpdateEffects();
    }

    public void UpdateFromEquipedArray(int n, Item item) {
        if (n < this.EquipedArray.length && n > -1 && item != null) {
            this.EquipedArray[n] = item;
        }
        this.UpdateEffects();
    }
}

