/*
 * Decompiled with CFR 0.152.
 */
package GameFiles.Character;

import GameFiles.Character.InventoryArray;
import GameFiles.Generators.ItemGenerator;
import GameFiles.Items.Item;
import java.util.Random;

public class Player {
    int level = 1;
    long currentExp = 0L;
    short undividedSkillpoints = (short)5;
    int maxHitPoints = 40;
    int currentHitpoints = 40;
    int intelligenceLevel = 5;
    int defenceSkillLevel = 5;
    int attackSkillLevel = 5;
    int StrenghtLevel = 5;
    int defence = 5;
    int weightModifier = 2;
    int gold = 0;
    int monstersKilled = 0;
    int itemsPickedUp = 0;
    public InventoryArray inventory = new InventoryArray(10);
    short xPos = 0;
    short yPos = 0;
    byte currentlyOn = 0;

    public Player() {
        this.level = 0;
        this.currentExp = 0L;
        this.undividedSkillpoints = 0;
        this.maxHitPoints = 0;
        this.currentHitpoints = 0;
        this.intelligenceLevel = 0;
        this.defenceSkillLevel = 0;
        this.attackSkillLevel = 0;
        this.StrenghtLevel = 0;
        this.defence = 0;
        this.weightModifier = 2;
        this.gold = 0;
        this.monstersKilled = 0;
        this.itemsPickedUp = 0;
        this.xPos = 0;
        this.yPos = 0;
        this.currentlyOn = 0;
    }

    public Player(short s, short s2) {
        this.xPos = s;
        this.yPos = s2;
        this.CreateCharacter();
    }

    public short getXPos() {
        return this.xPos;
    }

    public short getYPos() {
        return this.yPos;
    }

    public void setXPos(short s) {
        this.xPos = s;
    }

    public void setYPos(short s) {
        this.yPos = s;
    }

    public byte getCurrentlyOn() {
        return this.currentlyOn;
    }

    public void setCurrentlyOn(byte by) {
        this.currentlyOn = by;
    }

    public int getLevel() {
        return this.level;
    }

    public int getAttackSkillLevel() {
        return this.attackSkillLevel;
    }

    public int getDefenceSkillLevel() {
        return this.defenceSkillLevel;
    }

    public int getIntelligenceLevel() {
        return this.intelligenceLevel;
    }

    public int getStrenghtLevel() {
        return this.StrenghtLevel;
    }

    public int getDefence() {
        return this.defence;
    }

    public InventoryArray getInventory() {
        return this.inventory;
    }

    public int getMaxHitPoints() {
        return this.maxHitPoints;
    }

    public int getCurrentHitpoints() {
        return this.currentHitpoints;
    }

    public void setCurrentHitpoints(int n) {
        this.currentHitpoints = n;
    }

    public boolean CheckWeight(Item item) {
        return this.inventory.getTotalWeight() + item.getWeight() <= this.StrenghtLevel * this.weightModifier + 40;
    }

    public int getTotalWeightPosible() {
        return this.StrenghtLevel * this.weightModifier + 40;
    }

    public void AddExperiance(int n) {
        int n2 = this.getLevelThreshHold();
        while (this.currentExp + (long)n > (long)n2 || n != 0) {
            if (this.currentExp + (long)n > (long)n2) {
                this.currentExp = this.currentExp + (long)n - (long)n2;
                ++this.level;
                this.undividedSkillpoints = (short)(this.undividedSkillpoints + (this.level / 10 + 1));
            } else {
                this.currentExp += (long)n;
            }
            n = 0;
        }
    }

    public void setyPos(short s) {
        this.yPos = s;
    }

    public void setxPos(short s) {
        this.xPos = s;
    }

    public void setWeightModifier(int n) {
        this.weightModifier = n;
    }

    public void setStrenghtLevel(int n) {
        this.StrenghtLevel = n;
    }

    public void setMonstersKilled(int n) {
        this.monstersKilled = n;
    }

    public void setMaxHitPoints(int n) {
        this.maxHitPoints = n;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public void setItemsPickedUp(int n) {
        this.itemsPickedUp = n;
    }

    public void setInventory(InventoryArray inventoryArray) {
        this.inventory = inventoryArray;
    }

    public void setIntelligenceLevel(int n) {
        this.intelligenceLevel = n;
    }

    public void setGold(int n) {
        this.gold = n;
    }

    public void setDefenceSkillLevel(int n) {
        this.defenceSkillLevel = n;
    }

    public void setDefence(int n) {
        this.defence = n;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public void setCurrentExp(long l) {
        this.currentExp = l;
    }

    public void setAttackSkillLevel(int n) {
        this.attackSkillLevel = n;
    }

    public int getLevelThreshHold() {
        return (int)((double)(this.level + 5) + ((double)this.level + 1.0) * 0.3);
    }

    public void addToItemsPickedUp(int n) {
        this.itemsPickedUp += n;
    }

    public void addToMonstersKilled(int n) {
        this.monstersKilled += n;
    }

    public void addToStrenght(int n) {
        this.StrenghtLevel += n;
    }

    public void addToDefence(int n) {
        this.defence += n;
        this.maxHitPoints += this.level / 10 * 2 + 5;
        this.currentHitpoints += this.level / 10 * 2 + 5;
    }

    public void addToAttackSkill(int n) {
        this.attackSkillLevel += n;
    }

    public void addToDefenceSkill(int n) {
        this.defenceSkillLevel += n;
    }

    public void addToIntelligence(int n) {
        this.intelligenceLevel += n;
    }

    public void addGold(int n) {
        this.gold += n;
    }

    public int getItemsPickedUp() {
        return this.itemsPickedUp;
    }

    public int getMonstersKilled() {
        return this.monstersKilled;
    }

    public long getCurrentExp() {
        return this.currentExp;
    }

    public int getGold() {
        return this.gold;
    }

    public short getUndividedSkillpoints() {
        return this.undividedSkillpoints;
    }

    public void setUndividedSkillpoints(short s) {
        this.undividedSkillpoints = s;
    }

    private void CreateCharacter() {
        Random random = new Random();
        this.currentHitpoints = this.maxHitPoints = random.nextInt(20) + 60;
        this.intelligenceLevel = random.nextInt(3);
        this.defenceSkillLevel = random.nextInt(3);
        this.attackSkillLevel = random.nextInt(3);
        this.StrenghtLevel = random.nextInt(3);
        this.defence = random.nextInt(3);
        this.undividedSkillpoints = (short)(random.nextInt(8) + 2);
        for (int i = 0; i < this.level; ++i) {
            this.undividedSkillpoints = (short)(this.undividedSkillpoints + (i / 10 + 1));
        }
        ItemGenerator itemGenerator = new ItemGenerator();
        Item[] itemArray = itemGenerator.GetStartItems(this.level);
        for (int i = 0; i < itemArray.length; ++i) {
            this.inventory.AddItem(itemArray[i]);
        }
    }

    public String[] PlayerToString() {
        String[] stringArray = new String[]{"\u0423\u0440:" + this.level, "\u041e\u043f:" + this.currentExp, "Us:" + this.undividedSkillpoints, "Mh:" + this.maxHitPoints, "\u0416\u0441:" + this.currentHitpoints, "In:" + this.intelligenceLevel, "\u0417\u0443:" + this.defenceSkillLevel, "\u0410\u0443:" + this.attackSkillLevel, "\u0421\u0438\u043b:" + this.StrenghtLevel, "\u0417\u0430\u0449:" + this.defence, "\u0417\u043e\u043b:" + this.gold, "Mk:" + this.monstersKilled, "Ip:" + this.itemsPickedUp};
        return stringArray;
    }
}

