/*
 * Decompiled with CFR 0.152.
 */
package GameFiles.Generators;

import GameFiles.Generators.ItemGenerator;
import GameFiles.Generators.NPCGenerator;
import GameFiles.Instances.DesertCombatInstance;
import GameFiles.Instances.Dungeon;
import GameFiles.Instances.ForestCombatInstance;
import GameFiles.Instances.LakeCombatInstance;
import GameFiles.Instances.MountainCombatInstance;
import GameFiles.Instances.PlainCombatInstance;
import GameFiles.Instances.Ruin;
import GameFiles.Instances.SwampCombatInstance;
import GameFiles.Instances.Village;
import GameFiles.Instances.Void;
import GameFiles.Instances.World;
import GameFiles.Items.Item;
import GameFiles.NPCS.Monster;
import GameFiles.NPCS.NPC;
import java.util.Date;
import java.util.Random;

public class TerrainGenerator {
    private byte[][] map;
    private int worldSizeX;
    private int worldSizeY;
    private Random random = new Random();

    public TerrainGenerator(int n, int n2) {
        this.worldSizeX = n;
        this.worldSizeY = n2;
        this.worldSizeX = 100;
        this.worldSizeY = 100;
    }

    public byte[][] GetMap() {
        return this.map;
    }

    public World GenerateMap(boolean bl) {
        if (bl) {
            int[] nArray = new int[]{this.random.nextInt(80), this.random.nextInt(80), this.random.nextInt(80), this.random.nextInt(80), this.random.nextInt(80)};
            return this.GenerateMap(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], 45);
        }
        return this.GenerateMap(60, 60, 60, 40, 55, 45);
    }

    public World GenerateMap(int n, int n2, int n3, int n4, int n5, int n6) {
        short s;
        int n7;
        int n8;
        this.map = new byte[this.worldSizeY][this.worldSizeX];
        Date date = new Date();
        this.GenerateTerrain2(n, n2, n3, n4, n5);
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        for (int i = 0; i < this.map[0].length * this.map.length / (100 - n6); ++i) {
            int n13 = this.random.nextInt(100);
            if (n13 < 20) {
                ++n10;
            }
            if (n13 >= 20 && n13 < 70) {
                ++n11;
            }
            if (n13 < 70 || n13 >= 100) continue;
            ++n9;
        }
        short[][] sArray = new short[n10][4];
        byte[][][] byArray = new byte[n10][21][2];
        for (int i = 0; i < n10; ++i) {
            short s2 = (short)this.random.nextInt(this.map[0].length);
            n8 = (short)this.random.nextInt(this.map.length);
            this.map[n8][s2] = 6;
            sArray[i][0] = s2;
            sArray[i][1] = n8;
            byte[][] byArray2 = this.GenerateVillage();
            sArray[i][2] = this.GenerateID(byArray2);
            sArray[i][3] = 100;
            byArray[i] = byArray2;
        }
        short[][] sArray2 = new short[n11][4];
        byte[][][] byArray3 = new byte[n11][21][2];
        for (n8 = 0; n8 < n11; ++n8) {
            short s3 = (short)this.random.nextInt(this.map[0].length);
            n7 = (short)this.random.nextInt(this.map.length);
            this.map[n7][s3] = 9;
            sArray2[n8][0] = s3;
            sArray2[n8][1] = n7;
            byte[][] byArray4 = this.GenerateDungeon();
            sArray2[n8][2] = this.GenerateID(byArray4);
            sArray2[n8][3] = 100;
            byArray3[n8] = byArray4;
        }
        short[][] sArray3 = new short[n9][4];
        byte[][][] byArray5 = new byte[n9][21][2];
        for (n7 = 0; n7 < n9; ++n7) {
            short s4 = (short)this.random.nextInt(this.map[0].length);
            s = (short)this.random.nextInt(this.map.length);
            this.map[s][s4] = 8;
            sArray3[n7][0] = s4;
            sArray3[n7][1] = s;
            byte[][] byArray6 = this.GenerateRuin();
            sArray3[n7][2] = this.GenerateID(byArray6);
            sArray3[n7][3] = 100;
            byArray5[n7] = byArray6;
        }
        for (n7 = 0; n7 < this.random.nextInt(this.map.length / 5); ++n7) {
            if (this.random.nextInt(100) >= 50) continue;
            short s5 = (short)this.random.nextInt(this.map[0].length);
            s = (short)this.random.nextInt(this.map.length);
            this.map[s][s5] = 10;
            ++n12;
        }
        System.out.println("\u0413\u043e\u0440\u043e\u0434:" + n10);
        System.out.println("\u041f\u043e\u0434\u0437\u0435\u043c\u0435\u043b\u044c\u0435:" + n11);
        System.out.println("\u0420\u0443\u0438\u043d\u044b:" + n9);
        System.out.println("\u041f\u0443\u0441\u0442\u043e\u0442\u0430:" + n12);
        System.out.println("\u041e\u0431\u0449\u0435\u0435:" + (n10 + n11 + n9 + n12));
        System.out.println("Running time Bas : " + (new Date().getTime() - date.getTime()));
        return new World(0, this.map, byArray, sArray, byArray3, sArray2, byArray5, sArray3, this.RebuildName(this.GenerateVillage()));
    }

    private void GenerateTerrain2(int n, int n2, int n3, int n4, int n5) {
        block7: for (int i = 0; i < this.map[0].length * this.map.length / 25; ++i) {
            switch (this.random.nextInt(5)) {
                case 0: {
                    if (this.random.nextInt(100) >= n) continue block7;
                    this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)1, n);
                    continue block7;
                }
                case 1: {
                    if (this.random.nextInt(100) >= n2) continue block7;
                    this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)2, n2);
                    continue block7;
                }
                case 2: {
                    if (this.random.nextInt(100) >= n3) continue block7;
                    this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)3, n3);
                    continue block7;
                }
                case 3: {
                    if (this.random.nextInt(100) >= n4) continue block7;
                    this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)4, n4);
                    continue block7;
                }
                case 4: {
                    if (this.random.nextInt(100) >= n5) continue block7;
                    this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)5, n5);
                }
            }
        }
    }

    private void PlaceTerrainObject(int n, int n2, byte by, int n3) {
        if (this.random.nextInt(100) > n3 || this.map[n2][n] != 0) {
            return;
        }
        this.map[n2][n] = by;
        if (n > 0 && n2 < this.map.length - 1) {
            this.PlaceTerrainObject(n - 1, n2 + 1, by, n3 - 2);
        }
        if (n < this.map[0].length - 1 && n2 < this.map.length - 1) {
            this.PlaceTerrainObject(n + 1, n2 + 1, by, n3 - 2);
        }
        if (n2 < this.map.length - 1) {
            this.PlaceTerrainObject(n, n2 + 1, by, n3 - 2);
        }
        if (n > 0 && n2 > 0) {
            this.PlaceTerrainObject(n - 1, n2 - 1, by, n3 - 2);
        }
        if (n < this.map[0].length - 1 && n2 > 0) {
            this.PlaceTerrainObject(n + 1, n2 - 1, by, n3 - 2);
        }
        if (n2 > 0) {
            this.PlaceTerrainObject(n, n2 - 1, by, n3 - 2);
        }
        if (n < this.map[0].length - 1) {
            this.PlaceTerrainObject(n + 1, n2, by, n3 - 2);
        }
        if (n > 0) {
            this.PlaceTerrainObject(n - 1, n2, by, n3 - 2);
        }
    }

    private String RebuildName(byte[][] byArray) {
        char[] cArray = new char[]{'A', 'E', 'I', 'O', 'U', 'Y'};
        char[] cArray2 = new char[]{'B', 'C', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Z'};
        boolean bl = false;
        String string = "";
        if (byArray[0][0] % 2 == 0) {
            bl = true;
        }
        for (int i = 0; i < 7; ++i) {
            string = bl ? (i == 0 ? string + cArray[Math.abs(byArray[i][0]) % (cArray.length - 1)] : string + Character.toLowerCase(cArray[Math.abs(byArray[i][0]) % (cArray.length - 1)])) : (i == 0 ? string + cArray2[Math.abs(byArray[i][0]) % (cArray2.length - 1)] : string + Character.toLowerCase(cArray2[Math.abs(byArray[i][0]) % (cArray2.length - 1)]));
            bl = !bl;
        }
        return string;
    }

    public Village ReconstructVillage(byte[][] byArray) {
        int n;
        NPCGenerator nPCGenerator = new NPCGenerator();
        this.map = new byte[80][80];
        byte by3 = (byte)(this.random.nextInt(20) + 10);
        int n2 = 0;
        for (n = 0; n < byArray.length; ++n) {
            n2 += Math.abs((byArray[n][0] + byArray[n][1]) % 3 + 1);
        }
        NPC[] nPCArray = new NPC[n2 + 1];
        n2 = 0;
        for (n = 0; n < this.map.length * this.map[0].length / 100 * by3; ++n) {
            this.map[this.random.nextInt((int)this.map.length)][this.random.nextInt((int)this.map[0].length)] = this.random.nextInt(100) > 20 ? 7 : 8;
        }
        for (n = 0; n < byArray.length; ++n) {
            byte by2 = (byte)Math.abs(byArray[n][0] % 100 / 10);
            byte by = (byte)Math.abs(byArray[n][0] % 10);
            byte by4 = (byte)(byArray[n][1] % 100 / 10 * 10);
            byte by5 = (byte)(byArray[n][1] % 10 * 10);
            this.AddRoom(by2, by, by4, by5, byArray[n][0], true);
            if (by % 3 == 0) {
                if ((by4 = (byte)(by4 - by)) < 0) {
                    by4 = 0;
                }
            } else if (by % 3 == 1) {
                if ((by5 = (byte)(by5 - by2)) < 0) {
                    by5 = 0;
                }
            } else if (by % 3 == 2 && by4 + by - 1 < this.map[0].length) {
                by4 = (byte)(by4 + by - 1);
            }
            this.AddRoom(by, by2, by4, by5, byArray[n][0], false);
            int n3 = 0;
            while (n3 < (byArray[n][0] + byArray[n][1]) % 3 + 1) {
                nPCArray[n2] = nPCGenerator.GenerateVillager(byArray[n], n3 + 1);
                ++n3;
                ++n2;
            }
        }
        for (n = 0; n < nPCArray.length; ++n) {
            if (nPCArray[n] == null) continue;
            int n4 = this.random.nextInt(25 + (this.map[0].length - 50));
            int n5 = this.random.nextInt(25 + (this.map.length - 50));
            nPCArray[n].setXPos((short)n4);
            nPCArray[n].setYPos((short)n5);
            nPCArray[n].setCurrentlyOn(this.map[n5][n4]);
            this.map[nPCArray[n].getYPos()][nPCArray[n].getXPos()] = 9;
        }
        byte[][] byArray2 = this.map;
        this.map = null;
        return new Village(this.GenerateID(byArray), byArray2, this.RebuildName(byArray), nPCArray, new Item[0]);
    }

    private short GenerateID(byte[][] byArray) {
        short s = 0;
        for (int i = 0; i < byArray.length; ++i) {
            for (int j = 0; j < byArray[0].length; ++j) {
                s = (short)(s + byArray[i][j]);
            }
        }
        return s;
    }

    public byte[][] GenerateVillage() {
        String string;
        int n;
        int n2 = this.random.nextInt(5) + 5;
        int n3 = this.random.nextInt(5) + 5;
        byte[][] byArray = new byte[n2 + n3][2];
        for (n = 0; n < n3; ++n) {
            string = "";
            string = string + (this.random.nextInt(6) + 3);
            string = string + (this.random.nextInt(6) + 3);
            byArray[n][0] = -Byte.parseByte(string);
            string = "";
            string = string + (this.random.nextInt(6) + 1);
            string = string + (this.random.nextInt(6) + 1);
            byArray[n][1] = Byte.parseByte(string);
        }
        for (n = n3 - 1; n < n2 + n3; ++n) {
            string = "";
            string = string + (this.random.nextInt(4) + 3);
            string = string + (this.random.nextInt(4) + 3);
            byArray[n][0] = Byte.parseByte(string);
            string = "";
            string = string + (this.random.nextInt(6) + 1);
            string = string + (this.random.nextInt(6) + 1);
            byArray[n][1] = Byte.parseByte(string);
        }
        return byArray;
    }

    private void AddRoom(byte by, byte by2, int n, int n2, byte by3, boolean bl) {
        for (int i = n2; i <= by2 + n2; ++i) {
            for (int j = n; j <= by + n; ++j) {
                if (by3 >= 0) {
                    if (i == n2 || i == n2 + by2) {
                        this.map[i][j] = 2;
                        continue;
                    }
                    if (j == n || j == n + by) {
                        this.map[i][j] = 2;
                        continue;
                    }
                    this.map[i][j] = 1;
                    continue;
                }
                if ((by + by2) % 3 == 0) {
                    this.map[i][j] = 3;
                }
                if ((by + by2) % 3 == 1) {
                    this.map[i][j] = 4;
                }
                if ((by + by2) % 3 != 2) continue;
                this.map[i][j] = 10;
            }
        }
        if (bl && by3 >= 0) {
            if (by2 % 3 == by % 3) {
                this.map[n2 + by2][by / 2 + n] = 6;
            } else if (by % 3 == 0) {
                this.map[n2 + by2 / 2][n] = 6;
            } else if (by % 3 == 1) {
                this.map[n2][n + by / 2] = 6;
            } else if (by % 3 == 2) {
                this.map[n2 + by2 / 2][n + by] = 6;
            }
        } else if (by3 >= 0) {
            if (by % 3 == 0) {
                if (by2 / 2 == by) {
                    this.map[n2 + by2 / 2 - 1][n + by] = 6;
                } else {
                    this.map[n2 + by2 / 2][n + by] = 6;
                }
            }
            if (by % 3 == 1) {
                if (by / 2 == by2) {
                    this.map[n2 + by2][n + by / 2 - 1] = 6;
                } else {
                    this.map[n2 + by2][n + by / 2] = 6;
                }
            }
            if (by % 3 == 2) {
                if (by2 / 2 == by) {
                    this.map[n2 + by2 / 2 - 1][n] = 6;
                } else {
                    this.map[n2 + by2 / 2][n] = 6;
                }
            }
        }
    }

    public byte[][] GenerateDungeon() {
        int n = this.random.nextInt(20) + 11;
        byte[][] byArray = new byte[n][2];
        byArray[0][0] = 33;
        byArray[0][1] = 11;
        for (int i = 1; i < n; ++i) {
            String string = "";
            string = string + (this.random.nextInt(7) + 2);
            string = string + (this.random.nextInt(7) + 2);
            byArray[i][0] = -Byte.parseByte(string);
            string = "";
            string = string + (this.random.nextInt(8) + 1);
            string = string + (this.random.nextInt(8) + 1);
            byArray[i][1] = Byte.parseByte(string);
        }
        return byArray;
    }

    public Dungeon ReconstructDungeon(int n, byte[][] byArray, byte by) {
        int n2;
        this.map = new byte[100][100];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            this.DrawDungeonRoom(byArray[n2]);
        }
        for (n2 = 0; n2 < byArray.length - 1; ++n2) {
            this.DrawDungeonCorridor(byArray[n2], byArray[n2 + 1]);
        }
        this.DrawDungeonCorridor(byArray[n2], byArray[0]);
        this.GenerateWalls();
        Item[] itemArray = this.SetDungeonItems(n, byArray, by);
        NPC[] nPCArray = this.SetDungeonMonsters(n, byArray, by);
        this.PlaceDungeonEntrance(byArray[0]);
        byte[][] byArray2 = this.map;
        this.map = null;
        return new Dungeon(this.GenerateID(byArray), byArray2, this.RebuildName(byArray), nPCArray, itemArray);
    }

    private void DrawDungeonRoom(byte[] byArray) {
        byte by = (byte)Math.abs(byArray[0] % 100 / 10);
        byte by2 = (byte)Math.abs(byArray[0] % 10);
        byte by3 = (byte)(byArray[1] % 100 / 10 * 10);
        byte by4 = (byte)(byArray[1] % 10 * 10);
        for (int i = 0; i < by2 * 2; ++i) {
            if (by4 + i >= this.map.length - 2) continue;
            for (int j = 0; j < by * 2; ++j) {
                if (by3 + j >= this.map[0].length - 2) continue;
                this.map[by4 + i][by3 + j] = 1;
            }
        }
    }

    private void DrawDungeonCorridor(byte[] byArray, byte[] byArray2) {
        int n;
        byte by = (byte)Math.abs(byArray[0] % 100 / 10);
        byte by2 = (byte)Math.abs(byArray[0] % 10);
        byte by3 = (byte)(byArray[1] % 100 / 10 * 10);
        byte by4 = (byte)(byArray[1] % 10 * 10);
        int n2 = by3 + by / 2;
        int n3 = by4 + by2 / 2;
        byte by5 = (byte)Math.abs(byArray2[0] % 100 / 10);
        byte by6 = (byte)Math.abs(byArray2[0] % 10);
        byte by7 = (byte)(byArray2[1] % 100 / 10 * 10);
        byte by8 = (byte)(byArray2[1] % 10 * 10);
        int n4 = by7 + by5 / 2;
        int n5 = by8 + by6 / 2;
        int n6 = 0;
        for (n = 0; n < Math.abs(n3 - n5); ++n) {
            if (n3 - n5 < 0) {
                this.map[n3 + n][n2] = 1;
                n6 = n3 + n;
                continue;
            }
            this.map[n3 - n][n2] = 1;
            n6 = n3 - n;
        }
        for (n = 0; n < Math.abs(n2 - n4); ++n) {
            if (n2 - n4 < 0) {
                this.map[n6][n2 + n] = 1;
                continue;
            }
            this.map[n6][n2 - n] = 1;
        }
    }

    private void GenerateWalls() {
        for (int i = 1; i < this.map.length - 1; ++i) {
            for (int j = 1; j < this.map[0].length - 1; ++j) {
                if (this.map[i][j] != 1) continue;
                if (this.map[i + 1][j] != 1) {
                    this.map[i + 1][j] = 2;
                }
                if (this.map[i - 1][j] != 1) {
                    this.map[i - 1][j] = 2;
                }
                if (this.map[i][j + 1] != 1) {
                    this.map[i][j + 1] = 2;
                }
                if (this.map[i][j - 1] != 1) {
                    this.map[i][j - 1] = 2;
                }
                if (this.map[i - 1][j - 1] != 1) {
                    this.map[i - 1][j - 1] = 2;
                }
                if (this.map[i + 1][j - 1] != 1) {
                    this.map[i + 1][j - 1] = 2;
                }
                if (this.map[i + 1][j + 1] != 1) {
                    this.map[i + 1][j + 1] = 2;
                }
                if (this.map[i - 1][j + 1] == 1) continue;
                this.map[i - 1][j + 1] = 2;
            }
        }
    }

    private void PlaceDungeonEntrance(byte[] byArray) {
        byte by = (byte)Math.abs(byArray[0] % 100 / 10);
        byte by2 = (byte)Math.abs(byArray[0] % 10);
        byte by3 = (byte)(byArray[1] % 100 / 10 * 10);
        byte by4 = (byte)(byArray[1] % 10 * 10);
        this.map[by4 + by2 / 2 + 1][by3 + by / 2 + 1] = 3;
    }

    public byte[][] GenerateRuin() {
        int n = this.random.nextInt(10) + 10;
        byte[][] byArray = new byte[n][2];
        for (int i = 1; i < n; ++i) {
            String string = "";
            string = string + (this.random.nextInt(7) + 2);
            string = string + (this.random.nextInt(7) + 2);
            byArray[i][0] = -Byte.parseByte(string);
            string = "";
            string = string + (this.random.nextInt(8) + 1);
            string = string + (this.random.nextInt(8) + 1);
            byArray[i][1] = Byte.parseByte(string);
        }
        return byArray;
    }

    public Ruin ReconstructRuin(int n, byte[][] byArray, byte by) {
        int n2;
        this.map = new byte[100][100];
        byte by2 = (byte)(this.random.nextInt(20) + 20);
        int n3 = this.random.nextInt(100);
        for (n2 = 0; n2 < this.map.length * this.map[0].length / 100 * by2; ++n2) {
            this.map[this.random.nextInt((int)this.map.length)][this.random.nextInt((int)this.map[0].length)] = n3 < 20 ? 7 : (n3 > 20 && n3 < 40 ? 6 : 3);
            n3 = this.random.nextInt(100);
        }
        for (n2 = 0; n2 < byArray.length; ++n2) {
            this.DrawDungeonRoom(byArray[n2]);
        }
        this.GenerateRuinWalls(byArray);
        Item[] itemArray = this.SetDungeonItems(n, byArray, by);
        NPC[] nPCArray = this.SetDungeonMonsters(n, byArray, by);
        byte[][] byArray2 = this.map;
        this.map = null;
        return new Ruin(this.GenerateID(byArray), byArray2, this.RebuildName(byArray), nPCArray, itemArray);
    }

    private void GenerateRuinWalls(byte[][] byArray) {
        for (int i = 1; i < this.map.length - 1; ++i) {
            for (int j = 1; j < this.map[0].length - 1; ++j) {
                if (this.map[i][j] != 1) continue;
                if (this.map[i + 1][j] != 1 && Math.abs((byArray[i % (byArray.length - 1)][0] + i + j) % 97) < 19) {
                    this.map[i + 1][j] = 2;
                }
                if (this.map[i - 1][j] != 1 && Math.abs((byArray[i % (byArray.length - 1)][0] + i + j) % 97) < 32) {
                    this.map[i - 1][j] = 2;
                }
                if (this.map[i][j + 1] != 1 && Math.abs((byArray[i % (byArray.length - 1)][0] + i + j) % 97) < 19) {
                    this.map[i][j + 1] = 2;
                }
                if (this.map[i][j - 1] != 1 && Math.abs((byArray[i % (byArray.length - 1)][0] + i + j) % 97) < 32) {
                    this.map[i][j - 1] = 2;
                }
                if (this.map[i - 1][j - 1] != 1 && Math.abs((byArray[i % (byArray.length - 1)][0] + i + j) % 97) < 19) {
                    this.map[i - 1][j - 1] = 2;
                }
                if (this.map[i + 1][j - 1] != 1 && Math.abs((byArray[i % (byArray.length - 1)][0] + i + j) % 97) < 23) {
                    this.map[i + 1][j - 1] = 2;
                }
                if (this.map[i + 1][j + 1] != 1 && Math.abs((byArray[i % (byArray.length - 1)][0] + i + j) % 97) < 12) {
                    this.map[i + 1][j + 1] = 2;
                }
                if (this.map[i - 1][j + 1] == 1 || Math.abs((byArray[i % (byArray.length - 1)][0] + i + j) % 97) >= 32) continue;
                this.map[i - 1][j + 1] = 2;
            }
        }
    }

    public PlainCombatInstance GeneratePlainCombatInstance(int n) {
        this.map = new byte[100][100];
        byte by = (byte)(this.random.nextInt(20) + 20);
        int n2 = this.random.nextInt(100);
        for (int i = 0; i < this.map.length * this.map[0].length / 100 * by; ++i) {
            if (n2 < 30) {
                this.map[this.random.nextInt((int)this.map.length)][this.random.nextInt((int)this.map[0].length)] = 1;
            } else if (n2 > 30 && n2 < 90) {
                this.map[this.random.nextInt((int)this.map.length)][this.random.nextInt((int)this.map[0].length)] = 2;
            } else {
                this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)3, 30);
            }
            n2 = this.random.nextInt(100);
        }
        Item[] itemArray = this.SetCombatInstanceItems(n);
        NPC[] nPCArray = this.SetCombatInsanceMonsters(n);
        byte[][] byArray = this.map;
        this.map = null;
        return new PlainCombatInstance(1, byArray, "\u0420\u0430\u0432\u043d\u0438\u043d\u0430", nPCArray, itemArray);
    }

    public MountainCombatInstance GenerateMountainCombatInstance(int n) {
        this.map = new byte[100][100];
        byte by = (byte)(this.random.nextInt(20) + 20);
        int n2 = this.random.nextInt(100);
        for (int i = 0; i < this.map.length * this.map[0].length / 100 * by; ++i) {
            if (n2 < 35) {
                this.map[this.random.nextInt((int)this.map.length)][this.random.nextInt((int)this.map[0].length)] = 1;
            } else if (n2 > 35 && n2 < 70) {
                this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)2, 25);
            } else {
                this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)3, 25);
            }
            n2 = this.random.nextInt(100);
        }
        Item[] itemArray = this.SetCombatInstanceItems(n);
        NPC[] nPCArray = this.SetCombatInsanceMonsters(n);
        byte[][] byArray = this.map;
        this.map = null;
        return new MountainCombatInstance(1, byArray, "\u0413\u043e\u0440\u044b", nPCArray, itemArray);
    }

    public SwampCombatInstance GenerateSwampCombatInstance(int n) {
        this.map = new byte[100][100];
        byte by = (byte)(this.random.nextInt(20) + 20);
        int n2 = this.random.nextInt(100);
        for (int i = 0; i < this.map.length * this.map[0].length / 100 * by; ++i) {
            if (n2 < 30) {
                this.map[this.random.nextInt((int)this.map.length)][this.random.nextInt((int)this.map[0].length)] = 1;
            } else if (n2 > 30 && n2 < 70) {
                this.map[this.random.nextInt((int)this.map.length)][this.random.nextInt((int)this.map[0].length)] = 2;
            } else {
                this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)3, 30);
            }
            n2 = this.random.nextInt(100);
        }
        Item[] itemArray = this.SetCombatInstanceItems(n);
        NPC[] nPCArray = this.SetCombatInsanceMonsters(n);
        byte[][] byArray = this.map;
        this.map = null;
        return new SwampCombatInstance(1, byArray, "\u0411\u043e\u043b\u043e\u0442\u043e", nPCArray, itemArray);
    }

    public ForestCombatInstance GenerateForestCombatInstance(int n) {
        this.map = new byte[100][100];
        byte by = (byte)(this.random.nextInt(20) + 20);
        int n2 = this.random.nextInt(100);
        for (int i = 0; i < this.map.length * this.map[0].length / 100 * by; ++i) {
            if (n2 < 40) {
                this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)1, 25);
            } else if (n2 > 40 && n2 < 60) {
                this.map[this.random.nextInt((int)this.map.length)][this.random.nextInt((int)this.map[0].length)] = 2;
            } else if (n2 > 60 && n2 < 90) {
                this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)2, 30);
            } else {
                this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)3, 30);
            }
            n2 = this.random.nextInt(100);
        }
        Item[] itemArray = this.SetCombatInstanceItems(n);
        NPC[] nPCArray = this.SetCombatInsanceMonsters(n);
        byte[][] byArray = this.map;
        this.map = null;
        return new ForestCombatInstance(1, byArray, "\u041b\u0435\u0441", nPCArray, itemArray);
    }

    public LakeCombatInstance GenerateLakeCombatInstance(int n) {
        this.map = new byte[100][100];
        byte[][] byArray = this.GenerateDungeon();
        for (int i = 0; i < byArray.length; ++i) {
            this.DrawLakeIsland(byArray[i]);
        }
        Item[] itemArray = this.SetDungeonItems(n, byArray, (byte)20);
        NPC[] nPCArray = this.SetDungeonMonsters(n, byArray, (byte)60);
        byte[][] byArray2 = this.map;
        this.map = null;
        return new LakeCombatInstance(1, byArray2, "\u041e\u0437\u0435\u0440\u043e", nPCArray, itemArray);
    }

    private void DrawLakeIsland(byte[] byArray) {
        byte by = (byte)Math.abs(byArray[0] % 100 / 10);
        byte by2 = (byte)Math.abs(byArray[0] % 10);
        byte by3 = (byte)(byArray[1] % 100 / 10 * 10);
        byte by4 = (byte)(byArray[1] % 10 * 10);
        for (int i = 0; i < by2 * 2; ++i) {
            if (by4 + i >= this.map.length - 2) continue;
            for (int j = 0; j < by * 2; ++j) {
                if (by3 + j >= this.map[0].length - 2) continue;
                int n = this.random.nextInt(100);
                this.map[by4 + i][by3 + j] = n < 75 ? 3 : (n > 75 && n < 80 ? 1 : (n > 85 && n < 95 ? 2 : 6));
            }
        }
    }

    public Void GenerateVoid(int n) {
        this.map = new byte[100][100];
        byte by = (byte)(this.random.nextInt(20) + 20);
        int n2 = this.random.nextInt(100);
        for (int i = 0; i < this.map.length * this.map[0].length / 100 * by; ++i) {
            if (n2 < 10) {
                this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)1, 25);
            } else if (n2 > 10 && n2 < 20) {
                this.map[this.random.nextInt((int)this.map.length)][this.random.nextInt((int)this.map[0].length)] = 2;
            } else if (n2 > 20 && n2 < 30) {
                this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)2, 30);
            } else if (n2 > 30 && n2 < 40) {
                this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)3, 30);
            } else if (n2 > 40 && n2 < 50) {
                this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)9, 30);
            } else if (n2 > 50 && n2 < 60) {
                this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)10, 30);
            } else if (n2 > 60 && n2 < 70) {
                this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)6, 30);
            } else if (n2 > 70 && n2 < 80) {
                this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)7, 30);
            } else {
                this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)8, 30);
            }
            n2 = this.random.nextInt(100);
        }
        Item[] itemArray = this.SetCombatInstanceItems(n * (this.random.nextInt(10) + 2));
        NPC[] nPCArray = this.SetCombatInsanceMonsters(n * (this.random.nextInt(10) + 2));
        byte[][] byArray = this.map;
        this.map = null;
        return new Void(1, byArray, "\u041f\u0443\u0441\u0442\u043e\u0442\u0430", nPCArray, itemArray);
    }

    public DesertCombatInstance GenerateDessertInstance(int n) {
        this.map = new byte[100][100];
        byte by = (byte)(this.random.nextInt(10) + 10);
        int n2 = this.random.nextInt(100);
        for (int i = 0; i < this.map.length * this.map[0].length / 100 * by; ++i) {
            if (n2 < 60) {
                this.map[this.random.nextInt((int)this.map[0].length)][this.random.nextInt((int)this.map.length)] = 1;
            }
            if (n2 > 60 && n2 < 97) {
                this.map[this.random.nextInt((int)this.map[0].length)][this.random.nextInt((int)this.map.length)] = 2;
            }
            if (n2 > 97) {
                this.PlaceTerrainObject(this.random.nextInt(this.map[0].length), this.random.nextInt(this.map.length), (byte)3, 35);
            }
            n2 = this.random.nextInt(100);
        }
        Item[] itemArray = this.SetCombatInstanceItems(n);
        NPC[] nPCArray = this.SetCombatInsanceMonsters(n);
        byte[][] byArray = this.map;
        this.map = null;
        return new DesertCombatInstance(1, byArray, "\u041f\u0443\u0441\u0442\u044b\u043d\u044f", nPCArray, itemArray);
    }

    private NPC[] SetCombatInsanceMonsters(int n) {
        int n2;
        NPCGenerator nPCGenerator = new NPCGenerator();
        NPC[] nPCArray = new NPC[this.random.nextInt(30) + 20];
        NPC[] nPCArray2 = new NPC[this.random.nextInt(10) + 4];
        for (n2 = 0; n2 < nPCArray2.length; ++n2) {
            nPCArray2[n2] = nPCGenerator.CreateMonster(n);
        }
        for (n2 = 0; n2 < nPCArray.length; ++n2) {
            nPCArray[n2] = nPCGenerator.CloneMonster((Monster)nPCArray2[this.random.nextInt(100) % nPCArray2.length]);
            nPCArray[n2].setXPos((short)this.random.nextInt(this.map[0].length));
            nPCArray[n2].setYPos((short)this.random.nextInt(this.map.length));
            nPCArray[n2].setCurrentlyOn(this.map[nPCArray[n2].getYPos()][nPCArray[n2].getXPos()]);
            if (nPCArray[n2].getCurrentlyOn() != 4) {
                this.map[nPCArray[n2].getYPos()][nPCArray[n2].getXPos()] = 4;
                continue;
            }
            System.out.println("Error");
        }
        return nPCArray;
    }

    private NPC[] SetDungeonMonsters(int n, byte[][] byArray, byte by) {
        int n2;
        NPCGenerator nPCGenerator = new NPCGenerator();
        int n3 = (int)(1.5 * (double)by) + 1;
        int n4 = (int)(0.5 * (double)by) + 1;
        NPC[] nPCArray = new NPC[this.random.nextInt(n3) + n4];
        NPC[] nPCArray2 = new NPC[this.random.nextInt(30) + 10];
        int n5 = 0;
        for (n2 = 0; n2 < nPCArray2.length; ++n2) {
            nPCArray2[n2] = nPCGenerator.CreateMonster(n + 1);
            try {
                Thread.sleep(5L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n2 = 1; n2 < byArray.length; ++n2) {
            byte by2 = (byte)Math.abs(byArray[n2][0] % 100 / 10);
            byte by3 = (byte)Math.abs(byArray[n2][0] % 10);
            byte by4 = (byte)(byArray[n2][1] % 100 / 10 * 10);
            byte by5 = (byte)(byArray[n2][1] % 10 * 10);
            for (int i = 0; i < nPCArray.length / byArray.length; ++i) {
                nPCArray[n5] = nPCGenerator.CloneMonster((Monster)nPCArray2[this.random.nextInt(100) % nPCArray2.length]);
                nPCArray[n5].setXPos((short)(this.random.nextInt(by2) + by4));
                nPCArray[n5].setYPos((short)(this.random.nextInt(by3) + by5));
                nPCArray[n5].setCurrentlyOn(this.map[nPCArray[n5].getYPos()][nPCArray[n5].getXPos()]);
                if (nPCArray[n5].getCurrentlyOn() != 4) {
                    this.map[nPCArray[n5].getYPos()][nPCArray[n5].getXPos()] = 4;
                    ++n5;
                    continue;
                }
                nPCArray[n5] = null;
                System.out.println("ErrorD");
            }
        }
        return nPCArray;
    }

    private Item[] SetDungeonItems(int n, byte[][] byArray, byte by) {
        ItemGenerator itemGenerator = new ItemGenerator();
        int n2 = (int)(0.8 * (double)by) + 1;
        int n3 = (int)(0.4 * (double)by) + 1;
        Item[] itemArray = new Item[this.random.nextInt(n2) + n3];
        int n4 = 0;
        for (int i = 1; i < byArray.length; ++i) {
            byte by2 = (byte)Math.abs(byArray[i][0] % 100 / 10);
            byte by3 = (byte)Math.abs(byArray[i][0] % 10);
            byte by4 = (byte)(byArray[i][1] % 100 / 10 * 10);
            byte by5 = (byte)(byArray[i][1] % 10 * 10);
            for (int j = 0; j < itemArray.length / byArray.length; ++j) {
                itemArray[n4] = itemGenerator.GenerateRandomItem(n, false);
                itemArray[n4].setXPos((short)(this.random.nextInt(by2) + by4));
                itemArray[n4].setYPos((short)(this.random.nextInt(by3) + by5));
                itemArray[n4].setCurrentlyOn(this.map[itemArray[n4].getYPos()][itemArray[n4].getXPos()]);
                if (itemArray[n4].getCurrentlyOn() != 5) {
                    this.map[itemArray[n4].getYPos()][itemArray[n4].getXPos()] = 5;
                    ++n4;
                    continue;
                }
                itemArray[n4] = null;
            }
        }
        return itemArray;
    }

    private Item[] SetCombatInstanceItems(int n) {
        ItemGenerator itemGenerator = new ItemGenerator();
        Item[] itemArray = new Item[this.random.nextInt(20)];
        for (int i = 0; i < itemArray.length; ++i) {
            itemArray[i] = itemGenerator.GenerateRandomItem(n, false);
            itemArray[i].setXPos((short)this.random.nextInt(this.map[0].length));
            itemArray[i].setYPos((short)this.random.nextInt(this.map.length));
            itemArray[i].setCurrentlyOn(this.map[itemArray[i].getYPos()][itemArray[i].getXPos()]);
            if (itemArray[i].getCurrentlyOn() != 5) {
                this.map[itemArray[i].getYPos()][itemArray[i].getXPos()] = 5;
            } else {
                itemArray[i] = null;
                System.out.println("Error");
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return itemArray;
    }
}

