/*
 * Decompiled with CFR 0.152.
 */
package GameFiles;

import GameFiles.Character.Player;
import GameFiles.Generators.TerrainGenerator;
import GameFiles.Instances.CombatInstance;
import GameFiles.Instances.DesertCombatInstance;
import GameFiles.Instances.Dungeon;
import GameFiles.Instances.ForestCombatInstance;
import GameFiles.Instances.Instance;
import GameFiles.Instances.LakeCombatInstance;
import GameFiles.Instances.MountainCombatInstance;
import GameFiles.Instances.PlainCombatInstance;
import GameFiles.Instances.Ruin;
import GameFiles.Instances.SwampCombatInstance;
import GameFiles.Instances.Village;
import GameFiles.Instances.Void;
import GameFiles.Instances.World;
import GameFiles.Items.Item;
import GameFiles.MessageQueue;
import GameFiles.NPCS.NPC;
import java.util.Random;

public class Game {
    private World world;
    private Instance currentInstance;
    private Player player;
    private short worldXPos = (short)25;
    private short worldYPos = (short)25;
    private byte worldCurrentlyOn = 0;
    MessageQueue messageQueue = new MessageQueue(20);
    private byte filled = (byte)100;
    private short baseMonsters = 0;
    private short monstersKilled = 0;
    private short baseItems = 0;
    private short itemsPickedup = 0;
    private short timeReplanished = (short)100;
    private TerrainGenerator terrainGenerator = new TerrainGenerator(200, 200);
    private NPC currentTarget = null;
    private Random random = new Random();

    public Game(boolean bl) {
        if (bl) {
            this.NewGame();
        }
    }

    public void NewGame() {
        this.world = this.random.nextInt(100) < 60 ? this.terrainGenerator.GenerateMap(true) : this.terrainGenerator.GenerateMap(false);
        this.currentInstance = this.world;
        this.player = new Player((short)(this.currentInstance.getMap().length / 2), (short)(this.currentInstance.getMap()[0].length / 2));
        this.player.setCurrentlyOn(this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()]);
        this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()] = 11;
    }

    public World getWorld() {
        return this.world;
    }

    public Instance getCurrentInstance() {
        return this.currentInstance;
    }

    public void PlayerMoveLeft() {
        this.currentTarget = null;
        this.UseItems();
        this.ReplenishInstances();
        if (this.player.getXPos() - 1 >= 0) {
            if (!this.currentInstance.IsClipped(this.player.getXPos() - 1, this.player.getYPos())) {
                if (this.currentInstance instanceof Dungeon && this.player.getCurrentlyOn() == 3) {
                    this.EnterWorld();
                    this.messageQueue.AddMessages("You enter the wide world");
                    return;
                }
                this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()] = this.player.getCurrentlyOn();
                this.player.setXPos((short)(this.player.getXPos() - 1));
                this.player.setCurrentlyOn(this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()]);
                this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()] = 11;
                this.messageQueue.AddMessages(this.currentInstance.getSymbolDescription(this.player.getCurrentlyOn(), this.player.getXPos(), this.player.getYPos()));
                this.CreateAmbush();
            } else if (this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos() - 1] == 4 && this.currentInstance instanceof CombatInstance && !(this.currentInstance instanceof Village)) {
                this.BattlePlayerRound(((CombatInstance)this.currentInstance).GetNPCOn(this.player.getXPos() - 1, this.player.getYPos()));
            } else {
                this.messageQueue.AddMessages(this.currentInstance.getSymbolDescription(this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos() - 1], this.player.getXPos() - 1, this.player.getYPos()));
            }
            if (this.currentInstance instanceof CombatInstance) {
                this.BattleMonsterRound();
                ((CombatInstance)this.currentInstance).MoveNPC(this.player);
            }
        } else if (this.currentInstance instanceof CombatInstance) {
            this.EnterWorld();
            this.messageQueue.AddMessages("You enter the wide world");
        } else if (this.currentInstance instanceof World) {
            this.TransferToNewProvince(true);
        }
    }

    public void PlayerMoveRight() {
        this.currentTarget = null;
        this.UseItems();
        this.ReplenishInstances();
        if (this.player.getXPos() + 1 < this.currentInstance.getMap()[0].length) {
            if (!this.currentInstance.IsClipped(this.player.getXPos() + 1, this.player.getYPos())) {
                if (this.currentInstance instanceof Dungeon && this.player.getCurrentlyOn() == 3) {
                    this.EnterWorld();
                    this.messageQueue.AddMessages("You enter the wide world");
                    return;
                }
                this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()] = this.player.getCurrentlyOn();
                this.player.setXPos((short)(this.player.getXPos() + 1));
                this.player.setCurrentlyOn(this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()]);
                this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()] = 11;
                this.messageQueue.AddMessages(this.currentInstance.getSymbolDescription(this.player.getCurrentlyOn(), this.player.getXPos(), this.player.getYPos()));
                this.CreateAmbush();
            } else if (this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos() + 1] == 4 && this.currentInstance instanceof CombatInstance && !(this.currentInstance instanceof Village)) {
                this.BattlePlayerRound(((CombatInstance)this.currentInstance).GetNPCOn(this.player.getXPos() + 1, this.player.getYPos()));
            } else {
                this.messageQueue.AddMessages(this.currentInstance.getSymbolDescription(this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos() + 1], this.player.getXPos() + 1, this.player.getYPos()));
            }
            if (this.currentInstance instanceof CombatInstance) {
                this.BattleMonsterRound();
                ((CombatInstance)this.currentInstance).MoveNPC(this.player);
            }
        } else if (this.currentInstance instanceof CombatInstance) {
            this.EnterWorld();
            this.messageQueue.AddMessages("You enter the wide world");
        } else if (this.currentInstance instanceof World) {
            this.TransferToNewProvince(true);
        }
    }

    public void PlayerMoveUp() {
        this.currentTarget = null;
        this.UseItems();
        this.ReplenishInstances();
        if (this.player.getYPos() - 1 >= 0) {
            if (!this.currentInstance.IsClipped(this.player.getXPos(), this.player.getYPos() - 1)) {
                if (this.currentInstance instanceof Dungeon && this.player.getCurrentlyOn() == 3) {
                    this.EnterWorld();
                    this.messageQueue.AddMessages("You enter the wide world");
                    return;
                }
                this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()] = this.player.getCurrentlyOn();
                this.player.setYPos((short)(this.player.getYPos() - 1));
                this.player.setCurrentlyOn(this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()]);
                this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()] = 11;
                this.messageQueue.AddMessages(this.currentInstance.getSymbolDescription(this.player.getCurrentlyOn(), this.player.getXPos(), this.player.getYPos()));
                this.CreateAmbush();
            } else if (this.currentInstance.getMap()[this.player.getYPos() - 1][this.player.getXPos()] == 4 && this.currentInstance instanceof CombatInstance && !(this.currentInstance instanceof Village)) {
                this.BattlePlayerRound(((CombatInstance)this.currentInstance).GetNPCOn(this.player.getXPos(), this.player.getYPos() - 1));
            } else {
                this.messageQueue.AddMessages(this.currentInstance.getSymbolDescription(this.currentInstance.getMap()[this.player.getYPos() - 1][this.player.getXPos()], this.player.getXPos(), this.player.getYPos() - 1));
            }
            if (this.currentInstance instanceof CombatInstance) {
                this.BattleMonsterRound();
                ((CombatInstance)this.currentInstance).MoveNPC(this.player);
            }
        } else if (this.currentInstance instanceof CombatInstance) {
            this.EnterWorld();
            this.messageQueue.AddMessages("You enter the wide world");
        } else if (this.currentInstance instanceof World) {
            this.TransferToNewProvince(true);
        }
    }

    public void PlayerMoveDown() {
        this.currentTarget = null;
        this.UseItems();
        this.ReplenishInstances();
        if (this.player.getYPos() + 1 < this.currentInstance.getMap().length) {
            if (!this.currentInstance.IsClipped(this.player.getXPos(), this.player.getYPos() + 1)) {
                if (this.currentInstance instanceof Dungeon && this.player.getCurrentlyOn() == 3) {
                    this.EnterWorld();
                    this.messageQueue.AddMessages("You enter the wide world");
                    return;
                }
                this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()] = this.player.getCurrentlyOn();
                this.player.setYPos((short)(this.player.getYPos() + 1));
                this.player.setCurrentlyOn(this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()]);
                this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()] = 11;
                this.messageQueue.AddMessages(this.currentInstance.getSymbolDescription(this.player.getCurrentlyOn(), this.player.getXPos(), this.player.getYPos()));
                this.CreateAmbush();
            } else if (this.currentInstance.getMap()[this.player.getYPos() + 1][this.player.getXPos()] == 4 && this.currentInstance instanceof CombatInstance && !(this.currentInstance instanceof Village)) {
                this.BattlePlayerRound(((CombatInstance)this.currentInstance).GetNPCOn(this.player.getXPos(), this.player.getYPos() + 1));
            } else {
                this.messageQueue.AddMessages(this.currentInstance.getSymbolDescription(this.currentInstance.getMap()[this.player.getYPos() + 1][this.player.getXPos()], this.player.getXPos(), this.player.getYPos() + 1));
            }
            if (this.currentInstance instanceof CombatInstance) {
                this.BattleMonsterRound();
                ((CombatInstance)this.currentInstance).MoveNPC(this.player);
            }
        } else if (this.currentInstance instanceof CombatInstance) {
            this.EnterWorld();
            this.messageQueue.AddMessages("You enter the wide world");
        } else if (this.currentInstance instanceof World) {
            this.TransferToNewProvince(true);
        }
    }

    private void BattlePlayerRound(NPC nPC) {
        int n;
        int n2 = this.player.getAttackSkillLevel() + this.player.getInventory().getAttackSkillEffect() - (nPC.getDefenceSkill() + nPC.getNpcItem().getDefenceSkillEffect());
        if (n2 <= 20) {
            n2 = 25 + n2;
        }
        if ((n = this.player.getIntelligenceLevel() + this.player.getInventory().getIntelligenceEffect() - (nPC.getIntelligence() + nPC.getNpcItem().getIntelligenceEffect())) <= 0) {
            n = 1;
        }
        if (this.random.nextInt(100) < (n2 += this.random.nextInt(n))) {
            int n3 = this.player.getStrenghtLevel() + this.player.getInventory().getStrenghtEffect() - (nPC.getDefence() + nPC.getNpcItem().getDefenceSkillEffect());
            if (n3 <= 0) {
                n3 = 1;
            }
            if ((n3 = this.random.nextInt(n3) + n3 / 10) <= 0) {
                n3 = 1;
            }
            if ((n = this.player.getIntelligenceLevel() + this.player.getInventory().getIntelligenceEffect() - (nPC.getIntelligence() + nPC.getNpcItem().getIntelligenceEffect())) <= 0) {
                n = 1;
            }
            if (this.random.nextInt(100) < n) {
                n3 *= 2;
                this.messageQueue.AddMessages("You scored a critical hit");
            }
            nPC.setCurrentHealth(nPC.getCurrentHealth() - n3);
            this.messageQueue.AddMessages("You hit " + nPC.getRace() + " for " + n3 + " damage");
            if (nPC.getCurrentHealth() <= 0) {
                ((CombatInstance)this.currentInstance).RemoveNPC(nPC);
                if (nPC.getNpcItem() != null && nPC.getCurrentlyOn() != 5) {
                    ((CombatInstance)this.currentInstance).AddItemToCombatInstance(nPC.getNpcItem(), nPC.getXPos(), nPC.getYPos());
                }
                this.monstersKilled = (short)(this.monstersKilled + 1);
                this.messageQueue.AddMessages("You killed " + nPC.getRace());
                this.messageQueue.AddMessages("You gained " + nPC.getExperianceGained() + " XP and " + nPC.getGold() + " Gold");
                this.player.AddExperiance(nPC.getExperianceGained());
                this.player.addGold(nPC.getGold());
                this.player.addToMonstersKilled(1);
            }
        } else {
            this.messageQueue.AddMessages("You missed " + nPC.getRace());
        }
        this.currentTarget = nPC;
    }

    public void BattleMonsterRound() {
        if (this.currentInstance instanceof CombatInstance) {
            NPC[] nPCArray = new NPC[4];
            if (this.player.getXPos() - 1 > 0 && this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos() - 1] == 4) {
                nPCArray[0] = ((CombatInstance)this.currentInstance).GetNPCOn(this.player.getXPos() - 1, this.player.getYPos());
            }
            if (this.player.getXPos() + 1 < this.currentInstance.getMap()[0].length && this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos() + 1] == 4) {
                nPCArray[1] = ((CombatInstance)this.currentInstance).GetNPCOn(this.player.getXPos() + 1, this.player.getYPos());
            }
            if (this.player.getYPos() + 1 < this.currentInstance.getMap().length && this.currentInstance.getMap()[this.player.getYPos() + 1][this.player.getXPos()] == 4) {
                nPCArray[2] = ((CombatInstance)this.currentInstance).GetNPCOn(this.player.getXPos(), this.player.getYPos() + 1);
            }
            if (this.player.getYPos() - 1 > 0 && this.currentInstance.getMap()[this.player.getYPos() - 1][this.player.getXPos()] == 4) {
                nPCArray[3] = ((CombatInstance)this.currentInstance).GetNPCOn(this.player.getXPos(), this.player.getYPos() - 1);
            }
            for (int i = 0; i < nPCArray.length; ++i) {
                int n;
                if (nPCArray[i] == null) continue;
                NPC nPC = nPCArray[i];
                int n2 = nPC.getAttackSkill() + nPC.getNpcItem().getAttackSkillEffect() - this.player.getDefenceSkillLevel() + this.player.getInventory().getDefenceSkillEffect();
                if (n2 <= 20) {
                    n2 = 25 + n2;
                }
                if ((n = nPC.getIntelligence() + nPC.getNpcItem().getIntelligenceEffect() - this.player.getIntelligenceLevel() + this.player.getInventory().getIntelligenceEffect()) <= 0) {
                    n = 1;
                }
                if (this.random.nextInt(100) >= (n2 += this.random.nextInt(n))) continue;
                int n3 = nPC.getStrenght() + nPC.getNpcItem().getStrenghtEffect() - (this.player.getDefence() + this.player.getInventory().getDefence());
                if (n3 <= 0) {
                    n3 = 1;
                }
                if ((n3 = this.random.nextInt(n3) + n3 / 10) <= 0) {
                    n3 = 1;
                }
                if ((n = nPC.getIntelligence() + nPC.getNpcItem().getIntelligenceEffect() - (this.player.getIntelligenceLevel() + this.player.getInventory().getIntelligenceEffect())) <= 0) {
                    n = 1;
                }
                if (this.random.nextInt(100) < n) {
                    n3 *= 2;
                    this.messageQueue.AddMessages(nPC.getRace() + " scored a critical hit");
                }
                this.player.setCurrentHitpoints(this.player.getCurrentHitpoints() - n3);
                this.messageQueue.AddMessages("You where hit by " + nPC.getRace() + " for " + n3 + " damage");
                if (this.player.getCurrentHitpoints() > 0) continue;
                this.messageQueue.AddMessages("You where killed by " + nPC.getRace());
            }
        }
    }

    public NPC getCurrentTarget() {
        return this.currentTarget;
    }

    public boolean GotoInstance(int n, int n2) {
        if (this.currentInstance instanceof World) {
            if (((World)this.currentInstance).IsVillage(this.player.getCurrentlyOn())) {
                Village village = this.terrainGenerator.ReconstructVillage(((World)this.currentInstance).GetVillageOnPosition(n, n2));
                this.baseMonsters = (short)village.getNpcArray().length;
                this.baseItems = (short)village.GetNumberOfItems();
                this.messageQueue.AddMessages("You are in the village of " + village.getName());
                this.LeaveWorld(village, (short)2, (short)2);
                return true;
            }
            if (((World)this.currentInstance).IsDungeon(this.player.getCurrentlyOn())) {
                this.filled = ((World)this.currentInstance).GetDungeonFilledOnPosition(n, n2);
                Dungeon dungeon = this.terrainGenerator.ReconstructDungeon(this.player.getLevel(), ((World)this.currentInstance).GetDungeonOnPosition(n, n2), this.filled);
                this.baseMonsters = (short)dungeon.getNpcArray().length;
                this.baseItems = (short)dungeon.GetNumberOfItems();
                this.messageQueue.AddMessages("You are in the dungeon of " + dungeon.getName());
                this.LeaveWorld(dungeon, (short)10, (short)10);
                return true;
            }
            if (((World)this.currentInstance).IsRuin(this.player.getCurrentlyOn())) {
                this.filled = ((World)this.currentInstance).GetRuinFilledOnPosition(n, n2);
                Ruin ruin = this.terrainGenerator.ReconstructRuin(this.player.getLevel(), ((World)this.currentInstance).GetRuinOnPosition(n, n2), this.filled);
                this.baseMonsters = (short)ruin.getNpcArray().length;
                this.baseItems = (short)ruin.GetNumberOfItems();
                this.messageQueue.AddMessages("You are in the ruin of " + ruin.getName());
                this.LeaveWorld(ruin, (short)2, (short)2);
                return true;
            }
            if (this.player.getCurrentlyOn() == 0) {
                PlainCombatInstance plainCombatInstance = this.terrainGenerator.GeneratePlainCombatInstance(this.player.getLevel());
                this.baseMonsters = (short)plainCombatInstance.getNpcArray().length;
                this.baseItems = (short)plainCombatInstance.GetNumberOfItems();
                this.messageQueue.AddMessages("You are on the plains");
                this.LeaveWorld(plainCombatInstance, (short)(plainCombatInstance.getMap().length / 2), (short)(plainCombatInstance.getMap()[0].length / 2));
                return true;
            }
            if (this.player.getCurrentlyOn() == 1) {
                MountainCombatInstance mountainCombatInstance = this.terrainGenerator.GenerateMountainCombatInstance(this.player.getLevel());
                this.baseMonsters = (short)mountainCombatInstance.getNpcArray().length;
                this.baseItems = (short)mountainCombatInstance.GetNumberOfItems();
                this.messageQueue.AddMessages("You are in the mountains");
                this.LeaveWorld(mountainCombatInstance, (short)(mountainCombatInstance.getMap().length / 2), (short)(mountainCombatInstance.getMap()[0].length / 2));
                return true;
            }
            if (this.player.getCurrentlyOn() == 2) {
                ForestCombatInstance forestCombatInstance = this.terrainGenerator.GenerateForestCombatInstance(this.player.getLevel());
                this.baseMonsters = (short)forestCombatInstance.getNpcArray().length;
                this.baseItems = (short)forestCombatInstance.GetNumberOfItems();
                this.messageQueue.AddMessages("You are in a forest");
                this.LeaveWorld(forestCombatInstance, (short)(forestCombatInstance.getMap().length / 2), (short)(forestCombatInstance.getMap()[0].length / 2));
                return true;
            }
            if (this.player.getCurrentlyOn() == 3) {
                SwampCombatInstance swampCombatInstance = this.terrainGenerator.GenerateSwampCombatInstance(this.player.getLevel());
                this.baseMonsters = (short)swampCombatInstance.getNpcArray().length;
                this.baseItems = (short)swampCombatInstance.GetNumberOfItems();
                this.messageQueue.AddMessages("You are in a march");
                this.LeaveWorld(swampCombatInstance, (short)(swampCombatInstance.getMap().length / 2), (short)(swampCombatInstance.getMap()[0].length / 2));
                return true;
            }
            if (this.player.getCurrentlyOn() == 4) {
                LakeCombatInstance lakeCombatInstance = this.terrainGenerator.GenerateLakeCombatInstance(this.player.getLevel());
                this.baseMonsters = (short)lakeCombatInstance.getNpcArray().length;
                this.baseItems = (short)lakeCombatInstance.GetNumberOfItems();
                this.messageQueue.AddMessages("You are in a Lake area");
                this.LeaveWorld(lakeCombatInstance, (short)(lakeCombatInstance.getMap().length / 2), (short)(lakeCombatInstance.getMap()[0].length / 2));
                return true;
            }
            if (this.player.getCurrentlyOn() == 5) {
                DesertCombatInstance desertCombatInstance = this.terrainGenerator.GenerateDessertInstance(this.player.getLevel());
                this.baseMonsters = (short)desertCombatInstance.getNpcArray().length;
                this.baseItems = (short)desertCombatInstance.GetNumberOfItems();
                this.messageQueue.AddMessages("You are in a Desert");
                this.LeaveWorld(desertCombatInstance, (short)(desertCombatInstance.getMap().length / 2), (short)(desertCombatInstance.getMap()[0].length / 2));
                return true;
            }
            if (this.player.getCurrentlyOn() == 10) {
                Void void_ = this.terrainGenerator.GenerateVoid(this.player.getLevel());
                this.baseMonsters = (short)void_.getNpcArray().length;
                this.baseItems = (short)void_.GetNumberOfItems();
                this.messageQueue.AddMessages("You are in Void space");
                this.LeaveWorld(void_, (short)(void_.getMap().length / 2), (short)(void_.getMap()[0].length / 2));
                return true;
            }
        }
        this.messageQueue.AddMessages("There is no instance to go to");
        return false;
    }

    public Player getPlayer() {
        return this.player;
    }

    private void LeaveWorld(Instance instance, short s, short s2) {
        this.currentInstance = instance;
        this.worldXPos = this.player.getXPos();
        this.worldYPos = this.player.getYPos();
        this.worldCurrentlyOn = this.player.getCurrentlyOn();
        this.player.setXPos(s);
        this.player.setYPos(s2);
        this.player.setCurrentlyOn(this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()]);
        if (this.player.getCurrentlyOn() == 4 || this.player.getCurrentlyOn() == 9) {
            this.player.setCurrentlyOn((byte)0);
        }
        this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()] = 11;
    }

    private void EnterWorld() {
        this.AdminsterDepletion();
        this.currentInstance = this.world;
        this.player.setXPos(this.worldXPos);
        this.player.setYPos(this.worldYPos);
        this.player.setCurrentlyOn(this.worldCurrentlyOn);
        this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()] = 11;
    }

    public void DeEquipItem(int n) {
        this.player.getInventory().RemoveItemFromEquipedInventory(n);
    }

    public void EquipItem(int n, int n2) {
        if (n < this.player.getInventory().getCurrentArrayItems()) {
            this.player.getInventory().AddItemToEquipedInventory(this.player.getInventory().GetAll()[n], n2);
        }
    }

    public void GetItemFromInstance(int n, int n2) {
        CombatInstance combatInstance;
        Item item;
        if (this.currentInstance instanceof CombatInstance && (item = (combatInstance = (CombatInstance)this.currentInstance).GetItemsOnPosition(n, n2)) != null) {
            if (this.player.CheckWeight(item)) {
                combatInstance.RemoveItemOnPosition(n, n2);
                this.player.getInventory().AddItem(item);
                this.player.setCurrentlyOn(item.getCurrentlyOn());
                this.itemsPickedup = (short)(this.itemsPickedup + 1);
                this.messageQueue.AddMessages("You picked up the " + item.getName());
                this.player.addToItemsPickedUp(1);
            } else {
                this.messageQueue.AddMessages(item.getName() + " is to heavy");
            }
        }
    }

    public boolean DropItem(int n) {
        if (this.currentInstance instanceof CombatInstance && n < this.player.getInventory().getCurrentArrayItems() && this.player.getCurrentlyOn() != 5) {
            Item item = this.player.getInventory().RemoveItem(this.player.getInventory().GetAll()[n]);
            item.setXPos(this.player.getXPos());
            item.setYPos(this.player.getYPos());
            item.setCurrentlyOn(this.player.getCurrentlyOn());
            ((CombatInstance)this.currentInstance).AddItemToCombatInstance(item);
            this.player.setCurrentlyOn((byte)5);
            this.messageQueue.AddMessages("You have dropped the " + item.getName());
            return true;
        }
        return false;
    }

    public NPC[] GetConversationPartners() {
        NPC[] nPCArray = new NPC[4];
        byte by = 4;
        int n = 0;
        if (this.currentInstance instanceof Village) {
            by = 9;
        }
        if (this.currentInstance instanceof CombatInstance) {
            if (this.player.getXPos() - 1 > 0 && this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos() - 1] == by) {
                nPCArray[0] = ((CombatInstance)this.currentInstance).GetNPCOn(this.player.getXPos() - 1, this.player.getYPos());
                ++n;
            }
            if (this.player.getXPos() + 1 < this.currentInstance.getMap()[0].length && this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos() + 1] == by) {
                nPCArray[1] = ((CombatInstance)this.currentInstance).GetNPCOn(this.player.getXPos() + 1, this.player.getYPos());
                ++n;
            }
            if (this.player.getYPos() + 1 < this.currentInstance.getMap().length && this.currentInstance.getMap()[this.player.getYPos() + 1][this.player.getXPos()] == by) {
                nPCArray[2] = ((CombatInstance)this.currentInstance).GetNPCOn(this.player.getXPos(), this.player.getYPos() + 1);
                ++n;
            }
            if (this.player.getYPos() - 1 > 0 && this.currentInstance.getMap()[this.player.getYPos() - 1][this.player.getXPos()] == by) {
                nPCArray[3] = ((CombatInstance)this.currentInstance).GetNPCOn(this.player.getXPos(), this.player.getYPos() - 1);
                ++n;
            }
            NPC[] nPCArray2 = new NPC[n];
            int n2 = 0;
            for (int i = 0; i < nPCArray.length; ++i) {
                if (nPCArray[i] == null) continue;
                nPCArray2[n2] = nPCArray[i];
                ++n2;
            }
            return nPCArray2;
        }
        return nPCArray;
    }

    public void TransferToNewProvince(boolean bl) {
        this.world = null;
        this.currentInstance = null;
        System.gc();
        this.world = this.terrainGenerator.GenerateMap(false);
        this.currentInstance = this.world;
        if (bl) {
            if (this.player.getXPos() > 0) {
                this.player.setXPos((short)0);
            } else {
                this.player.setXPos((short)(this.world.getMap()[0].length - 1));
            }
        } else if (this.player.getYPos() > 0) {
            this.player.setYPos((short)0);
        } else {
            this.player.setYPos((short)(this.world.getMap().length - 1));
        }
        this.player.setCurrentlyOn(this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()]);
        this.currentInstance.getMap()[this.player.getYPos()][this.player.getXPos()] = 11;
        this.messageQueue.AddMessages("New Province");
        this.messageQueue.AddMessages("You enter the province of " + this.world.getName());
    }

    private byte CalculateDepletion() {
        byte by = this.filled;
        if ((double)by - (double)this.monstersKilled / (double)this.baseMonsters * 50.0 > 0.0) {
            by = (byte)(by - (byte)((double)this.monstersKilled / (double)this.baseMonsters * 50.0));
        }
        if ((double)by - (double)this.itemsPickedup / (double)this.baseItems * 50.0 > 0.0) {
            by = (byte)(by - (byte)((double)this.itemsPickedup / (double)this.baseItems * 50.0));
        }
        System.out.println("D:" + (double)this.monstersKilled / (double)this.baseMonsters * 50.0);
        System.out.println("Monsters Killed: " + this.monstersKilled + "/" + this.baseMonsters);
        System.out.println("Depletion: " + by);
        return by;
    }

    private void AdminsterDepletion() {
        if (this.currentInstance instanceof Dungeon) {
            this.world.SetDungeonFilledOnPosition(this.worldXPos, this.worldYPos, this.CalculateDepletion());
        }
        if (this.currentInstance instanceof Ruin) {
            this.world.SetRuinFilledOnPosition(this.worldXPos, this.worldXPos, this.CalculateDepletion());
        }
        this.monstersKilled = 0;
        this.itemsPickedup = 0;
        this.baseItems = 0;
        this.baseMonsters = 0;
    }

    public boolean Rest() {
        if (this.currentInstance instanceof Village) {
            this.player.setCurrentHitpoints(this.player.getMaxHitPoints());
            this.messageQueue.AddMessages("You are well rested and fit for an  other day");
            return true;
        }
        this.messageQueue.AddMessages("You can not rest here");
        return false;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    private void UseItems() {
        Item[] itemArray = this.player.getInventory().GetUsableItems();
        for (int i = 0; i < itemArray.length; ++i) {
            if (itemArray[i] == null) continue;
            if (this.player.getCurrentHitpoints() + itemArray[i].getHealthEffect() > this.player.getMaxHitPoints()) {
                this.player.setCurrentHitpoints(this.player.getMaxHitPoints());
            } else {
                this.player.setCurrentHitpoints(this.player.getCurrentHitpoints() + itemArray[i].getHealthEffect());
            }
            itemArray[i].setUses((short)(itemArray[i].getUses() - 1));
            if (itemArray[i].getUses() < 0) {
                this.player.getInventory().DeleteFromEquipedArray(i);
                this.messageQueue.AddMessages(itemArray[i].getName() + " has been depleted");
                continue;
            }
            this.player.getInventory().UpdateFromEquipedArray(i, itemArray[i]);
        }
    }

    private void ReplenishInstances() {
        if (this.timeReplanished == 0) {
            this.world.UpdateFilled(1);
            this.timeReplanished = (short)100;
        } else {
            this.timeReplanished = (short)(this.timeReplanished - 1);
        }
    }

    public void AddSkillPoints(int n) {
        if (this.player.getUndividedSkillpoints() > 0) {
            switch (n) {
                case 0: {
                    this.player.addToStrenght(1);
                    break;
                }
                case 1: {
                    this.player.addToDefence(1);
                    break;
                }
                case 2: {
                    this.player.addToAttackSkill(1);
                    break;
                }
                case 3: {
                    this.player.addToDefenceSkill(1);
                    break;
                }
                case 4: {
                    this.player.addToIntelligence(1);
                }
            }
            this.player.setUndividedSkillpoints((short)(this.player.getUndividedSkillpoints() - 1));
        }
    }

    public byte getWorldCurrentlyOn() {
        return this.worldCurrentlyOn;
    }

    public short getWorldXPos() {
        return this.worldXPos;
    }

    public short getWorldYPos() {
        return this.worldYPos;
    }

    public void setWorldXPos(short s) {
        this.worldXPos = s;
    }

    public void setWorldYPos(short s) {
        this.worldYPos = s;
    }

    public void setWorldCurrentlyOn(byte by) {
        this.worldCurrentlyOn = by;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public void setCurrentInstance(Instance instance) {
        this.currentInstance = instance;
    }

    public void SellItem(int n) {
        Item item;
        if (this.currentInstance instanceof Village && n < this.player.getInventory().GetAll().length && (item = this.player.getInventory().GetAll()[n]) != null) {
            this.player.setGold(this.player.getGold() + item.getValue());
            this.player.getInventory().RemoveItem(item);
        }
    }

    private void CreateAmbush() {
        if (this.random.nextInt(100) < 5 && this.currentInstance instanceof World && this.player.getCurrentlyOn() != 6 && this.player.getCurrentlyOn() != 8 && this.player.getCurrentlyOn() != 9) {
            this.messageQueue.AddMessages("You where ambushed by monsters");
            this.GotoInstance(this.player.getXPos(), this.player.getYPos());
        }
    }

    public MessageQueue getMessageQueue() {
        return this.messageQueue;
    }
}

