/*
 * Decompiled with CFR 0.152.
 */
package GameFiles.Instances;

import GameFiles.Character.Player;
import GameFiles.Instances.Instance;
import GameFiles.ItemList;
import GameFiles.Items.Item;
import GameFiles.NPCS.NPC;
import java.util.Random;

public abstract class CombatInstance
extends Instance {
    protected NPC[] npcArray;
    protected ItemList itemArray = new ItemList(20);

    public CombatInstance(short s, byte[][] byArray, String string, NPC[] nPCArray, Item[] itemArray) {
        super(s, byArray, string);
        this.npcArray = nPCArray;
        for (int i = 0; i < itemArray.length; ++i) {
            this.itemArray.AddItem(itemArray[i]);
        }
    }

    public NPC[] getNpcArray() {
        return this.npcArray;
    }

    public int getColorTable(byte by, int n, int n2) {
        if (this.colorTable[by] != 0xF0F0F0) {
            return this.colorTable[by];
        }
        for (int i = 0; i < this.npcArray.length; ++i) {
            if (this.npcArray[i] == null || this.npcArray[i].getXPos() != n || this.npcArray[i].getYPos() != n2) continue;
            return this.npcArray[i].getColor();
        }
        return 0xF000FF;
    }

    public char getInstanceSymbol(byte by, int n, int n2) {
        if (this.symbol[by] != 'M' && this.symbol[by] != 'V') {
            return this.symbol[by];
        }
        for (int i = 0; i < this.npcArray.length; ++i) {
            if (this.npcArray[i] == null || this.npcArray[i].getXPos() != n || this.npcArray[i].getYPos() != n2) continue;
            return this.npcArray[i].getSymbol();
        }
        return 'U';
    }

    public String getSymbolDescription(byte by, int n, int n2) {
        if (this.symbolDescription[by].equals("Monster") && this.symbolDescription[by].equals("Villager")) {
            for (int i = 0; i < this.npcArray.length; ++i) {
                if (this.npcArray[i] == null || this.npcArray[i].getXPos() != n || this.npcArray[i].getYPos() != n2) continue;
                return this.npcArray[i].DescribeMe();
            }
        } else {
            if (this.symbolDescription[by].equals("Items")) {
                System.out.println("D");
                return this.itemArray.GetItemOn(n, n2).DescribeMe();
            }
            return this.symbolDescription[by];
        }
        return "Unknown";
    }

    private boolean MoveMonsterOnX(Player player, NPC nPC) {
        if (player.getXPos() > nPC.getXPos() && nPC.getXPos() + 1 < this.map[0].length && !this.IsClipped(nPC.getXPos() + 1, nPC.getYPos())) {
            nPC.setXPos((short)(nPC.getXPos() + 1));
            return true;
        }
        if (player.getXPos() < nPC.getXPos() && nPC.getXPos() - 1 > 0 && !this.IsClipped(nPC.getXPos() - 1, nPC.getYPos())) {
            nPC.setXPos((short)(nPC.getXPos() - 1));
            return true;
        }
        return false;
    }

    private boolean MoveMonsterOnY(Player player, NPC nPC) {
        if (player.getYPos() > nPC.getYPos() && nPC.getYPos() + 1 < this.map.length && !this.IsClipped(nPC.getXPos(), nPC.getYPos() + 1)) {
            nPC.setYPos((short)(nPC.getYPos() + 1));
            return true;
        }
        if (player.getYPos() < nPC.getYPos() && nPC.getYPos() - 1 > 0 && !this.IsClipped(nPC.getXPos(), nPC.getYPos() - 1)) {
            nPC.setYPos((short)(nPC.getYPos() - 1));
            return true;
        }
        return false;
    }

    public void MoveNPC(Player player) {
        Random random = new Random();
        for (int i = 0; i < this.npcArray.length; ++i) {
            if (this.npcArray[i] == null || Math.abs(player.getXPos() - this.npcArray[i].getXPos()) >= this.npcArray[i].getSight() || Math.abs(player.getYPos() - this.npcArray[i].getYPos()) >= this.npcArray[i].getSight()) continue;
            this.map[this.npcArray[i].getYPos()][this.npcArray[i].getXPos()] = this.npcArray[i].getCurrentlyOn();
            if (random.nextInt(100) > 50) {
                if (!this.MoveMonsterOnX(player, this.npcArray[i])) {
                    this.MoveMonsterOnY(player, this.npcArray[i]);
                }
            } else if (!this.MoveMonsterOnY(player, this.npcArray[i])) {
                this.MoveMonsterOnX(player, this.npcArray[i]);
            }
            this.npcArray[i].setCurrentlyOn(this.map[this.npcArray[i].getYPos()][this.npcArray[i].getXPos()]);
            this.map[this.npcArray[i].getYPos()][this.npcArray[i].getXPos()] = 4;
            this.npcArray[i].setMoved(this.npcArray[i].getMayMove());
        }
    }

    public NPC GetNPCOn(int n, int n2) {
        for (int i = 0; i < this.npcArray.length; ++i) {
            if (this.npcArray[i] == null || this.npcArray[i].getXPos() != n || this.npcArray[i].getYPos() != n2) continue;
            return this.npcArray[i];
        }
        System.out.println("ErrorMonster");
        return null;
    }

    public void RemoveNPC(NPC nPC) {
        for (int i = 0; i < this.npcArray.length; ++i) {
            if (this.npcArray[i] == null || this.npcArray[i].getXPos() != nPC.getXPos() || this.npcArray[i].getYPos() != nPC.getYPos()) continue;
            this.map[this.npcArray[i].getYPos()][this.npcArray[i].getXPos()] = this.npcArray[i].getCurrentlyOn();
            this.npcArray[i] = null;
        }
    }

    public Item GetItemsOnPosition(int n, int n2) {
        return this.itemArray.GetItemOn(n, n2);
    }

    public void RemoveItemOnPosition(int n, int n2) {
        this.itemArray.RemoveItem(this.itemArray.GetItemOn(n, n2));
    }

    public void AddItemToCombatInstance(Item item, short s, short s2) {
        item.setXPos(s);
        item.setYPos(s2);
        item.setCurrentlyOn(this.map[item.getYPos()][item.getXPos()]);
        this.map[item.getYPos()][item.getXPos()] = 5;
        this.itemArray.AddItem(item);
    }

    public void AddItemToCombatInstance(Item item) {
        this.itemArray.AddItem(item);
    }

    public int GetNumberOfItems() {
        return this.itemArray.getCurrentArrayItems();
    }
}

