/*
 * Decompiled with CFR 0.152.
 */
package GameFiles.Instances;

import GameFiles.Character.Player;
import GameFiles.Instances.CombatInstance;
import GameFiles.Items.Item;
import GameFiles.NPCS.NPC;
import java.util.Random;

public class Village
extends CombatInstance {
    public Village(short s, byte[][] byArray, String string, NPC[] nPCArray, Item[] itemArray) {
        super(s, byArray, string, nPCArray, itemArray);
        this.symbol = new char[]{'-', '-', '#', '~', '=', '$', '/', 'T', '*', 'V', '\"', '@'};
        this.symbolDescription = new String[]{"You walk on a stretch of green grass", "You walk on a hard stone floor", "You bump into stone wall", "You swim in a clear pond", "You walk on a field", "Items", "You open a door", "You pass beneath a beautifull tree", "You walk trough a bush", "V", "You walk in a field of grain", "Yourself"};
        this.clip = new char[]{'#', 'V', '@'};
        this.colorTable = new int[]{0x228B22, 3092785, 0xC1CDCD, 2003199, 13468991, 16766720, 13468991, 65280, 65280, 0xF0F0F0, 16766720, 0xFFFFFF};
    }

    public char getInstanceSymbol(byte by, int n, int n2) {
        if (this.symbol[by] != 'V') {
            return this.symbol[by];
        }
        for (int i = 0; i < this.npcArray.length; ++i) {
            if (this.npcArray[i] == null || this.npcArray[i].getXPos() != n || this.npcArray[i].getYPos() != n2) continue;
            return this.npcArray[i].getSymbol();
        }
        return 'U';
    }

    public String getSymbolDescription(byte by, int n, int n2) {
        if (this.symbolDescription[by].equals("V")) {
            for (int i = 0; i < this.npcArray.length; ++i) {
                if (this.npcArray[i] == null || this.npcArray[i].getXPos() != n || this.npcArray[i].getYPos() != n2) continue;
                return this.npcArray[i].DescribeMe();
            }
        } else {
            if (this.symbolDescription[by].equals("Items")) {
                return this.itemArray.GetItemOn(n, n2).DescribeMe();
            }
            return this.symbolDescription[by];
        }
        return "Unknown";
    }

    public void MoveNPC(Player player) {
        Random random = new Random();
        for (int i = 0; i < this.npcArray.length; ++i) {
            if (this.npcArray[i] == null || Math.abs(player.getXPos() - this.npcArray[i].getXPos()) >= 20 || Math.abs(player.getYPos() - this.npcArray[i].getYPos()) >= 20) continue;
            if (this.npcArray[i].getMoved() == 0) {
                int n = random.nextInt(4);
                this.map[this.npcArray[i].getYPos()][this.npcArray[i].getXPos()] = this.npcArray[i].getCurrentlyOn();
                switch (n) {
                    case 0: {
                        if (this.npcArray[i].getXPos() > 10 && !this.IsClipped(this.npcArray[i].getXPos() - 1, this.npcArray[i].getYPos())) {
                            this.npcArray[i].setXPos((short)(this.npcArray[i].getXPos() - 1));
                            break;
                        }
                        if (this.IsClipped(this.npcArray[i].getXPos() + 1, this.npcArray[i].getYPos()) || this.npcArray[i].getXPos() >= this.map[0].length - 10) break;
                        this.npcArray[i].setXPos((short)(this.npcArray[i].getXPos() + 1));
                        break;
                    }
                    case 1: {
                        if (this.npcArray[i].getXPos() < this.map[0].length - 10 && !this.IsClipped(this.npcArray[i].getXPos() + 1, this.npcArray[i].getYPos())) {
                            this.npcArray[i].setXPos((short)(this.npcArray[i].getXPos() + 1));
                            break;
                        }
                        if (this.IsClipped(this.npcArray[i].getXPos() - 1, this.npcArray[i].getYPos()) || this.npcArray[i].getXPos() <= 10) break;
                        this.npcArray[i].setXPos((short)(this.npcArray[i].getXPos() - 1));
                        break;
                    }
                    case 2: {
                        if (this.npcArray[i].getYPos() < this.map.length - 10 && !this.IsClipped(this.npcArray[i].getXPos(), this.npcArray[i].getYPos() + 1)) {
                            this.npcArray[i].setYPos((short)(this.npcArray[i].getYPos() + 1));
                            break;
                        }
                        if (this.IsClipped(this.npcArray[i].getXPos(), this.npcArray[i].getYPos() - 1) || this.npcArray[i].getYPos() <= 10) break;
                        this.npcArray[i].setYPos((short)(this.npcArray[i].getYPos() - 1));
                        break;
                    }
                    case 3: {
                        if (this.npcArray[i].getYPos() > 10 && !this.IsClipped(this.npcArray[i].getXPos(), this.npcArray[i].getYPos() - 1)) {
                            this.npcArray[i].setYPos((short)(this.npcArray[i].getYPos() - 1));
                            break;
                        }
                        if (this.IsClipped(this.npcArray[i].getXPos(), this.npcArray[i].getYPos() + 1) || this.npcArray[i].getYPos() >= this.map.length - 10) break;
                        this.npcArray[i].setYPos((short)(this.npcArray[i].getYPos() + 1));
                    }
                }
                this.npcArray[i].setCurrentlyOn(this.map[this.npcArray[i].getYPos()][this.npcArray[i].getXPos()]);
                this.map[this.npcArray[i].getYPos()][this.npcArray[i].getXPos()] = 9;
                this.npcArray[i].setMoved(this.npcArray[i].getMayMove());
                continue;
            }
            this.npcArray[i].setMoved((short)(this.npcArray[i].getMoved() - 1));
        }
    }
}

