/*
 * Decompiled with CFR 0.152.
 */
import GameFiles.Character.Player;
import GameFiles.Game;
import GameFiles.Instances.CombatInstance;
import GameFiles.Instances.World;
import GameFiles.Items.Item;
import GameFiles.NPCS.NPC;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class PaintCanvas
extends GameCanvas
implements Runnable {
    private String[] modes = new String[]{"World", "Inventory", "Player Stats", "Barter", "Help", "sendScore"};
    private byte mode = 0;
    private short cameraXPos = 0;
    private short cameraYPos = 0;
    private short cameraWorldXPos = 0;
    private short cameraWorldYPos = 0;
    private byte spaceX = (byte)12;
    private byte spaceY = (byte)12;
    private short height = (short)this.getHeight();
    private short width = (short)this.getWidth();
    private short messageXSource = 0;
    private short messageYSource = 0;
    private short widthOfMessage = (short)(this.width - this.width / 100 * 0);
    private short heightOfMessage = (short)(3 * this.spaceY);
    private short widthOfMap = (short)(this.width - this.width / 100 * 45);
    private short heightOfMap = (short)(this.height - this.height / 100 * 40);
    private short mapXSource = 0;
    private short mapYSource = (short)(this.messageYSource + this.heightOfMessage);
    private short playerStatusXSource = (short)(this.mapXSource + this.widthOfMap + 7);
    private short playerStatusYSource = this.mapYSource;
    private short widthOfPlayerStatus = (short)(this.width - this.widthOfMap);
    private short heightOfPlayerStatus = (short)(this.heightOfMap / 2);
    private short monsterStatusXSource = (short)(this.mapXSource + this.widthOfMap + 7);
    private short monsterStatusYSource = (short)(this.mapYSource + this.heightOfPlayerStatus);
    private short widthOfMonsterStatus = (short)(this.width - this.widthOfMap);
    private short heightOfMonsterStatus = (short)(this.heightOfMap / 2 + 2);
    private boolean smallScreen = false;
    private boolean running = true;
    private int slowDown = 100;
    private int previousButton = 0;
    private byte timesPressed = 0;
    private int timesNotPressed = 0;
    short scrollIndex = 0;
    short inventoryScrollIndex = 0;
    byte conversationistIndex = 0;
    byte barterModes = 0;
    short statsIndex = 0;
    private Game game;
    private Thread mainThread;

    public PaintCanvas() {
        super(true);
        this.setFullScreenMode(true);
        this.ChangeScreenParameters();
        this.mainThread = new Thread(this);
        this.mainThread.start();
    }

    public void DrawTextMessage(String string, Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, (int)this.width, (int)this.height);
        graphics.setColor(255, 255, 0);
        graphics.setFont(Font.getFont((int)0, (int)2, (int)8));
        graphics.drawString(string, 2, 2, 0);
        graphics.setColor(255, 255, 0);
        graphics.drawRect(0, 0, this.width - 1, this.height - 1);
    }

    public void DrawSendScoreScreen(Graphics graphics) {
        int n = 2;
        graphics.setColor(255, 255, 0);
        graphics.setFont(Font.getFont((int)0, (int)2, (int)8));
        graphics.drawString("Send Score", 2, n, 0);
        graphics.drawLine(0, n + this.spaceY, (int)this.width, n + this.spaceY);
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        graphics.drawString("Press Fire to send the score", 2, n += this.spaceY + 4, 0);
    }

    public void DrawHelpScreen(Graphics graphics) {
        int n = 2;
        graphics.setColor(255, 255, 0);
        graphics.setFont(Font.getFont((int)0, (int)2, (int)8));
        graphics.drawString("Help", 2, n, 0);
        graphics.drawLine(0, n + this.spaceY - 2, (int)this.width, n + this.spaceY - 2);
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        graphics.drawString("arrows: move,attack,selection", 2, this.spaceY * 1, 0);
        graphics.drawString("fire     : sell,equip,goto,allocate", 2, this.spaceY * 2, 0);
        graphics.drawString("A        : previous screen", 2, this.spaceY * 3, 0);
        graphics.drawString("B        : next screen", 2, this.spaceY * 4, 0);
        graphics.drawString("C        : de-equip,rest", 2, this.spaceY * 5, 0);
        graphics.drawString("D        : drop item,save", 2, this.spaceY * 6, 0);
        graphics.setFont(Font.getFont((int)0, (int)2, (int)8));
        graphics.drawLine(0, (n += this.spaceY * 7) - 2, (int)this.width, n - 2);
        graphics.drawString("Credits, Many thanks to:", 2, n, 0);
        graphics.drawLine(0, n + this.spaceY, (int)this.width, n + this.spaceY);
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        graphics.drawString("Esmee,", 2, (n += this.spaceY * 1 + 2) + this.spaceY * 0, 0);
        graphics.drawString("My Parents,", 2, n + this.spaceY * 1, 0);
        graphics.drawString("Any one who plays this,", 2, n + this.spaceY * 2, 0);
        graphics.drawString("All the persons I have rudely", 2, n + this.spaceY * 3, 0);
        graphics.drawString("ignored whilst making this", 2, n + this.spaceY * 4, 0);
    }

    public void DrawBarterScreen(Graphics graphics) {
        Object[] objectArray;
        int n = 2;
        NPC[] nPCArray = this.game.GetConversationPartners();
        String string = "Sell";
        if (this.barterModes == 1) {
            string = "Buy";
        }
        graphics.setColor(255, 255, 0);
        graphics.setFont(Font.getFont((int)0, (int)2, (int)8));
        graphics.drawString("Bartering (Go:" + this.game.getPlayer().getGold() + ") " + string, 2, n, 0);
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        n = this.smallScreen ? (n += this.spaceY * 1) : (n += this.spaceY * 1 + 4);
        graphics.drawLine(0, n, (int)this.width, n);
        if (nPCArray.length > 0) {
            this.conversationistIndex = (byte)(this.conversationistIndex % nPCArray.length);
            if (nPCArray[this.conversationistIndex] != null) {
                graphics.drawString(nPCArray[this.conversationistIndex].GetName(), 14, n + 1, 0);
            }
        }
        graphics.setColor(0xFF0000);
        graphics.fillRoundRect(2, n + 2, 8, 8, 8, 8);
        graphics.setColor(255, 255, 0);
        n = this.smallScreen ? (n += this.spaceY * 1) : (n += this.spaceY * 1 + 4);
        graphics.drawLine(0, n, (int)this.width, n);
        if (!this.smallScreen) {
            if (this.scrollIndex < this.game.getPlayer().getInventory().GetAll().length) {
                objectArray = this.game.getPlayer().getInventory().GetAll()[this.scrollIndex].DescribeProperties();
                graphics.drawString(objectArray[0], 2, n + 2, 0);
                graphics.drawString(objectArray[1], 2, n + this.spaceY + 2, 0);
            }
            n += 2 * this.spaceY + 4;
        } else {
            if (this.scrollIndex < this.game.getPlayer().getInventory().GetAll().length) {
                objectArray = this.game.getPlayer().getInventory().GetAll()[this.scrollIndex].DescribePropertiesSmallScreen();
                graphics.drawString(objectArray[0], 2, n + 2, 0);
                graphics.drawString(objectArray[1], 2, n + this.spaceY + 2, 0);
                graphics.drawString(objectArray[2], 2, n + this.spaceY * 2 + 2, 0);
            }
            n += 3 * this.spaceY + 2;
        }
        graphics.drawLine(0, n + 2, (int)this.width, n + 2);
        graphics.setFont(Font.getFont((int)0, (int)2, (int)8));
        graphics.drawString("Player Inventory", 2, n + 3, 0);
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        n += this.spaceY + 4;
        if (!this.smallScreen) {
            objectArray = this.game.getPlayer().getInventory().GetAll();
            int n2 = (this.height - n) / this.spaceY;
            for (int i = 0; i < n2 && objectArray != null; ++i) {
                if (this.scrollIndex + i >= objectArray.length || objectArray[this.scrollIndex + i] == null) continue;
                graphics.drawString("[" + (this.scrollIndex + i) + "] : " + ((Item)objectArray[this.scrollIndex + i]).DescribeMeInGold(), 14, i * this.spaceY + n, 0);
            }
        } else {
            objectArray = this.game.getPlayer().getInventory().GetAll();
            int n3 = (this.height - n) / this.spaceY;
            for (int i = 0; i < n3 && objectArray != null; ++i) {
                if (this.scrollIndex + i >= objectArray.length || objectArray[this.scrollIndex + i] == null) continue;
                graphics.drawString(((Item)objectArray[this.scrollIndex + i]).getName(), 14, i * this.spaceY + n, 0);
            }
        }
        graphics.setColor(0xFF0000);
        graphics.fillRoundRect(3, n + 2, 8, 8, 8, 8);
        graphics.setColor(255, 255, 0);
    }

    public void DrawPlayerStats(Graphics graphics) {
        int n = 2;
        int n2 = 13;
        int n3 = this.width / 8 * 4 + 1;
        int n4 = 6;
        if (!this.smallScreen) {
            graphics.setColor(255, 255, 0);
            graphics.setFont(Font.getFont((int)0, (int)2, (int)8));
            graphics.drawString("Player Charestaristics", 2, n, 0);
            graphics.drawLine(0, (n += n4) + this.spaceY, (int)this.width, n + this.spaceY);
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            graphics.drawString("Level", n2, n + 1 * this.spaceY, 0);
            graphics.drawString(":     " + this.game.getPlayer().getLevel(), n3, n + 1 * this.spaceY, 0);
            graphics.drawLine(0, (n += n4 + 1 * this.spaceY) + this.spaceY, (int)this.width, n + this.spaceY);
            graphics.drawString("Hitpoints", n2, n + 1 * this.spaceY, 0);
            graphics.drawString(":     " + this.game.getPlayer().getCurrentHitpoints() + "/" + this.game.getPlayer().getMaxHitPoints(), n3, n + 1 * this.spaceY, 0);
            graphics.drawString("Strenght", n2, n + 2 * this.spaceY, 0);
            graphics.drawString(":     " + this.game.getPlayer().getStrenghtLevel() + "+(" + this.game.getPlayer().getInventory().getStrenghtEffect() + ")", n3, n + 2 * this.spaceY, 0);
            graphics.drawString("Defence", n2, n + 3 * this.spaceY, 0);
            graphics.drawString(":     " + this.game.getPlayer().getDefence() + "+(" + this.game.getPlayer().getInventory().getDefence() + ")", n3, n + 3 * this.spaceY, 0);
            graphics.drawString("Attack Skill", n2, n + 4 * this.spaceY, 0);
            graphics.drawString(":     " + this.game.getPlayer().getAttackSkillLevel() + "+(" + this.game.getPlayer().getInventory().getAttackSkillEffect() + ")", n3, n + 4 * this.spaceY, 0);
            graphics.drawString("Defence Skill", n2, n + 5 * this.spaceY, 0);
            graphics.drawString(":     " + this.game.getPlayer().getDefenceSkillLevel() + "+(" + this.game.getPlayer().getInventory().getDefenceSkillEffect() + ")", n3, n + 5 * this.spaceY, 0);
            graphics.drawString("Inteligence ", n2, n + 6 * this.spaceY, 0);
            graphics.drawString(":     " + this.game.getPlayer().getIntelligenceLevel() + "+(" + this.game.getPlayer().getInventory().getIntelligenceEffect() + ")", n3, n + 6 * this.spaceY, 0);
            graphics.setColor(0xFF0000);
            graphics.fillRoundRect(2, n + (this.statsIndex + 2) * this.spaceY + 4, 8, 8, 8, 8);
            graphics.setColor(255, 255, 0);
            graphics.drawLine(0, (n += n4 + 6 * this.spaceY) + this.spaceY, (int)this.width, n + this.spaceY);
            graphics.drawString("SkillPoints left", n2, n + 1 * this.spaceY, 0);
            graphics.drawString(":     " + this.game.getPlayer().getUndividedSkillpoints(), n3, n + 1 * this.spaceY, 0);
            graphics.drawString("XP to next level", n2, n + 2 * this.spaceY, 0);
            graphics.drawString(":     " + this.game.getPlayer().getCurrentExp() + "/" + this.game.getPlayer().getLevelThreshHold(), n3, n + 2 * this.spaceY, 0);
            graphics.drawLine(0, (n += n4 + 2 * this.spaceY) + this.spaceY - 1, (int)this.width, n + this.spaceY - 1);
            graphics.drawString("Gold aquired", n2, n + 1 * this.spaceY, 0);
            graphics.drawString(":     " + this.game.getPlayer().getGold(), n3, n + 1 * this.spaceY, 0);
            graphics.drawString("Monsters Killed", n2, n + 2 * this.spaceY, 0);
            graphics.drawString(":     " + this.game.getPlayer().getMonstersKilled(), n3, n + 2 * this.spaceY, 0);
            graphics.drawString("Items Picked Up", n2, n + 3 * this.spaceY, 0);
            graphics.drawString(":     " + this.game.getPlayer().getItemsPickedUp(), n3, n + 3 * this.spaceY, 0);
            graphics.drawLine(0, (n += n4 + 3 * this.spaceY) + this.spaceY, (int)this.width, n + this.spaceY);
        } else {
            n4 = this.spaceY;
            graphics.setColor(255, 255, 0);
            graphics.setFont(Font.getFont((int)0, (int)2, (int)8));
            graphics.drawString("Player Statistics", 2, n, 0);
            graphics.drawLine(0, (n += 1 * this.spaceY) - 2, (int)this.width, n - 2);
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            graphics.drawString("Level", n2, n, 0);
            graphics.drawString(":  " + this.game.getPlayer().getLevel(), n3, n, 0);
            graphics.drawLine(0, (n += 1 * this.spaceY) - 2, (int)this.width, n - 2);
            graphics.drawString("Hitpoints", n2, n + 0 * this.spaceY, 0);
            graphics.drawString(":  " + this.game.getPlayer().getCurrentHitpoints() + "/" + this.game.getPlayer().getMaxHitPoints(), n3, n + 0 * this.spaceY, 0);
            graphics.drawString("Strenght", n2, n + 1 * this.spaceY, 0);
            graphics.drawString(":  " + this.game.getPlayer().getStrenghtLevel() + "+(" + this.game.getPlayer().getInventory().getStrenghtEffect() + ")", n3, n + 1 * this.spaceY, 0);
            graphics.drawString("Defence", n2, n + 2 * this.spaceY, 0);
            graphics.drawString(":  " + this.game.getPlayer().getDefence() + "+(" + this.game.getPlayer().getInventory().getDefence() + ")", n3, n + 2 * this.spaceY, 0);
            graphics.drawString("Attack Skill", n2, n + 3 * this.spaceY, 0);
            graphics.drawString(":  " + this.game.getPlayer().getAttackSkillLevel() + "+(" + this.game.getPlayer().getInventory().getAttackSkillEffect() + ")", n3, n + 3 * this.spaceY, 0);
            graphics.drawString("Defence Skill", n2, n + 4 * this.spaceY, 0);
            graphics.drawString(":  " + this.game.getPlayer().getDefenceSkillLevel() + "+(" + this.game.getPlayer().getInventory().getDefenceSkillEffect() + ")", n3, n + 4 * this.spaceY, 0);
            graphics.drawString("Inteligence ", n2, n + 5 * this.spaceY, 0);
            graphics.drawString(":  " + this.game.getPlayer().getIntelligenceLevel() + "+(" + this.game.getPlayer().getInventory().getIntelligenceEffect() + ")", n3, n + 5 * this.spaceY, 0);
            graphics.drawString("Weight ", n2, n + 6 * this.spaceY, 0);
            graphics.drawString(":  We: " + this.game.getPlayer().getInventory().getTotalWeight() + "/" + this.game.getPlayer().getTotalWeightPosible(), n3, n + 6 * this.spaceY, 0);
            graphics.setColor(0xFF0000);
            graphics.fillRoundRect(2, n + (this.statsIndex + 1) * this.spaceY, 8, 8, 8, 8);
            graphics.setColor(255, 255, 0);
            graphics.drawLine(0, (n += 7 * this.spaceY) - 2, (int)this.width, n - 2);
            graphics.drawString("SP left", n2, n + 0 * this.spaceY, 0);
            graphics.drawString(":  " + this.game.getPlayer().getUndividedSkillpoints(), n3, n + 0 * this.spaceY, 0);
            graphics.drawString("XP to Lv", n2, n + 1 * this.spaceY, 0);
            graphics.drawString(":  " + this.game.getPlayer().getCurrentExp() + "/" + this.game.getPlayer().getLevelThreshHold(), n3, n + 1 * this.spaceY, 0);
            graphics.drawLine(0, (n += 2 * this.spaceY + 1) - 2, (int)this.width, n - 2);
            graphics.drawString("Gold aquired", n2, n + 0 * this.spaceY, 0);
            graphics.drawString(":  " + this.game.getPlayer().getGold(), n3, n + 0 * this.spaceY, 0);
            graphics.drawString("Kills", n2, n + 1 * this.spaceY, 0);
            graphics.drawString(":  " + this.game.getPlayer().getMonstersKilled(), n3, n + 1 * this.spaceY, 0);
            graphics.drawString("Items found", n2, n + 2 * this.spaceY, 0);
            graphics.drawString(":  " + this.game.getPlayer().getItemsPickedUp(), n3, n + 2 * this.spaceY, 0);
        }
    }

    public void DrawMessage(Graphics graphics) {
        graphics.setFont(Font.getFont((int)0, (int)2, (int)8));
        if (this.game.getMessageQueue().getMessageQueueContents() > 1) {
            graphics.setColor(0xFF0000);
            graphics.drawLine(this.messageXSource + this.widthOfMessage - 10, this.messageYSource + 5, this.messageXSource + this.widthOfMessage - 10, this.messageYSource + this.heightOfMessage - 5);
            graphics.drawLine(this.messageXSource + this.widthOfMessage - 13, this.messageYSource + this.heightOfMessage - 10, this.messageXSource + this.widthOfMessage - 10, this.messageYSource + this.heightOfMessage - 5);
            graphics.drawLine(this.messageXSource + this.widthOfMessage - 7, this.messageYSource + this.heightOfMessage - 10, this.messageXSource + this.widthOfMessage - 10, this.messageYSource + this.heightOfMessage - 5);
        }
        String string = this.game.getMessageQueue().GetMessage();
        String string2 = "";
        if (string.length() > this.width / 5) {
            string2 = string.substring(this.width / 5);
            string = string.substring(0, this.width / 5);
        }
        graphics.setColor(255, 255, 0);
        graphics.drawString(string, this.messageXSource + 2, this.messageYSource + 2, 0);
        graphics.drawString(string2, this.messageXSource + 2, this.messageYSource + 2 + this.spaceY, 0);
        graphics.setColor(255, 255, 0);
        graphics.drawRect((int)this.messageXSource, (int)this.messageYSource, this.widthOfMessage - 1, (int)this.heightOfMessage);
    }

    public void DrawInventoryScreen(Graphics graphics) {
        int n = 25;
        graphics.setColor(255, 255, 0);
        if (!this.smallScreen) {
            Object[] objectArray;
            int n2;
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            if (this.game.getPlayer().getInventory().getEquipedArray()[this.inventoryScrollIndex] != null) {
                String[] stringArray = this.game.getPlayer().getInventory().getEquipedArray()[this.inventoryScrollIndex].DescribeProperties();
                graphics.drawString(stringArray[0], 2, 2, 0);
                graphics.drawString(stringArray[1], 2, 2 + this.spaceY, 0);
            }
            graphics.drawLine(0, 2 * this.spaceY + 9, (int)this.width, 2 * this.spaceY + 9);
            graphics.drawString("Equiped Items", 2, 33, 0);
            n = (short)(n + 24);
            int n3 = this.game.getPlayer().getInventory().getEquipedArray().length;
            if (n3 >= this.height / this.spaceY / 2) {
                n3 = (short)(this.height / this.spaceY / 2);
            }
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            for (n2 = 0; n2 < n3; ++n2) {
                if (this.inventoryScrollIndex + n2 >= this.game.getPlayer().getInventory().getEquipedArray().length) continue;
                if (this.game.getPlayer().getInventory().getEquipedArray()[this.inventoryScrollIndex + n2] != null) {
                    graphics.drawString("[" + (this.inventoryScrollIndex + n2) + "] : " + this.game.getPlayer().getInventory().getEquipedArray()[this.inventoryScrollIndex + n2].DescribeMeInGold(), 14, n + n2 * this.spaceY, 0);
                    continue;
                }
                graphics.drawString("[" + (this.inventoryScrollIndex + n2) + "] : Empty", 14, n + n2 * this.spaceY, 0);
            }
            graphics.setColor(0xFF0000);
            graphics.fillRoundRect(3, n + 2, 8, 8, 8, 8);
            graphics.setColor(255, 255, 0);
            n = (short)(n2 * this.spaceY + n + 3);
            graphics.drawLine(0, n + 2, (int)this.width, n + 2);
            if (this.scrollIndex < this.game.getPlayer().getInventory().GetAll().length) {
                objectArray = this.game.getPlayer().getInventory().GetAll()[this.scrollIndex].DescribeProperties();
                graphics.drawString(objectArray[0], 2, n + 2, 0);
                graphics.drawString(objectArray[1], 2, n + this.spaceY + 2, 0);
            }
            n = (short)(n + (2 * this.spaceY + 2));
            graphics.drawLine(0, n + 8, (int)this.width, n + 8);
            graphics.setFont(Font.getFont((int)0, (int)2, (int)8));
            graphics.drawString("Inventory", 2, n + 8, 0);
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            n = (short)(n + 24);
            objectArray = this.game.getPlayer().getInventory().GetAll();
            n3 = (short)((this.height - n) / this.spaceY);
            for (int i = 0; i < n3 && objectArray != null; ++i) {
                if (this.scrollIndex + i >= objectArray.length || objectArray[this.scrollIndex + i] == null) continue;
                graphics.drawString("[" + (this.scrollIndex + i) + "] : " + ((Item)objectArray[this.scrollIndex + i]).DescribeMeInGold(), 14, i * this.spaceY + n, 0);
            }
            graphics.setColor(0xFF0000);
            graphics.fillRoundRect(3, n + 2, 8, 8, 8, 8);
            graphics.setColor(255, 255, 0);
        } else {
            Object[] objectArray;
            int n4;
            n = 0;
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            if (this.game.getPlayer().getInventory().getEquipedArray()[this.inventoryScrollIndex] != null) {
                String[] stringArray = this.game.getPlayer().getInventory().getEquipedArray()[this.inventoryScrollIndex].DescribePropertiesSmallScreen();
                graphics.drawString(stringArray[0], 2, n + 2, 0);
                graphics.drawString(stringArray[1], 2, n + this.spaceY + 2, 0);
                graphics.drawString(stringArray[2], 2, n + this.spaceY * 2 + 2, 0);
            }
            n = (short)(n + (3 * this.spaceY + 2));
            graphics.drawLine(0, n, (int)this.width, n);
            graphics.drawString("Equiped Items", 2, n + 2, 0);
            n = (short)(n + 1 * this.spaceY);
            int n5 = 2;
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            for (n4 = 0; n4 < n5; ++n4) {
                if (this.inventoryScrollIndex + n4 >= this.game.getPlayer().getInventory().getEquipedArray().length) continue;
                if (this.game.getPlayer().getInventory().getEquipedArray()[this.inventoryScrollIndex + n4] != null) {
                    graphics.drawString(this.game.getPlayer().getInventory().getEquipedArray()[this.inventoryScrollIndex + n4].getName(), 14, n + n4 * this.spaceY, 0);
                    continue;
                }
                graphics.drawString("Empty", 14, n + n4 * this.spaceY, 0);
            }
            graphics.setColor(0xFF0000);
            graphics.fillRoundRect(3, n, 8, 8, 8, 8);
            graphics.setColor(255, 255, 0);
            n = (short)(n4 * this.spaceY + n);
            graphics.drawLine(0, n, (int)this.width, n);
            if (this.scrollIndex < this.game.getPlayer().getInventory().GetAll().length) {
                objectArray = this.game.getPlayer().getInventory().GetAll()[this.scrollIndex].DescribePropertiesSmallScreen();
                graphics.drawString(objectArray[0], 2, n + 2, 0);
                graphics.drawString(objectArray[1], 2, n + this.spaceY + 2, 0);
                graphics.drawString(objectArray[2], 2, n + this.spaceY * 2 + 2, 0);
            }
            n = (short)(n + (3 * this.spaceY + 2));
            graphics.drawLine(0, n, (int)this.width, n);
            graphics.setFont(Font.getFont((int)0, (int)2, (int)8));
            graphics.drawString("Inventory", 2, n + 2, 0);
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            n = (short)(n + (1 * this.spaceY + 2));
            objectArray = this.game.getPlayer().getInventory().GetAll();
            n5 = 2;
            for (int i = 0; i < n5 && objectArray != null; ++i) {
                if (this.scrollIndex + i >= objectArray.length || objectArray[this.scrollIndex + i] == null) continue;
                graphics.drawString(((Item)objectArray[this.scrollIndex + i]).getName(), 14, i * this.spaceY + n, 0);
            }
            graphics.setColor(0xFF0000);
            graphics.fillRoundRect(3, n, 8, 8, 8, 8);
            graphics.setColor(255, 255, 0);
        }
    }

    public void DrawGameOverScreen(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, (int)this.width, (int)this.height);
        graphics.setColor(255, 255, 0);
        graphics.setFont(Font.getFont((int)0, (int)2, (int)8));
        graphics.drawString("You where killed by a: ", 2, 2, 0);
        if (this.game.getCurrentTarget() != null) {
            graphics.drawString(this.game.getCurrentTarget().GetName() + " Lv: " + this.game.getCurrentTarget().getLevel(), 2, 1 * this.spaceY + 2, 0);
        }
        graphics.drawString("Your achievements are: ", 2, 3 * this.spaceY + 2, 0);
        graphics.drawString("Level reached: " + this.game.getPlayer().getLevel(), 2, 4 * this.spaceY + 2, 0);
        graphics.drawString("Gold aquired: " + this.game.getPlayer().getGold(), 2, 5 * this.spaceY + 2, 0);
        graphics.drawString("Monsters killed: " + this.game.getPlayer().getMonstersKilled(), 2, 6 * this.spaceY + 2, 0);
        graphics.drawString("Items found: " + this.game.getPlayer().getItemsPickedUp(), 2, 7 * this.spaceY + 2, 0);
        graphics.drawString("Your record will be removed...", 2, 9 * this.spaceY + 2, 0);
        graphics.drawString("Thanks for playing", 2, 10 * this.spaceY + 2, 0);
        graphics.setColor(255, 255, 0);
        graphics.drawRect(0, 0, this.width - 1, this.height - 1);
    }

    public void DrawPlayerStatus(Graphics graphics) {
        if (!this.smallScreen) {
            graphics.setColor(255, 255, 0);
            graphics.setFont(Font.getFont((int)0, (int)2, (int)8));
            graphics.drawString("Player", this.playerStatusXSource + 1, (int)this.playerStatusYSource, 0);
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            graphics.drawString("Lv: " + this.game.getPlayer().getLevel(), this.playerStatusXSource + 1, this.playerStatusYSource + 1 * this.spaceY, 0);
            graphics.drawString("HP: " + this.game.getPlayer().getCurrentHitpoints() + "/" + this.game.getPlayer().getMaxHitPoints(), this.playerStatusXSource + 1, this.playerStatusYSource + 2 * this.spaceY, 0);
            graphics.drawString("St: " + this.game.getPlayer().getStrenghtLevel() + "+(" + this.game.getPlayer().getInventory().getStrenghtEffect() + ")", this.playerStatusXSource + 1, this.playerStatusYSource + 3 * this.spaceY, 0);
            graphics.drawString("De: " + this.game.getPlayer().getDefence() + "+(" + this.game.getPlayer().getInventory().getDefence() + ")", this.playerStatusXSource + 1, this.playerStatusYSource + 4 * this.spaceY, 0);
            graphics.drawString("AS: " + this.game.getPlayer().getAttackSkillLevel() + "+(" + this.game.getPlayer().getInventory().getAttackSkillEffect() + ")", this.playerStatusXSource + 1, this.playerStatusYSource + 5 * this.spaceY, 0);
            graphics.drawString("DS: " + this.game.getPlayer().getDefenceSkillLevel() + "+(" + this.game.getPlayer().getInventory().getDefenceSkillEffect() + ")", this.playerStatusXSource + 1, this.playerStatusYSource + 6 * this.spaceY, 0);
            graphics.drawString("In: " + this.game.getPlayer().getIntelligenceLevel() + "+(" + this.game.getPlayer().getInventory().getIntelligenceEffect() + ")", this.playerStatusXSource + 1, this.playerStatusYSource + 7 * this.spaceY, 0);
            graphics.drawString("We: " + this.game.getPlayer().getInventory().getTotalWeight() + "/" + this.game.getPlayer().getTotalWeightPosible(), this.playerStatusXSource + 1, this.playerStatusYSource + 8 * this.spaceY, 0);
            graphics.setColor(255, 255, 0);
            graphics.drawRect((int)this.playerStatusXSource, (int)this.playerStatusYSource, this.widthOfPlayerStatus - 1, (int)this.heightOfPlayerStatus);
        } else {
            graphics.setColor(255, 255, 0);
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            graphics.drawString("HP: " + this.game.getPlayer().getCurrentHitpoints() + "/" + this.game.getPlayer().getMaxHitPoints(), this.playerStatusXSource + 1, this.playerStatusYSource + 0 * this.spaceY + 2, 0);
            graphics.drawString("We: " + this.game.getPlayer().getInventory().getTotalWeight() + "/" + this.game.getPlayer().getTotalWeightPosible(), this.playerStatusXSource + 1, this.playerStatusYSource + 1 * this.spaceY + 2, 0);
            graphics.setColor(255, 255, 0);
            graphics.drawRect((int)this.playerStatusXSource, (int)this.playerStatusYSource, this.widthOfPlayerStatus - 1, (int)this.heightOfPlayerStatus);
        }
    }

    public void DrawMonsterStatus(Graphics graphics) {
        graphics.setColor(255, 255, 0);
        graphics.setFont(Font.getFont((int)0, (int)2, (int)8));
        graphics.drawString("Monster", this.monsterStatusXSource + 2, this.monsterStatusYSource + 2, 0);
        if (this.game.getCurrentTarget() != null && this.game.getCurrentTarget().getCurrentHealth() > 0) {
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            graphics.drawString("Sy: ", this.monsterStatusXSource + 1, this.monsterStatusYSource + 1 * this.spaceY, 0);
            graphics.setColor(this.game.getCurrentTarget().getColor());
            graphics.drawString("" + this.game.getCurrentTarget().getSymbol(), this.monsterStatusXSource + 1 + (1 * this.spaceX + 7), this.monsterStatusYSource + 1 * this.spaceY, 0);
            graphics.setColor(255, 255, 0);
            graphics.drawString("Lv: " + this.game.getCurrentTarget().getLevel(), this.monsterStatusXSource + 1, this.monsterStatusYSource + 2 * this.spaceY, 0);
            graphics.drawString("HP: " + this.game.getCurrentTarget().getCurrentHealth() + "/" + this.game.getCurrentTarget().getMaximumHealth(), this.monsterStatusXSource + 1, this.monsterStatusYSource + 3 * this.spaceY, 0);
            graphics.drawString("St: " + this.game.getCurrentTarget().getStrenght() + "+(" + this.game.getCurrentTarget().getNpcItem().getStrenghtEffect() + ")", this.monsterStatusXSource + 1, this.monsterStatusYSource + 4 * this.spaceY, 0);
            graphics.drawString("De: " + this.game.getCurrentTarget().getDefence() + "+(" + this.game.getCurrentTarget().getNpcItem().getDefenceEffect() + ")", this.monsterStatusXSource + 1, this.monsterStatusYSource + 5 * this.spaceY, 0);
            graphics.drawString("AS: " + this.game.getCurrentTarget().getAttackSkill() + "+(" + this.game.getCurrentTarget().getNpcItem().getAttackSkillEffect() + ")", this.monsterStatusXSource + 1, this.monsterStatusYSource + 6 * this.spaceY, 0);
            graphics.drawString("DS: " + this.game.getCurrentTarget().getDefenceSkill() + "+(" + this.game.getCurrentTarget().getNpcItem().getDefenceSkillEffect() + ")", this.monsterStatusXSource + 1, this.monsterStatusYSource + 7 * this.spaceY, 0);
            graphics.drawString("In: " + this.game.getCurrentTarget().getIntelligence() + "+(" + this.game.getCurrentTarget().getNpcItem().getIntelligenceEffect() + ")", this.monsterStatusXSource + 1, this.monsterStatusYSource + 8 * this.spaceY, 0);
        }
        graphics.setColor(255, 255, 0);
        graphics.drawRect((int)this.monsterStatusXSource, (int)this.monsterStatusYSource, this.widthOfMonsterStatus - 1, (int)this.heightOfMonsterStatus);
    }

    public void DrawTitle(Graphics graphics) {
        Runtime runtime = Runtime.getRuntime();
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        graphics.setColor(0);
        graphics.fillRect(0, 0, (int)this.width, (int)this.height);
        graphics.setColor(255, 255, 0);
        graphics.drawString("Roguelike Mobile", 5, 5, 0);
        graphics.drawString("Total Memory: " + runtime.totalMemory() / 1024L + " KB", 5, this.spaceY * 1 + 7, 0);
        graphics.drawString("Free Memory: " + runtime.freeMemory() / 1024L + " KB", 5, this.spaceY * 2 + 7, 0);
        graphics.drawString("(c) Bas Ameschot, 2009, v0.9", 5, this.spaceY * 3 + 7, 0);
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.flushGraphics();
    }

    public void DrawMap(Graphics graphics) {
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        int n = this.game.getCurrentInstance().getMap().length;
        int n2 = this.game.getCurrentInstance().getMap()[0].length;
        byte[][] byArray = this.game.getCurrentInstance().getMap();
        for (int i = this.cameraYPos; i < n && i < this.cameraYPos + this.heightOfMap / this.spaceY; ++i) {
            for (int j = this.cameraXPos; j < n2 && j < this.cameraXPos + this.widthOfMap / this.spaceX + 1; ++j) {
                graphics.setColor(this.game.getCurrentInstance().getColorTable(byArray[i][j], j, i));
                graphics.drawString(this.game.getCurrentInstance().getInstanceSymbol(byArray[i][j], j, i) + "", (j - this.cameraXPos) * this.spaceX + this.mapXSource, (i - this.cameraYPos) * this.spaceY + this.mapYSource, 0);
            }
        }
        graphics.setColor(255, 255, 0);
        graphics.drawRect((int)this.mapXSource, (int)this.mapYSource, this.widthOfMap + 7, this.heightOfMap + 3);
    }

    public void Render(Graphics graphics) {
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        graphics.setColor(0);
        graphics.fillRect(0, 0, (int)this.width, (int)this.height);
        graphics.setColor(255, 255, 255);
        if (this.mode == 0) {
            this.DrawPlayerStatus(graphics);
            this.DrawMonsterStatus(graphics);
            this.DrawMap(graphics);
            this.DrawMessage(graphics);
        } else if (this.mode == 1) {
            this.DrawInventoryScreen(graphics);
        } else if (this.mode == 2) {
            this.DrawPlayerStats(graphics);
        } else if (this.mode == 3) {
            this.DrawBarterScreen(graphics);
        } else if (this.mode == 4) {
            this.DrawHelpScreen(graphics);
        } else if (this.mode == 5) {
            this.DrawSendScoreScreen(graphics);
        }
        graphics.setColor(255, 255, 0);
        graphics.drawRect(0, 0, this.width - 1, this.height - 1);
        this.flushGraphics();
    }

    public void start() {
    }

    public void stop() {
        this.running = false;
    }

    public void run() {
        this.DrawTitle(this.getGraphics());
        this.flushGraphics();
        this.Load();
        this.cameraXPos = (short)(this.game.getPlayer().getXPos() - this.widthOfMap / this.spaceX / 2);
        this.cameraYPos = (short)(this.game.getPlayer().getYPos() - this.heightOfMap / this.spaceY / 2);
        if (this.cameraXPos < 0) {
            this.cameraXPos = 0;
        }
        if (this.cameraYPos < 0) {
            this.cameraYPos = 0;
        }
        Graphics graphics = this.getGraphics();
        this.Render(graphics);
        while (this.running && !this.GameOver()) {
            int n = this.getKeyStates();
            if (n == 0) {
                this.timesNotPressed += 100;
                if (this.timesNotPressed > 300000 && this.timesPressed != 300600) {
                    this.timesNotPressed = 300600;
                    this.slowDown = 10000;
                    this.DrawTextMessage("Pause...", graphics);
                    this.flushGraphics();
                    System.out.println("pause");
                }
            } else {
                this.timesNotPressed = 0;
                this.slowDown = 100;
            }
            this.timesPressed = n != this.previousButton ? (byte)0 : (byte)(this.timesPressed + 1);
            if ((n & 2) != 0) {
                if (this.timesPressed == 0) {
                    if (this.game.getMessageQueue().getMessageQueueContents() == 0 && this.mode == 0) {
                        this.game.PlayerMoveUp();
                        this.SetCamera();
                        if (this.game.getCurrentInstance() instanceof World) {
                            this.cameraWorldXPos = this.cameraXPos;
                            this.cameraWorldYPos = this.cameraYPos;
                            if (this.game.getMessageQueue().ContainsMessage("New Province")) {
                                this.EnterNewProvince();
                            }
                        }
                        if (this.game.getCurrentInstance() instanceof CombatInstance && this.game.getMessageQueue().ContainsMessage("You where ambushed by monsters")) {
                            this.cameraWorldXPos = this.cameraXPos;
                            this.cameraWorldYPos = this.cameraYPos;
                            this.cameraXPos = (short)(this.game.getPlayer().getXPos() - this.widthOfMap / this.spaceX / 2);
                            this.cameraYPos = (short)(this.game.getPlayer().getYPos() - this.heightOfMap / this.spaceY / 2);
                            if (this.cameraXPos < 0) {
                                this.cameraXPos = 0;
                            }
                            if (this.cameraYPos < 0) {
                                this.cameraYPos = 0;
                            }
                        }
                    } else if (this.mode == 1) {
                        if (this.scrollIndex > 0) {
                            this.scrollIndex = (short)(this.scrollIndex - 1);
                        }
                    } else if (this.mode == 2) {
                        if (this.statsIndex > 0) {
                            this.statsIndex = (short)(this.statsIndex - 1);
                        }
                    } else if (this.mode == 3 && this.conversationistIndex > 0) {
                        this.conversationistIndex = (byte)(this.conversationistIndex - 1);
                    }
                    this.Render(graphics);
                } else if (this.timesPressed >= 0) {
                    this.timesPressed = 0;
                }
            } else if ((n & 0x40) != 0) {
                if (this.timesPressed == 0) {
                    if (this.game.getMessageQueue().getMessageQueueContents() == 0 && this.mode == 0) {
                        this.game.PlayerMoveDown();
                        this.SetCamera();
                        if (this.game.getCurrentInstance() instanceof World) {
                            this.cameraWorldXPos = this.cameraXPos;
                            this.cameraWorldYPos = this.cameraYPos;
                            if (this.game.getMessageQueue().ContainsMessage("New Province")) {
                                this.EnterNewProvince();
                            }
                        }
                        if (this.game.getCurrentInstance() instanceof CombatInstance && this.game.getMessageQueue().ContainsMessage("You where ambushed by monsters")) {
                            this.cameraWorldXPos = this.cameraXPos;
                            this.cameraWorldYPos = this.cameraYPos;
                            this.cameraXPos = (short)(this.game.getPlayer().getXPos() - this.widthOfMap / this.spaceX / 2);
                            this.cameraYPos = (short)(this.game.getPlayer().getYPos() - this.heightOfMap / this.spaceY / 2);
                            if (this.cameraXPos < 0) {
                                this.cameraXPos = 0;
                            }
                            if (this.cameraYPos < 0) {
                                this.cameraYPos = 0;
                            }
                        }
                    } else if (this.mode == 1) {
                        if (this.scrollIndex < this.game.getPlayer().getInventory().GetAll().length - 1) {
                            this.scrollIndex = (short)(this.scrollIndex + 1);
                        }
                    } else if (this.mode == 2) {
                        if (this.statsIndex < 4) {
                            this.statsIndex = (short)(this.statsIndex + 1);
                        }
                    } else if (this.mode == 3) {
                        this.conversationistIndex = (byte)(this.conversationistIndex + 1);
                    }
                    this.Render(graphics);
                } else if (this.timesPressed >= 0) {
                    this.timesPressed = 0;
                }
            } else if ((n & 4) != 0) {
                if (this.timesPressed == 0) {
                    if (this.game.getMessageQueue().getMessageQueueContents() == 0 && this.mode == 0) {
                        this.game.PlayerMoveLeft();
                        this.SetCamera();
                        if (this.game.getCurrentInstance() instanceof World) {
                            this.cameraWorldXPos = this.cameraXPos;
                            this.cameraWorldYPos = this.cameraYPos;
                            if (this.game.getMessageQueue().ContainsMessage("New Province")) {
                                this.EnterNewProvince();
                            }
                        }
                        if (this.game.getCurrentInstance() instanceof CombatInstance && this.game.getMessageQueue().ContainsMessage("You where ambushed by monsters")) {
                            this.cameraWorldXPos = this.cameraXPos;
                            this.cameraWorldYPos = this.cameraYPos;
                            this.cameraXPos = (short)(this.game.getPlayer().getXPos() - this.widthOfMap / this.spaceX / 2);
                            this.cameraYPos = (short)(this.game.getPlayer().getYPos() - this.heightOfMap / this.spaceY / 2);
                            if (this.cameraXPos < 0) {
                                this.cameraXPos = 0;
                            }
                            if (this.cameraYPos < 0) {
                                this.cameraYPos = 0;
                            }
                        }
                    } else if (this.mode == 1) {
                        if (this.inventoryScrollIndex > 0) {
                            this.inventoryScrollIndex = (short)(this.inventoryScrollIndex - 1);
                        }
                    } else if (this.mode == 3 && this.scrollIndex > 0) {
                        this.scrollIndex = (short)(this.scrollIndex - 1);
                    }
                    this.Render(graphics);
                } else if (this.timesPressed >= 0) {
                    this.timesPressed = 0;
                }
            } else if ((n & 0x20) != 0) {
                if (this.timesPressed == 0) {
                    if (this.game.getMessageQueue().getMessageQueueContents() == 0 && this.mode == 0) {
                        this.game.PlayerMoveRight();
                        this.SetCamera();
                        if (this.game.getCurrentInstance() instanceof World) {
                            this.cameraWorldXPos = this.cameraXPos;
                            this.cameraWorldYPos = this.cameraYPos;
                            if (this.game.getMessageQueue().ContainsMessage("New Province")) {
                                this.EnterNewProvince();
                            }
                        }
                        if (this.game.getCurrentInstance() instanceof CombatInstance && this.game.getMessageQueue().ContainsMessage("You where ambushed by monsters")) {
                            this.cameraWorldXPos = this.cameraXPos;
                            this.cameraWorldYPos = this.cameraYPos;
                            this.cameraXPos = (short)(this.game.getPlayer().getXPos() - this.widthOfMap / this.spaceX / 2);
                            this.cameraYPos = (short)(this.game.getPlayer().getYPos() - this.heightOfMap / this.spaceY / 2);
                            if (this.cameraXPos < 0) {
                                this.cameraXPos = 0;
                            }
                            if (this.cameraYPos < 0) {
                                this.cameraYPos = 0;
                            }
                        }
                    } else if (this.mode == 1) {
                        if (this.inventoryScrollIndex < this.game.getPlayer().getInventory().getEquipedArray().length - 1) {
                            this.inventoryScrollIndex = (short)(this.inventoryScrollIndex + 1);
                        }
                    } else if (this.mode == 3 && this.scrollIndex < this.game.getPlayer().getInventory().GetAll().length - 1) {
                        this.scrollIndex = (short)(this.scrollIndex + 1);
                    }
                    this.Render(graphics);
                } else if (this.timesPressed >= 0) {
                    this.timesPressed = 0;
                }
            } else if ((n & 0x100) != 0) {
                if (this.timesPressed == 0) {
                    Object object;
                    if (this.game.getCurrentInstance() instanceof World && this.mode == 0) {
                        this.DrawTextMessage("Generating...", graphics);
                        this.flushGraphics();
                        this.game.GotoInstance(this.game.getPlayer().getXPos(), this.game.getPlayer().getYPos());
                        this.cameraWorldXPos = this.cameraXPos;
                        this.cameraWorldYPos = this.cameraYPos;
                        this.cameraXPos = (short)(this.game.getPlayer().getXPos() - this.widthOfMap / this.spaceX / 2);
                        this.cameraYPos = (short)(this.game.getPlayer().getYPos() - this.heightOfMap / this.spaceY / 2);
                        if (this.cameraXPos < 0) {
                            this.cameraXPos = 0;
                        }
                        if (this.cameraYPos < 0) {
                            this.cameraYPos = 0;
                        }
                        this.Render(graphics);
                    } else if (this.game.getPlayer().getCurrentlyOn() == 5 && this.mode == 0) {
                        this.game.GetItemFromInstance(this.game.getPlayer().getXPos(), this.game.getPlayer().getYPos());
                    } else if (this.mode == 1) {
                        this.game.EquipItem(this.scrollIndex, this.inventoryScrollIndex);
                    } else if (this.mode == 2) {
                        this.game.AddSkillPoints(this.statsIndex);
                    }
                    if (this.mode == 3 && this.barterModes == 0 && ((NPC[])(object = this.game.GetConversationPartners())).length > 0) {
                        this.conversationistIndex = (byte)(this.conversationistIndex % ((NPC[])object).length);
                        if (object[this.conversationistIndex] != null) {
                            this.game.SellItem(this.scrollIndex);
                        }
                    }
                    if (this.mode == 5) {
                        this.DrawTextMessage("Sending Data...", graphics);
                        this.flushGraphics();
                        object = new InternetConnector();
                        this.DrawTextMessage(((InternetConnector)object).SendScore("Me", this.game.getPlayer().getGold()), graphics);
                        this.flushGraphics();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.Render(graphics);
                } else if (this.timesPressed >= 0) {
                    this.timesPressed = 0;
                }
            } else if ((n & 0x200) != 0) {
                if (this.timesPressed == 0) {
                    this.mode = this.mode > 0 ? (byte)(this.mode - 1) : (byte)(this.modes.length - 1);
                    this.Render(graphics);
                } else if (this.timesPressed >= 0) {
                    this.timesPressed = 0;
                }
            } else if ((n & 0x400) != 0) {
                if (this.timesPressed == 0) {
                    this.mode = this.mode < this.modes.length - 1 ? (byte)(this.mode + 1) : (byte)0;
                    this.Render(graphics);
                } else if (this.timesPressed >= 0) {
                    this.timesPressed = 0;
                }
            } else if ((n & 0x800) != 0) {
                if (this.timesPressed == 0) {
                    if (this.mode == 0 && this.game.Rest()) {
                        this.DrawTextMessage("Resting...", graphics);
                        this.flushGraphics();
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.DrawTextMessage("Waking up...", graphics);
                        this.flushGraphics();
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.mode == 1) {
                        this.game.DeEquipItem(this.inventoryScrollIndex);
                    }
                    if (this.mode == 3) {
                        this.barterModes = this.barterModes == 0 ? (byte)1 : 0;
                    }
                    this.Render(graphics);
                } else if (this.timesPressed >= 0) {
                    this.timesPressed = 0;
                }
            } else if ((n & 0x1000) != 0) {
                if (this.timesPressed == 0) {
                    if (this.mode == 0) {
                        this.Save();
                    }
                    if (this.mode == 1) {
                        this.game.DropItem(this.scrollIndex);
                    }
                    this.Render(graphics);
                } else if (this.timesPressed >= 0) {
                    this.timesPressed = 0;
                }
            }
            this.previousButton = n;
            try {
                Thread.sleep(this.slowDown);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.previousButton = n;
            System.gc();
        }
    }

    private void SetCamera() {
        int n = 4;
        int n2 = 4;
        if (this.game.getMessageQueue().ContainsMessage("You enter the wide world")) {
            this.cameraYPos = this.cameraWorldYPos;
            this.cameraXPos = this.cameraWorldXPos;
        }
        if (Math.abs(this.cameraXPos - this.game.getPlayer().getXPos()) < n && this.cameraXPos > 0) {
            this.cameraXPos = (short)(this.cameraXPos - 1);
        }
        if (Math.abs(this.cameraYPos - this.game.getPlayer().getYPos()) < n2 && this.cameraYPos > 0) {
            this.cameraYPos = (short)(this.cameraYPos - 1);
        }
        if (Math.abs(this.cameraXPos + this.widthOfMap / this.spaceX - this.game.getPlayer().getXPos()) < n && this.cameraXPos + this.widthOfMap / this.spaceX < this.game.getCurrentInstance().getMap()[0].length) {
            this.cameraXPos = (short)(this.cameraXPos + 1);
        }
        if (Math.abs(this.cameraYPos + this.heightOfMap / this.spaceY - this.game.getPlayer().getYPos()) < n2 && this.cameraYPos + this.heightOfMap / this.spaceY < this.game.getCurrentInstance().getMap().length) {
            this.cameraYPos = (short)(this.cameraYPos + 1);
        }
    }

    private void EnterNewProvince() {
        this.cameraXPos = this.game.getPlayer().getXPos();
        this.cameraYPos = this.game.getPlayer().getYPos();
        if (this.cameraXPos == this.game.getCurrentInstance().getMap()[0].length - 1) {
            this.cameraXPos = (short)(this.cameraXPos - this.widthOfMap / this.spaceX);
            this.cameraYPos = this.cameraWorldYPos;
        }
        if (this.cameraYPos == this.game.getCurrentInstance().getMap().length - 1) {
            this.cameraYPos = (short)(this.cameraYPos - this.heightOfMap / this.spaceY);
            this.cameraXPos = this.cameraWorldXPos;
        }
        this.DrawTextMessage("Saving...", this.getGraphics());
        this.flushGraphics();
        this.game.getWorld().getMap()[this.game.getPlayer().getYPos()][this.game.getPlayer().getXPos()] = this.game.getPlayer().getCurrentlyOn();
        DataProcessor dataProcessor = new DataProcessor();
        dataProcessor = new DataProcessor();
        dataProcessor.SaveWorld(this.game.getWorld());
        this.game.getWorld().getMap()[this.game.getPlayer().getYPos()][this.game.getPlayer().getXPos()] = 11;
    }

    private void ChangeScreenParameters() {
        if (this.width > 200) {
            this.height = (short)this.getHeight();
            this.width = (short)this.getWidth();
            this.spaceX = (byte)12;
            this.spaceY = (byte)12;
            this.widthOfMessage = (short)(this.width - this.width / 100 * 0);
            this.heightOfMessage = (short)(3 * this.spaceY);
            this.widthOfMap = (short)(this.width - this.width / 100 * 50);
            this.heightOfMap = (short)(this.height - this.heightOfMessage);
            this.mapXSource = 0;
            this.mapYSource = (short)(this.messageYSource + this.heightOfMessage);
            this.playerStatusXSource = (short)(this.mapXSource + this.widthOfMap + 7);
            this.playerStatusYSource = this.mapYSource;
            this.widthOfPlayerStatus = (short)(this.width - this.widthOfMap);
            this.heightOfPlayerStatus = (short)(this.heightOfMap / 2);
            this.monsterStatusXSource = (short)(this.mapXSource + this.widthOfMap + 7);
            this.monsterStatusYSource = (short)(this.mapYSource + this.heightOfPlayerStatus);
            this.widthOfMonsterStatus = (short)(this.width - this.widthOfMap);
            this.heightOfMonsterStatus = (short)(this.heightOfMap / 2 + 4);
            this.smallScreen = false;
            this.flushGraphics();
        }
        if (this.width < 200) {
            this.height = (short)this.getHeight();
            this.width = (short)this.getWidth();
            this.spaceX = (byte)12;
            this.spaceY = (byte)12;
            this.widthOfMap = (short)(this.width - this.width / 100 * 65);
            this.heightOfMap = (short)(this.height - this.height / 100 * 0);
            this.widthOfMessage = (short)(this.width - this.width / 100 * 0);
            this.heightOfMessage = (short)(2 * this.spaceY);
            this.mapXSource = 0;
            this.mapYSource = (short)(this.messageYSource + this.heightOfMessage);
            this.playerStatusXSource = (short)(this.widthOfMap + this.mapXSource + 7);
            this.playerStatusYSource = (short)(this.messageXSource + this.heightOfMessage);
            this.widthOfPlayerStatus = (short)(this.width - this.widthOfMap);
            this.heightOfPlayerStatus = (short)(this.spaceY * 2);
            this.monsterStatusXSource = (short)(this.mapXSource + this.widthOfMap + 7);
            this.monsterStatusYSource = (short)(this.playerStatusYSource + this.heightOfPlayerStatus);
            this.widthOfMonsterStatus = (short)(this.width - this.widthOfMap);
            this.heightOfMonsterStatus = (short)(this.heightOfMap - 1);
            this.smallScreen = true;
            this.flushGraphics();
        }
    }

    public void DestroyMe() {
        if (this.running) {
            this.Save();
            this.running = false;
        }
    }

    public int getSlowDown() {
        return this.slowDown;
    }

    public void setSlowDown(int n) {
        this.slowDown = n;
    }

    public void Save() {
        this.DrawTextMessage("Saving...", this.getGraphics());
        this.flushGraphics();
        short[] sArray = new short[4];
        if (this.game.getCurrentInstance() instanceof CombatInstance) {
            sArray[0] = this.cameraWorldXPos;
            sArray[1] = this.cameraWorldYPos;
            sArray[2] = this.game.getWorldXPos();
            sArray[3] = this.game.getWorldYPos();
        } else {
            sArray[0] = this.cameraWorldXPos;
            sArray[1] = this.cameraWorldYPos;
            sArray[2] = this.game.getPlayer().getXPos();
            sArray[3] = this.game.getPlayer().getYPos();
        }
        DataProcessor dataProcessor = new DataProcessor();
        dataProcessor.SaveGame(this.game.getPlayer(), sArray);
        this.Render(this.getGraphics());
    }

    public boolean Load() {
        DataProcessor dataProcessor = new DataProcessor();
        this.DrawTextMessage("Loading...", this.getGraphics());
        this.flushGraphics();
        Player player = dataProcessor.LoadPlayer();
        World world = dataProcessor.LoadWorld();
        short[] sArray = dataProcessor.LoadEnvironementVariables();
        if (player != null && world != null && sArray != null) {
            System.out.println("Load Game");
            this.game = new Game(false);
            this.game.setWorld(world);
            this.game.setCurrentInstance(world);
            this.cameraXPos = sArray[0];
            this.cameraYPos = sArray[1];
            player.setXPos(sArray[2]);
            player.setYPos(sArray[3]);
            player.setCurrentlyOn(this.game.getWorld().getMap()[player.getYPos()][player.getXPos()]);
            this.game.getWorld().getMap()[player.getYPos()][player.getXPos()] = 11;
            this.game.setPlayer(player);
            System.out.println("End of load sequence");
            return true;
        }
        this.DrawTextMessage("Creating World...", this.getGraphics());
        this.flushGraphics();
        System.out.println("New Game");
        this.game = new Game(true);
        this.game.getWorld().getMap()[this.game.getPlayer().getYPos()][this.game.getPlayer().getXPos()] = this.game.getPlayer().getCurrentlyOn();
        dataProcessor = new DataProcessor();
        dataProcessor.SaveWorld(this.game.getWorld());
        this.game.getWorld().getMap()[this.game.getPlayer().getYPos()][this.game.getPlayer().getXPos()] = 11;
        return false;
    }

    public void ResetGame() {
        this.DestroyMe();
        DataProcessor dataProcessor = new DataProcessor();
        dataProcessor.DestroyAllData();
    }

    private boolean GameOver() {
        if (this.game.getPlayer().getCurrentHitpoints() < 0) {
            this.DrawGameOverScreen(this.getGraphics());
            this.flushGraphics();
            DataProcessor dataProcessor = new DataProcessor();
            dataProcessor.DestroyAllData();
            this.game = null;
            System.gc();
            this.running = false;
            return true;
        }
        return false;
    }
}

