/*
 * Decompiled with CFR 0.152.
 */
package mobilespicker;

import de.tuttas.GameAPI.FragmentImage;
import de.tuttas.GameAPI.Menu;
import de.tuttas.GameAPI.MenuItem;
import de.tuttas.GameAPI.MenuListener;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mobilespicker.Config;
import mobilespicker.SubMenu;

public class MainMenu
extends Menu
implements MenuListener {
    public static int EBENE1 = 1;
    public static int EBENE2 = 2;
    int state;
    static FragmentImage fi;
    MenuListener listener;
    MenuItem backItem = new MenuItem("back", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    static int width;
    static int height;
    int num;
    int yPos;
    SubMenu selectedSubMenu;

    public MainMenu(int y) {
        super(y);
        super.setListener(this);
        this.yPos = y;
        try {
            fi = new FragmentImage(Image.createImage((String)"/symb.png"));
            height = width = MainMenu.fi.largeImage.getHeight();
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        this.state = EBENE1;
    }

    public void setListener(MenuListener l) {
        this.listener = l;
    }

    public void add(SubMenu m) {
        m.add(this.backItem);
        super.add(m);
        m.setListener(this);
    }

    public void left() {
        if (this.state == EBENE1) {
            super.left();
        } else if (this.state == EBENE2) {
            this.selectedSubMenu.m.left();
        }
    }

    public void right() {
        if (this.state == EBENE1) {
            super.right();
        } else if (this.state == EBENE2) {
            this.selectedSubMenu.m.right();
        }
    }

    public void paint(Graphics g) {
        fi.paint(g, Config.SCREEN_WIDTH / 2 - width / 2, Config.SCREEN_HEIGHT / 2 - height / 2, this.index, 0, width, height);
        if (this.state == EBENE1) {
            g.setColor(Config.COLOR_0);
            g.setFont(Config.MENU_FONT);
            g.drawString("Maths Cheat", Config.SCREEN_WIDTH / 2, Config.HEADLINE_Y, 17);
            super.paint(g);
        } else if (this.state == EBENE2) {
            g.setColor(Config.COLOR_0);
            g.setFont(Config.MENU_FONT);
            g.drawString(this.selectedItem.text, Config.SCREEN_WIDTH / 2, Config.HEADLINE_Y, 17);
            this.selectedSubMenu.paint(g);
        }
    }

    public void select(MenuItem mi) {
        if (this.state == EBENE1) {
            try {
                this.selectedSubMenu = (SubMenu)mi;
                this.selectedSubMenu.m.setSelectedItem(0);
                this.state = EBENE2;
            }
            catch (ClassCastException ce) {
                this.listener.select(mi);
            }
        } else if (this.state == EBENE2) {
            if (this.selectedSubMenu.m.getSelectedItem() == this.backItem) {
                this.state = EBENE1;
            } else {
                this.listener.select(this.selectedSubMenu.m.getSelectedItem());
            }
        }
    }
}

