/*
 * Decompiled with CFR 0.152.
 */
package de.tuttas.GameAPI;

import de.tuttas.GameAPI.MenuListener;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MenuItem {
    public static int height = 0;
    public boolean isSelected;
    private MenuListener listener;
    public String text;
    private boolean visible = false;
    private int fontSize;
    public int colorActive;
    public int colorInactive;
    private int colorBg = -1;
    public int x;
    public int y;
    Font font;

    public MenuItem(String t, int c1, int c0, int f_Size) {
        this.init(t, c1, c0, f_Size);
    }

    public MenuItem() {
    }

    public MenuItem(String t, int c1, int c0, int cbg, int f_Size) {
        this.colorBg = cbg;
        this.init(t, c1, c0, f_Size);
    }

    public int getWidth() {
        return this.font.stringWidth(this.text);
    }

    private void init(String t, int c1, int c0, int f_Size) {
        this.font = Font.getFont((int)32, (int)1, (int)f_Size);
        height = this.font.getHeight();
        this.colorActive = c1;
        this.colorInactive = c0;
        this.fontSize = f_Size;
        this.text = t;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean state) {
        this.visible = state;
    }

    public void setListener(MenuListener ml) {
        this.listener = ml;
    }

    public void setSelect(boolean state) {
        this.isSelected = state;
    }

    public void toggle() {
        this.isSelected = !this.isSelected;
    }

    public void perform() {
        this.listener.select(this);
    }

    public void paint(Graphics g, int py, int w) {
        this.paint(g, g.getClipWidth() / 2, py, w);
    }

    public void paint(Graphics g, int px, int py, int w) {
        this.x = px;
        this.y = py;
        if (this.isSelected) {
            if (this.colorBg != -1) {
                g.setColor(this.colorBg);
                g.fillRoundRect(this.x - w / 2, this.y - 1, w, height, height, height);
            }
            MenuItem.Text3D(g, this.text, this.x, this.y, this.colorActive, 17);
        } else {
            MenuItem.Text3D(g, this.text, this.x, this.y, this.colorInactive, 17);
        }
    }

    public static void Text3D(Graphics g, String s, int x, int y, int c, int a) {
        g.setColor(0, 0, 0);
        g.drawString(s, x + 1, y + 1, a);
        g.setColor(c);
        g.drawString(s, x, y, a);
    }
}

