/*
 * Decompiled with CFR 0.152.
 */
package mobilespicker;

import de.tuttas.GameAPI.MenuItem;
import de.tuttas.GameAPI.MenuListener;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mobilespicker.Config;
import mobilespicker.MainMenu;
import mobilespicker.MyCanvas;
import mobilespicker.Spicker;
import mobilespicker.SplashListener;
import mobilespicker.SplashScreen;
import mobilespicker.SubMenu;

public class Displayable
extends MyCanvas
implements MenuListener,
SplashListener {
    public static final int SELECT = 1;
    public static final int DISPLAY = 2;
    public static final int WAIT = 3;
    public static final int HIDE = 4;
    int state;
    int prevState;
    Image titelImage;
    Image bgImage;
    MainMenu mm = new MainMenu(Config.SCREEN_HEIGHT - 2 * Config.MENU_FONT.getHeight());
    SubMenu mWinkel = new SubMenu(1, "angle");
    SubMenu mFlaeche = new SubMenu(2, "area");
    SubMenu mVolumen = new SubMenu(3, "volume");
    SubMenu mGeometrie = new SubMenu(4, "geometry");
    SubMenu mStatistik = new SubMenu(5, "statistics");
    SubMenu mProzent = new SubMenu(6, "percent");
    SubMenu mSonst = new SubMenu(7, "algebra");
    MenuItem itemSin = new MenuItem("sine", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemCos = new MenuItem("cosine", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemTan = new MenuItem("tangent", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemCoTan = new MenuItem("co-tangent", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemKreis = new MenuItem("cirle", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemRechteck = new MenuItem("rectangle", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemTrapez = new MenuItem("trapetium", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemParallel = new MenuItem("parallelogram", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemDreieck = new MenuItem("equil. triangle", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemKegel = new MenuItem("cone", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemQuader = new MenuItem("cuboid", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemKugel = new MenuItem("sphere", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemZylinder = new MenuItem("cylinder", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemPyramide = new MenuItem("pyramid", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemStrahl1 = new MenuItem("intercept theorem 1", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemStrahl2 = new MenuItem("intercept theorem 2", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemPyth = new MenuItem("Phythagoras", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemAMittel = new MenuItem("arithmetic mean", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemGMittel = new MenuItem("geometric mean", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemBinom = new MenuItem("binominal series", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemQuad = new MenuItem("quad. equation", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemZins = new MenuItem("percent", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem itemZinsZins = new MenuItem("compound interest", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem back = new MenuItem("back", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());
    MenuItem exit = new MenuItem("end", Config.COLOR_1, Config.COLOR_0, Config.MENU_FONT.getSize());

    public Displayable() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.state = 1;
    }

    private void jbInit() throws Exception {
        this.titelImage = Image.createImage((String)"/titel.png");
        this.mWinkel.add(this.itemSin);
        this.mWinkel.add(this.itemCos);
        this.mWinkel.add(this.itemTan);
        this.mWinkel.add(this.itemCoTan);
        this.mFlaeche.add(this.itemKreis);
        this.mFlaeche.add(this.itemRechteck);
        this.mFlaeche.add(this.itemTrapez);
        this.mFlaeche.add(this.itemParallel);
        this.mFlaeche.add(this.itemDreieck);
        this.mVolumen.add(this.itemKegel);
        this.mVolumen.add(this.itemQuader);
        this.mVolumen.add(this.itemKugel);
        this.mVolumen.add(this.itemZylinder);
        this.mVolumen.add(this.itemPyramide);
        this.mGeometrie.add(this.itemStrahl1);
        this.mGeometrie.add(this.itemStrahl2);
        this.mGeometrie.add(this.itemPyth);
        this.mStatistik.add(this.itemAMittel);
        this.mStatistik.add(this.itemGMittel);
        this.mProzent.add(this.itemZins);
        this.mProzent.add(this.itemZinsZins);
        this.mSonst.add(this.itemBinom);
        this.mSonst.add(this.itemQuad);
        this.mm.add(this.mWinkel);
        this.mm.add(this.mFlaeche);
        this.mm.add(this.mVolumen);
        this.mm.add(this.mGeometrie);
        this.mm.add(this.mStatistik);
        this.mm.add(this.mProzent);
        this.mm.add(this.mSonst);
        this.mm.add(this.exit);
        this.mm.setListener(this);
    }

    public void splashFinished() {
        Spicker.quitApp();
    }

    public void keyPressed(int keyCode) {
        block16: {
            block15: {
                int action = this.getGameAction(keyCode);
                if (this.state != 1) break block15;
                switch (action) {
                    case 2: {
                        this.mm.left();
                        break;
                    }
                    case 5: {
                        this.mm.right();
                        break;
                    }
                    case 1: 
                    case 8: {
                        this.mm.select();
                        break;
                    }
                    case 6: {
                        if (this.mm.state == MainMenu.EBENE2) {
                            this.mm.state = MainMenu.EBENE1;
                            break;
                        }
                        break block16;
                    }
                    default: {
                        if (keyCode == -8) {
                            if (this.mm.state == MainMenu.EBENE2) {
                                this.mm.state = MainMenu.EBENE1;
                            }
                        }
                        if (keyCode == 42) {
                            this.prevState = this.state;
                            this.state = 4;
                            break;
                        }
                        break block16;
                    }
                }
                break block16;
            }
            if (this.state == 2) {
                if (keyCode == 42) {
                    this.prevState = this.state;
                    this.state = 4;
                } else {
                    this.state = 1;
                }
            } else if (this.state == 4) {
                this.state = this.prevState;
            }
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        g = this.startPaint(g);
        if (this.state == 2) {
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, Config.SCREEN_WIDTH, Config.SCREEN_HEIGHT);
            g.drawImage(this.bgImage, Config.SCREEN_WIDTH / 2, Config.SCREEN_HEIGHT / 2, 3);
            g.setColor(0);
            g.setFont(Config.TOP_FONT);
            g.drawString(this.mm.selectedSubMenu.text + "/" + this.mm.selectedSubMenu.m.getSelectedItem().text + "/", 0, 0, 20);
        } else if (this.state == 1 && this.titelImage != null) {
            g.drawImage(this.titelImage, 0, 0, 20);
            this.mm.paint(g);
        } else if (this.state == 3) {
            g.drawImage(this.titelImage, 0, 0, 20);
            g.setFont(Config.MENU_FONT);
            g.setColor(Config.COLOR_1);
            g.drawString("Loading", Config.SCREEN_WIDTH / 2, Config.SCREEN_HEIGHT / 2, 17);
        } else if (this.state == 4) {
            g.setColor(0);
            g.fillRect(0, 0, Config.SCREEN_WIDTH, Config.SCREEN_HEIGHT);
        }
        this.stopPaint(g);
    }

    public void run() {
    }

    public void select(MenuItem mi) {
        if (mi == this.exit) {
            this.titelImage = null;
            this.bgImage = null;
            this.back = null;
            this.exit = null;
            this.itemAMittel = null;
            this.itemBinom = null;
            this.itemCos = null;
            this.itemCoTan = null;
            this.itemDreieck = null;
            this.itemGMittel = null;
            this.mFlaeche = null;
            this.mGeometrie = null;
            this.mm = null;
            this.mProzent = null;
            this.mSonst = null;
            this.mVolumen = null;
            this.mWinkel = null;
            MainMenu.fi.largeImage = null;
            System.gc();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ix) {
                // empty catch block
            }
            try {
                SplashScreen sc = new SplashScreen(Image.createImage((String)"/splash.png"), 0xFF0000);
                sc.setListener(this);
                sc.display();
            }
            catch (IOException iox) {
                iox.printStackTrace();
                this.splashFinished();
            }
        } else {
            this.state = 3;
            this.repaint();
            this.serviceRepaints();
            String name = "";
            if (mi == this.itemSin) {
                name = "sin.png";
            } else if (mi == this.itemCos) {
                name = "cos.png";
            } else if (mi == this.itemTan) {
                name = "tan.png";
            } else if (mi == this.itemCoTan) {
                name = "cot.png";
            } else if (mi == this.itemKreis) {
                name = "kreis.png";
            } else if (mi == this.itemRechteck) {
                name = "rechteck.png";
            } else if (mi == this.itemTrapez) {
                name = "trapez.png";
            } else if (mi == this.itemParallel) {
                name = "parallel.png";
            } else if (mi == this.itemDreieck) {
                name = "dreieck.png";
            } else if (mi == this.itemKegel) {
                name = "kegel.png";
            } else if (mi == this.itemQuader) {
                name = "quader.png";
            } else if (mi == this.itemKugel) {
                name = "kugel.png";
            } else if (mi == this.itemZylinder) {
                name = "zylinder.png";
            } else if (mi == this.itemPyramide) {
                name = "pyra.png";
            } else if (mi == this.itemStrahl1) {
                name = "strahl1.png";
            } else if (mi == this.itemStrahl2) {
                name = "strahl2.png";
            } else if (mi == this.itemPyth) {
                name = "pyth.png";
            } else if (mi == this.itemAMittel) {
                name = "amittel.png";
            } else if (mi == this.itemGMittel) {
                name = "gmittel.png";
            } else if (mi == this.itemBinom) {
                name = "binom.png";
            } else if (mi == this.itemQuad) {
                name = "quad.png";
            } else if (mi == this.itemZins) {
                name = "zins.png";
            } else if (mi == this.itemZinsZins) {
                name = "zinszins.png";
            }
            try {
                this.bgImage = Image.createImage((String)("/" + name));
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
            this.state = 2;
        }
    }
}

