/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.CommandHandler;
import graph.MyDisplayable;
import graph.core.Settings;
import graph.lang.Phrases;
import graph.utils.Utils;
import java.io.IOException;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;

public class Explorer
extends List
implements CommandListener,
MyDisplayable {
    private static final char pathSeparationSign = '/';
    String currentPath = "";
    public static final String pathPreceding = "file:///";
    private FileConnection fcn;
    Command OpenDirectoryCommand = new Command(Phrases.select, 4, 1);
    Command ChooseDirCommand = new Command(Phrases.chooseDir, 1, 1);
    Command backCommand = new Command(Phrases.Back, 2, 1);
    private StringItem pathField;

    public Explorer(StringItem pathField) {
        super("", 3);
        try {
            this.pathField = pathField;
            this.ndsInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void ndsInit() throws Exception {
        this.setCommandListener(this);
        this.setSelectCommand(this.OpenDirectoryCommand);
        this.addCommand(this.backCommand);
        this.addCommand(this.ChooseDirCommand);
        this.showRoots();
    }

    public boolean showDirectory() {
        this.setTitle(this.currentPath);
        if (this.currentPath.length() == 0) {
            this.showRoots();
            return true;
        }
        return this.showCurrentPath();
    }

    private void showRoots() {
        this.deleteAll();
        Enumeration list = FileSystemRegistry.listRoots();
        while (list.hasMoreElements()) {
            String root = (String)list.nextElement();
            this.append(root, null);
        }
    }

    private boolean showCurrentPath() {
        try {
            boolean hasAtLeastOneElement = false;
            this.fcn = (FileConnection)Connector.open((String)(pathPreceding + this.currentPath), (int)1);
            this.deleteAll();
            Enumeration list = this.fcn.list();
            while (list.hasMoreElements()) {
                String listElement = (String)list.nextElement();
                if (listElement.charAt(listElement.length() - 1) != '/') continue;
                this.append(listElement, null);
                hasAtLeastOneElement = true;
            }
            return hasAtLeastOneElement;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.OpenDirectoryCommand) {
            this.openDir();
        } else if (command == this.ChooseDirCommand) {
            this.chooseDir();
        } else if (command == this.backCommand) {
            this.goBackToPreviousDir();
        }
    }

    private void openDir() {
        String selectedString = this.getString(this.getSelectedIndex());
        this.currentPath = String.valueOf(this.currentPath) + selectedString;
        boolean hasAtLeastOneElement = this.showDirectory();
        if (!hasAtLeastOneElement) {
            this.pathField.setText(this.currentPath);
            Settings.defaultPath = this.currentPath;
            CommandHandler.getInstance().goBack();
        }
    }

    private void chooseDir() {
        String selectedString = this.getString(this.getSelectedIndex());
        this.currentPath = String.valueOf(this.currentPath) + selectedString;
        this.pathField.setText(this.currentPath);
        Settings.defaultPath = this.currentPath;
        CommandHandler.getInstance().goBack();
    }

    private void goBackToPreviousDir() {
        int indexOfLastSepartation = Utils.minlaatste(this.currentPath).lastIndexOf(47);
        this.currentPath = this.currentPath.substring(0, indexOfLastSepartation + 1);
        this.showDirectory();
    }

    public void hide(Displayable nextDisplayable) {
    }

    public void show(Displayable previousDisplayable) {
    }
}

