/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.CalculateTable;
import graph.CommandHandler;
import graph.GraphCanvas;
import graph.MyDisplayable;
import graph.SettingsForm;
import graph.core.CriticalPoint;
import graph.core.ProgressBar;
import graph.core.Settings;
import graph.lang.Phrases;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;

public class GraphTable
extends Form
implements CommandListener,
MyDisplayable {
    Command settingsCommand = new Command(Phrases.Settings, 1, 10);
    StringItem table = new StringItem("", Phrases.Table, 0);
    StringItem note = new StringItem(Phrases.note, "", 0);

    public GraphTable() {
        super("");
        try {
            this.ndsInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void ndsInit() throws Exception {
        this.setCommandListener(this);
        this.addCommand(CommandHandler.getGlobalBackCommand());
        this.addCommand(this.settingsCommand);
        this.setTitle(Phrases.graphtableTitle);
        this.append((Item)this.table);
        this.append((Item)this.note);
        Font font = Settings.getDefaultFont();
        if (font != null) {
            this.table.setFont(font);
            this.note.setFont(font);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.settingsCommand) {
            CommandHandler.getInstance().setCurrentDisplayable((Displayable)new SettingsForm());
        } else {
            CommandHandler.getInstance().handleCommand(command);
        }
    }

    public void setCriticalPoints(Vector criticalPoints, ProgressBar progressBar) {
        StringBuffer tableText = new StringBuffer();
        if (progressBar != null) {
            progressBar.setMaxValue(criticalPoints.size());
        }
        Enumeration enumeration = criticalPoints.elements();
        while (enumeration.hasMoreElements()) {
            CriticalPoint point = (CriticalPoint)enumeration.nextElement();
            tableText.append(Phrases.functionF);
            tableText.append(point.getEqnNumberString());
            tableText.append("(");
            tableText.append(point.getX());
            tableText.append(", ");
            tableText.append(point.getY());
            tableText.append(")");
            if (point.getDescription() != null && point.getDescription().length() > 0) {
                tableText.append(":\n\t" + point.getDescription());
            }
            tableText.append("\n");
            if (progressBar == null) continue;
            progressBar.incrementValue();
        }
        this.table.setText(tableText.toString());
        this.note.setText(String.valueOf(Phrases.CalculatedUpTo) + " " + Settings.getNbDecimals() + " " + Phrases.decimals + ".\n" + Phrases.settingsReference);
    }

    public void show(Displayable previousDisplayable) {
        if (previousDisplayable instanceof SettingsForm) {
            new Thread(new CalculateTable(GraphCanvas.plotter, new GraphTable())).start();
        }
    }

    public void hide(Displayable nextDisplayable) {
    }
}

