/*
 * Decompiled with CFR 0.152.
 */
package graph.eqn;

import graph.core.CalculateException;
import graph.core.Settings;
import graph.eqn.Difference;
import graph.eqn.Expression;
import graph.eqn.Number;
import graph.eqn.Sinus;
import graph.eqn.UnaryExpression;
import graph.eqn.X;
import graph.utils.Utils;

public class ArcSinus
extends UnaryExpression {
    private Number number = new Number(0.0);
    private Expression sinEqn = new Difference(new Sinus(new X()), this.number);

    public ArcSinus(Expression eqn) {
        super(eqn);
    }

    public double getValue(double xValue, double yValue) {
        try {
            double s = this.expr1.getValue(xValue, yValue);
            if (s < -1.0 || s > 1.0) {
                return Double.NaN;
            }
            if (s == -1.0) {
                return -1.5707963267948966;
            }
            if (s == 1.0) {
                return 1.5707963267948966;
            }
            this.number.setNumber(s);
            int nbDecimals = Settings.getNbDecimals();
            double x = Utils.getNullpoint(this.sinEqn, -1.5707963267948966, 1.5707963267948966, Utils.pow(0.1, nbDecimals));
            return x;
        }
        catch (CalculateException e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    public String getFunctionAsString() {
        return "asin(" + this.expr1.getFunctionAsString() + ")";
    }
}

