/*
 * Decompiled with CFR 0.152.
 */
package graph.eqn;

import graph.core.Settings;
import graph.eqn.Equation;
import graph.eqn.Expression;
import graph.utils.Utils;

public class SecondDerivate
extends Expression {
    private Equation eqn;

    public SecondDerivate(Equation eqn) {
        this.eqn = eqn;
    }

    public double getFunctionValue(double xValue) {
        double DELTA = Utils.pow(2.0, -Settings.DELTA);
        double y1 = this.eqn.getFunctionValue(xValue - DELTA);
        double y2 = this.eqn.getFunctionValue(xValue);
        double y3 = this.eqn.getFunctionValue(xValue + DELTA);
        double deltaY1 = y2 - y1;
        double deltaY2 = y3 - y2;
        return (deltaY2 - deltaY1) / (DELTA * DELTA);
    }

    public double getValue(double xValue, double yValue) {
        return this.getFunctionValue(xValue);
    }

    public String getFunctionAsString() {
        return "D(D(" + this.eqn.getFunctionAsString() + "))";
    }
}

