/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.CommandHandler;
import graph.MyDisplayable;
import graph.core.ProgressBar;
import graph.lang.Phrases;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Gauge;

public class ProgressBarAlert
implements ProgressBar,
CommandListener,
MyDisplayable {
    protected Alert alert;
    protected String message;
    protected Gauge gauge;
    protected Displayable displayable;
    protected ProgressBar.InvokeAble endTask;
    boolean cancelable;
    ProgressBar.InvokeAble cancelAction;
    public static final Command cancelCommand = new Command(Phrases.Cancel, 3, 0);

    public ProgressBarAlert(String title, String message, int maxValue, ProgressBar.InvokeAble endTask) {
        this.message = message;
        this.alert = new Alert(title, message, null, null);
        this.alert.setTimeout(-2);
        this.gauge = maxValue <= 0 ? new Gauge(null, false, -1, 2) : new Gauge(null, false, maxValue, 0);
        this.alert.setIndicator(this.gauge);
        this.alert.removeCommand(Alert.DISMISS_COMMAND);
        this.alert.setCommandListener((CommandListener)this);
        this.displayable = CommandHandler.getInstance().getCurrentDisplayable();
        this.endTask = endTask;
    }

    public void setMaxValue(int maxValue) {
        this.gauge.setMaxValue(maxValue);
    }

    public void setValue(int value) {
        this.gauge.setValue(value);
        this.updateAlertText();
    }

    public void incrementValue() {
        this.gauge.setValue(this.gauge.getValue() + 1);
        this.updateAlertText();
    }

    private void updateAlertText() {
        int newValue = this.gauge.getValue();
        int maxValue = this.gauge.getMaxValue();
        int percentage = newValue * 100 / maxValue;
        this.alert.setString(String.valueOf(this.message) + " (" + percentage + "%)");
    }

    public void show(Displayable previousDisplayable) {
        this.displayable = CommandHandler.getInstance().getCurrentDisplayable();
        CommandHandler.getInstance().setCurrentAlert(this.alert, this.displayable);
    }

    public void taskEnded() {
        if (this.endTask != null) {
            this.endTask.invoke();
        } else {
            CommandHandler.getInstance().setCurrentDisplayable(this.displayable);
        }
    }

    public void setCancellable(boolean cancelable, ProgressBar.InvokeAble cancelAction) {
        this.cancelable = cancelable;
        if (cancelable) {
            this.cancelAction = cancelAction;
            this.alert.addCommand(cancelCommand);
        } else {
            this.cancelAction = null;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == cancelCommand || command == Alert.DISMISS_COMMAND) {
            this.taskCanceled(displayable);
        }
    }

    public void taskCanceled(Displayable displayable) {
        if (this.cancelAction != null) {
            this.cancelAction.invoke();
        } else {
            CommandHandler.getInstance().setCurrentDisplayable(displayable);
        }
    }

    public void taskException(Exception e) {
        CommandHandler.getInstance().alertException(e);
    }

    public void hide(Displayable nextDisplayable) {
    }
}

