/*
 * Decompiled with CFR 0.152.
 */
package graph.core;

import graph.lang.Chinese;
import graph.lang.Czech;
import graph.lang.Dutch;
import graph.lang.English;
import graph.lang.French;
import graph.lang.German;
import graph.lang.Hungarian;
import graph.lang.Italian;
import graph.lang.Language;
import graph.lang.Latvian;
import graph.lang.Polish;
import graph.lang.PortugueseBR;
import graph.lang.Spanish;
import graph.utils.DebugTools;
import graph.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public class Settings {
    public static String versionNumber = "1.0.9";
    public static String copyrightDate = "02-2009";
    public static boolean isChanged = false;
    public static boolean debug = false;
    public static final String RECORD_STORE_SETTINGS = "Settings";
    public static int saveImageWidth = 120;
    public static int saveImageHeight = 160;
    public static String defaultPath = "";
    public static boolean BLACK_BACKGROUND = true;
    public static boolean FULLSCREEN = false;
    public static boolean SHOW_GRID = true;
    public static boolean SHOW_GRID_NUMBERS = true;
    public static boolean SHOW_AXIS = true;
    public static boolean SHOW_AXIS_NUMBERS = true;
    public static int[] fontSizeArray;
    public static int fontsizeIndex;
    public static int NB_REDRAWING_STEPS;
    public static boolean PRECISION_DERIVATE;
    public static boolean CALCULATE_CRITICAL_POINTS;
    public static int DELTA;
    public static int NB_DECIMALS;
    public static final int NbDecimalsMaxPrecision = 12;
    public static int internalPrecision;
    public static boolean maxPrecision;
    public static boolean doRound;
    static final int MAX_DEPTH = 100;
    static final int MIN_DEPTH = 10;
    public static Language[] languages;
    public static Language defaultLanguage;
    protected static int currentLanguageIndex;

    static {
        int[] nArray = new int[3];
        nArray[0] = 8;
        nArray[2] = 16;
        fontSizeArray = nArray;
        fontsizeIndex = 1;
        NB_REDRAWING_STEPS = 3;
        PRECISION_DERIVATE = false;
        CALCULATE_CRITICAL_POINTS = true;
        DELTA = 3;
        NB_DECIMALS = 4;
        internalPrecision = 10;
        doRound = false;
        languages = new Language[]{new English(), new Chinese(), new Czech(), new Dutch(), new French(), new German(), new Hungarian(), new Italian(), new Latvian(), new Polish(), new PortugueseBR(), new Spanish()};
        defaultLanguage = new English();
    }

    private static int getFontsize() {
        return fontSizeArray[fontsizeIndex];
    }

    public static Font getDefaultFont() {
        if (debug) {
            return null;
        }
        return Font.getFont((int)0, (int)0, (int)Settings.getFontsize());
    }

    public static final int getNbDecimals() {
        if (maxPrecision) {
            return 12;
        }
        return NB_DECIMALS;
    }

    public static int getInternalPrecision() {
        return internalPrecision;
    }

    public static void setInternalPrecision(int precision) {
        internalPrecision = precision;
    }

    public static final void setMaxPrecision(boolean newMaxPrecision) {
        maxPrecision = newMaxPrecision;
    }

    public static final int getMaxDepth() {
        if (maxPrecision) {
            return 100;
        }
        return internalPrecision * 90 / 100 + 10;
    }

    public static void setCurrentLanguage(int newLanguageIndex) {
        currentLanguageIndex = newLanguageIndex;
        defaultLanguage.initLanguage();
        languages[newLanguageIndex].initLanguage();
    }

    public static Language getCurrentLanguage() {
        return languages[currentLanguageIndex];
    }

    public static int getCurrentLanguageIndex() {
        return currentLanguageIndex;
    }

    public static void saveSettings() {
        if (isChanged) {
            RecordStore store = null;
            try {
                try {
                    store = RecordStore.openRecordStore((String)RECORD_STORE_SETTINGS, (boolean)true, (int)0, (boolean)true);
                    RecordEnumeration records = store.enumerateRecords(null, null, false);
                    if (records.hasNextElement()) {
                        int id = records.nextRecordId();
                        store.deleteRecord(id);
                    }
                    byte[] bytes = Settings.getSettings();
                    store.addRecord(bytes, 0, bytes.length);
                }
                catch (RecordStoreNotFoundException e) {
                    System.out.println("Warning: no settings saved yet.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                try {
                    if (store != null) {
                        store.closeRecordStore();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean loadSettings() {
        block14: {
            Settings.setCurrentLanguage(0);
            RecordStore store = null;
            try {
                store = RecordStore.openRecordStore((String)RECORD_STORE_SETTINGS, (boolean)false, (int)0, (boolean)false);
                RecordEnumeration records = store.enumerateRecords(null, null, false);
                if (!records.hasNextElement()) break block14;
                byte[] record = records.nextRecord();
                Settings.setSettings(record);
                return true;
            }
            catch (RecordStoreNotFoundException e) {
                System.out.println("Warning: no saved settings found.");
            }
            catch (Exception e) {
                DebugTools.printToScreen("!!! Error while loading settings !!!", null);
                e.printStackTrace();
            }
            finally {
                try {
                    if (store != null) {
                        store.closeRecordStore();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private static void setSettings(byte[] record) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(record);
        DataInputStream dataIn = new DataInputStream(in);
        String version = Utils.readString(dataIn);
        if (version.equals(versionNumber)) {
            BLACK_BACKGROUND = dataIn.readBoolean();
            FULLSCREEN = dataIn.readBoolean();
            SHOW_GRID = dataIn.readBoolean();
            SHOW_GRID_NUMBERS = dataIn.readBoolean();
            SHOW_AXIS = dataIn.readBoolean();
            SHOW_AXIS_NUMBERS = dataIn.readBoolean();
            fontsizeIndex = dataIn.readInt();
            PRECISION_DERIVATE = dataIn.readBoolean();
            CALCULATE_CRITICAL_POINTS = dataIn.readBoolean();
            NB_DECIMALS = dataIn.readInt();
            NB_REDRAWING_STEPS = dataIn.readInt();
            saveImageWidth = dataIn.readInt();
            saveImageHeight = dataIn.readInt();
            defaultPath = Utils.readString(dataIn);
            int newLanguageIndex = dataIn.readInt();
            if (newLanguageIndex != Settings.getCurrentLanguageIndex()) {
                Settings.setCurrentLanguage(newLanguageIndex);
            }
        }
        dataIn.close();
        in.close();
    }

    private static byte[] getSettings() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(out);
        Utils.writeString(dataOut, versionNumber);
        dataOut.writeBoolean(BLACK_BACKGROUND);
        dataOut.writeBoolean(FULLSCREEN);
        dataOut.writeBoolean(SHOW_GRID);
        dataOut.writeBoolean(SHOW_GRID_NUMBERS);
        dataOut.writeBoolean(SHOW_AXIS);
        dataOut.writeBoolean(SHOW_AXIS_NUMBERS);
        dataOut.writeInt(fontsizeIndex);
        dataOut.writeBoolean(PRECISION_DERIVATE);
        dataOut.writeBoolean(CALCULATE_CRITICAL_POINTS);
        dataOut.writeInt(NB_DECIMALS);
        dataOut.writeInt(NB_REDRAWING_STEPS);
        dataOut.writeInt(saveImageWidth);
        dataOut.writeInt(saveImageHeight);
        Utils.writeString(dataOut, defaultPath);
        dataOut.writeInt(Settings.getCurrentLanguageIndex());
        byte[] result = out.toByteArray();
        dataOut.close();
        out.close();
        return result;
    }
}

