/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

final class LerpSprite {
    public static int touchMe = 1;
    public ScriptThread thread;
    public int travelTime;
    public int startTime;
    public int hSprite;
    public int srcX;
    public int srcY;
    public int srcZ;
    public int dstX;
    public int dstY;
    public int dstZ;
    public int height;
    public int dist;
    public int srcScale;
    public int dstScale;
    public int flags;

    LerpSprite() {
    }

    public void saveState(DataOutputStream dataOutputStream) throws IOException {
        if (this.hSprite == 0) {
            return;
        }
        dataOutputStream.writeInt(this.travelTime);
        dataOutputStream.writeInt(App.gameTime - this.startTime);
        dataOutputStream.writeShort(this.hSprite);
        dataOutputStream.writeShort(Render.mapSprites[Render.S_X + this.hSprite - 1]);
        dataOutputStream.writeShort(Render.mapSprites[Render.S_Y + this.hSprite - 1]);
        dataOutputStream.writeShort(Render.mapSprites[Render.S_Z + this.hSprite - 1]);
        dataOutputStream.writeShort(this.srcX);
        dataOutputStream.writeShort(this.srcY);
        dataOutputStream.writeShort(this.srcZ);
        dataOutputStream.writeShort(this.dstX);
        dataOutputStream.writeShort(this.dstY);
        dataOutputStream.writeShort(this.dstZ);
        dataOutputStream.writeShort(this.height);
        dataOutputStream.writeByte(this.srcScale);
        dataOutputStream.writeByte(this.dstScale);
        dataOutputStream.writeShort(this.flags);
        if (this.thread != null) {
            dataOutputStream.writeByte(this.thread.getIndex());
        } else {
            dataOutputStream.writeByte(-1);
        }
    }

    public void calcDist() {
        int n = (this.dstX - this.srcX) * (this.dstX - this.srcX) + (this.dstY - this.srcY) * (this.dstY - this.srcY);
        this.dist = (int)(Game.FixedSqrt(n << 8) >> 8);
    }

    public void loadState(DataInputStream dataInputStream) throws IOException {
        this.travelTime = dataInputStream.readInt();
        this.startTime = App.gameTime - dataInputStream.readInt();
        this.hSprite = dataInputStream.readShort();
        int n = this.hSprite - 1;
        Render.mapSprites[Render.S_X + n] = dataInputStream.readShort();
        Render.mapSprites[Render.S_Y + n] = dataInputStream.readShort();
        Render.mapSprites[Render.S_Z + n] = dataInputStream.readShort();
        Render.relinkSprite(n);
        this.srcX = dataInputStream.readShort();
        this.srcY = dataInputStream.readShort();
        this.srcZ = dataInputStream.readShort();
        this.dstX = dataInputStream.readShort();
        this.dstY = dataInputStream.readShort();
        this.dstZ = dataInputStream.readShort();
        this.height = dataInputStream.readShort();
        this.srcScale = dataInputStream.readByte();
        this.dstScale = dataInputStream.readByte();
        this.flags = dataInputStream.readShort();
        byte by = dataInputStream.readByte();
        this.thread = by == -1 ? null : Game.scriptThreads[by];
        this.calcDist();
    }
}

