/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Image;

final class ScriptThread {
    public static int touchMe = 1;
    public static final int MAX_SCRIPT_THREADS = 20;
    public static final int MAX_STACK_SIZE = 16;
    public static final int DEFAULT_TIME_SCALE = 100;
    public int unpauseTime;
    public int state = 2;
    public boolean inuse = false;
    public int IP = 0;
    public int FP = 0;
    public int flags;
    public int type;
    public boolean throwAwayLoot;
    private int[] scriptStack = new int[16];
    public int stackPtr = 0;
    private Text debugString = null;
    public static int lootSource = -1;

    public void saveState(DataOutputStream dataOutputStream) throws IOException {
        if (this.unpauseTime == -1 || this.unpauseTime == 0) {
            dataOutputStream.writeInt(this.unpauseTime);
        } else {
            dataOutputStream.writeInt(this.unpauseTime - App.gameTime);
        }
        dataOutputStream.writeByte(this.state);
        dataOutputStream.writeInt(this.IP);
        dataOutputStream.writeInt(this.FP);
        for (int i = 0; i < this.FP; ++i) {
            dataOutputStream.writeInt(this.scriptStack[i]);
        }
    }

    public void loadState(DataInputStream dataInputStream) throws IOException {
        this.init();
        this.unpauseTime = dataInputStream.readInt();
        if (this.unpauseTime != 0 && this.unpauseTime != -1) {
            this.unpauseTime += App.gameTime;
        }
        this.state = dataInputStream.readByte();
        this.IP = dataInputStream.readInt();
        this.FP = dataInputStream.readInt();
        for (int i = 0; i < this.FP; ++i) {
            this.scriptStack[i] = dataInputStream.readInt();
        }
    }

    public int executeTile(int n, int n2, int n3, boolean bl) {
        if (n < 0 || n >= 32 || n2 < 0 || n2 >= 32) {
            this.state = 0;
            return 0;
        }
        Game.skipAdvanceTurn = false;
        int n4 = n2 * 32 + n;
        if ((Render.mapFlags[n4] & 0x40) != 0) {
            int n5 = Render.findEventIndex(n4);
            int n6 = 0;
            while (n5 != -1) {
                int n7 = Render.tileEvents[n5 + 1];
                int n8 = n7 & n3;
                if ((n7 & 0x80000) == 0 && (n8 & 0xF) != 0 && (n8 & 0xFF0) != 0 && ((n7 & 0x7000) == 0 && (n3 & 0x7000) == 0 || (n8 & 0x7000) != 0)) {
                    if ((n7 & 0x40000) != 0) {
                        Game.skipAdvanceTurn = true;
                        Game.queueAdvanceTurn = false;
                    }
                    this.alloc(n5, n3, bl);
                    n6 = this.run();
                }
                n5 = Render.getNextEventIndex();
            }
            return n6;
        }
        this.state = 0;
        return 0;
    }

    int queueTile(int n, int n2, int n3) {
        return this.queueTile(n, n2, n3, false);
    }

    int queueTile(int n, int n2, int n3, boolean bl) {
        if (n < 0 || n >= 32 || n2 < 0 || n2 >= 32) {
            this.state = 0;
            return 0;
        }
        Game.skipAdvanceTurn = false;
        int n4 = n2 * 32 + n;
        if ((Render.mapFlags[n4] & 0x40) != 0) {
            int n5 = Render.findEventIndex(n4);
            while (n5 != -1) {
                int n6 = Render.tileEvents[n5 + 1];
                int n7 = n6 & n3;
                if ((n6 & 0x80000) == 0 && (n7 & 0xF) != 0 && (n7 & 0xFF0) != 0 && ((n6 & 0x7000) == 0 && (n3 & 0x7000) == 0 || (n7 & 0x7000) != 0)) {
                    if ((n6 & 0x40000) != 0) {
                        Game.skipAdvanceTurn = true;
                        Game.queueAdvanceTurn = false;
                    }
                    this.alloc(n5, n3, bl);
                    this.flags |= 2;
                    return 2;
                }
                n5 = Render.getNextEventIndex();
            }
        }
        this.state = 0;
        return this.state;
    }

    private int evWait(int n) {
        if (Game.skippingCinematic) {
            return 1;
        }
        this.unpauseTime = App.gameTime + n;
        if ((this.flags & 1) != 0) {
            if (Canvas.state != 18) {
                Canvas.blockInputTime = this.unpauseTime;
            }
            if (Canvas.state == 6 || Canvas.state == 1) {
                Canvas.setState(3);
            }
            if (Canvas.state == 3) {
                Canvas.clearSoftKeys();
            }
        }
        return 2;
    }

    private boolean evReturn() {
        while (this.FP < this.stackPtr - 2) {
            this.pop();
        }
        this.FP = this.pop();
        int n = this.pop();
        if (n == -1) {
            if (this.stackPtr != 0) {
                App.Error(new Exception("The frame pointer should be zero if the script has completed."), 102);
            }
            return true;
        }
        this.IP = n;
        return false;
    }

    private void alloc(int n, int n2, boolean bl) {
        this.IP = (Render.tileEvents[n] & 0xFFFF0000) >> 16;
        this.FP = 0;
        this.stackPtr = 0;
        this.push(-1);
        this.push(0);
        this.type = n2;
        this.flags = 0;
        if (bl) {
            this.flags = 1;
        }
    }

    public void alloc(int n) {
        this.IP = n;
        this.FP = 0;
        this.stackPtr = 0;
        this.push(-1);
        this.push(0);
        this.type = 0;
        this.flags = 1;
    }

    private final int peekNextCmd() {
        return Render.mapByteCode[this.IP + 1];
    }

    public static void setupCamera(int n) {
        Game.cinUnpauseTime = App.gameTime + 1000;
        Game.activeCameraView = true;
        MayaCamera mayaCamera = Game.mayaCameras[n];
        Game.activeCameraKey = -1;
        Game.activeCamera = mayaCamera;
        mayaCamera.complete = false;
        Game.activeCameraTime = App.gameTime;
        Game.camPlayerX = Canvas.destX << 0;
        Game.camPlayerY = Canvas.destY << 0;
        Game.camPlayerZ = Canvas.destZ << 0;
        Game.camPlayerYaw = Canvas.destAngle & 0x3FF;
        Game.camPlayerPitch = Canvas.viewPitch;
        mayaCamera.x = Game.mayaCameraKeys[Game.OFS_MAYAKEY_X + mayaCamera.keyOffset];
        if (mayaCamera.x == -2) {
            mayaCamera.x = Game.camPlayerX;
        }
        mayaCamera.y = Game.mayaCameraKeys[Game.OFS_MAYAKEY_Y + mayaCamera.keyOffset];
        if (mayaCamera.y == -2) {
            mayaCamera.y = Game.camPlayerY;
        }
        mayaCamera.z = Game.mayaCameraKeys[Game.OFS_MAYAKEY_Z + mayaCamera.keyOffset];
        if (mayaCamera.z == -2) {
            mayaCamera.z = Game.camPlayerZ;
        }
        mayaCamera.x <<= 4;
        mayaCamera.y <<= 4;
        mayaCamera.z <<= 4;
        mayaCamera.pitch = Game.mayaCameraKeys[Game.OFS_MAYAKEY_PITCH + mayaCamera.keyOffset];
        if (mayaCamera.pitch == -2) {
            mayaCamera.pitch = Game.camPlayerPitch;
        }
        mayaCamera.yaw = Game.mayaCameraKeys[Game.OFS_MAYAKEY_YAW + mayaCamera.keyOffset];
        if (mayaCamera.yaw == -2) {
            mayaCamera.yaw = Game.camPlayerYaw;
        }
        mayaCamera.roll = Game.mayaCameraKeys[Game.OFS_MAYAKEY_ROLL + mayaCamera.keyOffset];
    }

    public int run() {
        Game.updateScriptVars();
        if (this.stackPtr == 0) {
            return 1;
        }
        int n = 1;
        int n2 = 0;
        boolean bl = true;
        byte[] byArray = Render.mapByteCode;
        while (this.IP < Render.mapByteCodeSize && n != 2) {
            bl = true;
            n2 = 0;
            switch (byArray[this.IP]) {
                case 0: {
                    int n3;
                    short s = this.getByteArg();
                    bl = false;
                    while ((s = (short)(s - 1)) >= 0) {
                        int n4;
                        n3 = this.getUByteArg();
                        if ((n3 & 0x80) != 0) {
                            n4 = n3 & 0x7F;
                            this.push(Game.scriptStateVars[n4]);
                            continue;
                        }
                        if ((n3 & 0x40) != 0) {
                            n3 = (n3 & 0x3F) << 8;
                            n3 |= this.getUByteArg();
                            n3 = n3 << 18 >> 18;
                            this.push(n3);
                            continue;
                        }
                        switch (n3) {
                            case 0: {
                                this.push(this.pop() == 1 && this.pop() == 1);
                                break;
                            }
                            case 1: {
                                this.push(this.pop() == 1 || this.pop() == 1);
                                break;
                            }
                            case 3: {
                                n4 = this.pop();
                                int n5 = this.pop();
                                this.push(n5 < n4);
                                break;
                            }
                            case 2: {
                                n4 = this.pop();
                                int n5 = this.pop();
                                this.push(n5 <= n4);
                                break;
                            }
                            case 4: {
                                this.push(this.pop() == this.pop());
                                break;
                            }
                            case 5: {
                                this.push(this.pop() != this.pop());
                                break;
                            }
                            case 6: {
                                n4 = this.pop();
                                if (n4 == 0) {
                                    this.push(1);
                                    break;
                                }
                                this.push(0);
                                break;
                            }
                        }
                    }
                    n3 = this.getUByteArg();
                    if (this.pop() != 0) break;
                    this.IP += n3;
                    break;
                }
                case 1: {
                    bl = false;
                    int n6 = this.getUShortArg();
                    this.IP += n6;
                    break;
                }
                case 2: {
                    if (!this.evReturn()) break;
                    return 1;
                }
                case 3: {
                    int n7 = this.getUShortArg();
                    short s = (short)(n7 & Short.MAX_VALUE);
                    int n8 = (n7 & 0x8000) >> 15;
                    if (n8 == 1) {
                        Hud.addMessage(Canvas.loadMapStringID, s, 3);
                        break;
                    }
                    if (Canvas.state == 18) {
                        Hud.msgCount = 0;
                    }
                    Hud.addMessage(Canvas.loadMapStringID, s);
                    break;
                }
                case 4: {
                    int n9 = this.getUByteArg();
                    n9 |= this.getUByteArg() << 8;
                    int n10 = (n9 |= this.getUByteArg() << 16) >> 14 & 0xFF;
                    int n11 = n9 >> 9 & 0x1F;
                    int n12 = n9 >> 4 & 0x1F;
                    int n13 = n9 & 0xF;
                    int n14 = (n13 & 8) == 0 ? this.getUByteArg() - 48 : 32;
                    int n15 = (n13 & 4) == 0 ? this.getUByteArg() * 100 : 0;
                    if (n15 != 0 && (n13 & 2) != 0) {
                        this.evWait(n15);
                    }
                    boolean bl2 = (n13 & 1) != 0;
                    LerpSprite lerpSprite = Game.allocLerpSprite(this, n10, (n13 & 2) != 0);
                    if (lerpSprite == null) {
                        return 0;
                    }
                    lerpSprite.dstX = 32 + (n11 << 6);
                    lerpSprite.dstY = 32 + (n12 << 6);
                    short s44 = Render.mapSprites[Render.S_ENT + n10];
                    if (s44 != -1) {
                        Game.entities[s44].info |= 0x400000;
                        if (Game.entities[s44].monster != null) {
                            Game.entities[s44].monster.flags = (short)(Game.entities[s44].monster.flags | 0x4000);
                        }
                    }
                    lerpSprite.dstZ = Render.getHeight(lerpSprite.dstX, lerpSprite.dstY) + n14;
                    lerpSprite.srcX = Render.mapSprites[Render.S_X + n10];
                    lerpSprite.srcY = Render.mapSprites[Render.S_Y + n10];
                    lerpSprite.srcZ = Render.mapSprites[Render.S_Z + n10];
                    lerpSprite.srcScale = lerpSprite.dstScale = Render.mapSprites[Render.S_SCALEFACTOR + n10];
                    lerpSprite.startTime = App.gameTime;
                    lerpSprite.travelTime = n15;
                    lerpSprite.flags = n13 & 3;
                    lerpSprite.calcDist();
                    if (n15 == 0) {
                        if ((Game.updateLerpSprite(lerpSprite) & 1) != 0) {
                            Canvas.invalidateRect();
                            break;
                        }
                        n = 0;
                        break;
                    }
                    if (bl2) break;
                    Game.skipAdvanceTurn = true;
                    Game.queueAdvanceTurn = false;
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 59: {
                    short s = this.getUByteArg();
                    int n16 = this.getUByteArg() * 100;
                    int n17 = this.getIntArg();
                    int n18 = n17 & 0x7FF;
                    int n19 = n17 >> 11 & 0x7FF;
                    int n20 = n17 >> 22 & 3;
                    int n21 = (n17 >> 24 & 0xFF) - 48;
                    LerpSprite lerpSprite = Game.allocLerpSprite(this, s, (n20 & 2) != 0);
                    if (lerpSprite == null) {
                        return 0;
                    }
                    lerpSprite.dstX = n19;
                    lerpSprite.dstY = n18;
                    short s2 = Render.mapSprites[Render.S_ENT + s];
                    if (s2 != -1) {
                        Game.entities[s2].info |= 0x400000;
                        if (Game.entities[s2].monster != null) {
                            Game.entities[s2].monster.flags = (short)(Game.entities[s2].monster.flags | 0x4000);
                        }
                    }
                    lerpSprite.dstZ = Render.getHeight(lerpSprite.dstX, lerpSprite.dstY) + n21;
                    lerpSprite.srcX = Render.mapSprites[Render.S_X + s];
                    lerpSprite.srcY = Render.mapSprites[Render.S_Y + s];
                    lerpSprite.srcZ = Render.mapSprites[Render.S_Z + s];
                    lerpSprite.srcScale = lerpSprite.dstScale = Render.mapSprites[Render.S_SCALEFACTOR + s];
                    lerpSprite.startTime = App.gameTime;
                    lerpSprite.travelTime = n16;
                    lerpSprite.calcDist();
                    lerpSprite.flags = n20 & 3;
                    if (n16 == 0) {
                        if ((Game.updateLerpSprite(lerpSprite) & 1) != 0) {
                            Canvas.invalidateRect();
                            break;
                        }
                        n = 0;
                        break;
                    }
                    if (n16 != 0 && (n20 & 2) != 0) {
                        this.evWait(n16);
                    }
                    if ((lerpSprite.flags & 1) != 0) break;
                    Game.skipAdvanceTurn = true;
                    Game.queueAdvanceTurn = false;
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 5: {
                    byte by = this.getByteArg();
                    ScriptThread.forceRemoveFromScopeZoom();
                    ScriptThread.setupCamera(by);
                    Game.activeCamera.cameraThread = this;
                    if (Canvas.state != 1 && Canvas.state != 18) {
                        Canvas.setState(18);
                    }
                    Game.skipAdvanceTurn = true;
                    Game.queueAdvanceTurn = false;
                    break;
                }
                case 6: {
                    short s;
                    short s3 = this.getByteArg();
                    Game.scriptStateVars[s3] = s = this.getShortArg();
                    break;
                }
                case 26: {
                    short s;
                    short s4 = s = (short)this.getByteArg();
                    Game.scriptStateVars[s4] = (short)(Game.scriptStateVars[s4] - 1);
                    break;
                }
                case 27: {
                    short s;
                    short s5 = s = (short)this.getByteArg();
                    Game.scriptStateVars[s5] = (short)(Game.scriptStateVars[s5] + 1);
                    break;
                }
                case 7: {
                    int n22 = this.getUShortArg();
                    int n23 = this.FP;
                    this.FP = this.stackPtr;
                    this.push(this.IP);
                    this.push(n23);
                    this.IP = n22 - 1;
                    break;
                }
                case 8: {
                    int n24 = this.getUShortArg();
                    int n25 = n24 & 0x1F;
                    int n26 = (n24 & 0x3E0) >> 5;
                    short s = 0;
                    byte by = this.getByteArg();
                    if (n25 == 0) {
                        s = Player.inventory[n26];
                    } else if (n25 == 1) {
                        if ((Player.weapons & 1 << n26) != 0) {
                            s = 1;
                        }
                    } else if (n25 == 2) {
                        s = Player.ammo[n26];
                    }
                    Game.scriptStateVars[by] = s;
                    break;
                }
                case 9: {
                    int n27 = this.getUShortArg();
                    int n28 = n27 & 0x1F;
                    int n29 = n27 >> 5 & 0x1F;
                    byte by = this.getByteArg();
                    short s = 1;
                    Entity entity = Game.entityDb[n28 + 32 * n29];
                    if (entity != null) {
                        while (entity != null) {
                            if (entity.def.eType != 12 && (1 << entity.def.eType & 0x6240) == 0) {
                                s = 0;
                                break;
                            }
                            entity = entity.nextOnTile;
                        }
                    }
                    Game.scriptStateVars[by] = s;
                    break;
                }
                case 10: {
                    byte by = this.getByteArg();
                    Game.scriptStateVars[by & 0x7F] = (short)Player.ce.weapon;
                    break;
                }
                case 11: {
                    short s = this.getUByteArg();
                    int n30 = this.getUShortArg();
                    boolean bl3 = true;
                    short s6 = (short)(Canvas.loadMapID - 1);
                    Player.completedLevels |= 1 << s6;
                    Game.spawnParam = (s >> 4 & 7) << 10 | n30 & 0x3FF;
                    MenuSystem.LEVEL_STATS_nextMap = (short)(s & 0xF);
                    if (MenuSystem.LEVEL_STATS_nextMap < Canvas.loadMapID) {
                        bl3 = false;
                    }
                    Game.snapAllMovers();
                    if ((s & 0x80) != 0) {
                        int n31 = 1;
                        n31 = bl3 ? (n31 |= 8) : (n31 |= 4);
                        if (Canvas.state == 6) {
                            Canvas.setState(3);
                        }
                        Render.startFade(1000, n31);
                    } else if (bl3) {
                        Canvas.saveState(51, (short)3, (short)194);
                    } else {
                        Canvas.loadMap(MenuSystem.LEVEL_STATS_nextMap, false, false);
                    }
                    Canvas.changeMapStarted = true;
                    break;
                }
                case 12: {
                    int n32 = this.getUShortArg();
                    int n33 = this.getUShortArg();
                    if (Game.skippingCinematic) break;
                    short s = (short)(n32 & 0x3FFF);
                    int n34 = (n32 & 0x8000) >> 15;
                    boolean bl4 = Hud.showCinPlayer = (n32 & 0x4000) != 0;
                    if (n34 == 1) {
                        Hud.showCinPlayer = false;
                    }
                    if (n34 == 0) {
                        Hud.subTitleID = Text.STRINGID(Canvas.loadMapStringID, s);
                        Hud.subTitleTime = App.gameTime + n33;
                    } else {
                        Hud.cinTitleID = Text.STRINGID(Canvas.loadMapStringID, s);
                        Hud.cinTitleTime = App.gameTime + n33;
                    }
                    Canvas.repaintFlags |= 0x10;
                    Hud.repaintFlags = 16;
                    break;
                }
                case 13: {
                    short s = this.getUByteArg();
                    int n35 = this.getUByteArg();
                    int n36 = n35 >> 4;
                    n35 &= 0xF;
                    if (Canvas.state == 6) {
                        Canvas.setState(3);
                        Canvas.invalidateRect();
                    }
                    if (Game.skipDialog) break;
                    if (n35 == 6 || n35 == 7 || n35 == 1) {
                        Player.inCombat = false;
                    }
                    if (n35 == 2) {
                        boolean bl5 = false;
                        Player.prevWeapon = Player.ce.weapon;
                        for (byte by = 0; by < 20; by = (byte)(by + 1)) {
                            if (Game.scriptThreads[by] != this) continue;
                            bl5 = Canvas.enqueueHelpDialog(Canvas.loadMapStringID, s, by);
                            break;
                        }
                        if (!bl5) {
                            break;
                        }
                    } else {
                        if (n35 == 4) {
                            Player.prevWeapon = Player.ce.weapon;
                        }
                        Canvas.startDialog(this, Canvas.loadMapStringID, s, n35, n36, true);
                    }
                    Game.skipAdvanceTurn = true;
                    Game.queueAdvanceTurn = false;
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 14: {
                    int n37 = this.getUByteArg() * 100;
                    n = this.evWait(n37);
                    break;
                }
                case 15: {
                    if (Game.interpolatingMonsters) {
                        Game.snapMonsters(true);
                    }
                    while (Game.combatMonsters != null) {
                        Game.combatMonsters.undoAttack();
                    }
                    Game.endMonstersTurn();
                    int n38 = this.getUShortArg();
                    boolean bl6 = (n38 & 0x4000) != 0;
                    Canvas.destX = (n38 >> 5 & 0x1F) * 64 + 32;
                    Canvas.destY = (n38 & 0x1F) * 64 + 32;
                    Canvas.destZ = Render.getHeight(Canvas.destX, Canvas.destY) + 36;
                    int n39 = n38 >> 10 & 0xF;
                    Canvas.destPitch = 0;
                    Canvas.viewPitch = 0;
                    Canvas.destRoll = 0;
                    Canvas.viewRoll = 0;
                    Canvas.knockbackDist = 0;
                    if (bl6) {
                        if (n39 != 15) {
                            int n40 = n39 << 7;
                            int n41 = Canvas.viewAngle & 0x3FF;
                            if (n40 - n41 > 512) {
                                n40 -= 1024;
                            } else if (n40 - n41 < -512) {
                                n40 += 1024;
                            }
                            Canvas.viewAngle = n41;
                            Canvas.destAngle = n40;
                        }
                        Canvas.startRotation(false);
                        Canvas.zStep = (Math.abs(Canvas.destZ - Canvas.viewZ) + Canvas.animFrames - 1) / Canvas.animFrames;
                        if (Canvas.destX != Canvas.viewX || Canvas.destY != Canvas.viewY || Canvas.viewAngle != Canvas.destAngle) {
                            Canvas.gotoThread = this;
                            this.unpauseTime = -1;
                            n = 2;
                        } else {
                            Canvas.viewPitch = Canvas.destPitch;
                        }
                    } else {
                        Canvas.viewX = Canvas.destX;
                        Canvas.viewY = Canvas.destY;
                        Canvas.viewZ = Canvas.destZ;
                        if (n39 != 15) {
                            Canvas.destAngle = Canvas.viewAngle = n39 << 7;
                            Canvas.finishRotation(true);
                        }
                        if ((n38 & 0x8000) != 0) {
                            Game.advanceTurn();
                        }
                        if (Canvas.state != 18) {
                            Canvas.startRotation(false);
                            Canvas.viewPitch = Canvas.destPitch;
                        } else {
                            Canvas.destPitch = 0;
                            Canvas.viewPitch = 0;
                        }
                        Game.gotoTriggered = true;
                        Canvas.automapDrawn = false;
                    }
                    Player.relink();
                    Canvas.clearEvents();
                    Canvas.updateFacingEntity = true;
                    Canvas.invalidateRect();
                    break;
                }
                case 69: {
                    byte by = this.getByteArg();
                    int n42 = by >> 3;
                    int n43 = by & 7;
                    int n44 = Canvas.viewAngle & 0x3FF;
                    int n45 = n43 << 7;
                    if (n45 - n44 > 512) {
                        n45 -= 1024;
                    } else if (n45 - n44 < -512) {
                        n45 += 1024;
                    }
                    if (n44 == n45) break;
                    if (n42 == 1) {
                        Canvas.viewAngle = n44;
                        Canvas.destAngle = n45;
                        Canvas.startRotation(false);
                        Canvas.gotoThread = this;
                        this.unpauseTime = -1;
                        n = 2;
                        break;
                    }
                    Canvas.viewAngle = Canvas.destAngle = n45;
                    break;
                }
                case 16: {
                    Canvas.abortMove = true;
                    break;
                }
                case 34: {
                    short s = this.getUByteArg();
                    short s7 = this.getUByteArg();
                    short s8 = Render.mapSprites[Render.S_ENT + s];
                    if (s8 == -1) break;
                    Entity entity = Game.entities[s8];
                    entity.info |= 0x400000;
                    entity.name = (short)(s7 | Canvas.loadMapStringID << 10);
                    break;
                }
                case 92: {
                    short s = this.getUByteArg();
                    short s9 = this.getUByteArg();
                    short s10 = Render.mapSprites[Render.S_ENT + s];
                    if (s10 == -1) break;
                    Entity entity = Game.entities[s10];
                    if (s9 == 1) {
                        entity.info &= 0xDFFFFFFF;
                        break;
                    }
                    if (s9 != 0) break;
                    entity.info |= 0x20000000;
                    break;
                }
                case 17: {
                    short s = this.getUByteArg();
                    short s11 = this.getUByteArg();
                    int n46 = this.getUByteArg() * 100;
                    short s12 = Render.mapSprites[Render.S_ENT + s];
                    Render.mapSpriteInfo[s] = Render.mapSpriteInfo[s] & 0xFFFF00FF | s11 << 8;
                    Canvas.staleView = true;
                    if (s12 != -1) {
                        Game.entities[s12].info |= 0x400000;
                        if (Game.entities[s12].monster != null) {
                            Game.entities[s12].monster.frameTime = Integer.MAX_VALUE;
                        }
                    }
                    if (n46 <= 0) break;
                    n = this.evWait(n46);
                    break;
                }
                case 18: {
                    if (Canvas.state == 18 || Canvas.state == 4) {
                        Game.activeCamera.keyThreadResumeCount = this.getUByteArg();
                        Game.activeCamera.keyThread = this;
                        Game.activeCamera.NextKey();
                        this.unpauseTime = -1;
                        n = 2;
                        break;
                    }
                    this.getUByteArg();
                    break;
                }
                case 19: {
                    short s = this.getUByteArg();
                    byte by = this.getByteArg();
                    short s13 = Render.mapSprites[Render.S_ENT + s];
                    if (s13 != -1) {
                        Entity entity = Game.entities[s13];
                        if (entity.monster != null) {
                            entity.info |= 0x20000;
                            entity.pain(by, null);
                            if (entity.monster.ce.getStat(0) <= 0) {
                                entity.died(false, null);
                            }
                        } else {
                            entity.died(false, null);
                        }
                    }
                    Canvas.staleView = true;
                    break;
                }
                case 20: {
                    byte by = this.getByteArg();
                    byte by2 = this.getByteArg();
                    int n47 = this.getByteArg();
                    if (by > 0) {
                        Player.painEvent(null, false);
                        Hud.damageTime = App.time + 1000;
                        if (n47 != -1) {
                            int n48 = 256 - (Canvas.viewAngle & 0x3FF) >> 7;
                            Hud.damageDir = n47 = n47 + n48 + 1 & 7;
                        }
                        Combat.totalDamage = 1;
                        Player.pain(by, null, true);
                    } else if (by < 0) {
                        Player.addHealth(-by);
                    }
                    Player.addArmor(-by2);
                    break;
                }
                case 21: {
                    int n49 = this.getUShortArg();
                    int n50 = n49 >> 10;
                    boolean bl7 = (n50 & 4) == 0 && Canvas.state != 6;
                    n50 &= 3;
                    short s = Render.mapSprites[Render.S_ENT + (n49 &= 0x3FF)];
                    if (s == -1) break;
                    Entity entity = Game.entities[s];
                    if (n50 == 1 || n50 == 0) {
                        if (n50 == 1 && entity.def.eType == 5) {
                            Game.setLineLocked(entity, false);
                        }
                        if (!Game.performDoorEvent(n50, bl7 ? this : null, entity, bl7 ? 1 : 0, false) || !bl7) break;
                        this.unpauseTime = -1;
                        n = 2;
                        break;
                    }
                    if (n50 == 2) {
                        Game.setLineLocked(entity, true);
                        if (!bl7) break;
                        Sound.playSound(24);
                        break;
                    }
                    Game.setLineLocked(entity, false);
                    if (!bl7) break;
                    Sound.playSound(24);
                    break;
                }
                case 22: {
                    short s = this.getUByteArg();
                    int n51 = this.getUByteArg();
                    int n52 = n51 >> 6 & 3;
                    n51 = 1 << (n51 & 0x3F);
                    short s14 = Render.mapSprites[Render.S_ENT + s];
                    if (s14 == -1) break;
                    Entity entity = Game.entities[s14];
                    if (entity.monster == null) break;
                    entity.monster.flags = n52 == 0 ? (short)(entity.monster.flags | n51) : (n52 == 1 ? (short)(entity.monster.flags & ~n51) : (short)n51);
                    entity.info |= 0x400000;
                    break;
                }
                case 23: {
                    int n53 = this.getUShortArg();
                    int n54 = (n53 & 0x8000) >> 15 << 19;
                    int n55 = Render.tileEvents[(n53 &= Short.MAX_VALUE) * 2 + 1] & 0xFFF7FFFF;
                    Render.tileEvents[n53 * 2 + 1] = n55 | n54;
                    break;
                }
                case 24: {
                    short s;
                    short s15 = s = this.getUByteArg();
                    Render.mapSpriteInfo[s15] = Render.mapSpriteInfo[s15] | 0x10000;
                    short s16 = Render.mapSprites[Render.S_ENT + s];
                    if (s16 != -1) {
                        Entity entity = Game.entities[s16];
                        entity.info |= 0x400000;
                        Game.unlinkEntity(entity);
                        EntityDef entityDef = entity.def;
                        if (entityDef.eType == 10) {
                            if (entityDef.eSubType != 3) {
                                Game.destroyedObject(s);
                            }
                        } else if (entityDef.eType == 6 && (entityDef.eSubType == 1 || entityDef.eSubType == 2 || entityDef.eSubType == 0 && entityDef.parm == 21)) {
                            Game.foundLoot(s, 1);
                        } else if (entityDef.eType == 2) {
                            ScriptThread.corpsifyMonster(entity.linkIndex % 32, entity.linkIndex / 32, entity, false);
                            Game.remove(entity);
                            entity.info |= 0x400000;
                        }
                    }
                    Canvas.updateFacingEntity = true;
                    break;
                }
                case 28: {
                    short s = this.getUByteArg();
                    short s17 = Render.mapSprites[Render.S_ENT + s];
                    if (s17 == -1 || Game.entities[s17].monster == null) {
                        App.Error(23);
                    }
                    Entity entity = Game.entities[s17];
                    if (entity.def.eType != 2) break;
                    int n56 = entity.getSprite();
                    entity.monster.frameTime = 0;
                    Render.mapSpriteInfo[n56] = Render.mapSpriteInfo[n56] & 0xFFFF00FF | 0;
                    Game.activate(entity, true, false, false, true);
                    break;
                }
                case 33: {
                    short s = this.getUByteArg();
                    short s18 = this.getUByteArg();
                    byte by = this.getByteArg();
                    if (this.throwAwayLoot) {
                        n2 = 1;
                        Game.foundLoot(Canvas.viewX + Canvas.viewStepX, Canvas.viewY + Canvas.viewStepY, Canvas.viewZ, 1);
                        break;
                    }
                    if (by == 0) {
                        short s19 = Render.mapSprites[Render.S_ENT + (s = (short)(s << 8 | s18))];
                        if (s19 == -1) {
                            App.Error(new Exception("Sprite index " + s + " error."), 16);
                        }
                        if (Game.entities[s19].touched()) break;
                        n2 = 1;
                        break;
                    }
                    EntityDef entityDef = EntityDef.lookup(s);
                    if (entityDef == null) {
                        App.Error(new Exception("Cannot find an entity to give"), 109);
                    }
                    if ((s18 = (short)((byte)s18)) < 0) {
                        if (Player.give(entityDef.eSubType, entityDef.parm, s18, true)) break;
                        n2 = 1;
                        break;
                    }
                    if (entityDef.eType == 6 && entityDef.eSubType == 1 && Player.weaponIsASentryBot(entityDef.parm)) {
                        if (Player.give(entityDef.eSubType, entityDef.parm, s18, true)) break;
                        n2 = 1;
                        break;
                    }
                    Entity entity = Game.spawnDropItem(0, 0, s, entityDef, s18, false);
                    byte by3 = entity.def.eType;
                    if (!entity.touched()) {
                        Game.remove(entity);
                        n2 = 1;
                        break;
                    }
                    if (by3 == 3 || s18 <= 0) break;
                    Game.foundLoot(Canvas.viewX + Canvas.viewStepX, Canvas.viewY + Canvas.viewStepY, Canvas.viewZ, 1);
                    break;
                }
                case 25: {
                    int n57 = this.getUShortArg();
                    short s = this.getUByteArg();
                    short s20 = (short)(n57 & 0x1F);
                    short s21 = (short)(n57 >> 5 & 0x1F);
                    short s22 = (short)(n57 >> 10 & 0x1F);
                    EntityDef entityDef = EntityDef.lookup(s);
                    if (entityDef == null) {
                        App.Error(new Exception("Cannot find an entity to drop"), 109);
                    }
                    Game.spawnDropItem((s20 << 6) + 32, (s21 << 6) + 32, s, entityDef.eType, entityDef.eSubType, entityDef.parm, s22, true);
                    Canvas.staleView = true;
                    break;
                }
                case 29: {
                    Game.cinematicWeapon = this.getByteArg();
                    if (Game.skippingCinematic || Canvas.state != 18) break;
                    int n58 = Game.cinematicWeapon * 9;
                    Combat.animLoopCount = 10 * Combat.weapons[n58 + 7];
                    Combat.animTime = Combat.weapons[n58 + 8];
                    Combat.animStartTime = App.gameTime;
                    Combat.animEndTime = Combat.animStartTime + (Combat.animTime *= 10);
                    Combat.flashTime = 0;
                    Combat.flashDoneTime = Combat.animStartTime + Combat.flashTime;
                    break;
                }
                case 30: {
                    short s = this.getUByteArg();
                    if (Render.mapSprites[Render.S_ENT + s] == -1) break;
                    Entity entity = Game.entities[Render.mapSprites[Render.S_ENT + s]];
                    ParticleSystem.spawnMonsterBlood(entity, false);
                    break;
                }
                case 31: {
                    short s = this.getUByteArg();
                    int n59 = s >> 3 & 0xF;
                    int n60 = s & 7;
                    int n61 = this.getUShortArg();
                    int n62 = this.getUByteArg() - 48;
                    if ((s & 0x80) != 0) {
                        int n63 = ((n61 >> 11 & 0x1F) << 6) + 32;
                        int n64 = ((n61 >> 6 & 0x1F) << 6) + 32;
                        int n65 = n62 + Render.getHeight(n63, n64);
                        ParticleSystem.spawnParticles(n59, ParticleSystem.levelColors[n60], n63, n64, n65);
                        break;
                    }
                    ParticleSystem.spawnParticles(n59, ParticleSystem.levelColors[n60], n61);
                    break;
                }
                case 32: {
                    boolean bl8;
                    int n66 = this.getUShortArg();
                    boolean bl9 = bl8 = (n66 & 0x8000) == 32768;
                    if (Game.skippingCinematic) {
                        if (!bl8) break;
                        Render.endFade();
                        break;
                    }
                    if (bl8) {
                        Render.startFade(n66 & Short.MAX_VALUE, 2);
                        break;
                    }
                    Render.startFade(n66, 1);
                    break;
                }
                case 35: {
                    boolean bl10 = false;
                    int n67 = this.getUShortArg();
                    int n68 = this.getUByteArg();
                    if ((n67 & 0x8000) != 0) {
                        n68 <<= 8;
                        n68 |= this.getUByteArg();
                        n67 &= Short.MAX_VALUE;
                        bl10 = true;
                    }
                    short s = this.getUByteArg();
                    short s23 = Render.mapSprites[Render.S_X + n67];
                    short s24 = Render.mapSprites[Render.S_Y + n67];
                    if (!bl10) {
                        EntityDef entityDef = EntityDef.lookup(n68);
                        if (entityDef == null) {
                            App.Error(new Exception("Cannot find an entity to drop"), 109);
                        }
                        Game.spawnDropItem(s23, s24, n68, entityDef, s, true);
                    } else {
                        short s25 = Render.mapSprites[Render.S_ENT + n68];
                        Entity entity = Game.entities[s25];
                        int n69 = Render.getHeight(s23, s24);
                        Render.mapSprites[Render.S_X + n68] = s23;
                        Render.mapSprites[Render.S_Y + n68] = s24;
                        Render.mapSprites[Render.S_Z + n68] = (short)(32 + n69);
                        Render.relinkSprite(n68);
                        Game.unlinkEntity(entity);
                        Game.linkEntity(entity, s23 >> 6, s24 >> 6);
                        Game.throwDropItem(s23, s24, n69, entity);
                        entity.info |= 0x400000;
                    }
                    Canvas.staleView = true;
                    break;
                }
                case 36: {
                    short s = this.getUByteArg();
                    short s26 = this.getShortArg();
                    short s27 = Render.mapSprites[Render.S_ENT + s];
                    if (s27 == -1) break;
                    Entity entity = Game.entities[s27];
                    if (s26 != -1) {
                        Game.addEntityDeathFunc(entity, s26);
                        break;
                    }
                    Game.removeEntityFunc(entity);
                    break;
                }
                case 40: {
                    short s = this.getUByteArg();
                    int n70 = this.getUShortArg();
                    break;
                }
                case 37: {
                    short s = this.getUByteArg();
                    short s28 = this.getUByteArg();
                    if (Canvas.inInitMap && Canvas.areSoundsAllowed) {
                        boolean bl11 = Sound.isSoundEnabled();
                        Sound.setSound(true);
                        Sound.playSound(s, 0);
                        Sound.setSound(bl11);
                        break;
                    }
                    Sound.playSound(s, 0);
                    break;
                }
                case 38: {
                    int n71 = this.getUShortArg();
                    int n72 = n71 >> 14 & 3;
                    Entity entity = null;
                    if (Render.mapSprites[Render.S_ENT + (n71 &= 0x3FFF)] != -1) {
                        entity = Game.entities[Render.mapSprites[Render.S_ENT + n71]];
                        if (entity.def.eType == 3) {
                            entity.param = n72;
                            break;
                        }
                    }
                    App.Error(14);
                }
                case 41: {
                    if (Canvas.showingLoot) {
                        this.unpauseTime = 1;
                        return 2;
                    }
                    this.composeLootDialog();
                    if (this.throwAwayLoot) break;
                    Game.skipAdvanceTurn = true;
                    Game.queueAdvanceTurn = false;
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 83: {
                    int n73 = this.getUShortArg();
                    if (Render.mapSprites[Render.S_ENT + (n73 &= 0xFFF)] != -1) {
                        int n74;
                        Entity entity = Game.entities[Render.mapSprites[Render.S_ENT + n73]];
                        boolean bl12 = entity.lootSet != null;
                        int n75 = this.getUByteArg();
                        for (n74 = 0; n74 < n75; ++n74) {
                            int n76 = this.getUShortArg();
                            if (!bl12) continue;
                            entity.lootSet[n74] = n76;
                        }
                        if (!bl12) break;
                        for (n74 = n75; n74 < 3; ++n74) {
                            entity.lootSet[n74] = 0;
                        }
                        break;
                    }
                    App.Error(117);
                    break;
                }
                case 42: {
                    int n77 = this.getUShortArg();
                    int n78 = n77 >> 10 & 0x3F;
                    int n79 = n77 >> 5 & 0x1F;
                    int n80 = n77 & 0x1F;
                    if ((n78 & 1) != 0) {
                        Entity.setMonsterClip(n79, n80);
                    }
                    if ((n78 & 0x20) != 0) {
                        Render.mapEntranceAutomap = (short)(n80 * 32 + n79);
                    }
                    if ((n78 & 0x10) != 0) {
                        Render.mapExitAutomap = (short)(n80 * 32 + n79);
                    }
                    if ((n78 & 2) != 0) {
                        int n81;
                        for (n81 = 0; n81 < Render.mapLadders.length && Render.mapLadders[n81] != -1; ++n81) {
                        }
                        if (n81 != Render.mapLadders.length) {
                            Render.mapLadders[n81] = (short)(n80 * 32 + n79);
                        }
                    }
                    n78 &= 0xFFFFFFFE;
                    n78 &= 0xFFFFFFDF;
                    n78 &= 0xFFFFFFEF;
                    n78 &= 0xFFFFFFFD;
                    int n82 = n80 * 32 + n79;
                    Render.mapFlags[n82] = (byte)(Render.mapFlags[n82] | (n78 <<= 2));
                    break;
                }
                case 82: {
                    int n83 = this.getUShortArg();
                    int n84 = n83 >> 10 & 0x3F;
                    int n85 = n83 >> 5 & 0x1F;
                    int n86 = n83 & 0x1F;
                    if ((n84 & 1) != 0) {
                        Entity.unsetMonsterClip(n85, n86);
                    }
                    if ((n84 & 0x20) != 0 && Render.mapEntranceAutomap == n86 * 32 + n85) {
                        Render.mapEntranceAutomap = (short)-1;
                    }
                    if ((n84 & 0x10) != 0 && Render.mapExitAutomap == n86 * 32 + n85) {
                        Render.mapExitAutomap = (short)-1;
                    }
                    if ((n84 & 2) != 0) {
                        for (int i = 0; i < Render.mapLadders.length; ++i) {
                            if (Render.mapLadders[i] != n86 * 32 + n85) continue;
                            Render.mapLadders[i] = -1;
                        }
                    }
                    n84 &= 0xFFFFFFFE;
                    n84 &= 0xFFFFFFDF;
                    n84 &= 0xFFFFFFEF;
                    n84 &= 0xFFFFFFFD;
                    int n87 = n86 * 32 + n85;
                    Render.mapFlags[n87] = (byte)(Render.mapFlags[n87] & ~(n84 <<= 2));
                    break;
                }
                case 90: {
                    int n88 = this.getUShortArg();
                    int n89 = n88 & 7;
                    int n90 = n88 >> 8 & 0x1F;
                    int n91 = n88 >> 3 & 0x1F;
                    int n92 = n88 >> 13 & 1;
                    if (n92 == 0) {
                        int n93;
                        for (n93 = 0; n93 < Render.mapKeepPitchLevelTiles.length && Render.mapKeepPitchLevelTiles[n93] != -1; ++n93) {
                        }
                        if (n93 == Render.mapKeepPitchLevelTiles.length) break;
                        Render.mapKeepPitchLevelTiles[n93] = (short)n90;
                        int n94 = n93;
                        Render.mapKeepPitchLevelTiles[n94] = (short)(Render.mapKeepPitchLevelTiles[n94] | (short)(n91 << 5));
                        int n95 = n93;
                        Render.mapKeepPitchLevelTiles[n95] = (short)(Render.mapKeepPitchLevelTiles[n95] | (short)(n89 << 10));
                        break;
                    }
                    if (n92 != 1) break;
                    for (int i = 0; i < Render.mapKeepPitchLevelTiles.length; ++i) {
                        short s;
                        if (Render.mapKeepPitchLevelTiles[i] == -1 || (n91 << 5) + n90 != ((s = Render.mapKeepPitchLevelTiles[i]) & 0x3FF) || n89 != (s & 0xFFFFFC00) >> 10) continue;
                        Render.mapKeepPitchLevelTiles[i] = -1;
                    }
                    break;
                }
                case 84: {
                    int n96 = this.getUShortArg();
                    int n97 = n96 & 7;
                    int n98 = n96 >> 8 & 0x1F;
                    int n99 = n96 >> 3 & 0x1F;
                    Player.enterTargetPractice(n98, n99, n97, this);
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 43: {
                    short s = this.getUByteArg();
                    short s29 = this.getUByteArg();
                    Player.updateQuests(s, s29);
                    if (s29 != 0) break;
                    Player.showHelp((short)5, true);
                    break;
                }
                case 45: {
                    short s = this.getUByteArg();
                    Player.modifyStat(s >> 5 & 7, (s & 0x1F) << 27 >> 27);
                    break;
                }
                case 47: {
                    int n100 = this.getUShortArg();
                    short s = this.getUByteArg();
                    short s30 = this.getUByteArg();
                    Entity entity = null;
                    if (Render.mapSprites[Render.S_ENT + n100] != -1) {
                        Entity entity2;
                        entity = Game.entities[Render.mapSprites[Render.S_ENT + n100]];
                        if ((entity.info & 0x1010000) != 0 && null == (entity2 = Game.findMapEntity(s, s30, 1030))) {
                            entity.resurrect((s << 6) + 32, (s30 << 6) + 32, 32);
                            break;
                        }
                    }
                    n2 = -1;
                    break;
                }
                case 48: {
                    int n101;
                    int n102;
                    int n103 = this.getUShortArg();
                    int n104 = n103 >> 14 & 3;
                    if (n104 >= 0) {
                        ++n104;
                    }
                    if ((n102 = n103 >> 7 & 0x7F) > 0) {
                        n102 = n102 + 1 << 4;
                    }
                    if ((n101 = n103 & 0x7F) > 0) {
                        n101 = n101 + 1 << 4;
                    }
                    Canvas.startShake(n102, n104, n101);
                    break;
                }
                case 49: {
                    Hud.showSpeechBubble(this.getUShortArg(), this.getUByteArg());
                    break;
                }
                case 51: {
                    int n105 = this.getUShortArg();
                    int n106 = n105 >> 12 & 0xF;
                    byte by = this.getByteArg();
                    if (Render.mapSprites[Render.S_ENT + (n105 &= 0xFFF)] != -1) {
                        Entity entity = Game.entities[Render.mapSprites[Render.S_ENT + n105]];
                        ScriptThread.setAIGoal(entity, n106, by);
                        break;
                    }
                    App.Error(76);
                    break;
                }
                case 50: {
                    Game.awardSecret(false);
                    break;
                }
                case 52: {
                    if (Game.interpolatingMonsters) {
                        Game.snapMonsters(true);
                    }
                    while (Game.combatMonsters != null) {
                        Game.combatMonsters.undoAttack();
                    }
                    Game.endMonstersTurn();
                    Canvas.clearEvents();
                    Game.advanceTurn();
                    break;
                }
                case 80: {
                    boolean bl13 = Canvas.startArmorRepair(this);
                    if (!bl13) break;
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 81: {
                    if (!Player.isFamiliar) break;
                    Player.familiarReturnsToPlayer(false);
                    break;
                }
                case 85: {
                    Game.givemap(0, 0, 32, 32);
                    break;
                }
                case 91: {
                    Player.usedChainsaw(false);
                    break;
                }
                case 93: {
                    int n107;
                    short s = this.getByteArg();
                    if (Player.noclip) break;
                    int n108 = n107 = Player.isFamiliar ? Player.ammo[7] : Player.ce.getStat(0);
                    if (!Player.isFamiliar) {
                        Player.painEvent(null, false);
                    }
                    Hud.damageTime = App.time + 1000;
                    Combat.totalDamage = 1;
                    Player.pain(n107, null, true);
                    if (Player.isFamiliar) {
                        if (s != 0) break;
                        Player.noFamiliarRemains = true;
                        break;
                    }
                    Player.addArmor(-Player.ce.getStat(2));
                    break;
                }
                case 87: {
                    int n109 = this.getByteArg();
                    int n110 = this.getByteArg();
                    short s = this.getByteArg();
                    short s31 = this.getByteArg();
                    for (int i = n110; i <= s31; ++i) {
                        for (int j = n109; j <= s; ++j) {
                            int n111 = i * 32 + j;
                            Render.mapFlags[n111] = (byte)(Render.mapFlags[n111] & 0xFFFFFFF7);
                        }
                    }
                    Canvas.automapDrawn = false;
                    break;
                }
                case 88: {
                    int n112 = this.getByteArg();
                    int n113 = this.getByteArg();
                    short s = this.getByteArg();
                    short s32 = this.getByteArg();
                    for (int i = n113; i <= s32; ++i) {
                        for (int j = n112; j <= s; ++j) {
                            int n114 = i * 32 + j;
                            Render.mapFlags[n114] = (byte)(Render.mapFlags[n114] | 8);
                        }
                    }
                    Canvas.automapDrawn = false;
                    break;
                }
                case 53: {
                    short s = this.getByteArg();
                    short s33 = this.getByteArg();
                    short s34 = this.getByteArg();
                    short s35 = this.getByteArg();
                    if (s == 0) {
                        short s36 = s33;
                        SentryBotGame.initGame(this, s36);
                        if (Game.skipMinigames) {
                            SentryBotGame.forceWin();
                        }
                        this.unpauseTime = -1;
                        n = 2;
                        break;
                    }
                    if (s == 4) {
                        short s37 = s33;
                        VendingMachine.initGame(this, Canvas.loadMapID, (Canvas.loadMapID - 1) * 2 + s37);
                        if (Game.skipMinigames) {
                            VendingMachine.forceWin();
                        }
                        this.unpauseTime = -1;
                        n = 2;
                        break;
                    }
                    if (s != 2) break;
                    short s38 = s33;
                    short s39 = s35;
                    if (s38 == 1) {
                        short s40 = s34;
                        Text text = Text.getSmallBuffer();
                        Text.composeText(Canvas.loadMapStringID, s40, text);
                        if (s39 == -1) {
                            HackingGame.initGame(this, text);
                        } else {
                            HackingGame.initGame(this, text, (int)s39);
                        }
                        text.dispose();
                    } else if (s38 == 0) {
                        short s41 = s34;
                        if (s39 == -1) {
                            HackingGame.initGame(this, s41);
                        } else {
                            HackingGame.initGame(this, s41, (int)s39);
                        }
                    }
                    if (Game.skipMinigames) {
                        HackingGame.forceWin();
                    }
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 55: {
                    break;
                }
                case 54: {
                    break;
                }
                case 56: {
                    int n115 = this.getUShortArg();
                    int n116 = n115 >> 12 & 0xF;
                    if (Render.mapSprites[Render.S_ENT + (n115 &= 0xFFF)] != -1) {
                        Entity entity = Game.entities[Render.mapSprites[Render.S_ENT + n115]];
                        Player.ce.weapon = n116;
                        Combat.performAttack(null, entity, 0, 0, true);
                    }
                    n = this.evWait(1);
                    break;
                }
                case 57: {
                    Render.buildFogTables(this.getIntArg());
                    break;
                }
                case 58: {
                    int n117 = this.getIntArg();
                    Render.startFogLerp(n117 & 0x7FF, n117 >> 11 & 0x7FF, (n117 >> 22 & 0xFF) * 100);
                    break;
                }
                case 60: {
                    Player.disabledWeapons = this.getShortArg();
                    if ((Player.disabledWeapons & 1 << Player.ce.weapon) == 0) break;
                    Player.selectNextWeapon();
                    break;
                }
                case 61: {
                    int n118 = this.getUShortArg();
                    int n119 = n118 >> 4;
                    int n120 = n118 & 0xF;
                    int n121 = this.getUShortArg();
                    short s = this.getUByteArg();
                    LerpSprite lerpSprite = Game.allocLerpSprite(this, n119, (n120 & 2) != 0);
                    if (lerpSprite == null) {
                        return 0;
                    }
                    lerpSprite.srcX = lerpSprite.dstX = Render.mapSprites[Render.S_X + n119];
                    lerpSprite.srcY = lerpSprite.dstY = Render.mapSprites[Render.S_Y + n119];
                    lerpSprite.srcZ = lerpSprite.dstZ = Render.mapSprites[Render.S_Z + n119];
                    lerpSprite.srcScale = Render.mapSprites[Render.S_SCALEFACTOR + n119];
                    lerpSprite.dstScale = s << 1;
                    short s42 = Render.mapSprites[Render.S_ENT + n119];
                    if (s42 != -1) {
                        Game.entities[s42].info |= 0x400000;
                    }
                    lerpSprite.startTime = App.gameTime;
                    lerpSprite.travelTime = n121;
                    lerpSprite.flags = n120 & 3;
                    if (n121 == 0) {
                        if ((Game.updateLerpSprite(lerpSprite) & 1) != 0) {
                            Canvas.invalidateRect();
                            break;
                        }
                        n = 0;
                        break;
                    }
                    if (n121 != 0 && (n120 & 2) != 0) {
                        this.evWait(n121);
                    }
                    if ((lerpSprite.flags & 1) != 0) break;
                    Game.skipAdvanceTurn = true;
                    Game.queueAdvanceTurn = false;
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 62: {
                    break;
                }
                case 65: {
                    break;
                }
                case 66: {
                    byte by;
                    if (this.debugString == null) {
                        this.debugString = Text.getLargeBuffer();
                    }
                    if ((by = this.getByteArg()) == 0) {
                        char c = (char)this.getUByteArg();
                        while (c != '\u0000') {
                            this.debugString.append(c);
                            c = (char)this.getUByteArg();
                        }
                    } else if (by == 1) {
                        short s = this.getUByteArg();
                        this.debugString.append(Game.scriptStateVars[s]);
                    }
                    if (this.peekNextCmd() == 66) break;
                    this.debugString.dispose();
                    this.debugString = null;
                    break;
                }
                case 67: {
                    MenuSystem.setMenu(this.getUByteArg());
                    break;
                }
                case 68: {
                    short s = this.getUByteArg();
                    ScriptThread.setupCamera(s & 0x7F);
                    Game.activeCamera.cameraThread = this;
                    Canvas.setState(4);
                    break;
                }
                case 70: {
                    short s = this.getUByteArg();
                    if ((s & 0x80) != 0) {
                        Player.removeStatusEffect(s & 0x7F);
                        break;
                    }
                    byte by = this.getByteArg();
                    int n122 = 30;
                    if (s == 2) {
                        n122 = 20;
                    } else if (s == 9) {
                        n122 = 10;
                    } else if (s == 1) {
                        n122 = 10;
                    } else if (s == 11) {
                        n122 = 6;
                    } else if (s == 17) {
                        n122 = 5;
                    }
                    Player.addStatusEffect(s, by, n122);
                    Player.translateStatusEffects();
                    break;
                }
                case 71: {
                    short s = this.getUByteArg();
                    int n123 = this.getUByteArg() & 0x1F;
                    int n124 = this.getUByteArg() & 0x1F;
                    Player.setQuestTile(s, n123, n124);
                    break;
                }
                case 72: {
                    int n125 = this.getUShortArg();
                    short s = (short)((this.getUByteArg() << 6) + 32);
                    short s43 = (short)((this.getUByteArg() << 6) + 32);
                    Entity entity = Game.entities[Render.mapSprites[Render.S_ENT + n125]];
                    if (entity.monster == null) break;
                    ScriptThread.corpsifyMonster(s, s43, entity, true);
                    break;
                }
                case 73: {
                    byte by = this.getByteArg();
                    if (by == 2) {
                        ScriptThread.restoreInventory();
                        break;
                    }
                    if (by == 1) {
                        ScriptThread.stripInventoryForTargetPractice();
                        break;
                    }
                    if (by != 0) break;
                    ScriptThread.stripInventoryForViosBattle();
                    break;
                }
                case 74: {
                    Player.gameCompleted = true;
                    Canvas.endingGame = true;
                    Canvas.setState(14);
                    break;
                }
                case 75: {
                    int n126 = this.getIntArg();
                    int n127 = this.getUShortArg();
                    int n128 = n126 >> 22 & 0x3FF;
                    int n129 = n126 >> 17 & 0x1F;
                    int n130 = n126 >> 12 & 0x1F;
                    int n131 = (n126 >> 4 & 0xFF) - 48;
                    int n132 = n126 & 0xF;
                    LerpSprite lerpSprite = Game.allocLerpSprite(this, n128, (n132 & 2) != 0);
                    if (lerpSprite == null) {
                        return 0;
                    }
                    lerpSprite.dstX = 32 + (n129 << 6);
                    lerpSprite.dstY = 32 + (n130 << 6);
                    short s = Render.mapSprites[Render.S_ENT + n128];
                    if (s != -1) {
                        Game.entities[s].info |= 0x400000;
                        if (Game.entities[s].monster != null) {
                            Game.entities[s].monster.flags = (short)(Game.entities[s].monster.flags & 0xFFFFBFFF);
                        }
                    }
                    lerpSprite.srcX = Render.mapSprites[Render.S_X + n128];
                    lerpSprite.srcY = Render.mapSprites[Render.S_Y + n128];
                    lerpSprite.srcZ = Render.mapSprites[Render.S_Z + n128];
                    lerpSprite.dstZ = Render.getHeight(lerpSprite.dstX, lerpSprite.dstY) + (lerpSprite.srcZ - Render.getHeight(lerpSprite.srcX, lerpSprite.srcY));
                    lerpSprite.srcScale = lerpSprite.dstScale = Render.mapSprites[Render.S_SCALEFACTOR + n128];
                    lerpSprite.height = n131;
                    lerpSprite.startTime = App.gameTime;
                    lerpSprite.travelTime = n127;
                    lerpSprite.calcDist();
                    lerpSprite.flags = n132 & 3;
                    lerpSprite.flags |= 4;
                    if (n127 == 0) {
                        if ((Game.updateLerpSprite(lerpSprite) & 1) != 0) {
                            Canvas.invalidateRect();
                            break;
                        }
                        n = 0;
                        break;
                    }
                    if (n127 != 0 && (n132 & 2) != 0) {
                        this.evWait(n127);
                    }
                    if ((lerpSprite.flags & 1) != 0) break;
                    Game.skipAdvanceTurn = true;
                    Game.queueAdvanceTurn = false;
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 95: {
                    int n133 = this.getIntArg();
                    int n134 = this.getUShortArg();
                    int n135 = n133 >> 22 & 0x3FF;
                    int n136 = n133 >> 17 & 0x1F;
                    int n137 = n133 >> 12 & 0x1F;
                    int n138 = (n133 >> 4 & 0xFF) - 48;
                    int n139 = n133 & 0xF;
                    short s = this.getUByteArg();
                    LerpSprite lerpSprite = Game.allocLerpSprite(this, n135, (n139 & 2) != 0);
                    if (lerpSprite == null) {
                        return 0;
                    }
                    lerpSprite.dstX = 32 + (n136 << 6);
                    lerpSprite.dstY = 32 + (n137 << 6);
                    short s44 = Render.mapSprites[Render.S_ENT + n135];
                    if (s44 != -1) {
                        Game.entities[s44].info |= 0x400000;
                        if (Game.entities[s44].monster != null) {
                            Game.entities[s44].monster.flags = (short)(Game.entities[s44].monster.flags & 0xFFFFBFFF);
                        }
                    }
                    lerpSprite.srcX = Render.mapSprites[Render.S_X + n135];
                    lerpSprite.srcY = Render.mapSprites[Render.S_Y + n135];
                    lerpSprite.srcZ = Render.mapSprites[Render.S_Z + n135];
                    lerpSprite.dstZ = Render.getHeight(lerpSprite.dstX, lerpSprite.dstY) + (lerpSprite.srcZ - Render.getHeight(lerpSprite.srcX, lerpSprite.srcY));
                    lerpSprite.srcScale = Render.mapSprites[Render.S_SCALEFACTOR + n135];
                    lerpSprite.dstScale = s << 1;
                    lerpSprite.height = n138;
                    lerpSprite.startTime = App.gameTime;
                    lerpSprite.travelTime = n134;
                    lerpSprite.calcDist();
                    lerpSprite.flags = n139 & 3;
                    lerpSprite.flags |= 4;
                    if (n134 == 0) {
                        if ((Game.updateLerpSprite(lerpSprite) & 1) != 0) {
                            Canvas.invalidateRect();
                            break;
                        }
                        n = 0;
                        break;
                    }
                    if (n134 != 0 && (n139 & 2) != 0) {
                        this.evWait(n134);
                    }
                    if ((lerpSprite.flags & 1) != 0) break;
                    Game.skipAdvanceTurn = true;
                    Game.queueAdvanceTurn = false;
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 76: {
                    Image image = Hud.imgCockpitOverlay;
                    if (Hud.cockpitOverlayRaw == null && image != null) {
                        Hud.cockpitOverlayRaw = new int[image.getWidth() * image.getHeight()];
                        break;
                    }
                    Hud.cockpitOverlayRaw = null;
                    System.gc();
                    break;
                }
                case 77: {
                    byte by = this.getByteArg();
                    Render.fogAffectsSkyMap = by != 0;
                    break;
                }
                case 78: {
                    byte by = this.getByteArg();
                    Player.enableHelp = by != 0;
                    break;
                }
                case 79: {
                    byte by = this.getByteArg();
                    Render.useMastermindHack = by != 0;
                    break;
                }
                case 96: {
                    byte by = this.getByteArg();
                    Render.useCaldexHack = by != 0;
                    break;
                }
                case 86: {
                    byte by = this.getByteArg();
                    Game.angryVIOS = by != 0;
                    break;
                }
                case 89: {
                    byte by = this.getByteArg();
                    int n140 = by & 0xF;
                    int n141 = by >> 4 & 0xF;
                    if (n140 == 4) {
                        Render.portalScripted = false;
                        break;
                    }
                    Render.portalScripted = true;
                    Render.portalState = n140;
                    Render.previousPortalState = n141;
                    break;
                }
                case 94: {
                    Canvas.setState(24);
                    break;
                }
                case -1: {
                    if (this.stackPtr != 0) {
                        App.Error(new Exception("The frame pointer should be zero if the script has completed."), 102);
                    }
                    return 1;
                }
                default: {
                    App.Error(new Exception("Cannot handle event: " + byArray[this.IP]), 2);
                }
            }
            if (bl) {
                Game.scriptStateVars[7] = n2;
            }
            ++this.IP;
        }
        return n;
    }

    public void init() {
        this.stackPtr = 0;
        this.IP = 0;
        this.FP = 0;
        this.unpauseTime = 0;
        this.state = 2;
        this.throwAwayLoot = false;
    }

    public void reset() {
        this.inuse = false;
        this.init();
    }

    public int attemptResume(int n) {
        if (this.stackPtr == 0) {
            return 1;
        }
        if (this.unpauseTime == -1 || n < this.unpauseTime) {
            return 2;
        }
        this.unpauseTime = 0;
        return this.run();
    }

    public int getIndex() {
        for (int i = 0; i < Game.scriptThreads.length; ++i) {
            if (this != Game.scriptThreads[i]) continue;
            return i;
        }
        return -1;
    }

    private int pop() {
        return this.scriptStack[--this.stackPtr];
    }

    private void push(boolean bl) {
        if (bl) {
            this.push(1);
        } else {
            this.push(0);
        }
    }

    private void push(int n) {
        this.scriptStack[this.stackPtr++] = n;
    }

    private short getUByteArg() {
        return (short)(Render.mapByteCode[++this.IP] & 0xFF);
    }

    private byte getByteArg() {
        return Render.mapByteCode[++this.IP];
    }

    private int getUShortArg() {
        int n = (Render.mapByteCode[this.IP + 1] & 0xFF) << 8 | Render.mapByteCode[this.IP + 2] & 0xFF;
        this.IP += 2;
        return n;
    }

    private short getShortArg() {
        short s = (short)(Render.mapByteCode[this.IP + 1] << 8 | Render.mapByteCode[this.IP + 2] & 0xFF);
        this.IP += 2;
        return s;
    }

    private int getIntArg() {
        int n = Render.mapByteCode[this.IP + 1] << 24 | (Render.mapByteCode[this.IP + 2] & 0xFF) << 16 | (Render.mapByteCode[this.IP + 3] & 0xFF) << 8 | Render.mapByteCode[this.IP + 4] & 0xFF;
        this.IP += 4;
        return n;
    }

    private void composeLootDialog() {
        Text text = Text.getLargeBuffer();
        if (lootSource != -1) {
            Text.composeTextField(lootSource, text);
            Text.composeText((short)0, (short)129, text);
            lootSource = -1;
        } else {
            Text.composeText((short)0, (short)130, text);
        }
        if (!this.throwAwayLoot) {
            Canvas.showingLoot = true;
            Canvas.setState(8);
        }
        int n = 0;
        int n2 = this.getByteArg();
        int n3 = 0;
        block5: for (int i = 0; i < n2; ++i) {
            short s;
            int n4 = this.getUShortArg();
            int n5 = n4 >> 12 & 0xF;
            if (n5 == 6) {
                s = (short)(n4 & 0xFFF);
                text.append('\u0088');
                Text.composeText(Canvas.loadMapStringID, s, text);
                text.append("|");
                continue;
            }
            if (n5 == 5) {
                s = (short)(n4 & 0xFFF);
                Player.updateQuests(s, 0);
                continue;
            }
            s = (n4 & 0xFC0) >> 6;
            int n6 = n4 & 0x3F;
            ++n;
            if (this.throwAwayLoot) continue;
            if (n5 == 0) {
                if (s == 24) {
                    n3 += n6;
                    continue;
                }
                if (s == 25) {
                    n3 += n6 * 100;
                    continue;
                }
            }
            Text.resetTextArgs();
            Text.addTextArg('\u0088');
            switch (n5) {
                case 0: 
                case 3: {
                    Player.give(n5, s, n6, false);
                    EntityDef entityDef = EntityDef.find(6, n5, s);
                    Text.addTextArg(n6);
                    Text.addTextArg((short)1, entityDef.longName);
                    Text.composeText((short)0, (short)90, text);
                    continue block5;
                }
                case 1: {
                    Player.give(1, s, n6, true);
                    int n7 = s * 9;
                    if (Combat.weapons[n7 + 5] != 0) {
                        Player.give(2, Combat.weapons[n7 + 4], 10, true);
                    }
                    EntityDef entityDef = EntityDef.find(6, n5, s);
                    Text.addTextArg((short)1, entityDef.longName);
                    Text.composeText((short)0, (short)91, text);
                    continue block5;
                }
                case 2: {
                    if (Game.difficulty == 4) continue block5;
                    Player.give(2, s, n6, false);
                    EntityDef entityDef = EntityDef.find(6, n5, s);
                    Text.addTextArg(n6);
                    Text.addTextArg((short)1, entityDef.longName);
                    Text.composeText((short)0, (short)90, text);
                }
            }
        }
        if (n3 != 0) {
            Player.give(0, 24, n3, false);
            Text.resetTextArgs();
            Text.addTextArg('\u0088');
            Text.addTextArg(n3);
            Text.addTextArg((short)1, (short)157);
            Text.composeText((short)0, (short)90, text);
        }
        if (!this.throwAwayLoot) {
            text.setLength(text.length() - 1);
            Canvas.startDialog(this, text, 4, 0, true);
        } else {
            text.setLength(0);
            Text.resetTextArgs();
            Text.addTextArg(n2);
            Text.composeText((short)0, (short)145, text);
            Hud.addMessage(text, 3);
        }
        text.dispose();
        Game.foundLoot(Canvas.viewX + Canvas.viewStepX, Canvas.viewY + Canvas.viewStepY, Canvas.viewZ, n);
    }

    private static final void setAIGoal(Entity entity, int n, int n2) {
        entity.monster.resetGoal();
        entity.monster.goalType = (byte)n;
        if (n == 2 || n == 3) {
            entity.monster.goalParam = 1;
        } else if (n == 4 || n == 6) {
            entity.monster.goalParam = n2;
        }
        if (!Player.noclip) {
            if ((entity.info & 0x40000) == 0) {
                Game.activate(entity, true, false, false, true);
            }
            entity.aiThink(true);
        }
        if (n == 3) {
            entity.monster.goalFlags = (byte)(entity.monster.goalFlags & 0xFFFFFFF7);
            if (Game.combatMonsters != null) {
                Combat.performAttack(Game.combatMonsters, Game.combatMonsters.monster.target, 0, 0, false);
            }
        }
    }

    private static final void corpsifyMonster(int n, int n2, Entity entity, boolean bl) {
        int n3 = entity.getSprite();
        Game.snapLerpSprites(n3);
        entity.monster.resetGoal();
        entity.monster.clearEffects();
        entity.undoAttack();
        Game.deactivate(entity);
        Render.mapSpriteInfo[n3] = Render.mapSpriteInfo[n3] & 0xFFFE00FF | 0x7000;
        Render.mapSprites[Render.S_X + n3] = (short)n;
        Render.mapSprites[Render.S_Y + n3] = (short)n2;
        Render.mapSprites[Render.S_Z + n3] = (short)(Render.getHeight(n, n2) + 32);
        Render.relinkSprite(n3);
        entity.info = entity.info & 0xFFFF | 0x1000000 | 0x20000 | 0x400000;
        entity.def = EntityDef.find(9, entity.def.eSubType, entity.def.parm);
        Game.unlinkEntity(entity);
        Game.linkEntity(entity, n >> 6, n2 >> 6);
        entity.checkMonsterDeath(false, bl);
    }

    private static final void stripInventoryForViosBattle() {
        Player.weaponsCopy = 0;
        Player.ammoCopy[3] = Player.ammo[3];
        Player.ammo[3] = 0;
        if ((Player.weapons & 4) != 0) {
            Player.give(1, 2, -1);
            Player.weaponsCopy |= 4;
        }
        if ((Player.weapons & 0x2000) != 0) {
            Player.give(1, 13, -1);
            Player.weaponsCopy |= 0x2000;
        }
        if ((Player.weapons & 8) != 0) {
            Player.give(1, 3, -1);
            Player.weaponsCopy |= 8;
        } else if ((Player.weapons & 0x10) != 0) {
            Player.give(1, 4, -1);
            Player.weaponsCopy |= 0x10;
        } else if ((Player.weapons & 0x20) != 0) {
            Player.give(1, 5, -1);
            Player.weaponsCopy |= 0x20;
        } else if ((Player.weapons & 0x40) != 0) {
            Player.give(1, 6, -1);
            Player.weaponsCopy |= 0x40;
        }
    }

    public static final void stripInventoryForTargetPractice() {
        Player.currentWeaponCopy = Player.ce.weapon;
        System.arraycopy(Player.ammo, 0, Player.ammoCopy, 0, Player.ammo.length);
        Player.weaponsCopy = Player.weapons & 0xFFFFFFFF;
        for (int i = 0; i < 9; ++i) {
            Player.ammo[i] = 0;
        }
        Player.weapons = 0;
        Player.give(1, 9, 1, true);
        Player.give(2, 1, 8, true);
    }

    public static final void restoreInventory() {
        if ((Player.weapons & 1) != 0) {
            Player.currentWeaponCopy = Player.ce.weapon;
            Player.ammo[3] = Player.ammoCopy[3];
            if ((Player.weaponsCopy & 4) != 0) {
                Player.give(1, 2, 1, true);
            }
            if ((Player.weaponsCopy & 0x2000) != 0) {
                Player.give(1, 13, 1, true);
            }
            if ((Player.weaponsCopy & 8) != 0) {
                short s = Player.ammo[7];
                Player.give(1, 3, 1, true);
                Player.ammo[7] = s;
            } else if ((Player.weaponsCopy & 0x10) != 0) {
                short s = Player.ammo[7];
                Player.give(1, 4, 1, true);
                Player.ammo[7] = s;
            } else if ((Player.weaponsCopy & 0x20) != 0) {
                short s = Player.ammo[7];
                Player.give(1, 5, 1, true);
                Player.ammo[7] = s;
            } else if ((Player.weaponsCopy & 0x40) != 0) {
                short s = Player.ammo[7];
                Player.give(1, 6, 1, true);
                Player.ammo[7] = s;
            }
            ScriptThread.forceRemoveFromScopeZoom();
            Player.selectWeapon(Player.currentWeaponCopy);
            Game.angryVIOS = false;
        } else {
            int n;
            boolean bl = (Player.weaponsCopy & 0x200) != 0;
            for (n = 0; n < 9; ++n) {
                Player.ammo[n] = 0;
                Player.give(2, n, Player.ammoCopy[n], true);
            }
            for (n = 0; n < 15; ++n) {
                int n2 = 1 << n;
                if ((n2 & Player.weaponsCopy) == 0) continue;
                Player.give(1, n, 1, true);
            }
            ScriptThread.forceRemoveFromScopeZoom();
            if (!bl) {
                Player.give(1, 9, -1);
            }
            Player.selectWeapon(Player.currentWeaponCopy);
        }
    }

    private static final void forceRemoveFromScopeZoom() {
        if (Canvas.isZoomedIn) {
            Canvas.zoomTurn = 0;
            Canvas.handleZoomEvents(-6, 15, true);
        }
    }
}

