/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Sound
implements Runnable {
    public static int touchMe = 1;
    public static final int FLAGS_NONE = 0;
    public static final int FLAGS_LOOP = 1;
    public static final int SND_NEG = 0;
    public static final int SND_POS = 1;
    public static final int SND_DYN = 2;
    private static Player soundPlayer;
    public static boolean soundLooped;
    public static boolean soundFormatAllowed;
    public static boolean vibrateEnabled;
    private static boolean allowSounds;
    public static final String SOUND_FORMAT = "audio/midi";
    private static int[] sndIndex;
    private static int activeSound;
    private static Player[] sound;
    private static int iMaxS;
    private static Player music;
    public static boolean loop;
    public static int actual;
    private int doN = -1;
    private static boolean bInProgress;

    public static final boolean startup() {
        try {
            sndIndex = Resource.loadFileIndex("/sounds.idx");
        }
        catch (Exception exception) {
            App.Error(exception, 80);
            return false;
        }
        Sound.setVibrate(true);
        allowSounds = true;
        return true;
    }

    public static boolean isSoundEnabled() {
        return allowSounds;
    }

    public static void setSound(boolean bl) {
        allowSounds = bl;
    }

    public static boolean isVibrateEnabled() {
        return vibrateEnabled;
    }

    public static void setVibrate(boolean bl) {
        vibrateEnabled = bl;
    }

    public static final void startSound(int n) {
        if (!allowSounds) {
            return;
        }
        if (soundLooped && n != 2) {
            return;
        }
        try {
            soundPlayer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (soundLooped) {
                soundPlayer.setLoopCount(-1);
            }
            soundPlayer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getActiveSound() {
        return activeSound;
    }

    public static void resetActiveSound() {
        activeSound = -1;
        if (soundPlayer != null) {
            soundPlayer.deallocate();
            soundPlayer.close();
            soundPlayer = null;
            soundLooped = false;
            System.gc();
        }
    }

    public static final void loadSound(int n, boolean bl) {
        if (!allowSounds || n == activeSound) {
            return;
        }
        if (soundPlayer != null) {
            soundPlayer.deallocate();
            soundPlayer.close();
            soundPlayer = null;
            activeSound = -1;
            soundLooped = false;
            System.gc();
        }
        activeSound = n;
        InputStream inputStream = App.getResourceAsStream("sounds" + sndIndex[n * 3] + ".bin");
        try {
            soundPlayer = Manager.createPlayer((InputStream)inputStream, (String)SOUND_FORMAT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            soundPlayer.realize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            soundPlayer.prefetch();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            soundPlayer.setLoopCount(-1);
        }
        soundLooped = bl;
    }

    public static final void soundStop() {
        Sound.stopAll();
    }

    public static final void clearDynamicSound() {
    }

    public Sound(int n) {
        bInProgress = true;
        this.doN = n;
        try {
            sndIndex = Resource.loadFileIndex("/sounds.idx");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Player load(int n) {
        Player player = null;
        if (n == 0) {
            n = 11;
        } else if (n == 1) {
            n = 13;
        } else if (n == 2) {
            n = 24;
        }
        String string = "sounds" + sndIndex[n * 3] + ".bin";
        try {
            InputStream inputStream = App.getResourceAsStream(string);
            player = Manager.createPlayer((InputStream)inputStream, (String)SOUND_FORMAT);
            player.realize();
        }
        catch (Exception exception) {
            player = null;
        }
        return player;
    }

    public static void playSound(int n) {
        if (n == 5 || n == 6 || n == 4 || n == 3 || n == 2 || n == 15 || n == 17 || n == 18 || n == 19 || n == 21) {
            return;
        }
        loop = false;
        if (bInProgress) {
            return;
        }
        new Thread(new Sound(n)).start();
    }

    public static void playSound(int n, int n2) {
        boolean bl;
        if (n == 5 || n == 6 || n == 4 || n == 3 || n == 2 || n == 15 || n == 17 || n == 18 || n == 19 || n == 21) {
            return;
        }
        boolean bl2 = bl = (n2 & 1) != 0;
        if (bInProgress) {
            return;
        }
        new Thread(new Sound(n)).start();
    }

    public static void play(int n) {
        if (!allowSounds) {
            return;
        }
        if (actual != n) {
            Sound.stopAll();
        }
        if (music == null && (music = Sound.load(n)) == null) {
            return;
        }
        try {
            actual = n;
            music.prefetch();
            if (loop) {
                music.setLoopCount(-1);
            }
            VolumeControl volumeControl = (VolumeControl)music.getControl("VolumeControl");
            volumeControl.setLevel(99);
            music.start();
        }
        catch (Exception exception) {
            music = null;
            actual = -1;
        }
    }

    public void run() {
        try {
            Sound.play(this.doN);
        }
        catch (Exception exception) {
            // empty catch block
        }
        bInProgress = false;
    }

    public static void stopSound() {
        Sound.stopAll();
    }

    public static void stopAll() {
        if (actual == -1) {
            return;
        }
        try {
            music.stop();
            music.deallocate();
            music = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        actual = -1;
    }

    static {
        soundFormatAllowed = true;
        allowSounds = true;
        activeSound = -1;
        iMaxS = -1;
        loop = false;
        actual = -1;
        bInProgress = false;
    }
}

