/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

final class EntityMonster {
    public static int touchMe = 1;
    public static final int GOAL_NONE = 0;
    public static final int GOAL_MOVE = 1;
    public static final int GOAL_MOVETOENTITY = 2;
    public static final int GOAL_FIGHT = 3;
    public static final int GOAL_FLEE = 4;
    public static final int GOAL_EVADE = 5;
    public static final int GOAL_STUN = 6;
    public static final int GFL_LERPING = 1;
    public static final int GFL_SPECIAL = 2;
    public static final int GFL_MOVE2ATTACK = 4;
    public static final int GFL_ATTACK2EVADE = 8;
    public static final int GFL_MOVEAGAIN = 16;
    public static final int GFL_STEALTHMOVE = 32;
    public static final int GFL_RAMBOMOVE = 64;
    public static final int MAX_GOAL_TURNS = 16;
    public CombatEntity ce = new CombatEntity();
    public Entity nextOnList;
    public Entity prevOnList;
    public Entity nextAttacker;
    public Entity target;
    public int frameTime;
    public short flags;
    public int monsterEffects;
    public byte goalType;
    public byte goalFlags;
    public byte goalTurns;
    public int goalX;
    public int goalY;
    public int goalParam;
    public static final int DEFAULT_PAIN_TIME = 250;
    public static final int MFX_COUNT = 5;
    public static final int MFX_POISON = 1;
    public static final int MFX_FREEZE = 2;
    public static final int MFX_RAISE_TIMER = 4;
    public static final int MFX_FIRE = 8;
    public static final int MFX_SHIELD = 16;
    public static final int MFX_MAX = 16;
    public static final int MFX_MASK_ALL = 31;
    public static final int MFX_BITS_PER_COUNT = 4;
    public static final int MFX_POISON_SHIFT = 5;
    public static final int MFX_FREEZE_SHIFT = 9;
    public static final int MFX_RAISE_SHIFT = 13;
    public static final int MFX_FIRE_SHIFT = 17;
    public static final int MFX_SHIELD_SHIFT = 21;
    public static final int MFX_TURN_MASK = 15;
    public static final int MFX_POISON_REMOVE = -482;
    public static final int MFX_FREEZE_REMOVE = -7683;
    public static final int MFX_RAISE_REMOVE = -122885;
    public static final int MFX_FIRE_REMOVE = -1966089;
    public static final int MFX_SHIELD_REMOVE = -31457297;
    public static final int MFX_REMOVE_TURNS = -32737;
    public static final int MFX_ALL_ONE_TURNS = 0x220220;

    EntityMonster() {
    }

    void clearEffects() {
        this.monsterEffects = 0;
    }

    public void reset() {
        this.prevOnList = null;
        this.nextOnList = null;
        this.target = null;
        this.nextAttacker = null;
        this.frameTime = 0;
        this.flags = 0;
        this.monsterEffects = 0;
        this.clearEffects();
        this.resetGoal();
    }

    public void saveGoalState(DataOutputStream dataOutputStream) throws IOException {
        int n = this.goalType | this.goalFlags << 4 | this.goalTurns << 8 | this.goalX << 12 | this.goalY << 17 | this.goalParam << 22;
        dataOutputStream.writeInt(n);
    }

    public void loadGoalState(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        this.goalType = (byte)(n & 0xF);
        this.goalFlags = (byte)(n >> 4 & 0xF);
        this.goalTurns = (byte)(n >> 8 & 0xF);
        this.goalX = n >> 12 & 0x1F;
        this.goalY = n >> 17 & 0x1F;
        this.goalParam = n >> 22 & 0x3FF;
    }

    public void resetGoal() {
        this.goalType = 0;
        this.goalFlags = 0;
        this.goalTurns = 0;
        this.goalY = 0;
        this.goalX = 0;
        this.goalParam = 0;
    }
}

