/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class wlGameCanvas
extends FullCanvas {
    public static final int UP_PRESSED = 2;
    public static final int DOWN_PRESSED = 64;
    public static final int LEFT_PRESSED = 4;
    public static final int RIGHT_PRESSED = 32;
    public static final int FIRE_PRESSED = 256;
    public static final int GAME_A_PRESSED = 512;
    public static final int GAME_B_PRESSED = 1024;
    public static final int GAME_C_PRESSED = 2048;
    public static final int GAME_D_PRESSED = 4096;
    private int keyStates;
    private int releasedKeys;
    private Image bufferedImage;
    private int clipX;
    private int clipY;
    private int clipWidth;
    private int clipHeight;
    private boolean setClip;

    protected wlGameCanvas(boolean suppressKeyEvents) {
        int width = this.getWidth();
        int height = this.getHeight();
        this.bufferedImage = Image.createImage((int)width, (int)height);
    }

    protected Graphics getGraphics() {
        return this.bufferedImage.getGraphics();
    }

    public int getKeyStates() {
        int states = this.keyStates;
        this.keyStates &= ~this.releasedKeys;
        this.releasedKeys = 0;
        return states;
    }

    public void paint(Graphics g2) {
        if (this.setClip) {
            g2.clipRect(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            this.setClip = false;
        }
        g2.drawImage(this.bufferedImage, 0, 0, 20);
    }

    public void flushGraphics(int x, int y, int width, int height) {
        this.setClip = true;
        this.clipX = x;
        this.clipY = y;
        this.clipWidth = width;
        this.clipHeight = height;
        this.repaint();
        this.serviceRepaints();
    }

    public void flushGraphics() {
        this.repaint();
        this.serviceRepaints();
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        if (gameAction != 0) {
            int bit = 1 << gameAction;
            this.keyStates |= bit;
            this.releasedKeys &= ~bit;
        }
        return false;
    }

    protected void keyPressed(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        if (gameAction != 0) {
            int bit = 1 << gameAction;
            this.keyStates |= bit;
            this.releasedKeys &= ~bit;
        }
    }

    public void setFullScreenMode(boolean enable) {
    }

    protected void keyReleased(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        if (gameAction != 0) {
            this.releasedKeys |= 1 << gameAction;
        }
    }
}

