/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.Spacer;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class TireCalc
extends MIDlet
implements CommandListener,
ItemCommandListener,
ItemStateListener {
    private boolean midletPaused = false;
    private TireCalculator standartTire = null;
    private TireCalculator currentTire = null;
    private TireCalculator editedTire = null;
    private TireCalculator tmpTire = null;
    private Form FTireCalc;
    private StringItem standartTSI;
    private StringItem currentTSI;
    private Spacer spacer;
    private StringItem siCurrentD;
    private TextField tfSpeedometerR;
    private StringItem siSpeedometerC;
    private StringItem siStandartD;
    private StringItem siCorrectionFactor;
    private StringItem siClearance;
    private Spacer spacer1;
    private Form FAbout;
    private ImageItem imageItemAbout;
    private StringItem stringItem;
    private StringItem stringItem2;
    private StringItem stringItem3;
    private StringItem stringItem4;
    private Form FParameters;
    private ChoiceGroup widthCG;
    private ChoiceGroup diameterCG;
    private ChoiceGroup ratioCG;
    private ImageItem imgItemTireParam;
    private Form FHelp;
    private StringItem stringItem1;
    private Command exitCommand;
    private Command standartTParamCmd;
    private Command currentTParamCmd;
    private Command aboutCmd;
    private Command backCommand;
    private Command paramCancelCmd;
    private Command paramOkCmd;
    private Command csKochiniUrl;
    private Command helpCommand;
    private Command backCommand1;
    private Image imgTireParam;
    private Image imageAbout;

    private void initialize() {
        this.tmpTire = new TireCalculator();
        this.standartTire = new TireCalculator();
        this.currentTire = new TireCalculator();
        this.standartTire.setTireParams(205, 55, 16);
        this.currentTire.setTireParams(225, 45, 17);
    }

    public void startMIDlet() {
        this.switchDisplayable(null, (Displayable)this.getFTireCalc());
    }

    public void resumeMIDlet() {
    }

    public void switchDisplayable(Alert alert, Displayable nextDisplayable) {
        Display display = this.getDisplay();
        if (alert == null) {
            display.setCurrent(nextDisplayable);
        } else {
            display.setCurrent(alert, nextDisplayable);
        }
    }

    public Form getFTireCalc() {
        if (this.FTireCalc == null) {
            this.FTireCalc = new Form("Tire calculator", new Item[]{this.getStandartTSI(), this.getCurrentTSI(), this.getSpacer(), this.getSiStandartD(), this.getSiCurrentD(), this.getSiClearance(), this.getSiCorrectionFactor(), this.getSpacer1(), this.getTfSpeedometerR(), this.getSiSpeedometerC()});
            this.FTireCalc.addCommand(this.getExitCommand());
            this.FTireCalc.addCommand(this.getAboutCmd());
            this.FTireCalc.addCommand(this.getHelpCommand());
            this.FTireCalc.setCommandListener((CommandListener)this);
            this.FTireCalc.setItemStateListener((ItemStateListener)this);
            this.calculateParameters();
        }
        return this.FTireCalc;
    }

    public StringItem getStandartTSI() {
        if (this.standartTSI == null) {
            this.standartTSI = new StringItem("Standard", null, 2);
            this.standartTSI.addCommand(this.getStandartTParamCmd());
            this.standartTSI.setItemCommandListener((ItemCommandListener)this);
            this.standartTSI.setDefaultCommand(this.getStandartTParamCmd());
        }
        return this.standartTSI;
    }

    public StringItem getCurrentTSI() {
        if (this.currentTSI == null) {
            this.currentTSI = new StringItem("Current", null, 2);
            this.currentTSI.addCommand(this.getCurrentTParamCmd());
            this.currentTSI.setItemCommandListener((ItemCommandListener)this);
            this.currentTSI.setDefaultCommand(this.getCurrentTParamCmd());
        }
        return this.currentTSI;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.FAbout) {
            if (command == this.backCommand) {
                this.switchDisplayable(null, (Displayable)this.getFTireCalc());
            }
        } else if (displayable == this.FHelp) {
            if (command == this.backCommand1) {
                this.switchDisplayable(null, (Displayable)this.getFTireCalc());
            }
        } else if (displayable == this.FParameters) {
            if (command == this.paramCancelCmd) {
                this.switchDisplayable(null, (Displayable)this.getFTireCalc());
            } else if (command == this.paramOkCmd) {
                this.switchDisplayable(null, (Displayable)this.getFTireCalc());
                this.editedTire.setTireParams(this.tmpTire.getTireParams());
                this.calculateParameters();
            }
        } else if (displayable == this.FTireCalc) {
            if (command == this.aboutCmd) {
                this.switchDisplayable(null, (Displayable)this.getFAbout());
            } else if (command == this.exitCommand) {
                this.exitMIDlet();
            } else if (command == this.helpCommand) {
                this.switchDisplayable(null, (Displayable)this.getFHelp());
            }
        }
    }

    public Command getExitCommand() {
        if (this.exitCommand == null) {
            this.exitCommand = new Command("Exit", 7, 0);
        }
        return this.exitCommand;
    }

    public void commandAction(Command command, Item item) {
        if (item == this.currentTSI) {
            if (command == this.currentTParamCmd) {
                this.switchDisplayable(null, (Displayable)this.getFParameters());
                this.setParametersForm(this.currentTire);
            }
        } else if (item == this.standartTSI && command == this.standartTParamCmd) {
            this.switchDisplayable(null, (Displayable)this.getFParameters());
            this.setParametersForm(this.standartTire);
        }
    }

    public Command getStandartTParamCmd() {
        if (this.standartTParamCmd == null) {
            this.standartTParamCmd = new Command("Standard tire parameters", 1, 0);
        }
        return this.standartTParamCmd;
    }

    public Command getCurrentTParamCmd() {
        if (this.currentTParamCmd == null) {
            this.currentTParamCmd = new Command("Current tire parameters", 1, 0);
        }
        return this.currentTParamCmd;
    }

    public Spacer getSpacer() {
        if (this.spacer == null) {
            this.spacer = new Spacer(16, 1);
            this.spacer.setLayout(16896);
        }
        return this.spacer;
    }

    public Command getAboutCmd() {
        if (this.aboutCmd == null) {
            this.aboutCmd = new Command("About", 1, 0);
        }
        return this.aboutCmd;
    }

    public Form getFAbout() {
        if (this.FAbout == null) {
            this.FAbout = new Form("About Tire Calculator", new Item[]{this.getImageItemAbout(), this.getStringItem3(), this.getStringItem(), this.getStringItem4(), this.getStringItem2()});
            this.FAbout.addCommand(this.getBackCommand());
            this.FAbout.setCommandListener((CommandListener)this);
        }
        return this.FAbout;
    }

    public Command getBackCommand() {
        if (this.backCommand == null) {
            this.backCommand = new Command("Back", 2, 0);
        }
        return this.backCommand;
    }

    public ImageItem getImageItemAbout() {
        if (this.imageItemAbout == null) {
            this.imageItemAbout = new ImageItem("", this.getImageAbout(), 16899, "<Missing Image>");
        }
        return this.imageItemAbout;
    }

    public Image getImgTireParam() {
        if (this.imgTireParam == null) {
            try {
                this.imgTireParam = Image.createImage((String)"/tire-param-2.png");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.imgTireParam;
    }

    public Form getFParameters() {
        if (this.FParameters == null) {
            this.FParameters = new Form("Tire parameters", new Item[]{this.getImgItemTireParam(), this.getWidthCG(), this.getRatioCG(), this.getDiameterCG()});
            this.FParameters.addCommand(this.getParamOkCmd());
            this.FParameters.addCommand(this.getParamCancelCmd());
            this.FParameters.setCommandListener((CommandListener)this);
            this.FParameters.setItemStateListener((ItemStateListener)this);
            this.getImgTireParam();
            int scrWidth = this.FParameters.getWidth();
            if (this.FParameters.getWidth() < this.imgTireParam.getWidth()) {
                float factor = (float)scrWidth / (float)this.imgTireParam.getWidth();
                this.imgTireParam = Resizer.resizeImage(this.imgTireParam, factor, 0);
            }
            this.imgItemTireParam.setImage(this.imgTireParam);
        }
        return this.FParameters;
    }

    public ChoiceGroup getWidthCG() {
        if (this.widthCG == null) {
            this.widthCG = new ChoiceGroup("Width", 4);
            this.widthCG.append("225", null);
            this.widthCG.setLayout(16384);
            this.widthCG.setSelectedFlags(new boolean[]{false});
            TireParameter tp = new TireParameter();
            tp.fillWidth(this.widthCG, 0);
        }
        return this.widthCG;
    }

    public ChoiceGroup getRatioCG() {
        if (this.ratioCG == null) {
            this.ratioCG = new ChoiceGroup("Ratio", 4);
            this.ratioCG.append("45", null);
            this.ratioCG.setLayout(16384);
            this.ratioCG.setSelectedFlags(new boolean[]{false});
            TireParameter tp = new TireParameter();
            tp.fillRatio(this.ratioCG, 0);
        }
        return this.ratioCG;
    }

    public ChoiceGroup getDiameterCG() {
        if (this.diameterCG == null) {
            this.diameterCG = new ChoiceGroup("Diameter", 4);
            this.diameterCG.append("17", null);
            this.diameterCG.setLayout(16384);
            this.diameterCG.setSelectedFlags(new boolean[]{false});
            TireParameter tp = new TireParameter();
            tp.fillDiameter(this.diameterCG, 0);
        }
        return this.diameterCG;
    }

    public Command getParamOkCmd() {
        if (this.paramOkCmd == null) {
            this.paramOkCmd = new Command("Ok", 4, 0);
        }
        return this.paramOkCmd;
    }

    public Command getParamCancelCmd() {
        if (this.paramCancelCmd == null) {
            this.paramCancelCmd = new Command("Cancel", 3, 0);
        }
        return this.paramCancelCmd;
    }

    public StringItem getStringItem() {
        if (this.stringItem == null) {
            this.stringItem = new StringItem("Author: ", "Michael Kochiashvili");
            this.stringItem.setLayout(512);
        }
        return this.stringItem;
    }

    public StringItem getStringItem2() {
        if (this.stringItem2 == null) {
            this.stringItem2 = new StringItem("May, 2011", null);
            this.stringItem2.setLayout(512);
        }
        return this.stringItem2;
    }

    public Command getCsKochiniUrl() {
        if (this.csKochiniUrl == null) {
            this.csKochiniUrl = new Command("Go to URL", "Go to www.kochini.com", 8, 0);
        }
        return this.csKochiniUrl;
    }

    public StringItem getSiStandartD() {
        if (this.siStandartD == null) {
            this.siStandartD = new StringItem("Standard tire diameter: ", null, 0);
            this.siStandartD.setLayout(512);
        }
        return this.siStandartD;
    }

    public StringItem getSiCurrentD() {
        if (this.siCurrentD == null) {
            this.siCurrentD = new StringItem("Current tire diameter: ", null);
            this.siCurrentD.setLayout(0);
        }
        return this.siCurrentD;
    }

    public TextField getTfSpeedometerR() {
        if (this.tfSpeedometerR == null) {
            this.tfSpeedometerR = new TextField("If your speedometer reads (speed, distance)", "100", 7, 5);
            this.tfSpeedometerR.setLayout(0);
            this.tfSpeedometerR.setPreferredSize(-1, -1);
        }
        return this.tfSpeedometerR;
    }

    public StringItem getSiSpeedometerC() {
        if (this.siSpeedometerC == null) {
            this.siSpeedometerC = new StringItem("You're going ", "109");
            this.siSpeedometerC.setLayout(0);
        }
        return this.siSpeedometerC;
    }

    public ImageItem getImgItemTireParam() {
        if (this.imgItemTireParam == null) {
            this.imgItemTireParam = new ImageItem("", null, 515, "<Missing Image>");
        }
        return this.imgItemTireParam;
    }

    public Image getImageAbout() {
        if (this.imageAbout == null) {
            try {
                this.imageAbout = Image.createImage((String)"/icon-5-1-2.png");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.imageAbout;
    }

    public StringItem getSiCorrectionFactor() {
        if (this.siCorrectionFactor == null) {
            this.siCorrectionFactor = new StringItem("Speed, distance correction factor: ", null);
            this.siCorrectionFactor.setLayout(512);
        }
        return this.siCorrectionFactor;
    }

    public StringItem getSiClearance() {
        if (this.siClearance == null) {
            this.siClearance = new StringItem("Clearance: ", null);
            this.siClearance.setLayout(512);
        }
        return this.siClearance;
    }

    public Form getFHelp() {
        if (this.FHelp == null) {
            this.FHelp = new Form("Tire calculator help", new Item[]{this.getStringItem1()});
            this.FHelp.addCommand(this.getBackCommand1());
            this.FHelp.setCommandListener((CommandListener)this);
        }
        return this.FHelp;
    }

    public Command getHelpCommand() {
        if (this.helpCommand == null) {
            this.helpCommand = new Command("Help", 5, 0);
        }
        return this.helpCommand;
    }

    public Command getBackCommand1() {
        if (this.backCommand1 == null) {
            this.backCommand1 = new Command("Back", 2, 0);
        }
        return this.backCommand1;
    }

    public StringItem getStringItem1() {
        if (this.stringItem1 == null) {
            this.stringItem1 = new StringItem("", "Use the calculator to see what happens to your speedometer reading when you change the size of your tires and wheels.\n\nTo compare tire sizes, first select your vehicle standard tire size. Then select tire sizes to compare to your standard size.");
        }
        return this.stringItem1;
    }

    public Spacer getSpacer1() {
        if (this.spacer1 == null) {
            this.spacer1 = new Spacer(16, 5);
        }
        return this.spacer1;
    }

    public StringItem getStringItem3() {
        if (this.stringItem3 == null) {
            this.stringItem3 = new StringItem("Version: ", this.getAppProperty("MIDlet-Version"));
            this.stringItem3.setLayout(512);
        }
        return this.stringItem3;
    }

    public StringItem getStringItem4() {
        if (this.stringItem4 == null) {
            this.stringItem4 = new StringItem("Site: ", "www.kochini.com");
            this.stringItem4.setLayout(512);
        }
        return this.stringItem4;
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void exitMIDlet() {
        this.switchDisplayable(null, null);
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void startApp() {
        if (this.midletPaused) {
            this.resumeMIDlet();
        } else {
            this.initialize();
            this.startMIDlet();
        }
        this.midletPaused = false;
    }

    public void pauseApp() {
        this.midletPaused = true;
    }

    public void destroyApp(boolean unconditional) {
    }

    public void calculateParameters() {
        if (this.standartTire.valid()) {
            this.standartTSI.setText(this.standartTire.toString());
        } else {
            this.standartTSI.setText("Not defined");
        }
        if (this.currentTire.valid()) {
            this.currentTSI.setText(this.currentTire.toString());
        } else {
            this.currentTSI.setText("Not defined");
        }
        String calcInfo = "";
        if (!this.standartTire.valid()) {
            calcInfo = "Standart tire not defined";
        }
        if (!this.currentTire.valid()) {
            calcInfo = calcInfo.length() > 1 ? "Standart an Current tires not defined" : "Current tire not defined";
        }
        if (this.standartTire.valid() && this.currentTire.valid()) {
            double correction = this.standartTire.compareDistance(this.currentTire);
            int radiusDiffMM = (int)Math.floor((double)(this.currentTire.DiameterMM() - this.standartTire.DiameterMM()) / 2.0);
            String sign = "";
            if (radiusDiffMM > 0) {
                sign = "+";
            }
            double correction3 = (double)((int)((correction + 5.0E-4) * 1000.0)) / 1000.0;
            String correctionS = String.valueOf(correction3);
            double correction2 = (double)((int)((correction * 100.0 + 0.005) * 100.0)) / 100.0;
            String speed100S = String.valueOf(correction2);
            double standartDiameterInch = (double)((int)((this.standartTire.DiameterInch() + 0.005) * 100.0)) / 100.0;
            this.getSiStandartD().setText(Integer.toString(this.standartTire.DiameterMM()) + "mm, " + String.valueOf(standartDiameterInch) + "\"");
            double currentDiameterInch = (double)((int)((this.currentTire.DiameterInch() + 0.005) * 100.0)) / 100.0;
            this.getSiCurrentD().setText(Integer.toString(this.currentTire.DiameterMM()) + "mm, " + String.valueOf(currentDiameterInch) + "\"");
            this.siCorrectionFactor.setText(correctionS);
            this.siClearance.setText(sign + Integer.toString(radiusDiffMM) + "mm");
            this.calcActualSpeed();
        }
    }

    private void calcActualSpeed() {
        double speed = 0.0;
        try {
            speed = Double.valueOf(this.tfSpeedometerR.getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        double correction = this.standartTire.compareDistance(this.currentTire);
        double actualSpeed = speed * correction;
        actualSpeed = (double)((int)((actualSpeed + 0.005) * 100.0)) / 100.0;
        this.siSpeedometerC.setText(String.valueOf(actualSpeed));
    }

    private void setParametersForm(TireCalculator TC) {
        this.editedTire = TC;
        if (TC == this.standartTire) {
            this.FParameters.setTitle("Standard tire parameters");
        } else {
            this.FParameters.setTitle("Current tire parameters");
        }
        this.tmpTire.setTireParams(TC.getTireParams());
        TireParameter tp = new TireParameter();
        tp.setValue(this.widthCG, TC.width);
        tp.setValue(this.ratioCG, TC.ratio);
        tp.setValue(this.diameterCG, TC.wdiameter);
        tp = null;
    }

    public void itemStateChanged(Item item) {
        TireParameter tp = new TireParameter();
        if (item == this.widthCG) {
            this.tmpTire.width = tp.getValue(this.widthCG);
        } else if (item == this.ratioCG) {
            this.tmpTire.ratio = tp.getValue(this.ratioCG);
        } else if (item == this.diameterCG) {
            this.tmpTire.wdiameter = tp.getValue(this.diameterCG);
        } else if (item == this.tfSpeedometerR) {
            this.calcActualSpeed();
        }
        tp = null;
    }
}

