/*
 * Decompiled with CFR 0.152.
 */
public class TireCalculator {
    public int width = 0;
    public int ratio = 0;
    public int wdiameter = 0;

    public TireCalculator(int aWidth, int aRatio, int aDiameter) {
        this.width = aWidth;
        this.ratio = aRatio;
        this.wdiameter = aDiameter;
    }

    public TireCalculator() {
        this.reset();
    }

    public void reset() {
        this.width = 0;
        this.ratio = 0;
        this.wdiameter = 0;
    }

    public int[] getTireParams() {
        int[] aP = new int[]{this.width, this.ratio, this.wdiameter};
        return aP;
    }

    public void setTireParams(int aWidth, int aRatio, int aDiameter) {
        this.width = aWidth;
        this.ratio = aRatio;
        this.wdiameter = aDiameter;
    }

    public void setTireParams(int[] paramArr) {
        this.width = paramArr[0];
        this.ratio = paramArr[1];
        this.wdiameter = paramArr[2];
    }

    public boolean valid() {
        return this.width > 0 && this.ratio > 0 && this.wdiameter > 0;
    }

    public String toString() {
        String s = "Not set";
        if (this.valid()) {
            s = this.width + "/" + this.ratio + " R" + this.wdiameter;
        }
        return s;
    }

    public double DiameterInch() {
        if (this.valid()) {
            return (double)(2 * this.width) * ((double)this.ratio * 0.01) / 25.4 + (double)this.wdiameter;
        }
        return 0.0;
    }

    public int DiameterMM() {
        if (this.valid()) {
            return (int)Math.floor(this.DiameterInch() / 0.039370079);
        }
        return 0;
    }

    public double compareDistance(TireCalculator tc) {
        if (this.valid() && tc.valid()) {
            return Math.PI * tc.DiameterInch() / (Math.PI * this.DiameterInch());
        }
        return 1.0;
    }
}

