/*
 * Decompiled with CFR 0.152.
 */
import com.dvidearts.jengine.CustomFont;
import com.dvidearts.jengine.MyScreen;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PauseScreen
extends MyScreen {
    private Game game;
    Image imgControls;
    static final byte PS_Y_SPACING = 2;
    static final byte PO_RESUME = 0;
    static final byte PO_STATUS = 1;
    static final byte PO_CONTROLS = 2;
    static final byte PO_MISSION = 3;
    static final byte PO_TITLE = 4;
    static final byte PO_END = 5;
    static final byte PO_TOTAL = 6;
    public boolean isActive;
    public boolean showStatus;
    public boolean showControls;
    public short cursor;
    private int nameY;
    private byte exit;
    public static final byte EXIT_TITLE = 1;
    public static final byte EXIT_MISSION = 2;
    public static final byte EXIT_DEMO = 3;

    public PauseScreen(Game midlet) {
        this.game = midlet;
        this.isActive = false;
        this.cursor = 0;
        switch (this.game.buildType) {
            case 2: {
                this.nameY = this.game.y + this.game.cfont.getHeight() * 3;
                break;
            }
            case 0: 
            case 1: {
                this.nameY = this.game.y + this.game.cfont.getHeight() * 5;
            }
        }
        this.Load();
        this.exit = 0;
    }

    public void Load() {
        try {
            this.imgControls = Image.createImage((String)(Game.DATA_PATH + "controls.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Free() {
        this.imgControls = null;
        this.isActive = false;
    }

    public void Show() {
        this.game.popup.setMinWidth(this.game.resw - this.game.FONTW);
        this.cursor = 0;
        this.isActive = true;
        this.showStatus = false;
        this.showControls = false;
        this.game.cmdY = (short)(this.game.y + this.game.render.getOriginalResHeight() - this.game.COMMANDH);
    }

    public void Hide() {
        this.isActive = false;
        this.showStatus = false;
        this.showControls = false;
    }

    public void Render(Graphics g) {
        if (this.exit > 0) {
            switch (this.exit) {
                case 2: {
                    if (this.game.sinfo[this.game.infoSlot].currlevel == 13) {
                        this.game.loader.Start((byte)1);
                        break;
                    }
                    this.game.loader.Start((byte)5);
                    break;
                }
                case 1: {
                    this.game.loader.Start((byte)1);
                    break;
                }
                case 3: {
                    this.game.loader.Start((byte)8);
                }
            }
            this.game.LoadSettings();
            return;
        }
        this.game.popup.drawBackground = true;
        this.game.popup.drawBorder = true;
        this.game.popup.center = true;
        g.drawImage(this.game.imgBg, this.game.wcenter - this.game.imgBg.getWidth() / 2, this.game.hcenter - this.game.imgBg.getHeight() / 2, 20);
        this.game.sprTextbar.setPosition(this.game.x, this.game.y);
        this.game.sprTextbar.paint(g);
        this.game.sprTextbar.setPosition(this.game.x, this.game.y + this.game.render.getOriginalResHeight() - this.game.sprTextbar.getHeight());
        this.game.sprTextbar.paint(g);
        if (this.showStatus) {
            this.drawStatus(g);
            return;
        }
        if (this.showControls) {
            this.drawControls(g);
            return;
        }
        this.game.sprOptions.setFrame(4);
        this.game.sprOptions.setPosition(this.game.wcenter - this.game.sprOptions.getWidth() / 2, this.game.y + this.game.sprTextbar.getHeight() / 2);
        this.game.sprOptions.paint(g);
        this.game.cfont.drawStringCentered(g, Text.txtRESUME, this.nameY + this.game.cfont.getHeight() * 1, this.game.wcenter);
        this.game.cfont.drawStringCentered(g, Text.txtSTATUS, this.nameY + this.game.cfont.getHeight() * 3, this.game.wcenter);
        this.game.cfont.drawStringCentered(g, Text.txtCONTROLS, this.nameY + this.game.cfont.getHeight() * 5, this.game.wcenter);
        this.game.cfont.drawStringCentered(g, Text.txtQUITTOMISSION, this.nameY + this.game.cfont.getHeight() * 7, this.game.wcenter);
        this.game.cfont.drawStringCentered(g, Text.txtQUITTOTITLE, this.nameY + this.game.cfont.getHeight() * 9, this.game.wcenter);
        this.game.cfont.drawStringCentered(g, Text.txtENDGAME, this.nameY + this.game.cfont.getHeight() * 11, this.game.wcenter);
        if (!this.game.popup.isActive && this.game.currframe % 10 != 0) {
            switch (this.cursor) {
                case 0: {
                    this.game.cfont2.drawStringCentered(g, Text.txtRESUME, this.nameY + this.game.cfont2.getHeight() * 1, this.game.wcenter);
                    break;
                }
                case 1: {
                    this.game.cfont2.drawStringCentered(g, Text.txtSTATUS, this.nameY + this.game.cfont2.getHeight() * 3, this.game.wcenter);
                    break;
                }
                case 2: {
                    this.game.cfont2.drawStringCentered(g, Text.txtCONTROLS, this.nameY + this.game.cfont2.getHeight() * 5, this.game.wcenter);
                    break;
                }
                case 3: {
                    this.game.cfont2.drawStringCentered(g, Text.txtQUITTOMISSION, this.nameY + this.game.cfont2.getHeight() * 7, this.game.wcenter);
                    break;
                }
                case 4: {
                    this.game.cfont2.drawStringCentered(g, Text.txtQUITTOTITLE, this.nameY + this.game.cfont2.getHeight() * 9, this.game.wcenter);
                    break;
                }
                case 5: {
                    this.game.cfont2.drawStringCentered(g, Text.txtENDGAME, this.nameY + this.game.cfont2.getHeight() * 11, this.game.wcenter);
                }
            }
        }
        this.game.showFPS(g);
    }

    public void drawControls(Graphics g) {
        CustomFont c2 = this.game.cfont;
        int yp = this.game.y + this.game.sprTextbar.getHeight();
        int spacer = 0;
        int amount = 3;
        g.drawImage(this.imgControls, this.game.wcenter - this.imgControls.getWidth() / 2, yp + (spacer += amount), 20);
        c2.drawStringCentered(g, " Change Players:    1", yp + this.imgControls.getHeight() + (spacer += amount) + c2.getHeight() * 1, this.game.wcenter);
        c2.drawStringCentered(g, " Power Up:          0", yp + this.imgControls.getHeight() + (spacer += amount) + c2.getHeight() * 2, this.game.wcenter);
        if (!this.game.popup.isActive) {
            this.game.drawCommand(g, (byte)3, (byte)0);
        }
        this.game.showFPS(g);
    }

    public void drawStatus(Graphics g) {
        int xp = this.game.x + this.game.smallfont.getWidth();
        int yp = this.game.y + this.game.render.getOriginalResHeight() - this.game.sprTextbar.getHeight() - this.game.sprCharacters.getHeight();
        if (this.game.buildType != 2) {
            this.game.sprCharacters.setPosition(this.game.x + this.game.resw - this.game.sprCharacters.getWidth(), yp);
            this.game.sprCharacters.setFrame(0);
            this.game.sprCharacters.paint(g);
        }
        CustomFont c2 = this.game.smallfont;
        int spacer = 3;
        yp = this.game.y + this.game.sprTextbar.getHeight() + c2.getHeight();
        c2.drawString(g, " Score:             " + this.game.sinfo[this.game.infoSlot].score, xp, yp);
        c2.drawString(g, " Max Health:        " + this.game.sinfo[this.game.infoSlot].maxHealth + " (" + 170 + " Max)", xp, yp += spacer + c2.getHeight());
        c2.drawString(g, " Destruction Time:  " + this.game.sinfo[this.game.infoSlot].destructionMaxTime + " (" + 160 + " Max)", xp, yp += spacer + c2.getHeight());
        c2.drawString(g, " Shotgun Power:     " + this.game.sinfo[this.game.infoSlot].shotgunDamage + " (" + 70 + " Max)", xp, yp += spacer + c2.getHeight());
        c2.drawString(g, " Tech-Taser Damage: " + this.game.sinfo[this.game.infoSlot].taserDamage + " (" + 60 + " Max)", xp, yp += spacer + c2.getHeight());
        c2.drawString(g, " Stealth Wait:      " + this.game.sinfo[this.game.infoSlot].stealthMaxTime + " (" + 40 + " Min)", xp, yp += spacer + c2.getHeight());
        c2.drawString(g, " Deaths:            " + (this.game.sinfo[this.game.infoSlot].numDeaths + this.game.tempNumDeaths), xp, yp += spacer + c2.getHeight());
        c2.drawString(g, " Hostages Captued:  " + (this.game.sinfo[this.game.infoSlot].totalHostages + this.game.newHostages), xp, yp += spacer + c2.getHeight());
        c2.drawString(g, " Hostages Broken:   " + this.game.sinfo[this.game.infoSlot].hostagesBroken, xp, yp += spacer + c2.getHeight());
        c2.drawString(g, " Hostages Killed:   " + this.game.sinfo[this.game.infoSlot].hostagesKilled, xp, yp += spacer + c2.getHeight());
        c2.drawString(g, " Objects Destroyed: " + this.game.sinfo[this.game.infoSlot].numObjectsDestroyed, xp, yp += spacer + c2.getHeight());
        c2.drawString(g, " Guards Killed:     " + this.game.sinfo[this.game.infoSlot].numGuardsKilled, xp, yp += spacer + c2.getHeight());
        c2.drawString(g, " Stealth Kills:     " + this.game.sinfo[this.game.infoSlot].stealthKills, xp, yp += spacer + c2.getHeight());
        c2.drawString(g, " Explosion Kills:   " + this.game.sinfo[this.game.infoSlot].explosionKills, xp, yp += spacer + c2.getHeight());
        c2.drawString(g, " Taser Kills:       " + this.game.sinfo[this.game.infoSlot].taserKills, xp, yp += spacer + c2.getHeight());
        yp += spacer + c2.getHeight();
        if (this.game.buildType == 2) {
            c2.drawString(g, " Time Played:", xp, yp);
            c2.drawString(g, "  " + this.game.getTimePlayed(), xp, yp += spacer + c2.getHeight());
        } else {
            c2.drawString(g, " Time Played:       " + this.game.getTimePlayed(), xp, yp);
        }
        if (!this.game.popup.isActive) {
            this.game.drawCommand(g, (byte)3, (byte)0);
        }
        this.game.showFPS(g);
    }

    public void keyReleased(int gameAction) {
        if (this.showStatus || this.showControls) {
            switch (this.game.render.getInput()) {
                case '*': {
                    this.doNext();
                    break;
                }
                case '0': {
                    break;
                }
            }
            switch (gameAction) {
                case 8: {
                    this.doNext();
                }
            }
            return;
        }
        if (!this.isActive) {
            return;
        }
        if (this.game.popup.isActive) {
            int result = this.game.popup.keyPressed(gameAction);
            this.game.popup.getClass();
            if (result == 1) {
                switch (this.cursor) {
                    case 3: {
                        this.exit = (byte)2;
                        break;
                    }
                    case 4: {
                        this.exit = 1;
                        break;
                    }
                    case 5: {
                        if (this.game.isDemo) {
                            this.exit = (byte)3;
                            break;
                        }
                        this.game.close();
                    }
                }
            } else {
                this.game.popup.getClass();
                if (result == 0) {
                    // empty if block
                }
            }
            switch (gameAction) {
                default: 
            }
            return;
        }
        switch (gameAction) {
            case 1: {
                this.cursor = (short)(this.cursor - 1);
                if (this.cursor >= 0) break;
                this.cursor = (short)5;
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.cursor = (short)(this.cursor + 1);
                if (this.cursor < 6) break;
                this.cursor = 0;
                break;
            }
            case 8: {
                this.doNext();
            }
        }
        switch (this.game.render.getInput()) {
            case '*': {
                break;
            }
            case '0': {
                break;
            }
        }
    }

    void doNext() {
        switch (this.cursor) {
            case 0: {
                this.Hide();
                break;
            }
            case 1: {
                if (this.showStatus) {
                    this.showStatus = false;
                    break;
                }
                this.showStatus = true;
                break;
            }
            case 2: {
                if (this.showControls) {
                    this.showControls = false;
                    break;
                }
                this.showControls = true;
                break;
            }
            case 3: {
                this.game.popup.clearText();
                this.game.popup.addLineText(" ");
                this.game.popup.addLineText(Text.txtQUITTOMISSION);
                this.game.popup.confirm(Text.txtYES, Text.txtNO);
                break;
            }
            case 4: {
                this.game.popup.clearText();
                this.game.popup.addLineText(" ");
                this.game.popup.addLineText(Text.txtQUIT);
                this.game.popup.confirm(Text.txtYES, Text.txtNO);
                break;
            }
            case 5: {
                this.game.popup.clearText();
                this.game.popup.addLineText(" ");
                this.game.popup.addLineText(Text.txtENDGAMEQUESTION);
                this.game.popup.confirm(Text.txtYES, Text.txtNO);
            }
        }
    }

    public void Process(int gameAction) {
        switch (this.game.render.getInput()) {
            case '*': {
                break;
            }
            case '0': {
                break;
            }
        }
        if (gameAction == 0) {
            return;
        }
        switch (gameAction) {
            case 6: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                break;
            }
        }
    }

    public void keyPressed(int arg0) {
    }

    public void commandAction(Command arg0, Displayable arg1) {
    }
}

