/*
 * Decompiled with CFR 0.152.
 */
import com.dvidearts.jengine.MyColor;
import com.dvidearts.jengine.MyScreen;
import com.dvidearts.jengine.MySprite;
import com.dvidearts.jengine.Utils;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TitleScreen
extends MyScreen {
    private Game game;
    private Image imgTitle;
    private MySprite sprFlag;
    private boolean playedExplode;
    short cursor;
    int optionsYp;
    int arrowYp;
    private static final byte CURSOR_NEWGAME = 0;
    private static final byte CURSOR_LOADGAME = 1;
    private static final byte CURSOR_OPTIONS = 2;
    private static final byte CURSOR_EXIT = 3;
    static final byte NUM_OPTIONS = 4;
    public KeyboardScreen keyboardscreen;
    public ManageGamesScreen managegamesscreen;
    public OptionsScreen optionsscreen;
    public byte exit;
    public static final byte EXIT_DEMO = 1;

    public TitleScreen(Game g) {
        this.game = g;
        this.exit = 0;
        this.playedExplode = false;
        this.Load();
        this.reset();
    }

    public void Load() {
        try {
            this.sprFlag = new MySprite(Image.createImage((String)(Game.DATA_PATH + this.game.dpath + "usflag.png")), this.game.FLAGW, this.game.FLAGH);
            this.sprFlag.setPosition(this.game.wcenter - this.sprFlag.getWidth() / 2, this.game.height / 20 * 13);
            this.imgTitle = Image.createImage((String)(Game.DATA_PATH + this.game.dpath + "title.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.keyboardscreen = new KeyboardScreen(this.game);
        this.keyboardscreen.Load();
        this.managegamesscreen = new ManageGamesScreen(this.game);
        this.managegamesscreen.Load();
        this.optionsscreen = new OptionsScreen(this.game);
        this.optionsscreen.Load();
    }

    public void Free() {
        this.imgTitle = null;
        this.sprFlag.free();
        this.sprFlag = null;
        this.keyboardscreen.Free();
        this.keyboardscreen = null;
        this.managegamesscreen.Free();
        this.managegamesscreen = null;
        this.optionsscreen.Free();
        this.optionsscreen = null;
    }

    public void reset() {
        this.game.resh = this.game.render.getOriginalResHeight();
        this.game.popup.setMinWidth(this.game.width - this.game.FONTW);
        this.game.popup.setPosition(this.game.popup.getMinWidth() / (this.game.FONTW / 2), this.game.y + this.game.FONTW / 2);
        this.game.popup.center = true;
        this.game.wipe.reset();
        this.game.cmdY = (short)(this.game.y + this.game.render.getOriginalResHeight() - this.game.COMMANDH);
        this.optionsYp = (short)(this.game.height / 20 * 15);
        this.arrowYp = this.optionsYp + this.game.sprOptions.getHeight() + this.game.height / 50;
        this.cursor = 0;
        if (this.game.haveSavedData) {
            for (int r = 0; r < 3; ++r) {
                if (this.game.sinfo[r] == null || this.game.sinfo[r].name == null || this.game.sinfo[r].name.length() <= 0) continue;
                this.cursor = 1;
                break;
            }
        }
    }

    public void Render(Graphics g) {
        this.game.render.ClearScreen(g, 0, 0, 0);
        if (this.exit > 0) {
            switch (this.exit) {
                case 1: {
                    this.game.loader.Start((byte)8);
                }
            }
            return;
        }
        if (this.keyboardscreen.isActive) {
            this.keyboardscreen.Render(g);
            return;
        }
        if (this.managegamesscreen.isActive) {
            this.managegamesscreen.Render(g);
            return;
        }
        if (this.optionsscreen.isActive) {
            this.optionsscreen.Render(g);
            return;
        }
        if (!this.playedExplode) {
            this.playedExplode = true;
        }
        g.drawImage(this.imgTitle, this.game.wcenter - this.imgTitle.getWidth() / 2, this.game.hcenter - this.imgTitle.getHeight() / 2, 20);
        this.sprFlag.nextFrame();
        this.sprFlag.paint(g);
        this.game.sprOptions.setPosition(this.game.wcenter - this.game.sprOptions.getWidth() / 2, this.optionsYp);
        switch (this.cursor) {
            case 0: {
                this.game.sprOptions.setFrame(0);
                break;
            }
            case 1: {
                this.game.sprOptions.setFrame(1);
                break;
            }
            case 2: {
                this.game.sprOptions.setFrame(2);
                break;
            }
            case 3: {
                this.game.sprOptions.setFrame(3);
            }
        }
        if (this.game.currframe / 2 % this.game.render.getMaxFramesPerSecond() != 0) {
            this.game.sprArrow.setFrame(0);
            this.game.sprArrow.setPosition(this.game.wcenter - this.game.sprArrow.getWidth() / 2, this.arrowYp);
            this.game.sprArrow.paint(g);
        }
        if (this.game.buildType != 2) {
            Utils.drawTextbox(g, this.game.strToSelect, this.game.smallfont, (byte)1, (byte)2, this.game.reswc, this.game.y + this.game.resh, MyColor.BLACK, MyColor.WHITE, 4);
        }
        this.game.sprOptions.paint(g);
        this.game.wipe.paint(g);
        if (this.game.wipe.isComplete()) {
            this.game.wipe.reset();
            this.doNext();
        }
        this.game.showFPS(g);
    }

    public void keyReleased(int gameAction) {
        if (this.game.wipe.IsActive() || this.exit > 0) {
            return;
        }
        if (this.keyboardscreen.isActive) {
            this.keyboardscreen.keyReleased(gameAction);
            return;
        }
        if (this.managegamesscreen.isActive) {
            this.managegamesscreen.keyReleased(gameAction);
            return;
        }
        if (this.optionsscreen.isActive) {
            this.optionsscreen.keyReleased(gameAction);
            return;
        }
        switch (gameAction) {
            case 6: {
                this.cursor = (short)(this.cursor + 1);
                if (this.cursor < 4) break;
                this.cursor = 0;
                break;
            }
            case 1: {
                this.cursor = (short)(this.cursor - 1);
                if (this.cursor >= 0) break;
                this.cursor = (short)3;
                break;
            }
            case 8: {
                this.game.wipe.BlindsOut((short)6);
            }
        }
        switch (this.game.render.getInput()) {
            case '*': {
                break;
            }
            case '0': {
                break;
            }
        }
    }

    public void doNext() {
        switch (this.cursor) {
            case 0: {
                int numSaved = 0;
                for (int i2 = 0; i2 < 3; i2 = (int)((byte)(i2 + 1))) {
                    if (this.game.sinfo[i2].name.trim().length() <= 0) continue;
                    numSaved = (byte)(numSaved + 1);
                }
                if (numSaved >= 3) {
                    this.managegamesscreen.mode = 1;
                    this.managegamesscreen.Show();
                    break;
                }
                this.keyboardscreen.Show();
                break;
            }
            case 1: {
                this.managegamesscreen.mode = 0;
                this.managegamesscreen.Show();
                break;
            }
            case 2: {
                this.optionsscreen.Show();
                break;
            }
            case 3: {
                if (this.game.isDemo) {
                    this.exit = 1;
                    break;
                }
                this.game.close();
            }
        }
    }

    public void Process(int arg0) {
    }

    public void commandAction(Command arg0, Displayable arg1) {
    }

    public void keyPressed(int arg0) {
    }
}

