/*
 * Decompiled with CFR 0.152.
 */
package com.dvidearts.jengine;

import com.dvidearts.jengine.CustomFont;
import com.dvidearts.jengine.MySprite;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Popup {
    private short x;
    private short y;
    private short maxw;
    private short maxh;
    private short minw;
    private short minh;
    private short width;
    private short height;
    private short r;
    private short g;
    private short b;
    private short br;
    private short bg;
    private short bb;
    private short cr;
    private short cg;
    private short cb;
    private short counter;
    private short ticks;
    private byte cursor;
    private Vector v;
    private boolean isFlashing;
    private boolean isConfirm;
    private boolean isConfirmButtons;
    private boolean isWaitForKeypress;
    private byte yesNoBorderSpacing = (byte)6;
    private byte line_spacing = (byte)2;
    private byte top_margin = (byte)4;
    private byte bottom_margin = (byte)2;
    private byte side_margins = (byte)2;
    private byte waitForKeyPressDelay = (byte)8;
    private boolean showcursor = false;
    private CustomFont cfont = null;
    private CustomFont altfont = null;
    private String yesText = "";
    private String noText = "";
    private int confirmY;
    private int noX;
    private int noW;
    private int yesX;
    private int yesW;
    private int maxLength;
    public boolean center = false;
    public boolean drawBackground = true;
    public boolean drawBorder = true;
    public boolean isActive = false;
    private int yesframe;
    private int noframe;
    public final byte C_NO;
    public final byte C_YES;
    public final byte KEYPRESSED;
    private Image imgHBorder;
    private Image imgVBorder;
    private MySprite sprButton;
    private MySprite sprCursor;

    public Popup(int iMaxWidth, int iMaxHeight) {
        this.C_NO = 0;
        this.C_YES = 1;
        this.KEYPRESSED = 1;
        this.setBackgroundColor(0, 0, 0);
        this.setBorderColor(128, 128, 128);
        this.setCursorColor(255, 0, 0);
        this.setMaxWidth(iMaxWidth);
        this.setMaxHeight(iMaxHeight);
        this.showCursor(true);
        this.center = true;
        this.v = new Vector();
        this.width = 0;
        this.height = 0;
        this.reset();
        this.imgHBorder = null;
        this.imgVBorder = null;
        this.sprButton = null;
        this.sprCursor = null;
        this.yesframe = 0;
        this.noframe = 0;
    }

    public void setButtons(MySprite sButton, MySprite sCursor) {
        this.sprButton = sButton;
        this.sprCursor = sCursor;
    }

    public void setTopBorderImage(Image horizontalBorder) {
        this.imgHBorder = horizontalBorder;
    }

    public void setSideBorderImage(Image verticalBorder) {
        this.imgVBorder = verticalBorder;
    }

    public void setCursorDefault(byte YesOrNo) {
        this.cursor = YesOrNo;
    }

    public void setFont(CustomFont cf) {
        this.cfont = cf;
    }

    public void setAltFont(CustomFont cf) {
        this.altfont = cf;
    }

    public void showCursor(boolean val) {
        this.showcursor = val;
    }

    public void setMaxWidth(int iw) {
        this.maxw = (short)iw;
    }

    public void setMaxHeight(int ih) {
        this.maxh = (short)ih;
    }

    public void setMinWidth(int iw) {
        this.minw = (short)iw;
    }

    public void setMinHeight(int ih) {
        this.minh = (short)ih;
    }

    public short getWidth() {
        return this.width;
    }

    public short getHeight() {
        return this.height;
    }

    public short getMinWidth() {
        return this.minw;
    }

    public short getMinHeight() {
        return this.minh;
    }

    public void setPosition(int ix, int iy) {
        this.x = (short)ix;
        this.y = (short)iy;
    }

    public short getX() {
        return this.x;
    }

    public short getY() {
        return this.y;
    }

    public void setYesNoBorderSpacing(int size) {
        this.yesNoBorderSpacing = (byte)size;
    }

    public void setLineSpacing(int size) {
        this.line_spacing = (byte)size;
    }

    public void setTopMargin(int size) {
        this.top_margin = (byte)size;
    }

    public void setBottomMargin(int size) {
        this.bottom_margin = (byte)size;
    }

    public void setSideMargins(int size) {
        this.side_margins = (byte)size;
    }

    public short getCounter() {
        return this.counter;
    }

    public byte getKeyPressDelay() {
        return this.waitForKeyPressDelay;
    }

    public void setBackgroundColor(int ir, int ig, int ib) {
        this.r = (short)ir;
        this.g = (short)ig;
        this.b = (short)ib;
    }

    public void setCursorColor(int ir, int ig, int ib) {
        this.cr = (short)ir;
        this.cg = (short)ig;
        this.cb = (short)ib;
    }

    public void setBorderColor(int ir, int ig, int ib) {
        this.br = (short)ir;
        this.bg = (short)ig;
        this.bb = (short)ib;
    }

    public void clearText() {
        this.v.removeAllElements();
        this.width = 0;
        this.height = 0;
    }

    public void reset() {
        this.counter = 0;
        this.ticks = 0;
        this.isActive = false;
        this.isFlashing = false;
        this.isConfirm = false;
        this.isConfirmButtons = false;
        this.isWaitForKeypress = false;
        this.cursor = 0;
        this.yesText = "";
        this.noText = "";
        this.maxLength = 0;
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            LineText lt = (LineText)e.nextElement();
            if (lt == null || lt.text == null || lt.text.length() <= this.maxLength) continue;
            this.maxLength = lt.text.length();
        }
    }

    public void flash(int time) {
        if (this.cfont == null) {
            return;
        }
        if (this.isFlashing) {
            return;
        }
        this.reset();
        this.isFlashing = true;
        this.ticks = (short)time;
        this.isActive = true;
    }

    public void addLineText(String txt) {
        this.addLineText(txt, false);
    }

    public void addLineText(String txt, boolean leftJustify) {
        LineText lt = new LineText(txt, leftJustify);
        this.v.addElement(lt);
    }

    public void confirm(String YES_TEXT, String NO_TEXT) {
        if (this.cfont == null) {
            return;
        }
        this.reset();
        this.yesText = YES_TEXT;
        this.noText = NO_TEXT;
        this.isConfirm = true;
        this.isActive = true;
    }

    public void confirm(int yesFrame, int noFrame) {
        if (this.cfont == null) {
            return;
        }
        this.reset();
        this.yesframe = yesFrame;
        this.noframe = noFrame;
        this.isConfirmButtons = true;
        this.isActive = true;
    }

    public void waitForKeypress() {
        if (this.cfont == null) {
            return;
        }
        this.reset();
        this.isWaitForKeypress = true;
        this.isActive = true;
    }

    public int keyPressed(int code) {
        block13: {
            block12: {
                if (this.cfont == null || !this.isActive) {
                    return -1;
                }
                if (!this.isConfirm && (!this.isConfirmButtons || this.sprButton == null)) break block12;
                switch (code) {
                    case 2: 
                    case 6: {
                        this.cursor = (byte)(this.cursor - 1);
                        if (this.cursor < 0) {
                            this.cursor = 1;
                            break;
                        }
                        break block13;
                    }
                    case 1: 
                    case 5: {
                        this.cursor = (byte)(this.cursor + 1);
                        if (this.cursor > 1) {
                            this.cursor = 0;
                            break;
                        }
                        break block13;
                    }
                    case 8: {
                        byte selected = this.cursor;
                        this.reset();
                        return selected;
                    }
                }
                break block13;
            }
            if (this.isWaitForKeypress && this.counter >= this.waitForKeyPressDelay) {
                switch (code) {
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 8: {
                        this.reset();
                        return 1;
                    }
                }
            }
        }
        return -1;
    }

    public void update() {
        if (this.cfont == null || !this.isActive) {
            return;
        }
        if (this.isFlashing) {
            this.counter = (short)(this.counter + 1);
            if (this.counter > this.ticks) {
                this.counter = this.ticks;
                this.isActive = false;
                this.isFlashing = false;
            }
        } else if (this.isConfirm || this.isConfirmButtons && this.sprButton != null) {
            this.counter = (short)(this.counter + 1);
            if (this.counter > 5) {
                this.counter = 0;
            }
        } else if (this.isWaitForKeypress) {
            this.counter = (short)(this.counter + 1);
            if (this.counter > this.waitForKeyPressDelay) {
                this.counter = this.waitForKeyPressDelay;
            }
        }
    }

    public void draw(Graphics gr, int screenX, int screenY, int screenWidth, int screenHeight) {
        int i2;
        int numTiles;
        int py;
        int px;
        if (this.cfont == null || !this.isActive) {
            return;
        }
        int pw = this.cfont.getWidth() * this.maxLength + this.side_margins * 2;
        if (pw < this.minw) {
            pw = this.minw;
        }
        if (pw > this.maxw) {
            pw = this.maxw;
        }
        int ph = this.v.size() * (this.cfont.getHeight() + this.line_spacing) + this.top_margin + this.bottom_margin;
        if (this.isConfirm) {
            ph += this.cfont.getHeight() * 2;
            ph += this.yesNoBorderSpacing;
        } else if (this.isConfirmButtons && this.sprButton != null) {
            ph += this.sprButton.getHeight() + this.cfont.getHeight();
        }
        if (ph < this.minh) {
            ph = this.minh;
        }
        if (ph > this.maxh) {
            ph = this.maxh;
        }
        if (this.center) {
            px = screenX + screenWidth / 2 - pw / 2;
            py = screenY + screenHeight / 2 - ph / 2;
        } else {
            px = this.x;
            py = this.y;
        }
        if (this.drawBackground) {
            gr.setColor((int)this.r, (int)this.g, (int)this.b);
            gr.fillRect(px, py, pw, ph);
        }
        if (this.imgVBorder != null) {
            numTiles = ph / this.imgVBorder.getHeight();
            i2 = 0;
            while (i2 < numTiles) {
                gr.drawImage(this.imgVBorder, px, py + i2 * this.imgVBorder.getHeight(), 20);
                gr.drawImage(this.imgVBorder, px + pw - this.imgVBorder.getWidth(), py + i2 * this.imgVBorder.getHeight(), 20);
                ++i2;
            }
            gr.drawImage(this.imgVBorder, px, py + ph - this.imgVBorder.getHeight(), 20);
            gr.drawImage(this.imgVBorder, px + pw - this.imgVBorder.getWidth(), py + ph - this.imgVBorder.getHeight(), 20);
        }
        if (this.imgHBorder != null) {
            numTiles = pw / this.imgHBorder.getWidth();
            i2 = 0;
            while (i2 < numTiles) {
                gr.drawImage(this.imgHBorder, px + i2 * this.imgHBorder.getWidth(), py, 20);
                gr.drawImage(this.imgHBorder, px + i2 * this.imgHBorder.getWidth(), py + ph, 20);
                ++i2;
            }
            gr.drawImage(this.imgHBorder, px + pw - this.imgHBorder.getWidth(), py, 20);
            gr.drawImage(this.imgHBorder, px + pw - this.imgHBorder.getWidth(), py + ph, 20);
        }
        if (this.drawBorder) {
            gr.setColor((int)this.br, (int)this.bg, (int)this.bb);
            gr.drawRect(px, py, pw, ph);
        }
        this.x = (short)px;
        this.y = (short)py;
        this.width = (short)pw;
        this.height = (short)ph;
        int newY = py + this.top_margin;
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            LineText lt = (LineText)e.nextElement();
            if (lt.leftJustify) {
                this.cfont.drawString(gr, lt.text, px + this.side_margins, newY);
            } else {
                this.cfont.drawString(gr, lt.text, px + pw / 2 - this.cfont.stringWidth(lt.text) / 2, newY);
            }
            newY += this.cfont.getHeight() + this.line_spacing;
        }
        if (this.isConfirm) {
            String temp = "";
            temp = String.valueOf(this.yesText) + " " + this.noText;
            this.yesX = px + pw / 2 - this.cfont.stringWidth(temp) / 2;
            this.confirmY = newY + this.cfont.getHeight();
            this.cfont.drawString(gr, temp, this.yesX, this.confirmY);
            temp = String.valueOf(this.yesText) + " ";
            this.noX = this.yesX + this.cfont.stringWidth(temp);
            temp = this.yesText;
            this.yesW = this.cfont.stringWidth(temp);
            temp = this.noText;
            this.noW = this.cfont.stringWidth(temp);
            if (this.counter > 1) {
                if (this.showcursor) {
                    gr.setColor((int)this.cr, (int)this.cg, (int)this.cb);
                }
                switch (this.cursor) {
                    case 1: {
                        if (this.showcursor) {
                            gr.drawRect(this.yesX - this.yesNoBorderSpacing / 2, this.confirmY - this.yesNoBorderSpacing / 2, this.yesW + this.yesNoBorderSpacing / 2 + 1, this.cfont.getHeight() + this.yesNoBorderSpacing);
                        }
                        if (this.altfont == null) break;
                        this.altfont.drawString(gr, this.yesText, this.yesX, this.confirmY);
                        break;
                    }
                    case 0: {
                        if (this.showcursor) {
                            gr.drawRect(this.noX - this.yesNoBorderSpacing / 2, this.confirmY - this.yesNoBorderSpacing / 2, this.noW + this.yesNoBorderSpacing / 2 + 1, this.cfont.getHeight() + this.yesNoBorderSpacing);
                        }
                        if (this.altfont == null) break;
                        this.altfont.drawString(gr, this.noText, this.noX, this.confirmY);
                    }
                }
            }
            temp = null;
        } else if (this.isConfirmButtons && this.sprButton != null) {
            int centerofpopup = px + pw / 2;
            short spacer = this.cfont.getWidth();
            this.yesX = centerofpopup - spacer / 2 - this.sprButton.getWidth();
            this.noX = centerofpopup + spacer / 2;
            this.confirmY = newY + this.cfont.getHeight();
            this.sprButton.setFrame(this.yesframe);
            this.sprButton.setPosition(this.yesX, this.confirmY);
            this.sprButton.paint(gr);
            this.sprButton.setFrame(this.noframe);
            this.sprButton.setPosition(this.noX, this.confirmY);
            this.sprButton.paint(gr);
            if (this.sprCursor != null) {
                this.sprCursor.nextFrame();
                switch (this.cursor) {
                    case 1: {
                        this.sprCursor.setPosition(this.yesX + this.sprButton.getWidth() / 2 - this.sprCursor.getWidth() / 2, this.confirmY + this.sprButton.getHeight() / 2 - this.sprCursor.getHeight() / 2);
                        break;
                    }
                    case 0: {
                        this.sprCursor.setPosition(this.noX + this.sprButton.getWidth() / 2 - this.sprCursor.getWidth() / 2, this.confirmY + this.sprButton.getHeight() / 2 - this.sprCursor.getHeight() / 2);
                    }
                }
                this.sprCursor.paint(gr);
            }
        }
    }

    private class LineText {
        public String text;
        public boolean leftJustify;

        public LineText(String txt, boolean lJustify) {
            if (txt == null) {
                txt = "";
            }
            this.text = txt;
            this.leftJustify = lJustify;
        }
    }
}

