/*
 * Decompiled with CFR 0.152.
 */
import com.dvidearts.jengine.MyColor;
import com.dvidearts.jengine.MyPoint;
import com.dvidearts.jengine.Utils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Guard
extends Object {
    Game game;
    private byte mAnimation;
    private byte damage;
    public short animate;
    public short health;
    public short maxhealth;
    public short shotDelayCounter;
    public short shotDelay;
    public short captureTimer;
    public short helpCounter;
    public boolean dead;
    public boolean inSight;
    public boolean firing;
    public boolean shocked;
    public boolean explode;
    public boolean showBones;
    public Blood blood;
    public MyPoint ptStart;
    public MyPoint ptTarget;
    public byte id;
    public byte state;
    public byte direction;
    public byte targetID;
    public Patrol patrol;
    public short counter;
    public short chaseCounter;
    public short healthBarCounter;
    public short points;
    public static final short MAX_WAIT_TIME = 270;
    public static final byte PAUSE_TIME = 22;
    public static final byte SHOW_HEALTH_TIME = 50;
    public static final short ALARM_TIME = 100;
    private static final byte PAUSE_AT_POINT_TIME = 50;
    private int WALK_SPEED;
    public static final byte STATE_PATROL = 0;
    public static final byte STATE_ALERT = 1;
    public static final byte STATE_ATTACK = 2;
    public static final byte STATE_INVESTIGATE = 3;
    public static final byte STATE_RETURNTOPOST = 4;
    public static final byte STATE_FOUNDNOTHING = 5;
    public static final byte STATE_DEAD = 6;
    public static final byte STATE_STUNNED = 7;
    public static final byte STATE_HEAR = 8;
    public static final byte STATE_SETALARM = 9;
    public static final byte ANIM_STAND = 0;
    public static final byte ANIM_RUNLEFT = 1;
    public static final byte ANIM_RUNRIGHT = 2;
    public static final byte ANIM_RUNUP = 3;
    public static final byte ANIM_RUNDOWN = 4;
    public static final byte ANIM_FIRE_DOWN = 5;
    public static final byte ANIM_FIRE_UP = 6;
    public static final byte ANIM_FIRE_LEFT = 7;
    public static final byte ANIM_FIRE_RIGHT = 8;
    public static final byte ANIM_DEATH = 9;
    public static final short[] FRAMES_STAND = new short[]{0};
    public static final short[] FRAMES_RUNRIGHT = new short[]{6, 7, 6, 8};
    public static final short[] FRAMES_RUNLEFT = new short[]{11, 10, 11, 9};
    public static final short[] FRAMES_RUNUP = new short[]{3, 4, 3, 5};
    public static final short[] FRAMES_RUNDOWN = new short[]{0, 1, 0, 2};
    public static final short[] FRAMES_FIRE_DOWN = new short[]{12};
    public static final short[] FRAMES_FIRE_UP = new short[]{13};
    public static final short[] FRAMES_FIRE_RIGHT = new short[]{14};
    public static final short[] FRAMES_FIRE_LEFT = new short[]{15};
    public static final short[] FRAMES_DEATH = new short[]{16};
    public static final byte TALKTYPE_GIVEUP = 0;
    public static final byte TALKTYPE_SEEPLAYER = 1;
    public static final byte TALKTYPE_FOUNDNOTHING = 2;
    public static final byte TALKTYPE_QUESTION = 3;
    public static final byte TALKTYPE_HELP = 4;
    public static final byte TALKTYPE_STEALTH = 5;
    public static final byte TALKTYPE_HEAR = 6;
    public static final byte WEAPON_PISTOL = 0;
    public static final byte WEAPON_SHOTGUN = 1;
    public static final byte WEAPON_MGUN = 2;
    public static final byte WEAPON_ROCKET = 3;

    public Guard(Game g, byte ID, Image[] img, int x2, int y2, Patrol paramPatrol) {
        super(img);
        this.game = g;
        this.id = ID;
        this.targetID = 0;
        this.reset();
        this.patrol = new Patrol();
        this.patrol.copy(paramPatrol);
        this.ptStart = new MyPoint();
        this.ptStart.set(x2, y2);
        this.ptTarget = new MyPoint();
        this.blood = new Blood(6);
        this.sortOffset = (short)(this.sprite.getHeight() / 3);
        this.WALK_SPEED = 2;
        switch (this.id) {
            case 3: {
                this.damage = (byte)5;
                this.points = (short)200;
                this.shotDelay = this.game.PISTOL_DELAY;
                this.maxhealth = (short)100;
                break;
            }
            case 7: {
                this.damage = (byte)5;
                this.points = (short)300;
                this.shotDelay = (short)(this.game.PISTOL_DELAY - 1);
                this.maxhealth = (short)110;
                break;
            }
            case 8: {
                this.damage = (byte)5;
                this.points = (short)400;
                this.shotDelay = (short)(this.game.PISTOL_DELAY - 3);
                this.maxhealth = (short)130;
                break;
            }
            case 6: {
                this.damage = (byte)5;
                this.points = (short)500;
                this.shotDelay = (short)(this.game.PISTOL_DELAY - 5);
                this.maxhealth = (short)140;
                break;
            }
            case 5: {
                this.damage = (byte)6;
                this.points = (short)600;
                this.shotDelay = (short)(this.game.PISTOL_DELAY - 6);
                this.maxhealth = (short)155;
                break;
            }
            case 4: {
                this.damage = (byte)5;
                this.points = (short)700;
                this.shotDelay = (short)7;
                this.maxhealth = (short)170;
                break;
            }
            case 13: {
                this.damage = (byte)20;
                this.points = (short)800;
                this.shotDelay = (short)(this.game.PISTOL_DELAY + 6);
                this.maxhealth = (short)190;
            }
        }
        int iw = this.sprite.getWidth() / 10 * 4;
        int ih = this.sprite.getHeight() / 10;
        this.sprite.defineCollisionRectangle(iw, ih * 8, -iw, -(ih / 2));
        this.sprite.setOffset(this.game.x - this.sprite.getWidth() / 2, this.game.y - this.sprite.getHeight());
        this.setAnimation((byte)0);
        this.moveto(this.ptStart);
        this.health = this.maxhealth;
        int dist = 0;
        switch (this.patrol.type) {
            case 0: {
                this.patrol.point[0].set(this.ptStart.x, this.ptStart.y);
                break;
            }
            case 1: {
                dist = this.game.TILE_SIZE * 2;
                switch (this.patrol.orgDirection) {
                    case 0: 
                    case 1: {
                        this.patrol.point[0].x = this.ptStart.x;
                        this.patrol.point[0].y = this.ptStart.y - dist;
                        this.patrol.point[1].x = this.ptStart.x;
                        this.patrol.point[1].y = this.ptStart.y + dist;
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.patrol.point[0].x = this.ptStart.x - dist;
                        this.patrol.point[0].y = this.ptStart.y;
                        this.patrol.point[1].x = this.ptStart.x + dist;
                        this.patrol.point[1].y = this.ptStart.y;
                    }
                }
                this.patrol.currpoint = (short)Utils.RandNum(0, 1);
                this.moveto(this.patrol.point[this.patrol.currpoint]);
                break;
            }
            case 2: {
                dist = this.game.TILE_SIZE * this.patrol.areaSize;
                this.patrol.point[0].x = this.ptStart.x + dist - this.game.TILE_SIZE;
                this.patrol.point[0].y = this.ptStart.y - dist + this.game.TILE_SIZE;
                this.patrol.point[1].x = this.ptStart.x - this.game.TILE_SIZE;
                this.patrol.point[1].y = this.ptStart.y - dist + this.game.TILE_SIZE;
                this.patrol.point[2].x = this.ptStart.x - this.game.TILE_SIZE;
                this.patrol.point[2].y = this.ptStart.y;
                this.patrol.point[3].x = this.ptStart.x + dist - this.game.TILE_SIZE;
                this.patrol.point[3].y = this.ptStart.y;
                this.patrol.currpoint = this.game.sinfo[this.game.infoSlot].currlevel == 2 ? (short)0 : (short)Utils.RandNum(0, 3);
                this.moveto(this.patrol.point[this.patrol.currpoint]);
            }
        }
        this.OnPatrol();
    }

    public void reset() {
        this.setAnimation((byte)0);
        this.health = this.maxhealth;
        this.explode = false;
        this.animate = 0;
        this.counter = 0;
        this.dead = false;
        this.inSight = false;
        this.firing = false;
        this.mAnimation = (byte)-1;
        this.shotDelayCounter = 0;
        this.state = 0;
        this.shocked = false;
        this.active = true;
        this.showBones = false;
        this.burned = true;
        this.helpCounter = 0;
    }

    public void free() {
        super.free();
        this.ptTarget = null;
        this.ptStart = null;
        if (this.patrol != null) {
            this.patrol.free();
            this.patrol = null;
        }
        if (this.blood != null) {
            this.blood.free();
            this.blood = null;
        }
    }

    public boolean track(MyPoint p, int speed, boolean nextFrame) {
        boolean withGuard;
        short cellid;
        boolean moving = false;
        boolean testForCollsion = false;
        if (this.state == 2 || this.state == 3 || this.state == 5 || this.state == 9 || this.state == 8 || this.state == 4) {
            testForCollsion = true;
        }
        if (this.state == 4 && (this.chaseCounter = (short)(this.chaseCounter + 1)) >= 270) {
            this.chaseCounter = (short)270;
            testForCollsion = false;
        }
        int tx = this.ptWorld.x;
        int ty = this.ptWorld.y;
        if (p.x < this.ptWorld.x) {
            moving = true;
            this.ptWorld.x = this.ptWorld.x - p.x < speed ? (int)((short)p.x) : (this.ptWorld.x -= speed);
            if (!this.firing) {
                this.setAnimation((byte)1);
            }
            if (testForCollsion) {
                super.update(this.game, this.game.playscreen.world);
                cellid = this.game.playscreen.world.groundMap.getCell(this.game.playscreen.world.groundMap.getColumn(this.ptWorld.x), this.game.playscreen.world.groundMap.getRow(this.ptWorld.y + this.sprite.colh));
                withGuard = false;
                if (this.game.playscreen.world.collideSolid(cellid, this, true) || withGuard) {
                    this.ptWorld.x = tx;
                    this.game.playscreen.world.translate();
                    super.update(this.game, this.game.playscreen.world);
                }
            }
        } else if (p.x > this.ptWorld.x) {
            moving = true;
            this.ptWorld.x = p.x - this.ptWorld.x < speed ? (int)((short)p.x) : (this.ptWorld.x += speed);
            if (!this.firing) {
                this.setAnimation((byte)2);
            }
            if (testForCollsion) {
                super.update(this.game, this.game.playscreen.world);
                cellid = this.game.playscreen.world.groundMap.getCell(this.game.playscreen.world.groundMap.getColumn(this.ptWorld.x), this.game.playscreen.world.groundMap.getRow(this.ptWorld.y + this.sprite.colh));
                withGuard = false;
                if (this.game.playscreen.world.collideSolid(cellid, this, true) || withGuard) {
                    this.ptWorld.x = tx;
                    this.game.playscreen.world.translate();
                    super.update(this.game, this.game.playscreen.world);
                }
            }
        }
        if (p.y < this.ptWorld.y) {
            this.ptWorld.y = this.ptWorld.y - p.y < speed ? (int)((short)p.y) : (this.ptWorld.y -= speed);
            if (!moving && !this.firing) {
                this.setAnimation((byte)3);
            }
            if (testForCollsion) {
                super.update(this.game, this.game.playscreen.world);
                cellid = this.game.playscreen.world.groundMap.getCell(this.game.playscreen.world.groundMap.getColumn(this.ptWorld.x), this.game.playscreen.world.groundMap.getRow(this.ptWorld.y + this.sprite.colh));
                withGuard = false;
                if (this.game.playscreen.world.collideSolid(cellid, this, true) || withGuard) {
                    this.ptWorld.y = ty;
                    this.game.playscreen.world.translate();
                    super.update(this.game, this.game.playscreen.world);
                }
            }
        } else if (p.y > this.ptWorld.y) {
            this.ptWorld.y = p.y - this.ptWorld.y < speed ? (int)((short)p.y) : (this.ptWorld.y += speed);
            if (!moving && !this.firing) {
                this.setAnimation((byte)4);
            }
            if (testForCollsion) {
                super.update(this.game, this.game.playscreen.world);
                cellid = this.game.playscreen.world.groundMap.getCell(this.game.playscreen.world.groundMap.getColumn(this.ptWorld.x), this.game.playscreen.world.groundMap.getRow(this.ptWorld.y + this.sprite.colh));
                withGuard = false;
                if (this.game.playscreen.world.collideSolid(cellid, this, true) || withGuard) {
                    this.ptWorld.y = ty;
                    this.game.playscreen.world.translate();
                    super.update(this.game, this.game.playscreen.world);
                }
            }
        }
        if (nextFrame) {
            this.sprite.nextFrame();
        }
        if (this.ptWorld.getDistance(p.x, p.y, true) <= speed) {
            this.ptWorld.set(p.x, p.y);
            return true;
        }
        return false;
    }

    public void update(Game game, World world) {
        super.update(game, world);
        if (this.captureTimer > 0) {
            this.captureTimer = (short)(this.captureTimer - 1);
            if (this.captureTimer <= 0) {
                this.captureTimer = 0;
                this.setAnimation((byte)9);
            }
        }
        if (game.popup.isActive || this.shocked) {
            return;
        }
        this.move(world);
        this.animate = (short)(this.animate + 1);
        if (this.animate > 1) {
            this.animate = 0;
        }
        if (this.health <= 0) {
            this.health = 0;
            if (!this.dead) {
                this.healthBarCounter = 0;
                this.state = (byte)6;
                this.setAnimation((byte)9);
                this.dead = true;
                game.sinfo[game.infoSlot].numGuardsKilled = (short)(game.sinfo[game.infoSlot].numGuardsKilled + 1);
                game.sinfo[game.infoSlot].score += (long)this.points;
                if (this.showBones) {
                    game.sinfo[game.infoSlot].score += 100L;
                } else if (this.id != 13 && Utils.RandNum(0, 3) == 0) {
                    this.captureTimer = (short)200;
                    this.setAnimation((byte)0);
                }
            }
            return;
        }
        if (this.state == 9) {
            return;
        }
        if (this.state == 2 || this.state == 1) {
            this.seePlayer(game.playscreen.world.player[this.targetID]);
        } else if (!this.seePlayer(game.playscreen.world.player[game.playscreen.world.currplayer]) && this.onscreen && (this.state == 0 || this.state == 5) && game.playscreen.world.player[game.playscreen.world.currplayer].health > 0 && !game.playscreen.world.player[game.playscreen.world.currplayer].stealth && game.playscreen.world.player[game.playscreen.world.currplayer].moving && this.ptWorld.getDistance(game.playscreen.world.player[game.playscreen.world.currplayer].ptWorld.x, game.playscreen.world.player[game.playscreen.world.currplayer].ptWorld.y, true) <= game.TILE_SIZE / 2 * 5) {
            this.targetID = game.playscreen.world.player[game.playscreen.world.currplayer].id;
            this.state = (byte)8;
            this.counter = 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void OnPatrol() {
        block21: {
            switch (this.patrol.type) {
                case 0: {
                    switch (this.patrol.state) {
                        case 0: {
                            switch (this.patrol.orgDirection) {
                                case 0: {
                                    this.setAnimation((byte)3);
                                    break;
                                }
                                case 1: {
                                    this.setAnimation((byte)4);
                                    break;
                                }
                                case 2: {
                                    this.setAnimation((byte)1);
                                    break;
                                }
                                case 3: {
                                    this.setAnimation((byte)2);
                                }
                            }
                            this.sprite.setFrame(0);
                            return;
                        }
                        case 1: {
                            if (!this.track(this.patrol.point[0], this.WALK_SPEED, this.game.currframe % 3 == 0)) break;
                            this.patrol.state = 0;
                            this.counter = 0;
                            this.state = 0;
                        }
                    }
                    return;
                }
                case 1: 
                case 2: {
                    switch (this.patrol.state) {
                        case 0: {
                            this.sprite.setFrame(0);
                            if (this.counter < 50) return;
                            this.counter = 0;
                            this.patrol.state = 1;
                            this.patrol.currpoint = (short)(this.patrol.currpoint + 1);
                            if (this.patrol.type == 2 && this.patrol.currpoint >= 4 || this.patrol.type == 1 && this.patrol.currpoint >= 2) {
                                this.patrol.currpoint = 0;
                            }
                            this.ptTarget.set(this.patrol.point[this.patrol.currpoint].x, this.patrol.point[this.patrol.currpoint].y);
                            break block21;
                        }
                        case 1: {
                            if (!this.track(this.ptTarget, this.WALK_SPEED, this.game.currframe % 3 == 0)) return;
                            this.patrol.state = 0;
                            this.counter = 0;
                            this.state = 0;
                        }
                    }
                }
            }
        }
    }

    public void helpCall() {
        for (int i2 = 0; i2 < this.game.playscreen.world.numGuards; ++i2) {
            if (this == this.game.playscreen.world.guard[i2] || !this.game.playscreen.world.guard[i2].onscreen || this.game.playscreen.world.guard[i2].state != 0 || this.game.playscreen.world.guard[i2].shocked || this.ptWorld.getDistance(this.game.playscreen.world.guard[i2].ptWorld.x, this.game.playscreen.world.guard[i2].ptWorld.y, true) >= this.game.TILE_SIZE * 4) continue;
            this.talk((byte)4);
            this.game.playscreen.world.guard[i2].state = 1;
            this.game.playscreen.world.guard[i2].targetID = this.targetID;
            this.game.playscreen.world.guard[i2].chaseCounter = 0;
            this.game.playscreen.world.guard[i2].counter = (short)2;
        }
    }

    public void draw(Graphics g) {
        if (this.onscreen && this.health > 0 && this.game.playscreen.world.poweredUp && this.game.playscreen.world.player[this.game.playscreen.world.currplayer].id == 1 && this != this.game.playscreen.world.alarmguard && this.game.playscreen.world.player[this.game.playscreen.world.currplayer].ptWorld.getDistance(this.ptWorld.x, this.ptWorld.y, true) < this.game.TILE_SIZE * 2) {
            this.health = (short)(this.health - 15);
            this.healthBarCounter = (short)100;
            if (this.health <= 0) {
                this.showBones = true;
            }
            if (this.state != 9 && this.state != 2 && this.state != 1) {
                this.startAlert((byte)1);
            }
        }
        if (this.healthBarCounter > 0) {
            this.healthBarCounter = (short)(this.healthBarCounter - 1);
            if (this.captureTimer <= 0) {
                Utils.drawProgress(g, this.ptScreen.x, this.ptScreen.y, this.sprite.getWidth(), this.sprite.getHeight() / 6, this.health, this.maxhealth, MyColor.BLACK, MyColor.RED, MyColor.WHITE);
            }
        }
        if (this.shocked && !this.dead) {
            this.firing = false;
            this.game.playscreen.world.sprShock.setPosition(this.ptScreen.x + this.sprite.getWidth() / 2 - this.game.playscreen.world.sprShock.getWidth() / 2, this.ptScreen.y);
            this.game.playscreen.world.sprShock.paint(g);
            if (this.game.currframe % 2 == 0) {
                this.game.playscreen.world.sprShock.nextFrame();
            }
            if (this.explode) {
                this.health = (short)(this.health - 4);
                this.healthBarCounter = (short)100;
                if (this.health <= 0) {
                    this.showBones = true;
                    this.shocked = false;
                    MyPoint p = new MyPoint();
                    p.set(this.ptWorld.x, this.ptWorld.y - this.sprite.getHeight() / 2);
                    this.game.playscreen.world.startExplode(p);
                    this.helpCall();
                    this.game.sinfo[this.game.infoSlot].taserKills = (short)(this.game.sinfo[this.game.infoSlot].taserKills + 1);
                }
            }
            return;
        }
        if (!this.onscreen) {
            return;
        }
        int x2 = this.ptScreen.x + this.sprite.getWidth() / 2 - this.game.playscreen.world.sprReaction.getWidth() / 2;
        int y2 = this.ptScreen.y - this.game.playscreen.world.sprReaction.getHeight() / 10 * 7;
        if (this.showBones && this.dead && this.game.showBlood) {
            g.drawImage(this.game.playscreen.world.imgBones, this.sprite.getX() + this.sprite.getXOffset(), this.sprite.getY() + this.sprite.getYOffset(), 20);
        } else {
            super.draw(g);
        }
        if (this.captureTimer > 0) {
            this.game.playscreen.world.sprReaction.setFrame(4);
            this.game.playscreen.world.sprReaction.setPosition(x2, y2 - this.captureTimer % 10);
            this.game.playscreen.world.sprReaction.paint(g);
        }
        switch (this.state) {
            case 1: 
            case 2: 
            case 9: {
                this.game.playscreen.world.sprReaction.setFrame(0);
                this.game.playscreen.world.sprReaction.setPosition(x2, y2);
                this.game.playscreen.world.sprReaction.paint(g);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.game.playscreen.world.sprReaction.setFrame(1);
                this.game.playscreen.world.sprReaction.setPosition(x2, y2);
                this.game.playscreen.world.sprReaction.paint(g);
                break;
            }
            case 8: {
                this.game.playscreen.world.sprReaction.setFrame(2);
                this.game.playscreen.world.sprReaction.setPosition(x2, y2);
                this.game.playscreen.world.sprReaction.paint(g);
            }
        }
    }

    public boolean seePlayer(Player p) {
        this.inSight = false;
        if (p.health <= 0 || !p.active) {
            return false;
        }
        if (this.state == 7 || this.state == 6) {
            return false;
        }
        if (this.state == 4 && (this.chaseCounter < 22 || this.chaseCounter >= 270)) {
            return false;
        }
        boolean headOnScreen = false;
        MyPoint head = new MyPoint();
        head.set(this.ptScreen.x + this.sprite.getWidth() / 2, this.ptScreen.y + this.sprite.getHeight() / 10 * 4);
        if (head.collideWith(this.game.x, this.game.y, this.game.resw, this.game.resh)) {
            headOnScreen = true;
        }
        head = null;
        if (this.state != 2 && !headOnScreen) {
            return false;
        }
        boolean facing = false;
        if (this.direction == 3 && p.ptWorld.x >= this.ptWorld.x || this.direction == 2 && p.ptWorld.x <= this.ptWorld.x || this.direction == 0 && p.ptWorld.y <= this.ptWorld.y || this.direction == 1 && p.ptWorld.y >= this.ptWorld.y) {
            facing = true;
        }
        if (!facing) {
            return false;
        }
        boolean seen = this.game.playscreen.world.isInLineOfSight(this, p, null);
        if (seen) {
            MyPoint start = this.game.playscreen.world.getLineOfSightOrigin(this);
            MyPoint end = this.game.playscreen.world.getLineOfSightOrigin(p);
            int max_vision = this.game.TILE_SIZE * 6;
            int dist = start.getDistance(end.x, end.y, true);
            if (!p.stealth && dist <= max_vision && headOnScreen) {
                this.inSight = true;
            }
            if (this.inSight) {
                this.chaseCounter = 0;
            }
            if (this.state != 9 && this.state != 2 && this.state != 1) {
                if (p.stealth) {
                    MyPoint point = new MyPoint();
                    point.x = end.x;
                    point.y = end.y + this.game.TILE_SIZE / 4;
                    int tempdist = start.getDistance(point.x, point.y, true);
                    if (tempdist < this.game.TILE_SIZE / 2 * 5) {
                        this.startAlert(p.id);
                        if (p.stealthTimer == 0) {
                            p.stealthTimer = this.game.sinfo[this.game.infoSlot].stealthMaxTime;
                        }
                        p.specialAction = 0;
                        p.doAction();
                        return true;
                    }
                    point = null;
                } else {
                    if (dist < max_vision - this.game.TILE_SIZE * 2) {
                        this.startAlert(p.id);
                        if (p.id == 1 && p.stealthTimer == 0) {
                            p.stealthTimer = this.game.sinfo[this.game.infoSlot].stealthMaxTime;
                        }
                        return true;
                    }
                    if (dist < max_vision && this.state != 3) {
                        this.targetID = p.id;
                        this.state = (byte)3;
                        this.counter = 0;
                        return true;
                    }
                }
                start = null;
                end = null;
            }
        }
        return false;
    }

    private void Alert() {
        if (this.counter == 1) {
            this.talk((byte)1);
        }
        if (this.counter > 22) {
            MyPoint p = this.game.playscreen.world.checkAlarm(this);
            if (p != null) {
                this.state = (byte)9;
                this.ptTarget.set(p.x, p.y);
            } else {
                this.state = (byte)2;
            }
            p = null;
            this.chaseCounter = 0;
            this.counter = 0;
        }
    }

    private void SetAlarm() {
        this.track(this.ptTarget, this.game.playscreen.world.player[this.game.playscreen.world.currplayer].RUN_SPEED + this.game.playscreen.world.player[this.game.playscreen.world.currplayer].RUN_SPEED / 3, this.game.currframe % 2 == 0);
        if (this.ptWorld.getDistance(this.ptTarget.x, this.ptTarget.y, true) <= this.game.TILE_SIZE * 2) {
            this.game.playscreen.world.alarmCounter = (short)100;
            this.game.playscreen.world.alarmguard.reset();
            this.game.playscreen.world.alarmguard.ptStart.set(this.ptTarget.x, this.ptTarget.y + this.game.TILE_SIZE * 2);
            this.game.playscreen.world.alarmguard.moveto(this.game.playscreen.world.alarmguard.ptStart);
            this.game.playscreen.world.alarmguard.startAlert(this.game.playscreen.world.player[this.game.playscreen.world.currplayer].id);
            this.game.playscreen.world.alarmguard.setAnimation((byte)0);
            this.state = (byte)2;
            this.chaseCounter = 0;
            this.counter = 0;
        }
        if (this.counter > 44) {
            this.state = (byte)2;
            this.chaseCounter = 0;
            this.counter = 0;
        }
    }

    private void Investigate() {
        if (this.counter == 1) {
            this.talk((byte)3);
            this.ptTarget.set(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y);
            this.chaseCounter = 0;
        }
        if (this.counter > 22) {
            this.chaseCounter = (short)(this.chaseCounter + 1);
            if (this.chaseCounter >= 88 || this.track(this.ptTarget, this.WALK_SPEED, this.game.currframe % 3 == 0)) {
                this.talk((byte)2);
                this.state = (byte)5;
                this.counter = 0;
                this.chaseCounter = 0;
            }
        }
    }

    private void Hear() {
        if (this.counter == 1) {
            this.talk((byte)6);
            this.ptTarget.set(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y);
            this.chaseCounter = 0;
        }
        if (this.counter > 22 && ((this.chaseCounter = (short)(this.chaseCounter + 1)) >= 88 || this.track(this.ptTarget, this.WALK_SPEED, this.game.currframe % 3 == 0))) {
            this.talk((byte)2);
            this.state = (byte)5;
            this.counter = 0;
            this.chaseCounter = 0;
        }
    }

    private void Stunned() {
        if (this.counter < 44) {
            this.setAnimation((byte)9);
        } else {
            this.setAnimation((byte)0);
            this.state = (byte)2;
            this.chaseCounter = 0;
            this.counter = 0;
            this.helpCall();
        }
    }

    private void FoundNothing() {
        this.sprite.setFrame(0);
        if (this.counter > 22) {
            this.state = (byte)4;
            this.patrol.state = 1;
            this.ptTarget.set(this.patrol.point[this.patrol.currpoint].x, this.patrol.point[this.patrol.currpoint].y);
            this.counter = 0;
            this.chaseCounter = 0;
        }
    }

    private void Attack() {
        if (this.helpCounter == 0) {
            this.helpCall();
        }
        if ((this.helpCounter = (short)(this.helpCounter + 1)) > 44) {
            this.helpCounter = 0;
        }
        if (this.game.playscreen.world.alarmCounter > 0) {
            this.chaseCounter = 0;
            this.counter = 0;
        }
        if (this.game.playscreen.world.player[this.targetID].health <= 0) {
            this.chaseCounter = 0;
            this.state = (byte)4;
            this.counter = 0;
            this.ptTarget.set(this.patrol.point[this.patrol.currpoint].x, this.patrol.point[this.patrol.currpoint].y);
            this.patrol.state = 1;
            this.stopFire();
            return;
        }
        this.ptTarget.set(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y);
        int dist = this.ptWorld.getDistance(this.ptTarget.x, this.ptTarget.y, true);
        if (!this.firing && this.inSight && dist <= this.game.TILE_SIZE * 5) {
            this.startFire();
        }
        if (this.firing) {
            if (this.shotDelayCounter == 0) {
                this.game.playscreen.world.player[this.targetID].health = this.game.playscreen.world.player[this.targetID].poweredUp ? (short)(this.game.playscreen.world.player[this.targetID].health - this.damage / 3) : (short)(this.game.playscreen.world.player[this.targetID].health - this.damage);
                if (this.targetID != this.game.playscreen.world.currplayer) {
                    this.game.playscreen.world.player[this.targetID].healthBarCounter = (short)100;
                }
                this.game.playscreen.world.player[this.targetID].blood.startDrop(this.game.playscreen.world.player[this.targetID].ptWorld, this.game.TILE_SIZE / 6, this.game);
                this.game.playscreen.world.splat.startDrop(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y - this.game.playscreen.world.player[this.targetID].sprite.getHeight() / 2, this.game.TILE_SIZE / 6, this.game);
                this.game.playscreen.world.shootObject(this, this.game.playscreen.world.player[this.targetID]);
            }
            if ((this.shotDelayCounter = (short)(this.shotDelayCounter + 1)) > this.shotDelay) {
                this.firing = false;
            }
        } else {
            this.track(this.ptTarget, this.game.playscreen.world.player[this.game.playscreen.world.currplayer].RUN_SPEED + this.game.playscreen.world.player[this.game.playscreen.world.currplayer].RUN_SPEED / 3, this.game.currframe % 2 == 0);
        }
        if (this.game.playscreen.world.player[this.targetID].stealth) {
            this.chaseCounter = 0;
            this.talk((byte)5);
            this.ptTarget.set(this.ptWorld.x, this.ptWorld.y);
            this.chaseCounter = 0;
            this.state = (byte)3;
            this.counter = (short)2;
            this.stopFire();
            return;
        }
        this.chaseCounter = (short)(this.chaseCounter + 1);
        if (this.chaseCounter > 66) {
            this.chaseCounter = 0;
            this.talk((byte)0);
            this.state = (byte)4;
            this.counter = 0;
            this.ptTarget.set(this.patrol.point[this.patrol.currpoint].x, this.patrol.point[this.patrol.currpoint].y);
            this.patrol.state = 1;
            this.stopFire();
        }
    }

    public void talk(byte talk_type) {
    }

    public void move(World world) {
        if (this.health <= 0) {
            return;
        }
        switch (this.state) {
            case 0: 
            case 4: {
                this.OnPatrol();
                break;
            }
            case 1: {
                this.Alert();
                break;
            }
            case 2: {
                this.Attack();
                break;
            }
            case 3: {
                this.Investigate();
                break;
            }
            case 8: {
                this.Hear();
                break;
            }
            case 5: {
                this.FoundNothing();
                break;
            }
            case 7: {
                this.Stunned();
                break;
            }
            case 9: {
                this.SetAlarm();
            }
        }
        this.counter = (short)(this.counter + 1);
        if (this.counter > 1000) {
            this.counter = (short)1000;
        }
    }

    public void setAnimation(byte newAnimation) {
        if (newAnimation == this.mAnimation) {
            return;
        }
        this.sprite.setFrame(0);
        switch (newAnimation) {
            case 0: {
                this.sprite.setFrameSequence(FRAMES_STAND);
                this.direction = 1;
                break;
            }
            case 1: {
                this.sprite.setFrameSequence(FRAMES_RUNLEFT);
                this.direction = (byte)2;
                break;
            }
            case 2: {
                this.sprite.setFrameSequence(FRAMES_RUNRIGHT);
                this.direction = (byte)3;
                break;
            }
            case 3: {
                this.sprite.setFrameSequence(FRAMES_RUNUP);
                this.direction = 0;
                break;
            }
            case 4: {
                this.sprite.setFrameSequence(FRAMES_RUNDOWN);
                this.direction = 1;
                break;
            }
            case 9: {
                this.sprite.setFrameSequence(FRAMES_DEATH);
                break;
            }
            case 5: {
                this.sprite.setFrameSequence(FRAMES_FIRE_DOWN);
                this.direction = 1;
                break;
            }
            case 6: {
                this.sprite.setFrameSequence(FRAMES_FIRE_UP);
                this.direction = 0;
                break;
            }
            case 7: {
                this.sprite.setFrameSequence(FRAMES_FIRE_LEFT);
                this.direction = (byte)2;
                break;
            }
            case 8: {
                this.sprite.setFrameSequence(FRAMES_FIRE_RIGHT);
                this.direction = (byte)3;
            }
        }
        this.mAnimation = newAnimation;
    }

    public void startFire() {
        this.firing = false;
        this.track(this.ptTarget, 0, true);
        switch (this.mAnimation) {
            case 3: {
                this.setAnimation((byte)6);
                this.sprite.setFrame(0);
                break;
            }
            case 1: {
                this.setAnimation((byte)7);
                this.sprite.setFrame(0);
                break;
            }
            case 2: {
                this.setAnimation((byte)8);
                this.sprite.setFrame(0);
                break;
            }
            case 0: 
            case 4: {
                this.setAnimation((byte)5);
                this.sprite.setFrame(0);
            }
        }
        this.firing = true;
        this.shotDelayCounter = 0;
    }

    public void stopFire() {
        switch (this.mAnimation) {
            case 6: {
                this.setAnimation((byte)3);
                this.sprite.setFrame(0);
                break;
            }
            case 7: {
                this.setAnimation((byte)1);
                this.sprite.setFrame(0);
                break;
            }
            case 8: {
                this.setAnimation((byte)2);
                this.sprite.setFrame(0);
                break;
            }
            case 5: {
                this.setAnimation((byte)0);
                this.sprite.setFrame(0);
            }
        }
        this.firing = false;
    }

    public void startAlert(byte playerid) {
        this.state = 1;
        this.targetID = playerid;
        this.counter = 0;
    }

    public void drawPatrolArea(Graphics g, World world) {
        int x2 = this.patrol.point[1].x + world.nx;
        int y2 = this.patrol.point[1].y + world.ny;
        int w = this.patrol.point[0].x - this.patrol.point[1].x;
        int h = this.patrol.point[2].y - this.patrol.point[1].y;
        g.setColor(0, 0, 255);
        g.drawRect(x2, y2, w, h);
    }
}

