/*
 * Decompiled with CFR 0.152.
 */
import com.dvidearts.jengine.MyPoint;
import com.dvidearts.jengine.MySprite;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Object {
    public MyPoint ptWorld;
    public MyPoint ptScreen;
    public MyPoint ptCell;
    public MySprite sprite;
    public boolean onscreen;
    public boolean burned;
    public boolean seethrough;
    public boolean active;
    public short id;
    public short sortOffset;

    private void initDefaults() {
        this.free();
        this.id = 0;
        this.ptWorld = new MyPoint();
        this.ptScreen = new MyPoint();
        this.ptCell = new MyPoint();
        this.onscreen = false;
        this.sortOffset = 0;
        this.burned = false;
        this.seethrough = false;
        this.active = true;
    }

    public Object() {
        this.initDefaults();
    }

    public Object(Image[] img) {
        this.initDefaults();
        this.sprite = new MySprite(img);
    }

    public Object(MySprite spr) {
        this.initDefaults();
        this.sprite = new MySprite(spr);
    }

    public Object(Object o) {
        this.id = o.id;
        this.ptWorld = new MyPoint();
        this.ptWorld.set(o.ptWorld.x, o.ptWorld.y);
        this.ptScreen = new MyPoint();
        this.ptScreen.set(o.ptScreen.x, o.ptScreen.y);
        this.ptCell = new MyPoint();
        this.ptCell.set(o.ptCell.x, o.ptCell.y);
        this.sprite = new MySprite(o.sprite);
        this.onscreen = o.onscreen;
        this.sortOffset = o.sortOffset;
        this.burned = o.burned;
        this.seethrough = o.seethrough;
        this.active = o.active;
    }

    public void free() {
        if (this.sprite != null) {
            this.sprite.free();
            this.sprite = null;
        }
        this.ptWorld = null;
        this.ptScreen = null;
        this.ptCell = null;
    }

    public void moveto(int x2, int y2) {
        this.ptWorld.x = (short)x2;
        this.ptWorld.y = (short)y2;
    }

    public void moveto(MyPoint p) {
        this.ptWorld.set(p.x, p.y);
    }

    public void update(Game game, World world) {
        this.onscreen = false;
        if (!this.active) {
            return;
        }
        this.sprite.setPosition(world.nx + this.ptWorld.x, world.ny + this.ptWorld.y);
        this.ptScreen.x = (short)(this.sprite.getX() + this.sprite.getXOffset());
        this.ptScreen.y = (short)(this.sprite.getY() + this.sprite.getYOffset());
        this.onscreen = this.sprite.isOnScreen(game.x, game.y, game.resw, game.resh);
    }

    public void draw(Graphics g) {
        if (!this.onscreen || !this.active) {
            return;
        }
        this.sprite.paint(g);
    }

    public boolean collideWith(Object o) {
        if (!this.active) {
            return false;
        }
        return this.sprite.collidesWith(o.sprite);
    }
}

