/*
 * Decompiled with CFR 0.152.
 */
package com.dvidearts.jengine;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MyBinSprite {
    public Image[] image;
    private short xo;
    private short yo;
    private short frame;
    short colx;
    short coly;
    short colw;
    short colh;
    private int x;
    private int y;
    private byte[] frameSequence;

    public MyBinSprite(Image[] image) {
        this.image = image;
        this.initDefaults();
    }

    public MyBinSprite(String name, String ext) {
        String temp = "";
        int i2 = 0;
        boolean done = false;
        Vector<Image> v = new Vector<Image>();
        while (!done) {
            temp = String.valueOf(name) + i2 + "." + ext;
            try {
                Image img = Image.createImage((String)temp);
                v.addElement(img);
            }
            catch (Exception e) {
                done = true;
            }
            i2 = (short)(i2 + 1);
        }
        this.image = new Image[v.size()];
        v.copyInto(this.image);
        v = null;
        temp = null;
        this.initDefaults();
    }

    private void initDefaults() {
        this.frame = 0;
        this.x = 0;
        this.y = 0;
        this.xo = 0;
        this.yo = 0;
        this.frameSequence = new byte[this.image.length];
        int i2 = 0;
        while (i2 < this.image.length) {
            this.frameSequence[i2] = (byte)i2;
            ++i2;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public short getXOffset() {
        return this.xo;
    }

    public short getYOffset() {
        return this.yo;
    }

    public short getWidth() {
        return (short)this.image[this.frameSequence[this.frame]].getWidth();
    }

    public void setOffset(int sx, int sy) {
        this.xo = (short)sx;
        this.yo = (short)sy;
    }

    public short getHeight() {
        return (short)this.image[this.frameSequence[this.frame]].getHeight();
    }

    public short getFrame() {
        return this.frame;
    }

    public Image getFrame(int i2) {
        if (i2 < this.frameSequence.length) {
            return this.image[this.frameSequence[i2]];
        }
        return null;
    }

    public void setPosition(int X, int Y) {
        this.x = X;
        this.y = Y;
    }

    public void setFrame(int f) {
        if (f < this.frameSequence.length && f >= 0) {
            this.frame = (short)f;
        }
    }

    public short getFrameSequenceLength() {
        if (this.image == null) {
            return 0;
        }
        return (short)this.frameSequence.length;
    }

    public void paint(Graphics g) {
        if (this.image != null) {
            g.drawImage(this.image[this.frameSequence[this.frame]], this.x + this.xo, this.y + this.yo, 20);
        }
    }

    public void nextFrame() {
        this.frame = (short)(this.frame + 1);
        if (this.frame >= this.frameSequence.length) {
            this.frame = 0;
        }
    }

    public void prevFrame() {
        this.frame = (short)(this.frame - 1);
        if (this.frame < 0) {
            this.frame = (short)(this.frameSequence.length - 1);
            if (this.frame < 0) {
                this.frame = 0;
            }
        }
    }

    public void setFrameSequence(byte[] sequence) {
        this.frameSequence = sequence;
    }

    public boolean collidesWith(Image img, int ix, int iy) {
        int nx = this.x + this.xo;
        int ny = this.y + this.yo;
        return nx + this.colx < ix + img.getWidth() && nx + this.colw + this.image[this.frameSequence[this.frame]].getWidth() > ix && ny + this.coly < iy + img.getHeight() && ny + this.colh + this.image[this.frameSequence[this.frame]].getHeight() > iy;
    }

    public boolean collideOnX(Image img, int ix) {
        int nx = this.x + this.xo;
        return nx + this.colx < ix + img.getWidth() && nx + this.colw + this.image[this.frameSequence[this.frame]].getWidth() > ix;
    }

    public boolean collidesOnY(Image img, int iy) {
        int ny = this.y + this.yo;
        return ny + this.coly < iy + img.getHeight() && ny + this.colh + this.image[this.frameSequence[this.frame]].getHeight() > iy;
    }

    public boolean collidesWith(MyBinSprite s) {
        int nx = this.x + this.xo;
        int ny = this.y + this.yo;
        int nsx = s.getX() + s.getXOffset();
        int nsy = s.getY() + s.getYOffset();
        return nx + this.colx < nsx + s.getWidth() && nx + this.colw + this.image[this.frameSequence[this.frame]].getWidth() > nsx && ny + this.coly < nsy + s.getHeight() && ny + this.colh + this.image[this.frameSequence[this.frame]].getHeight() > nsy;
    }

    public void defineCollisionRectangle(int ix, int iy, int iwidth, int iheight) {
        this.colx = (short)ix;
        this.coly = (short)iy;
        this.colw = (short)iwidth;
        this.colh = (short)iheight;
    }

    public boolean isOnScreen(int iScreenX, int iScreenY, int iScreenWidth, int iScreenHeight) {
        int nx = this.x + this.xo;
        int ny = this.y + this.yo;
        return nx < iScreenX + iScreenWidth && nx + this.image[this.frameSequence[this.frame]].getWidth() > iScreenX && ny < iScreenY + iScreenHeight && ny + this.image[this.frameSequence[this.frame]].getHeight() > iScreenY;
    }
}

