/*
 * Decompiled with CFR 0.152.
 */
package Calc4M;

import Calc4M.DashBoard;
import Calc4M.DisplayList;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import ral.Real;

public class Constants
extends DisplayList {
    public static final Real cmPerInch = new Real(0, 0x40000001, 5856841243402782638L);
    public static final Real cmPerFoot = new Real(0, 0x40000004, 8785261865104173957L);
    public static final Real mPerYd = new Real("0.9144");
    public static final Real mPerMile = new Real(0, 0x4000000A, 7247841038710943515L);
    public static final Real hectarPerAcre = new Real("0.40468564224");
    public static final Real kmPerNmile = new Real(0, 0x40000000, 8540842506127522398L);
    public static final Real lPerUSGallon = new Real(0, 0x40000001, 8728565336025025807L);
    public static final Real kgPerLb = new Real(0, 0x3FFFFFFE, 8367302363177370209L);
    public static final Real wPerHp = new Real(0, 0x40000009, 6624795051861999616L);
    public static final Real jPerKcal = new Real(0, 0x4000000C, 4713917729968698163L);
    public static final Real mjPerKwh = new Real(0, 0x40000001, 0x7333333333333333L);
    public static final Real kAt0C = new Real("273.15");
    public static final Real gPerOz = new Real("28.34952");
    public static final Real paPerBar = new Real(100000);
    public static final Real paPerMmhg = new Real(133);
    public static Constants list = null;
    protected static int[] constantList = new int[]{145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161};

    public static Real mpgToL100km(Real mpg) {
        Real v = new Real(Real.ONE);
        v.div(mpg);
        v.mul(lPerUSGallon);
        v.div(mPerMile);
        v.mul(10000);
        mpg.assign(v);
        return mpg;
    }

    public static Real L100kmToMpg(Real l) {
        Real v = new Real(Real.ONE);
        v.mul(10000);
        v.div(l);
        v.div(mPerMile);
        v.mul(lPerUSGallon);
        l.assign(v);
        return l;
    }

    public static Real fToC(Real f) {
        f.sub(32);
        f.div(9);
        f.mul(5);
        return f;
    }

    public static Real cToF(Real c) {
        c.mul(9);
        c.div(5);
        c.add(32);
        return c;
    }

    private static String constantDescription(int constant) {
        switch (constant) {
            case 145: {
                return "\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0441\u0432\u0435\u0442\u0430 c [\u043c/\u0441]";
            }
            case 146: {
                return "\u042d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430 \u03b50 [F/m]";
            }
            case 147: {
                return "\u041c\u0430\u0433\u043d\u0438\u0442\u043d\u0430\u044f \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430 \u03bc0 [N/A\u00b2]";
            }
            case 148: {
                return "\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430 \u041f\u043b\u0430\u043d\u043a\u0430 h [J\u00b7s]";
            }
            case 149: {
                return "\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430 Dirac' \u0127 [J\u00b7s]";
            }
            case 150: {
                return "\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430 Coulomb's K [Nm\u00b2/C\u00b2]";
            }
            case 151: {
                return "\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430 \u0424\u0430\u0440\u0430\u0434\u0435\u044f F [C/mol]";
            }
            case 152: {
                return "\u0417\u0430\u0440\u044f\u0434 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u0430 e [C]";
            }
            case 153: {
                return "\u041c\u0430\u0441\u0441\u0430 \u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u0430 me [\u043a\u0433]";
            }
            case 154: {
                return "\u041c\u0430\u0441\u0441\u0430 \u0424\u043e\u0442\u043e\u043d\u0430 mp [\u043a\u0433]";
            }
            case 155: {
                return "\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430 \u0420\u0443\u0434\u0431\u0435\u0440\u0433\u0430 R [m\u02c9\u00b9]";
            }
            case 156: {
                return "\u0427\u0438\u0441\u043b\u043e \u0410\u0432\u043e\u0433\u0430\u0434\u0440\u043e NA [mol\u02c9\u00b9]";
            }
            case 157: {
                return "\u0413\u0430\u0437\u043e\u0432\u0430\u044f \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430 R [J/(K\u00b7mol)]";
            }
            case 158: {
                return "\u041f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u0430\u044f \u0422\u044f\u0433\u043e\u0442\u0435\u043d\u0438\u044f G [\u043c\u00b3/(\u043a\u0433\u00b7\u0441\u00b2)]";
            }
            case 159: {
                return "\u0421\u0438\u043b\u0430 \u0442\u044f\u0436\u0435\u0441\u0442\u0438 g [\u043c/\u0441\u00b2]";
            }
            case 160: {
                return "\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0417\u0432\u0443\u043a\u0430 [\u043c/\u0441]";
            }
            case 161: {
                return "\u0420\u0430\u0434\u0438\u0443\u0441 \u0417\u0435\u043c\u043b\u0438 [\u043a\u043c]";
            }
        }
        return null;
    }

    public static String constantValue(int constant) {
        switch (constant) {
            case 145: {
                return "299792458";
            }
            case 146: {
                return "8.854187817e-12";
            }
            case 147: {
                return "1.256637061e-6";
            }
            case 148: {
                return "6.62606896e-34";
            }
            case 149: {
                return "1.054571628e-34";
            }
            case 150: {
                return "8.987551787e9";
            }
            case 151: {
                return "96485.3383";
            }
            case 152: {
                return "1.602176487e-19";
            }
            case 153: {
                return "9.10938215e-31";
            }
            case 154: {
                return "1.6726217129e-27";
            }
            case 155: {
                return "10973731.568525";
            }
            case 156: {
                return "6.02214179e23";
            }
            case 157: {
                return "8.314472";
            }
            case 158: {
                return "6.67428e-11";
            }
            case 159: {
                return "9.80665";
            }
            case 160: {
                return "344";
            }
            case 161: {
                return "6372.7976";
            }
        }
        return null;
    }

    public Constants() {
        this.colorSelectedBackground = 0x8888EE;
        this.drawBorder = true;
        this.items = new String[constantList.length];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = Constants.constantDescription(constantList[i]) + " (" + Constants.constantValue(constantList[i]) + ")";
        }
        this.leftButtonText = "\u0412\u044b\u0431\u043e\u0440";
    }

    public static void show(Display display, Canvas nextScreen) {
        if (list == null) {
            list = new Constants();
        }
        list.prepareShow(display, (Displayable)nextScreen, true);
        display.setCurrent((Displayable)list);
        list.sizeChanged(0, 0);
    }

    protected void handleKeyPress(int keyNum, boolean alreadyHandled) {
        if (!(alreadyHandled || keyNum != 17 && keyNum != 21)) {
            ((DashBoard)this.nextScreen).handleFunction(constantList[this.currItem]);
            this.switchToNextScreen();
        }
    }
}

