/*
 * Decompiled with CFR 0.152.
 */
package Calc4M;

import Calc4M.Settings;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Header {
    public static final int COLOR_TEXT = 0;
    public static final int COLOR_BACKGROUND = 15263984;
    private Font textFont;
    private int width;
    private int height;
    private String text = "";

    public Header() {
        this.updateSize(0, 0);
    }

    public void updateText(int mode) {
        switch (mode) {
            case 1: {
                this.setText(null);
                break;
            }
            case 4: {
                this.setText("\u041f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u04351");
                break;
            }
            case 5: {
                this.setText("\u041f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u04352");
                break;
            }
            case 6: {
                this.setText(null);
                break;
            }
            case 3: {
                this.setText(Settings.getMemoryStringShort());
                break;
            }
            case 2: {
                this.setText(Settings.getDRGString());
                break;
            }
            default: {
                this.setText(null);
            }
        }
    }

    private void setText(String text) {
        String fse = Settings.getLocalNFSEString();
        String hexbin = Settings.getCalcBaseString();
        if (text == null || text.length() < 5) {
            this.text = "Calc4M";
            if (hexbin != null && hexbin.length() > 0) {
                this.text = this.text + " - " + hexbin;
            }
            if (fse != null && fse.length() > 0) {
                this.text = this.text + " - " + fse;
            }
            if (text != null) {
                this.text = this.text + " - " + text;
            }
        } else {
            this.text = text;
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void updateSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.textFont = Settings.getFont((byte)(Settings.getFontSize() - 2), 64, 2);
        this.height = this.textFont.getHeight();
    }

    protected void paint(Graphics g) {
        g.setClip(0, 0, this.width, this.height);
        g.setColor(15263984);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(0);
        g.setFont(this.textFont);
        if (this.text != null) {
            g.drawString(this.text, 0, 0, 20);
        }
    }
}

