/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Button;
import game.DisplayableCanvas;
import game.DrawString;
import game.SystemFont;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainMenu {
    DrawString ds;
    DisplayableCanvas dc;
    int MENU_MODE;
    final byte SPLASH;
    final byte MAIN_MENU;
    final byte OPTIONS = (byte)2;
    final byte HELP = (byte)3;
    final byte ABOUT = (byte)4;
    final byte GAME_TYPE = (byte)5;
    final byte CHECK_SAMEPHONE = (byte)6;
    int WIDTH;
    int HEIGHT;
    Image imgLogo;
    Image imgSplash;
    Image imgMenuLogo;
    Image imgAboutLogo;
    Image[] imgFont;
    Font font = Font.getFont((int)0, (int)1, (int)16);
    boolean isContinue;
    boolean onoffs = true;
    boolean onoffv = true;
    Button butContinue;
    Button butNewGame;
    Button butOption;
    Button butHelp;
    Button butAbout;
    Button butExit;
    Button butSoundon;
    Button butSoundoff;
    Button butVibrateon;
    Button butVibrateoff;
    Button buttonHome;
    Image imgOptHead;
    Image imgAboutHead;
    Image imgHelpHead;
    int selectIndex = 1;
    byte optionIndex;
    Button buttonSingleP;
    Button buttonMultiP;
    Button buttonNFC;
    Button buttonSamePhone;
    int menuy;
    int menupanY;
    boolean isloading;
    Image uparrow;
    Image downarrow;
    String helpString;
    int scroll;
    int dragedY;

    public MainMenu(DisplayableCanvas dc, DrawString ds) {
        this.SPLASH = 0;
        this.MAIN_MENU = 1;
        this.dc = dc;
        this.ds = ds;
        this.WIDTH = dc.WIDTH;
        this.HEIGHT = dc.HEIGHT;
        this.isloading = false;
    }

    public void resetSplash() {
        try {
            this.imgLogo = Image.createImage((String)"/res/menu/logo.png");
            this.imgSplash = Image.createImage((String)"/res/menu/splash.png");
        }
        catch (Exception io) {
            io.printStackTrace();
        }
        this.MENU_MODE = 0;
    }

    public void resetMainMenu() {
        if (this.butContinue == null) {
            this.butContinue = new Button(0, 0, "/res/menu/continue0.png", "/res/menu/continue1.png");
            this.butNewGame = new Button(0, 0, "/res/menu/play0.png", "/res/menu/play1.png");
            this.butOption = new Button(0, 0, "/res/menu/option0.png", "/res/menu/option1.png");
            this.butHelp = new Button(0, 0, "/res/menu/help0.png", "/res/menu/help1.png");
            this.butAbout = new Button(0, 0, "/res/menu/about0.png", "/res/menu/about1.png");
            this.butExit = new Button(0, 0, "/res/menu/exit0.png", "/res/menu/exit1.png");
            this.butSoundon = new Button(this.WIDTH - 194 >> 1, 270, "/res/menu/soundon0.png", "/res/menu/soundon1.png");
            this.butSoundoff = new Button(this.WIDTH - 211 >> 1, 270, "/res/menu/soundoff0.png", "/res/menu/soundoff1.png");
            this.butVibrateon = new Button(this.WIDTH - 273 >> 1, this.butSoundon.y + 80, "/res/menu/vibrateon0.png", "/res/menu/vibrateon1.png");
            this.butVibrateoff = new Button(this.WIDTH - 290 >> 1, this.butSoundon.y + 80, "/res/menu/vibrateoff0.png", "/res/menu/vibrateoff1.png");
            this.buttonHome = new Button(190, 304, "/res/menu/home0.png", "/res/menu/home1.png");
            this.butSoundon.setXY(this.WIDTH - this.butSoundon.width >> 1, 170);
            this.butSoundoff.setXY(this.WIDTH - this.butSoundoff.width >> 1, 170);
            this.butVibrateon.setXY(this.WIDTH - this.butVibrateon.width >> 1, 210);
            this.butVibrateoff.setXY(this.WIDTH - this.butVibrateoff.width >> 1, 210);
        }
        this.menuy = 69;
        if (this.isContinue) {
            this.butContinue.setXY(this.WIDTH - this.butContinue.width >> 1, 99);
            this.butNewGame.setXY(this.WIDTH - this.butNewGame.width >> 1, this.butContinue.y + 36);
            this.butOption.setXY(this.WIDTH - this.butOption.width >> 1, this.butNewGame.y + 36);
            this.butHelp.setXY(this.WIDTH - this.butHelp.width >> 1, this.butOption.y + 36);
            this.butAbout.setXY(this.WIDTH - this.butAbout.width >> 1, this.butHelp.y + 36);
            this.butExit.setXY(this.WIDTH - this.butExit.width >> 1, this.butAbout.y + 36);
        } else {
            this.butNewGame.setXY(this.WIDTH - this.butNewGame.width >> 1, 101);
            this.butOption.setXY(this.WIDTH - this.butOption.width >> 1, this.butNewGame.y + 45);
            this.butHelp.setXY(this.WIDTH - this.butHelp.width >> 1, this.butOption.y + 45);
            this.butAbout.setXY(this.WIDTH - this.butAbout.width >> 1, this.butHelp.y + 45);
            this.butExit.setXY(this.WIDTH - this.butExit.width >> 1, this.butAbout.y + 45);
        }
        this.MENU_MODE = 1;
    }

    public void resetOptions() {
    }

    public void resetHelp() {
        this.helpString = "\u0411\u0435\u0439\u0442\u0435 \u043a\u0443\u043a\u043b\u0443! \u041f\u0440\u0430\u043a\u0442\u0438\u043a\u0443\u0439\u0442\u0435 \u0432\u0430\u0448\u0438 \u043d\u0430\u0432\u044b\u043a\u0438 \u0431\u043e\u043a\u0441\u0430 \u043d\u0430 \u0438\u0433\u0440\u0443\u0448\u043a\u0435 \u0438\u043b\u0438 \u0432\u043e\u0437\u044c\u043c\u0438\u0442\u0435 \u0447\u044c\u044e-\u043d\u0438\u0431\u0443\u0434\u044c \u0444\u043e\u0442\u043e\u0433\u0440\u0430\u0444\u0438\u044e, \u043f\u043e\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u0438 \u0438\u0437\u0431\u0438\u0432\u0430\u0439\u0442\u0435. ";
        this.helpString = this.helpString + "\u0423\u0434\u0430\u0440\u044f\u0439\u0442\u0435 \u043d\u0435\u043f\u0440\u0435\u0440\u044b\u0432\u043d\u043e \u0438 \u043d\u0435 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0439\u0442\u0435 \u0443\u0440\u043e\u0432\u043d\u044e \u0432\u0430\u0448\u0435\u0433\u043e \u0433\u043d\u0435\u0432\u0430 \u0443\u043f\u0430\u0441\u0442\u044c. \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044c \u043c\u043e\u0449\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u043f\u0440\u044f\u043c\u0443\u044e \u0441\u0432\u044f\u0437\u0430\u043d \u0441 \u0443\u0440\u043e\u0432\u043d\u0435\u043c \u0432\u0430\u0448\u0435\u0433\u043e \u0433\u043d\u0435\u0432\u0430, \u0435\u0441\u043b\u0438 \u043e\u043d \u043e\u043f\u0443\u0441\u0442\u0438\u0442\u0441\u044f \u0434\u043e \u043d\u0443\u043b\u044f, \u0432\u044b \u043f\u0440\u043e\u0438\u0433\u0440\u0430\u0435\u0442\u0435. ";
        this.helpString = this.helpString + "\u041a\u0430\u043a \u0438\u0433\u0440\u0430\u0442\u044c: ";
        this.helpString = this.helpString + "\u041d\u0430\u0436\u0438\u043c\u0430\u0439\u0442\u0435 1, 4 \u0438 7 \u0434\u043b\u044f \u0443\u0434\u0430\u0440\u0430 \u0441\u043b\u0435\u0432\u0430. ";
        this.helpString = this.helpString + "\u041d\u0430\u0436\u0438\u043c\u0430\u0439\u0442\u0435 2, 5 \u0438 8 , \u0447\u0442\u043e\u0431\u044b \u0443\u0434\u0430\u0440\u044f\u0442\u044c \u0432 \u0441\u0435\u0440\u0435\u0434\u0438\u043d\u0435. ";
        this.helpString = this.helpString + "\u041d\u0430\u0436\u0438\u043c\u0430\u0439\u0442\u0435 3, 6 \u0438 9 \u0434\u043b\u044f \u0443\u0434\u0430\u0440\u0430 \u0441\u043f\u0440\u0430\u0432\u0430. ";
        this.helpString = this.helpString + "\u0414\u043b\u044f \u0441\u0435\u043d\u0441\u043e\u0440\u0430: ";
        this.helpString = this.helpString + "\u041f\u0440\u043e\u0441\u0442\u043e \u043d\u0430\u0436\u0438\u043c\u0430\u0439\u0442\u0435 \u043d\u0430 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435.";
    }

    public void resetAbout() {
    }

    public void resetMode(int gameMode) {
        switch (gameMode) {
            case 0: {
                this.resetSplash();
                break;
            }
            case 1: {
                if (this.imgMenuLogo == null) {
                    try {
                        this.imgSplash = Image.createImage((String)"/res/menu/menuBg.png");
                        this.imgMenuLogo = Image.createImage((String)"/res/menu/menuLogo.png");
                        this.imgOptHead = Image.createImage((String)"/res/menu/Optheading.png");
                        this.imgHelpHead = Image.createImage((String)"/res/menu/Helpheading.png");
                        this.imgAboutLogo = Image.createImage((String)"/res/menu/aboutLogo.png");
                        this.uparrow = Image.createImage((String)"/res/menu/upArrow.png");
                        this.downarrow = Image.createImage((String)"/res/menu/downArrow.png");
                        System.out.println(" in menu load");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.resetMainMenu();
                break;
            }
            case 2: {
                this.resetOptions();
                break;
            }
            case 3: {
                this.resetHelp();
                break;
            }
            case 4: {
                this.resetAbout();
                break;
            }
            case 5: {
                break;
            }
        }
        this.MENU_MODE = gameMode;
    }

    protected void pointerPressed(int x, int y) {
        boolean result = false;
        switch (this.MENU_MODE) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isContinue && (result = this.butContinue.isPressed(x, y))) {
                    this.selectIndex = 0;
                }
                if (result) break;
                result = this.butNewGame.isPressed(x, y);
                if (!result) {
                    result = this.butOption.isPressed(x, y);
                    if (!result) {
                        result = this.butHelp.isPressed(x, y);
                        if (!result) {
                            result = this.butAbout.isPressed(x, y);
                            if (!result) {
                                result = this.butExit.isPressed(x, y);
                                if (!result) break;
                                this.selectIndex = 5;
                                break;
                            }
                            this.selectIndex = 4;
                            break;
                        }
                        this.selectIndex = 3;
                        break;
                    }
                    this.selectIndex = 2;
                    break;
                }
                this.selectIndex = 1;
                break;
            }
            case 2: {
                if (this.onoffs) {
                    result = this.butSoundon.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 0;
                    }
                } else {
                    result = this.butSoundoff.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 0;
                    }
                }
                if (this.onoffv) {
                    result = this.butVibrateon.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 1;
                    }
                } else {
                    result = this.butVibrateoff.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 1;
                    }
                }
                if (result) break;
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 3: {
                result = this.buttonHome.isPressed(x, y);
                if (this.buttonHome.isPressed(x, y) || x <= 5 || x >= 235 || y <= 130 || y >= 296) break;
                this.dragedY = y;
                break;
            }
            case 4: {
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 5: {
                result = this.buttonSingleP.isPressed(x, y);
                if (result || (result = this.buttonMultiP.isPressed(x, y))) break;
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 6: {
                result = this.buttonNFC.isPressed(x, y);
                if (result || (result = this.buttonSamePhone.isPressed(x, y))) break;
                result = this.buttonHome.isPressed(x, y);
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        boolean result = false;
        switch (this.MENU_MODE) {
            case 0: {
                break;
            }
            case 1: {
                result = this.butExit.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                if (this.isContinue && (result = this.butContinue.isReleased(x, y))) {
                    this.selection();
                }
                if (result) break;
                result = this.butNewGame.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                result = this.butOption.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                result = this.butHelp.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                result = this.butAbout.isReleased(x, y);
                if (!result) break;
                this.selection();
                break;
            }
            case 2: {
                if (this.onoffs) {
                    result = this.butSoundon.isReleased(x, y);
                    if (result) {
                        this.onoffs = false;
                    }
                } else {
                    result = this.butSoundoff.isReleased(x, y);
                    if (result) {
                        this.onoffs = true;
                    }
                }
                if (this.onoffv) {
                    result = this.butVibrateon.isReleased(x, y);
                    if (result) {
                        this.onoffv = false;
                    }
                } else {
                    result = this.butVibrateoff.isReleased(x, y);
                    if (result) {
                        this.onoffv = true;
                    }
                }
                if (result || !(result = this.buttonHome.isReleased(x, y))) break;
                this.resetMainMenu();
                break;
            }
            case 3: {
                result = this.buttonHome.isReleased(x, y);
                if (result) {
                    this.MENU_MODE = 1;
                }
                this.dragedY = 0;
                break;
            }
            case 4: {
                result = this.buttonHome.isReleased(x, y);
                if (!result) break;
                this.MENU_MODE = 1;
                break;
            }
            case 5: {
                result = this.buttonSingleP.isReleased(x, y);
                if (result) {
                    this.dc.isSinglePlayer = true;
                    this.dc.isSingleHandSet = false;
                    this.dc.initGame();
                    this.isContinue = true;
                    break;
                }
                result = this.buttonMultiP.isReleased(x, y);
                if (result) {
                    this.resetMode(6);
                    break;
                }
                result = this.buttonHome.isReleased(x, y);
                if (!result) break;
                this.MENU_MODE = 1;
                break;
            }
            case 6: {
                result = this.buttonNFC.isReleased(x, y);
                if (result) {
                    this.dc.isSinglePlayer = false;
                    this.dc.isSingleHandSet = false;
                    this.isContinue = false;
                    break;
                }
                result = this.buttonSamePhone.isReleased(x, y);
                if (result) {
                    this.dc.isSinglePlayer = false;
                    this.dc.isSingleHandSet = true;
                    this.dc.initGame();
                    this.isContinue = true;
                    break;
                }
                result = this.buttonHome.isReleased(x, y);
                if (!result) break;
                this.MENU_MODE = 1;
            }
        }
    }

    public void clearImage() {
        this.imgMenuLogo = null;
        this.imgOptHead = null;
        this.imgHelpHead = null;
        this.imgAboutLogo = null;
        this.butContinue = null;
        this.butNewGame = null;
        this.butOption = null;
        this.butHelp = null;
        this.butAbout = null;
        this.butExit = null;
        this.butSoundon = null;
        this.butSoundoff = null;
        this.butVibrateon = null;
        this.butVibrateoff = null;
        System.gc();
    }

    private void selection() {
        switch (this.selectIndex) {
            case 0: {
                this.clearImage();
                this.dc.loadImage();
                this.dc.continueGame();
                this.dc.getClass();
                this.dc.GAME_MODE = 5;
                break;
            }
            case 1: {
                this.dc.isSinglePlayer = true;
                this.dc.isSingleHandSet = false;
                this.clearImage();
                this.dc.loadImage();
                this.dc.initGame();
                this.isContinue = true;
                break;
            }
            case 2: {
                this.resetMode(2);
                break;
            }
            case 3: {
                this.resetMode(3);
                break;
            }
            case 4: {
                this.resetMode(4);
                break;
            }
            case 5: {
                this.dc.midlet.exit();
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void input(int KEY) {
        block44: {
            block43: {
                block42: {
                    block41: {
                        if (KEY == this.dc.KEY_LEFT_SOFT) break block41;
                        if (KEY != 42) break block42;
                    }
                    this.dc.KEY = 0;
                    return;
                }
                if (KEY == this.dc.KEY_RIGHT_SOFT) break block43;
                if (KEY != 35) break block44;
            }
            switch (this.MENU_MODE) {
                case 2: 
                case 3: 
                case 4: {
                    this.resetMainMenu();
                    return;
                }
            }
            return;
        }
        if (KEY == 49) {
            return;
        }
        if (KEY == 50) {
            switch (this.MENU_MODE) {
                case 1: {
                    if (this.isContinue) {
                        this.selectIndex = (this.selectIndex + 5) % 6;
                    } else {
                        --this.selectIndex;
                        if (this.selectIndex == 0) {
                            this.selectIndex = 5;
                        } else if (this.selectIndex == 6) {
                            this.selectIndex = 5;
                        }
                    }
                    this.dc.KEY = 0;
                    return;
                }
                case 2: {
                    if (this.optionIndex == 0) {
                        this.optionIndex = 1;
                    } else if (this.optionIndex == 1) {
                        this.optionIndex = 0;
                    }
                    this.dc.KEY = 0;
                    return;
                }
                case 3: {
                    if (this.scroll <= 0) return;
                    --this.scroll;
                    return;
                }
            }
            return;
        }
        if (KEY == 56) {
            switch (this.MENU_MODE) {
                case 1: {
                    if (this.isContinue) {
                        this.selectIndex = (this.selectIndex + 1) % 6;
                    } else {
                        ++this.selectIndex;
                        if (this.selectIndex == 6) {
                            this.selectIndex = 1;
                        }
                    }
                    this.dc.KEY = 0;
                    return;
                }
                case 2: {
                    if (this.optionIndex == 0) {
                        this.optionIndex = 1;
                    } else if (this.optionIndex == 1) {
                        this.optionIndex = 0;
                    }
                    this.dc.KEY = 0;
                    return;
                }
                case 3: {
                    if (this.scroll >= 31) return;
                    ++this.scroll;
                    return;
                }
            }
            return;
        }
        if (KEY != 53) return;
        switch (this.MENU_MODE) {
            case 1: {
                this.selection();
                break;
            }
            case 2: {
                if (this.optionIndex == 0) {
                    this.onoffs = !this.onoffs;
                    break;
                }
                if (this.optionIndex != 1) break;
                this.onoffv = !this.onoffv;
                break;
            }
        }
        this.dc.KEY = 0;
    }

    public void run() {
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter <= 60) break;
                this.imgLogo = null;
                this.imgSplash = null;
                this.resetMode(1);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public void paint(Graphics g) {
        g.setFont(this.font);
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter < 40) {
                    g.setColor(0xFFFFFF);
                    g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
                    g.drawImage(this.imgLogo, this.WIDTH >> 1, this.HEIGHT >> 1, 1 | 2);
                    break;
                }
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                break;
            }
            case 1: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgMenuLogo, 74, 0, 0x10 | 4);
                if (this.isContinue) {
                    this.butContinue.paint(g);
                }
                this.butNewGame.paint(g);
                this.butOption.paint(g);
                this.butHelp.paint(g);
                this.butAbout.paint(g);
                this.butExit.paint(g);
                switch (this.selectIndex) {
                    case 0: {
                        if (!this.isContinue || this.butContinue.buttonState != 0) break;
                        this.butContinue.buttonState = 1;
                        this.butContinue.paint(g);
                        this.butContinue.buttonState = 0;
                        break;
                    }
                    case 1: {
                        if (this.butNewGame.buttonState != 0) break;
                        this.butNewGame.buttonState = 1;
                        this.butNewGame.paint(g);
                        this.butNewGame.buttonState = 0;
                        break;
                    }
                    case 2: {
                        if (this.butOption.buttonState != 0) break;
                        this.butOption.buttonState = 1;
                        this.butOption.paint(g);
                        this.butOption.buttonState = 0;
                        break;
                    }
                    case 3: {
                        if (this.butHelp.buttonState != 0) break;
                        this.butHelp.buttonState = 1;
                        this.butHelp.paint(g);
                        this.butHelp.buttonState = 0;
                        break;
                    }
                    case 4: {
                        if (this.butAbout.buttonState != 0) break;
                        this.butAbout.buttonState = 1;
                        this.butAbout.paint(g);
                        this.butAbout.buttonState = 0;
                        break;
                    }
                    case 5: {
                        if (this.butExit.buttonState != 0) break;
                        this.butExit.buttonState = 1;
                        this.butExit.paint(g);
                        this.butExit.buttonState = 0;
                    }
                }
                break;
            }
            case 2: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgMenuLogo, 74, 0, 0x10 | 4);
                g.drawImage(this.imgOptHead, this.WIDTH >> 1, 87, 1 | 0x10);
                if (this.onoffs) {
                    this.butSoundon.paint(g);
                } else {
                    this.butSoundoff.paint(g);
                }
                if (this.onoffv) {
                    this.butVibrateon.paint(g);
                } else {
                    this.butVibrateoff.paint(g);
                }
                if (this.optionIndex == 0) {
                    if (this.onoffs) {
                        if (this.butSoundon.buttonState == 0) {
                            this.butSoundon.buttonState = 1;
                            this.butSoundon.paint(g);
                            this.butSoundon.buttonState = 0;
                        }
                    } else if (this.butSoundoff.buttonState == 0) {
                        this.butSoundoff.buttonState = 1;
                        this.butSoundoff.paint(g);
                        this.butSoundoff.buttonState = 0;
                    }
                } else if (this.optionIndex == 1) {
                    if (this.onoffv) {
                        if (this.butVibrateon.buttonState == 0) {
                            this.butVibrateon.buttonState = 1;
                            this.butVibrateon.paint(g);
                            this.butVibrateon.buttonState = 0;
                        }
                    } else if (this.butVibrateoff.buttonState == 0) {
                        this.butVibrateoff.buttonState = 1;
                        this.butVibrateoff.paint(g);
                        this.butVibrateoff.buttonState = 0;
                    }
                }
                this.buttonHome.paint(g);
                break;
            }
            case 3: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgMenuLogo, 74, 0, 0x10 | 4);
                g.drawImage(this.imgHelpHead, this.WIDTH >> 1, 91, 1 | 0x10);
                g.setFont(SystemFont.font1);
                g.setColor(255, 255, 255);
                g.setClip(5, 130, 230, 166);
                SystemFont.drawText(this.helpString, g, 12, 131 - this.scroll * 11, 220, 0x10 | 4);
                g.setClip(0, 0, 240, 320);
                if (this.scroll < 2) {
                    g.drawImage(this.downarrow, 120, 305, 0x10 | 4);
                } else if (this.scroll >= 2 && this.scroll < 26) {
                    g.drawImage(this.uparrow, 114, 305, 0x10 | 4);
                    g.drawImage(this.downarrow, 126, 305, 0x10 | 4);
                } else if (this.scroll >= 26) {
                    g.drawImage(this.uparrow, 120, 305, 0x10 | 4);
                }
                this.buttonHome.paint(g);
                this.buttonHome.paint(g);
                break;
            }
            case 4: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgMenuLogo, 74, 0, 0x10 | 4);
                if (this.imgAboutLogo != null) {
                    g.drawImage(this.imgAboutLogo, this.WIDTH >> 1, 90, 1 | 0x10);
                }
                this.buttonHome.paint(g);
                break;
            }
            case 5: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgMenuLogo, this.WIDTH >> 1, 48, 1 | 2);
                this.buttonSingleP.paint(g);
                this.buttonMultiP.paint(g);
                this.buttonHome.paint(g);
                break;
            }
            case 6: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgMenuLogo, this.WIDTH >> 1, 48, 1 | 2);
                this.buttonNFC.paint(g);
                this.buttonSamePhone.paint(g);
                this.buttonHome.paint(g);
            }
        }
    }

    protected void pointerDragged(int x, int y) {
        if (this.MENU_MODE == 3) {
            if (y > this.dragedY && this.scroll > 0) {
                --this.scroll;
            }
            if (y < this.dragedY && this.scroll < 31) {
                ++this.scroll;
            }
        }
    }
}

