/*
 * Decompiled with CFR 0.152.
 */
package bluetooth1;

import bluetooth1.ServerConnectionHandler;
import bluetooth1.ServerConnectionHandlerListener;
import bluetooth1.ServerInterface;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.ServiceRecord;

public class Server
implements ServerConnectionHandlerListener {
    ServerConnectionHandler handler;
    private int maxConnections;
    private int sendMessageId = 0;
    public ServerInterface delegate;

    public Server(ServerInterface canvas) {
        this.delegate = canvas;
        String value = LocalDevice.getProperty((String)"bluetooth.connected.devices.max");
        try {
            this.maxConnections = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            this.maxConnections = 0;
        }
        try {
            String address = LocalDevice.getLocalDevice().getBluetoothAddress();
        }
        catch (BluetoothStateException e) {
            // empty catch block
        }
        String deviceName = null;
        try {
            deviceName = LocalDevice.getLocalDevice().getFriendlyName();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.delegate.setDeviceName(deviceName);
    }

    public void makeConnections(ServiceRecord serviceRecord, int security) {
        this.handler = new ServerConnectionHandler(this, serviceRecord, security);
        this.handler.start();
    }

    public void close() {
        if (this.handler != null) {
            this.handler.close();
        }
        this.handler = null;
    }

    public void sendData(byte[] data) {
        Integer id = new Integer(this.sendMessageId++);
        try {
            this.handler.queueMessageForSending(id, data);
        }
        catch (IllegalArgumentException e) {
            String errorMessage = "IllegalArgumentException while trying to send a message: " + e.getMessage();
        }
    }

    public void handleOpen(ServerConnectionHandler handler) {
        this.delegate.setDeviceConnection(true);
    }

    public void handleOpenError(ServerConnectionHandler handler, String errorMessage) {
    }

    public void handleReceivedMessage(ServerConnectionHandler handler, byte[] messageBytes) {
        this.delegate.messageToServer(messageBytes);
    }

    public void handleQueuedMessageWasSent(ServerConnectionHandler handler, Integer id) {
    }

    public void handleClose(ServerConnectionHandler handler) {
        handler = null;
        System.out.println("Server Handler Closed");
    }

    public void handleErrorClose(ServerConnectionHandler handler, String errorMessage) {
        handler = null;
        System.out.println("Server Handler Closed");
    }
}

