/*
 * Decompiled with CFR 0.152.
 */
package math;

import math.DoubleBits;
import math.Frexp;

public class MathEx
implements DoubleBits {
    public static final double LOG2 = 0.693147180559945;
    public static final double LOG10 = 2.30258509299405;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double QUARTER_PI = 0.7853981633974483;
    private static final double[] atanTable = new double[]{1.0, 0.0, -0.3333333333333333, 0.0, 0.2, 0.0, -0.14285714285714285, 0.0, 0.10416666666666667, 0.05, -0.24431818181818182, 0.25, -0.12980769230769232, 0.03571428571428571, -0.004166666666666667};

    public static boolean isInfOrNaN(double d) {
        return (Double.doubleToLongBits(d) & 0x7FF0000000000000L) == 0x7FF0000000000000L;
    }

    public static boolean isNaN(double d) {
        long l = Double.doubleToLongBits(d);
        return (l & 0x7FF0000000000000L) == 0x7FF0000000000000L && (l & 0xFFFFFFFFFFFFFL) != 0L;
    }

    public static boolean isZero(double d, double d2) {
        return d > -d2 && d < d2;
    }

    public static double frac(double d) {
        return d - Math.floor(d);
    }

    public static long round(double d) {
        return (long)(d + 0.5);
    }

    public static int sign(double d) {
        return d == 0.0 ? 0 : (d > 0.0 ? 1 : -1);
    }

    public static double intPower(double d, int n) {
        if (Math.abs(n) > 20) {
            return MathEx.exp(MathEx.log(d) * (double)n);
        }
        double d2 = 1.0;
        for (int i = 0; i < Math.abs(n); ++i) {
            d2 *= d;
        }
        if (n < 0 && d2 != 0.0) {
            return 1.0 / d2;
        }
        return d2;
    }

    public static double safeDiv(double d, double d2) {
        if (d2 == 0.0) {
            return d / 1.0E-50;
        }
        return d / d2;
    }

    public static double safeParseDouble(String string) {
        if (string.length() == 0) {
            return 0.0;
        }
        return Double.parseDouble(string);
    }

    public static double atan(double d) {
        boolean bl;
        boolean bl2;
        if (d == Double.POSITIVE_INFINITY) {
            return 1.5707963267948966;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return -1.5707963267948966;
        }
        if (MathEx.isInfOrNaN(d)) {
            return Double.NaN;
        }
        boolean bl3 = bl2 = d < 0.0;
        if (bl2) {
            d = -d;
        }
        boolean bl4 = bl = d > 1.0;
        if (bl) {
            d = 1.0 / d;
        }
        double d2 = d;
        double d3 = 0.0;
        for (int i = 0; i < atanTable.length; ++i) {
            d3 += d2 * atanTable[i];
            d2 *= d;
        }
        if (bl && (d3 = 1.5707963267948966 - d3) > 1.5707963267948966) {
            d3 -= Math.PI;
        }
        if (bl2) {
            d3 = -d3;
        }
        return d3;
    }

    public static double exp(double d) {
        int n;
        double d2;
        if (d == 0.0) {
            return 1.0;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (MathEx.isInfOrNaN(d)) {
            return Double.NaN;
        }
        Frexp frexp = new Frexp(d);
        if (frexp.exponent > 11) {
            return frexp.sign == 1 ? Double.POSITIVE_INFINITY : 0.0;
        }
        if (frexp.exponent <= -1) {
            d2 = d;
            n = 0;
        } else {
            d2 = (double)frexp.sign * frexp.mantissa * 0.5;
            n = frexp.exponent + 1;
        }
        int n2 = 0;
        double d3 = 0.0;
        for (double d4 = 1.0; d4 != 0.0; d4 *= d2 / (double)(++n2)) {
            d3 += d4;
        }
        for (n2 = 0; n2 < n; ++n2) {
            d3 *= d3;
        }
        return d3;
    }

    public static double log(double d) {
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (d < 0.0 || MathEx.isInfOrNaN(d)) {
            return Double.NaN;
        }
        Frexp frexp = new Frexp(d);
        double d2 = (double)frexp.exponent * 0.693147180559945;
        int n = 1;
        for (double d3 = 1.0 - frexp.mantissa; d3 != 0.0; d3 *= 1.0 - frexp.mantissa) {
            d2 -= d3 / (double)n;
            ++n;
        }
        return d2;
    }

    public static double getPolarAngle(double d, double d2) {
        if (MathEx.isNaN(d) || MathEx.isNaN(d2)) {
            return Double.NaN;
        }
        if (d == 0.0) {
            if (d2 > 0.0) {
                return 1.5707963267948966;
            }
            if (d2 == 0.0) {
                return 0.0;
            }
            return 4.71238898038469;
        }
        double d3 = MathEx.atan(d2 / d);
        if (d < 0.0) {
            return d3 + Math.PI;
        }
        if (d3 < 0.0) {
            return d3 + Math.PI * 2;
        }
        return d3;
    }

    public static double asin(double d) {
        if (MathEx.isNaN(d) || d < -1.0 || d > 1.0) {
            return Double.NaN;
        }
        return 2.0 * MathEx.atan(d / (1.0 + Math.sqrt(1.0 - d * d)));
    }

    public static double acos(double d) {
        return 1.5707963267948966 - MathEx.asin(d);
    }

    public static double sinh(double d) {
        return (MathEx.exp(d) - MathEx.exp(-d)) * 0.5;
    }

    public static double cosh(double d) {
        return (MathEx.exp(d) + MathEx.exp(-d)) * 0.5;
    }

    public static double tanh(double d) {
        return (MathEx.exp(d) - MathEx.exp(-d)) / (MathEx.exp(d) + MathEx.exp(-d));
    }

    public static double asinh(double d) {
        if (MathEx.isNaN(d)) {
            return Double.NaN;
        }
        return MathEx.log(d + Math.sqrt(d * d + 1.0));
    }

    public static double acosh(double d) {
        if (MathEx.isNaN(d) || d < 1.0) {
            return Double.NaN;
        }
        return MathEx.log(d + Math.sqrt(d * d - 1.0));
    }

    public static double atanh(double d) {
        if (MathEx.isNaN(d) || d < -1.0 || d > 1.0) {
            return Double.NaN;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (d == -1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return 0.5 * MathEx.log((1.0 + d) / (1.0 - d));
    }
}

