/*
 * Decompiled with CFR 0.152.
 */
package win;

import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import win.ColorDialog;

public class RGBScrollBar
extends CustomItem {
    private ColorDialog dialog;
    private final int component;
    private int color;
    private boolean traversing;
    private static final int[] GET_BIT = new int[]{16, 8, 0};
    private static final int[] GET_COLOR = new int[]{0x800000, 32768, 128};

    public RGBScrollBar(ColorDialog colorDialog, String string, int n, int n2) {
        super(string);
        this.component = n;
        this.color = n2;
        this.traversing = false;
    }

    protected int getMinContentHeight() {
        return 25;
    }

    protected int getMinContentWidth() {
        return 70;
    }

    protected int getPrefContentHeight(int n) {
        return this.getMinContentHeight();
    }

    protected int getPrefContentWidth(int n) {
        return 230;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int n) {
        if (this.color != n) {
            this.color = n;
            this.repaint();
        }
    }

    private int getPosition() {
        return this.color >> GET_BIT[this.component] & 0xFF;
    }

    private void setPosition(int n) {
        this.setColor(this.getColorAt(n));
    }

    private void userSetPosition(int n) {
        this.setPosition(n);
        this.notifyStateChanged();
    }

    private int getColorAt(int n) {
        int n2 = GET_BIT[this.component];
        return this.color & ~(255 << n2) | n << n2;
    }

    protected void paint(Graphics graphics, int n, int n2) {
        int n3;
        graphics.setColor(0xE0E0E0);
        graphics.fillRect(0, 0, n, n2);
        Font font = Font.getFont((int)64, (int)1, (int)0);
        graphics.setFont(font);
        int n4 = 12;
        int n5 = n - font.charWidth('M') * 3 - 16 - 12;
        int n6 = 2;
        int n7 = n2 - 2;
        int n8 = this.getPosition();
        int n9 = n4;
        for (int i = 0; i < 16; ++i) {
            n3 = n4 + ((n5 - n4) * (i + 1) >> 4);
            graphics.setColor(this.getColorAt(i << 4));
            graphics.fillRect(n9, n6, n3 - n9, n7 - n6);
            n9 = n3;
        }
        graphics.setColor(0);
        graphics.drawRect(n4, 2, n5 - n4 - 1, n7 - n6 - 1);
        n3 = n4 + ((n5 - n4) * n8 >> 8);
        graphics.setColor(0);
        graphics.drawRect(n3 - 2, n6 - 2, 4, n7 - n6 + 3);
        int n10 = n2 / 2;
        graphics.setColor(0);
        graphics.drawLine(4, n10, 7, n10 - 3);
        graphics.drawLine(4, n10, 7, n10 + 3);
        graphics.drawLine(7, n10 - 3, 7, n10 + 3);
        graphics.drawLine(n5 + 7, n10, n5 + 4, n10 - 3);
        graphics.drawLine(n5 + 7, n10, n5 + 4, n10 + 3);
        graphics.drawLine(n5 + 4, n10 - 3, n5 + 4, n10 + 3);
        graphics.setColor(GET_COLOR[this.component]);
        graphics.drawString(String.valueOf(n8), n - 8, (n2 - font.getHeight()) / 2, 24);
        graphics.setFont(null);
    }

    protected boolean traverse(int n, int n2, int n3, int[] nArray) {
        if (!this.traversing) {
            this.traversing = true;
            return true;
        }
        int n4 = this.getPosition();
        switch (n) {
            case 2: {
                if ((n4 & 7) == 0) {
                    this.userSetPosition(Math.max(0, n4 - 8));
                    break;
                }
                this.userSetPosition(n4 & 0xFFFFFFF8);
                break;
            }
            case 5: {
                this.userSetPosition(Math.min(255, (n4 & 0xFFFFFFF8) + 8));
                break;
            }
            case 0: {
                break;
            }
            default: {
                this.traversing = false;
                return false;
            }
        }
        return true;
    }
}

