/*
 * Decompiled with CFR 0.152.
 */
package docobj;

import docobj.DocEntry;
import docobj.PlotRect;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import ui.App;

public class PlotDoc {
    public App app;
    public Vector entries = new Vector();
    public PlotRect window;
    public int clAxis;
    public int clGrid;
    public int clLabel;

    public PlotDoc(App app) {
        this.app = app;
        this.clear();
    }

    public void clear() {
        this.entries.removeAllElements();
        this.window = new PlotRect(this.app.frmPlot.width, this.app.frmPlot.height);
        this.clAxis = 0;
        this.clGrid = 0xC0C0C0;
        this.clLabel = 128;
        DocEntry docEntry = new DocEntry();
        this.functionChanged(docEntry);
        this.entries.addElement(docEntry);
    }

    public DocEntry getEntry(int n) {
        return (DocEntry)this.entries.elementAt(n);
    }

    public void moveEntry(int n, int n2) {
        Object e = this.entries.elementAt(n);
        this.entries.removeElementAt(n);
        this.entries.insertElementAt(e, n2);
    }

    public void functionChanged(DocEntry docEntry) {
        docEntry.compile();
        docEntry.recalcGraph(this.window);
    }

    public void windowChanged(boolean bl) {
        if (bl) {
            for (int i = 0; i < this.entries.size(); ++i) {
                DocEntry docEntry = this.getEntry(i);
                if (docEntry.kind != 0) continue;
                docEntry.recalcGraph(this.window);
            }
        }
        this.app.frmPlot.repaint();
    }

    public void paint(Graphics graphics) {
        for (int i = 0; i < this.entries.size(); ++i) {
            this.getEntry(i).paint(graphics, this.window);
        }
    }
}

