/*
 * Decompiled with CFR 0.152.
 */
package ui;

import docobj.PlotRect;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import math.MathEx;
import ui.App;
import win.KeyEx;
import win.StringEx;

public class FrmPlot
extends Canvas
implements CommandListener {
    public App app;
    private final Command CMD_FUNCTIONS;
    private final Command CMD_HELP;
    private final Command CMD_LANGUAGE;
    private final Command CMD_QUIT;
    public final int width;
    public final int height;
    public boolean drawClock;
    private static final int MOVE_UP = 1;
    private static final int MOVE_DOWN = 2;
    private static final int MOVE_LEFT = 3;
    private static final int MOVE_RIGHT = 4;
    private static final int ZOOM_IN = 5;
    private static final int ZOOM_OUT = 6;
    private static final int ASPECT_GROW = 7;
    private static final int ASPECT_SHRINK = 8;
    private static final int MENU_FUNCTIONS = 9;
    private static final int GRIDSIZE = 40;
    private static final double SCROLLSTEP = 12.0;
    private static final double ZOOMRATIO = 1.2;
    private Image imageClock;

    public FrmPlot(App app) {
        this.app = app;
        this.CMD_FUNCTIONS = new Command(this.app.langPack.get("FUNCTIONS"), 1, 1);
        this.CMD_HELP = new Command(this.app.langPack.get("HELP"), 5, 2);
        this.CMD_LANGUAGE = new Command("\u042f\u0437\u044b\u043a", 1, 3);
        this.CMD_QUIT = new Command(this.app.langPack.get("QUIT"), 7, 4);
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.drawClock = false;
        try {
            this.imageClock = Image.createImage((String)"/clock.png");
        }
        catch (Exception exception) {
            this.imageClock = null;
        }
        this.addCommand(this.CMD_FUNCTIONS);
        this.addCommand(this.CMD_HELP);
        this.addCommand(this.CMD_LANGUAGE);
        this.addCommand(this.CMD_QUIT);
        this.setCommandListener(this);
    }

    public void show() {
        this.app.display.setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.CMD_FUNCTIONS) {
            this.app.frmFunctions.updateList();
            this.app.frmFunctions.show();
        } else if (command == this.CMD_HELP) {
            this.app.frmInfo.setText(this.app.langPack.get("HELP_CONTENT"));
            this.app.frmInfo.show((Displayable)this);
        } else if (command == this.CMD_LANGUAGE) {
            this.app.frmLanguage.show((Displayable)this);
        } else if (command == this.CMD_QUIT) {
            this.app.quit();
        }
    }

    protected void keyPressed(int n) {
        this.onKeyDown(n);
    }

    protected void keyRepeated(int n) {
        this.onKeyDown(n);
    }

    private void onKeyDown(int n) {
        PlotRect plotRect = this.app.doc.window;
        int n2 = 0;
        block0 : switch (n) {
            case 49: {
                n2 = 5;
                break;
            }
            case 50: {
                n2 = 1;
                break;
            }
            case 51: {
                n2 = 6;
                break;
            }
            case 52: {
                n2 = 3;
                break;
            }
            case 53: {
                n2 = 5;
                break;
            }
            case 54: {
                n2 = 4;
                break;
            }
            case 55: {
                n2 = 7;
                break;
            }
            case 56: {
                n2 = 2;
                break;
            }
            case 57: {
                n2 = 8;
                break;
            }
            default: {
                switch (this.getGameAction(n)) {
                    case 1: {
                        n2 = 1;
                        break block0;
                    }
                    case 6: {
                        n2 = 2;
                        break block0;
                    }
                    case 2: {
                        n2 = 3;
                        break block0;
                    }
                    case 5: {
                        n2 = 4;
                        break block0;
                    }
                    case 8: {
                        n2 = 5;
                        break block0;
                    }
                }
                if (KeyEx.isBack(n)) {
                    n2 = 6;
                    break;
                }
                if (!KeyEx.isClear(n)) break;
                n2 = 9;
            }
        }
        if (n2 == 3 || n2 == 4 || n2 == 5 || n2 == 6 || n2 == 7 || n2 == 8) {
            this.drawClock = true;
            this.repaint();
            this.serviceRepaints();
        }
        switch (n2) {
            case 1: 
            case 2: {
                double d = 12.0 / (plotRect.zoom * plotRect.aspect);
                plotRect.yCenter = n2 == 1 ? (plotRect.yCenter += d) : (plotRect.yCenter -= d);
                this.app.doc.windowChanged(false);
                break;
            }
            case 3: 
            case 4: {
                double d = 12.0 / plotRect.zoom;
                plotRect.xCenter = n2 == 4 ? (plotRect.xCenter += d) : (plotRect.xCenter -= d);
                this.app.doc.windowChanged(true);
                break;
            }
            case 5: {
                plotRect.zoom *= 1.2;
                this.app.doc.windowChanged(true);
                break;
            }
            case 6: {
                plotRect.zoom /= 1.2;
                this.app.doc.windowChanged(true);
                break;
            }
            case 7: {
                plotRect.aspect *= 1.2;
                this.app.doc.windowChanged(true);
                break;
            }
            case 8: {
                plotRect.aspect /= 1.2;
                this.app.doc.windowChanged(true);
                break;
            }
            case 9: {
                this.commandAction(this.CMD_FUNCTIONS, (Displayable)this);
            }
        }
        this.drawClock = false;
        this.repaint();
    }

    public double getGridSize(double d) {
        double d2 = MathEx.safeDiv(40.0, d);
        double d3 = MathEx.intPower(10.0, (int)Math.ceil(MathEx.log(d2) / 2.30258509299405));
        if (d3 * 0.5 >= d2 && (d3 *= 0.5) * 0.5 >= d2) {
            d3 *= 0.5;
        }
        return d3;
    }

    private void drawAxes(Graphics graphics) {
        int n;
        double d;
        PlotRect plotRect = this.app.doc.window;
        int n2 = plotRect.xToView(0.0);
        int n3 = plotRect.yToView(0.0);
        double d2 = this.getGridSize(plotRect.zoom);
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        if ((d = this.getGridSize(plotRect.zoom * plotRect.aspect)) == 0.0) {
            d = 1.0;
        }
        graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
        boolean bl = false;
        for (double d3 = d2 * Math.ceil(plotRect.xMin() / d2); d3 <= plotRect.xMax(); d3 += d2) {
            if (MathEx.isZero(d3, 1.0E-12)) continue;
            n = plotRect.xToView(d3);
            graphics.setColor(this.app.doc.clGrid);
            graphics.drawLine(n, 0, n, this.height);
            graphics.setColor(this.app.doc.clLabel);
            int n4 = bl ? 20 : 36;
            graphics.drawString(StringEx.valueOf(d3, 5), n + 3, n3, n4);
            bl = !bl;
        }
        for (double d4 = d * Math.ceil(plotRect.yMin() / d); d4 <= plotRect.yMax(); d4 += d) {
            if (MathEx.isZero(d4, 1.0E-12)) continue;
            n = plotRect.yToView(d4);
            graphics.setColor(this.app.doc.clGrid);
            graphics.drawLine(0, n, this.width, n);
            graphics.setColor(this.app.doc.clLabel);
            graphics.drawString(StringEx.valueOf(d4, 5), n2 + 3, n, 20);
        }
        graphics.setColor(this.app.doc.clAxis);
        graphics.drawLine(n2, 0, n2, this.height);
        graphics.drawLine(0, n3, this.width, n3);
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.width, this.height);
        this.drawAxes(graphics);
        this.app.doc.paint(graphics);
        int n = this.width / 2;
        int n2 = this.height / 2;
        graphics.setColor(0);
        graphics.drawLine(n, n2 - 10, n, n2 + 10);
        graphics.drawLine(n - 10, n2, n + 10, n2);
        graphics.drawString("x=" + StringEx.valueOf(this.app.doc.window.xCenter, 6), 0, 20, 36);
        graphics.drawString("y=" + StringEx.valueOf(this.app.doc.window.yCenter, 6), 0, 20, 20);
        if (this.drawClock && this.imageClock != null) {
            graphics.drawImage(this.imageClock, this.width / 2, this.height / 2, 3);
        }
    }
}

