/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

public final class AALDevice
extends Canvas {
    public static AALDevice s_instance;
    public static Graphics s_activeGraphics;
    private static Graphics s_backBufferGraphics;
    private static Image s_backBufferImage;
    private static boolean s_isDoubleBuffered;
    public static final int RENDER_SCREEN_WIDTH = 400;
    public static final int RENDER_SCREEN_HEIGHT = 240;
    public static final int RESIZE_FACTOR = 1;
    public static int s_width;
    public static int s_width_s;
    public static int s_height;
    private static final int TRANSROTATE_90 = 1;
    private static final int TRANSROTATE_270 = 3;
    private static Image s_imageToTransform;
    private static int[] s_imageData;
    private static int[] s_transformation;
    private static int[] s_transformedImage;
    private static int s_transformedWidth;
    private static int s_transformedHeight;
    private static int s_usedTransformation;
    private static boolean s_soundIsSoundEnabled;
    private static Player s_soundPlayer;
    private static int s_currentlyLoadedSoundFileId;
    public static boolean s_soundIsFX;
    private static int s_soundFileId;
    private static boolean s_isCurrentSoundLooping;
    private static long s_SoundReloadTimer;
    private static boolean s_isSoundReloading;
    private static int SOUND_RELOAD_INTERVAL;
    private static int SOUND_RELOAD_DELAY;
    private static final String SOUND_FORMAT_MIDI = "audio/midi";
    private static final String SOUND_FORMAT_AMR = "audio/x-wav";
    private static boolean s_isSoundInterrupted;
    private static boolean s_vibrationEnabled;
    public static final byte COMMAND_TYPE_OK = 0;
    public static final byte COMMAND_TYPE_NOT_OK = 1;
    public static final byte COMMAND_TYPE_MENU = 2;
    public static final int SOFTKEY_LEFT = 0;
    public static final int SOFTKEY_RIGHT = 1;
    public static final int SOFTKEY_CLEAR = 2;
    private static byte[] s_commandTypes;
    private static int s_leftSoftkeyCommandIndex;
    private static int s_rightSoftkeyCommandIndex;
    private static int s_clearSoftkeyCommandIndex;
    public static int s_commandReceivedIndex;
    private static int s_commandReceivedIndexAsync;
    private static final int SOFTKEY_CODE_LEFT = -6;
    private static final int SOFTKEY_CODE_RIGHT = -7;
    private static final int SOFTKEY_CODE_CLEAR = 0;
    private static final int KEY_CODE_HANG_UP = 0;
    private static final int KEY_CODE_PICK_UP = 0;
    private static final int KEY_CODE_UP = 0;
    private static final int KEY_CODE_DOWN = 0;
    private static final int KEY_CODE_FIRE = 0;
    private static final int KEY_CODE_LEFT = 0;
    private static final int KEY_CODE_RIGHT = 0;
    public static final int VK_INVALID = 0;
    public static final int VK_NUM0 = 2;
    public static final int VK_NUM1 = 4;
    public static final int VK_NUM2 = 8;
    public static final int VK_NUM3 = 16;
    public static final int VK_NUM4 = 32;
    public static final int VK_NUM5 = 64;
    public static final int VK_NUM6 = 128;
    public static final int VK_NUM7 = 256;
    public static final int VK_NUM8 = 512;
    public static final int VK_NUM9 = 1024;
    public static final int VK_POUND = 2048;
    public static final int VK_STAR = 4096;
    public static final int VK_LEFT = 8192;
    public static final int VK_RIGHT = 16384;
    public static final int VK_UP = 32768;
    public static final int VK_DOWN = 65536;
    public static final int VK_FIRE = 131072;
    public static final int VK_SOFTKEY_LEFT = 262144;
    public static final int VK_SOFTKEY_RIGHT = 524288;
    public static final int VK_SOFTKEY_CLEAR = 0x100000;
    public static final int SOFTKEY_WIDTH = 75;
    public static final int SOFTKEY_HEIGHT = 20;
    public static boolean s_pointerPressed;
    public static int s_pointerXlastpressed;
    public static int s_pointerYlastpressed;
    public static int s_virtualKeysPressed;
    public static int s_virtualKeysReleased;
    public static int s_virtualKeysDown;
    public static boolean s_anyKeyPressed;
    private static int s_virtualKeysPressedAsync;
    private static int s_virtualKeysReleasedAsync;
    private static int s_virtualKeysDownAsync;
    public static boolean s_anyKeyPressedAsync;
    public static int s_pointerX;
    public static int s_pointerY;
    public static int s_pointerXAsync;
    public static int s_pointerYAsync;
    public static int s_currentShift;
    public static boolean s_pointerActive;
    public static boolean s_pointerActiveAsync;
    private static long s_firstKeyReleaseTime;
    private static long s_secondKeyReleaseTime;
    private static int s_previousP_X;
    private static int s_previousP_Y;
    private static boolean wasFirstKeyReleased;
    private static int s_maxTimeBetweenPresses;
    public static long lPointerKeyReleaseTime;
    public static int s_viewportWidth;
    public static int s_viewportHeight;
    public static final int RECORDSTORE_CACHE_INDEX_START = 0;
    public static final int RECORDSTORE_CACHE_INDEX_END = 5;
    public static final int RECORDSTORE_STATUS_SAVE_TO_FILE_SYSTEM_ENABLED = 1;
    public static final int RECORDSTORE_STATUS_SAVE_TO_CACHE_ENABLED = 2;
    public static final int RECORDSTORE_STATUS_LOAD_FROM_FILE_SYSTEM_ENABLED = 4;
    public static final int RECORDSTORE_STATUS_LOAD_FROM_CACHE_ENABLED = 8;
    private static final byte[][] s_rmsCache;
    public static int s_rmsStatus;
    static final int VOLUME_TYPE_FILESYSTEM = 0;
    static final int VOLUME_TYPE_BIGFILE = 1;
    private static final int FILEREF_CHUNK_TYPE_UTF8 = 0;
    private static final int FILEREF_CHUNK_TYPE_UBYTE = 1;
    private static final int FILEREF_CHUNK_TYPE_USHORT = 2;
    private static final int FILEREF_CHUNK_TYPE_UINT = 4;
    private static String[] s_volumeNamesArray;
    static int[] s_volumeTypesArray;
    static byte[][] s_volumeBufferArray;
    static String[] s_systemFileNamesArray;
    private static int[] s_systemFileSizeArray;
    private static int[] s_crc32Table;
    private static final byte[] PNG_SIGNATURE;
    private static final byte[] PNG_CHUNK_IEND;
    private static final byte[] PNG_CHUNK_tRNS;
    public static boolean s_forcePaletteCopy;
    private static byte[] s_rSrc;
    private static byte[] s_gSrc;
    private static byte[] s_bSrc;
    private static byte[] s_rDst;
    private static byte[] s_gDst;
    private static byte[] s_bDst;
    private static int[] s_fillLineBuffer;
    private static int s_fillColor;

    public AALDevice() {
        AALDevice.generateTransformationTable(400, 240, 1, 1);
        this.setFullScreenMode(true);
        s_instance = this;
        s_isDoubleBuffered = false;
    }

    private static void generateTransformationTable(int orgWidth, int orgHeight, int resizeFactor, int transformation) {
        block16: {
            block17: {
                block15: {
                    if (transformation != 0 || resizeFactor != 1) {
                        s_imageData = new int[orgWidth * orgHeight];
                        s_transformation = new int[orgWidth * orgHeight * resizeFactor * resizeFactor];
                        s_transformedImage = new int[orgWidth * orgHeight * resizeFactor * resizeFactor];
                        s_imageToTransform = Image.createImage((int)400, (int)240);
                    }
                    s_usedTransformation = transformation;
                    if (transformation == 3 || transformation == 1) {
                        s_transformedWidth = orgHeight * resizeFactor;
                        s_transformedHeight = orgWidth * resizeFactor;
                    } else {
                        s_transformedWidth = orgWidth * resizeFactor;
                        s_transformedHeight = orgHeight * resizeFactor;
                    }
                    if (transformation != 1) break block15;
                    for (int i = 0; i < s_transformedWidth / resizeFactor; ++i) {
                        for (int j = 0; j < s_transformedHeight / resizeFactor; ++j) {
                            for (int k = 0; k < resizeFactor; ++k) {
                                for (int l = 0; l < resizeFactor; ++l) {
                                    AALDevice.s_transformation[i * resizeFactor + k + (j * resizeFactor + l) * (orgHeight * resizeFactor)] = j + (orgHeight - i - 1) * orgWidth;
                                }
                            }
                        }
                    }
                    break block16;
                }
                if (transformation != 3) break block17;
                for (int i = 0; i < s_transformedWidth / resizeFactor; ++i) {
                    for (int j = 0; j < s_transformedHeight / resizeFactor; ++j) {
                        for (int k = 0; k < resizeFactor; ++k) {
                            for (int l = 0; l < resizeFactor; ++l) {
                                AALDevice.s_transformation[i * resizeFactor + k + (j * resizeFactor + l) * (orgHeight * resizeFactor)] = orgWidth - j - 1 + i * orgWidth;
                            }
                        }
                    }
                }
                break block16;
            }
            if (transformation == 0) break block16;
            for (int i = 0; i < s_transformedWidth / resizeFactor; ++i) {
                for (int j = 0; j < s_transformedHeight / resizeFactor; ++j) {
                    for (int k = 0; k < resizeFactor; ++k) {
                        for (int l = 0; l < resizeFactor; ++l) {
                            AALDevice.s_transformation[i * resizeFactor + k + (j * resizeFactor + l) * (orgWidth * resizeFactor)] = i + j * orgWidth;
                        }
                    }
                }
            }
        }
    }

    protected void sizeChanged(int p_width, int p_height) {
        AALMidlet.notifyExternalEvent(4);
    }

    public void paint(Graphics p_graphics) {
        if (!AALMidlet.s_repaintRequested) {
            return;
        }
        int displayW = this.getWidth();
        int displayH = this.getHeight();
        if (s_usedTransformation == 1 || s_usedTransformation == 3) {
            if (s_width > s_height && displayW > displayH) {
                p_graphics.setColor(0xFFFFFF);
                p_graphics.fillRect(0, 0, displayW, displayH);
                p_graphics.setColor(0);
                p_graphics.drawString("Wrong screen orientation.", (displayW - p_graphics.getFont().stringWidth("Wrong screen orientation.")) / 2, displayH / 2 - 4, 36);
                p_graphics.drawString("Please change to continue.", (displayW - p_graphics.getFont().stringWidth("Please change to continue.")) / 2, displayH / 2 + 4, 20);
                return;
            }
        } else if (s_width > s_height && displayW < displayH) {
            p_graphics.setColor(0xFFFFFF);
            p_graphics.fillRect(0, 0, displayW, displayH);
            p_graphics.setColor(0);
            p_graphics.drawString("Wrong screen orientation.", (displayW - p_graphics.getFont().stringWidth("Wrong screen orientation.")) / 2, displayH / 2 - 4, 36);
            p_graphics.drawString("Please change to continue.", (displayW - p_graphics.getFont().stringWidth("Please change to continue.")) / 2, displayH / 2 + 4, 20);
            return;
        }
        s_activeGraphics = s_usedTransformation != 0 ? s_imageToTransform.getGraphics() : p_graphics;
        AALMidlet.paint();
        p_graphics.drawRegion(s_imageToTransform, 0, 0, 400, 240, 5, 0, 0, 0);
        s_activeGraphics = null;
        AALMidlet.s_repaintRequested = false;
    }

    protected void showNotify() {
        AALMidlet.notifyExternalEvent(3);
    }

    protected void hideNotify() {
        AALMidlet.notifyExternalEvent(1);
    }

    private static void soundSleep() {
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void soundStopCurrentPlayer() {
        if (s_soundPlayer != null) {
            s_currentlyLoadedSoundFileId = -1;
            s_isCurrentSoundLooping = false;
            try {
                s_soundPlayer.stop();
            }
            catch (Exception e) {
                // empty catch block
            }
            AALDevice.soundSleep();
            try {
                s_soundPlayer.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            AALDevice.soundSleep();
            try {
                s_soundPlayer = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean soundIsSupported() {
        return true;
    }

    public static boolean soundIsEnabled() {
        return s_soundIsSoundEnabled;
    }

    public static void soundSetEnabled(boolean p_enable) {
        s_soundIsSoundEnabled = p_enable;
        if (!p_enable) {
            AALDevice.soundStopCurrentPlayer();
        }
    }

    public static void setSoundInterrupted(boolean p_isPaused) {
        s_isSoundInterrupted = p_isPaused;
        if (s_isSoundInterrupted) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                s_soundPlayer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void loadSound() {
        AALDevice.soundStopCurrentPlayer();
        try {
            DataInputStream inputStream = AALDevice.openFileAsStream(s_soundFileId);
            s_soundPlayer = s_soundIsFX ? Manager.createPlayer((InputStream)inputStream, (String)SOUND_FORMAT_AMR) : Manager.createPlayer((InputStream)inputStream, (String)SOUND_FORMAT_MIDI);
            AALDevice.soundSleep();
            s_currentlyLoadedSoundFileId = s_soundFileId;
            if (!s_soundIsFX) {
                s_soundPlayer.prefetch();
                AALDevice.soundSleep();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int soundCreate(int p_fileId, boolean p_isSFX) {
        s_soundFileId = p_fileId;
        s_soundIsFX = p_isSFX;
        return 0;
    }

    public static void soundPlay(int p_id, int p_loopCount) {
        if (p_id != 0 || !s_soundIsSoundEnabled) {
            return;
        }
        if (s_soundPlayer != null && s_currentlyLoadedSoundFileId == s_soundFileId && s_soundPlayer.getState() == 400) {
            return;
        }
        AALDevice.loadSound();
        if (s_soundIsFX) {
            p_loopCount = 1;
            s_isCurrentSoundLooping = false;
        } else {
            s_isCurrentSoundLooping = p_loopCount == -1;
        }
        try {
            s_soundPlayer.setLoopCount(p_loopCount);
        }
        catch (Exception e) {
            // empty catch block
        }
        AALDevice.soundSleep();
        try {
            s_soundPlayer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void soundRelease(int p_id) {
        if (p_id == 0) {
            AALDevice.soundStopCurrentPlayer();
        }
    }

    public static void soundUpdate() {
        if (s_isCurrentSoundLooping) {
            if (s_isSoundReloading) {
                long l_currentTime = System.currentTimeMillis();
                if (l_currentTime - s_SoundReloadTimer > (long)SOUND_RELOAD_DELAY) {
                    s_SoundReloadTimer = l_currentTime;
                    AALDevice.soundStopCurrentPlayer();
                    AALDevice.soundPlay(0, -1);
                    s_isSoundReloading = false;
                } else {
                    AALDevice.soundSleep();
                }
            } else if (s_soundPlayer.getState() != 400) {
                long l_currentTime = System.currentTimeMillis();
                if (l_currentTime - s_SoundReloadTimer < (long)SOUND_RELOAD_INTERVAL) {
                    return;
                }
                s_isSoundReloading = true;
                s_SoundReloadTimer = l_currentTime;
            }
        }
    }

    public static void cleanupSounds() {
        s_soundFileId = -1;
        s_currentlyLoadedSoundFileId = -1;
        s_soundPlayer = null;
        s_isCurrentSoundLooping = false;
    }

    public static boolean vibrationIsSupported() {
        boolean isSupported = false;
        try {
            isSupported = AALMidlet.s_display.vibrate(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isSupported;
    }

    public static boolean vibrationIsEnabled() {
        return s_vibrationEnabled;
    }

    public static void vibrationSetEnabled(boolean p_enabled) {
        try {
            s_vibrationEnabled = p_enabled;
            if (!p_enabled) {
                AALMidlet.s_display.vibrate(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void vibrationStart(int p_duration) {
        try {
            if (s_vibrationEnabled) {
                AALMidlet.s_display.vibrate(p_duration);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void vibrationUpdate(int p_elapsedTime) {
    }

    public static void setCommands(byte[] p_commandTypes, String[] p_commandLabels) {
        AALDevice.removeAllCommands();
        s_commandTypes = p_commandTypes;
    }

    public static void addCommand(int p_commandIndex) {
        switch (s_commandTypes[p_commandIndex]) {
            case 0: {
                s_leftSoftkeyCommandIndex = p_commandIndex;
                break;
            }
            case 1: {
                s_rightSoftkeyCommandIndex = p_commandIndex;
                s_clearSoftkeyCommandIndex = p_commandIndex;
                break;
            }
            case 2: {
                s_leftSoftkeyCommandIndex = p_commandIndex;
                s_clearSoftkeyCommandIndex = p_commandIndex;
            }
        }
    }

    public static void removeAllCommands() {
        s_leftSoftkeyCommandIndex = -1;
        s_rightSoftkeyCommandIndex = -1;
        s_clearSoftkeyCommandIndex = -1;
        s_commandReceivedIndex = -1;
        s_commandReceivedIndexAsync = -1;
    }

    public static void updateCommandHandler() {
        s_commandReceivedIndex = s_commandReceivedIndexAsync;
        s_commandReceivedIndexAsync = -1;
    }

    public static int getCommandIndexFromSoftkey(int p_softkey) {
        if (p_softkey == 0) {
            return s_leftSoftkeyCommandIndex;
        }
        if (p_softkey == 2) {
            return s_clearSoftkeyCommandIndex;
        }
        return s_rightSoftkeyCommandIndex;
    }

    public static void onSoftkeyPressed(int p_softkey) {
        if (p_softkey == 0 && s_leftSoftkeyCommandIndex >= 0) {
            s_commandReceivedIndexAsync = s_leftSoftkeyCommandIndex;
        } else if (p_softkey == 1 && s_rightSoftkeyCommandIndex >= 0) {
            s_commandReceivedIndexAsync = s_rightSoftkeyCommandIndex;
        } else if (p_softkey == 2 && s_clearSoftkeyCommandIndex >= 0) {
            s_commandReceivedIndexAsync = s_clearSoftkeyCommandIndex;
        }
    }

    public static void clearKeyStates() {
        s_virtualKeysPressed = 0;
        s_virtualKeysReleased = 0;
        s_virtualKeysDown = 0;
        s_anyKeyPressed = false;
        s_virtualKeysPressedAsync = 0;
        s_virtualKeysReleasedAsync = 0;
        s_virtualKeysDownAsync = 0;
        s_anyKeyPressedAsync = false;
        s_pointerXAsync = 0;
        s_pointerYAsync = 0;
        s_pointerActiveAsync = false;
        s_pointerX = 0;
        s_pointerY = 0;
        s_pointerActive = false;
    }

    public void keyPressed(int p_rawKeyCode) {
        int virtualKeyCode;
        if (p_rawKeyCode != 0 && p_rawKeyCode != 0) {
            s_anyKeyPressedAsync = true;
        }
        if (((virtualKeyCode = AALDevice.getVirtualKeyCodeFromRawKeyCode(p_rawKeyCode)) & 0x40000) != 0) {
            AALDevice.onSoftkeyPressed(0);
        } else if ((virtualKeyCode & 0x80000) != 0) {
            AALDevice.onSoftkeyPressed(1);
        } else if ((virtualKeyCode & 0x100000) != 0) {
            AALDevice.onSoftkeyPressed(2);
        }
        s_virtualKeysPressedAsync |= virtualKeyCode;
        s_virtualKeysDownAsync |= virtualKeyCode;
    }

    protected void keyReleased(int p_rawKeyCode) {
        int virtualKeyCode = AALDevice.getVirtualKeyCodeFromRawKeyCode(p_rawKeyCode);
        s_virtualKeysReleasedAsync |= virtualKeyCode;
    }

    protected void keyRepeated(int p_rawKeyCode) {
        int virtualKeyCode = AALDevice.getVirtualKeyCodeFromRawKeyCode(p_rawKeyCode);
        if (p_rawKeyCode != 0) {
            s_anyKeyPressedAsync = true;
        }
        s_virtualKeysDownAsync |= virtualKeyCode;
        s_virtualKeysPressedAsync &= ~virtualKeyCode;
    }

    public void pointerPressed(int p_x, int p_y) {
        int p_x_temp = p_y / 1;
        int p_y_temp = (s_height * 1 - p_x) / 1;
        p_x = p_x_temp;
        p_y = p_y_temp;
        this.handleTouchScreenSoftkeys(p_x, p_y, true);
        s_pointerPressed = true;
        s_pointerXlastpressed = p_x -= s_currentShift;
        s_pointerYlastpressed = p_y;
        s_pointerActiveAsync = true;
        s_pointerXAsync = p_x;
        s_pointerYAsync = p_y;
        this.handleTouchScreenSoftkeys(p_x, p_y, true);
        if (System.currentTimeMillis() - s_firstKeyReleaseTime > (long)s_maxTimeBetweenPresses) {
            wasFirstKeyReleased = true;
        }
        if (wasFirstKeyReleased) {
            s_previousP_X = p_x;
            s_previousP_Y = p_y;
            s_firstKeyReleaseTime = System.currentTimeMillis();
            s_secondKeyReleaseTime = 0L;
            wasFirstKeyReleased = false;
        } else if (p_x - s_previousP_X < 25 && p_x - s_previousP_X > -25 && p_y - s_previousP_Y < 25 && p_y - s_previousP_Y > -25) {
            s_secondKeyReleaseTime = System.currentTimeMillis();
            s_previousP_X = -1;
            s_previousP_Y = -1;
            wasFirstKeyReleased = true;
        } else {
            s_firstKeyReleaseTime = 0L;
            s_secondKeyReleaseTime = 0L;
            s_previousP_X = -1;
            s_previousP_Y = -1;
            wasFirstKeyReleased = true;
        }
    }

    public void pointerReleased(int p_x, int p_y) {
        int p_x_temp = p_y / 1;
        int p_y_temp = (s_height * 1 - p_x) / 1;
        p_x = p_x_temp;
        p_y = p_y_temp;
        this.handleTouchScreenSoftkeys(p_x, p_y, false);
        s_pointerPressed = false;
        s_pointerXlastpressed = 0;
        s_pointerYlastpressed = 0;
        this.handleTouchScreenSoftkeys(p_x -= s_currentShift, p_y, false);
    }

    public void keypress(int p_RawCode, boolean p_pressed) {
        if (p_pressed) {
            this.keyPressed(p_RawCode);
        } else {
            this.keyReleased(p_RawCode);
        }
    }

    public static boolean wasDoubleTapped(int p_interval) {
        s_maxTimeBetweenPresses = p_interval;
        if (s_secondKeyReleaseTime == 0L || s_firstKeyReleaseTime == 0L) {
            return false;
        }
        if (s_secondKeyReleaseTime - s_firstKeyReleaseTime < (long)p_interval) {
            s_firstKeyReleaseTime = 0L;
            s_secondKeyReleaseTime = 0L;
            return true;
        }
        s_firstKeyReleaseTime = 0L;
        s_secondKeyReleaseTime = 0L;
        return false;
    }

    public void handleTouchScreenSoftkeys(int p_x, int p_y, boolean p_presses) {
        if (p_x > 0 && p_x < 75 && p_y < s_height && p_y > s_height - 20) {
            this.keypress(-6, p_presses);
        } else if (p_x < s_width && p_x > s_width - 75 && p_y < s_height && p_y > s_height - 20) {
            this.keypress(-7, p_presses);
        }
    }

    public static void updateKeyboardHandler() {
        s_virtualKeysPressed = s_virtualKeysPressedAsync;
        s_virtualKeysReleased = s_virtualKeysReleasedAsync;
        s_virtualKeysDown = s_virtualKeysDownAsync;
        s_anyKeyPressed = s_anyKeyPressedAsync;
        s_virtualKeysPressedAsync = 0;
        s_virtualKeysReleasedAsync = 0;
        s_virtualKeysDownAsync &= ~s_virtualKeysReleased;
        s_anyKeyPressedAsync = false;
        s_pointerActive = s_pointerActiveAsync;
        s_pointerX = s_pointerXAsync;
        s_pointerY = s_pointerYAsync;
        s_pointerActiveAsync = false;
        s_pointerXAsync = 0;
        s_pointerYAsync = 0;
    }

    private static int getVirtualKeyCodeFromRawKeyCode(int p_rawKeyCode) {
        if (p_rawKeyCode == 0 || p_rawKeyCode == 0 || p_rawKeyCode == 0) {
            return 0;
        }
        if (p_rawKeyCode == -6 || p_rawKeyCode == 6) {
            return 262144;
        }
        if (p_rawKeyCode == -7 || p_rawKeyCode == 7) {
            return 524288;
        }
        if (p_rawKeyCode == 0 || p_rawKeyCode == 0) {
            return 0x100000;
        }
        int virtualKeyCode = 0;
        switch (p_rawKeyCode) {
            case 48: {
                virtualKeyCode = 2;
                break;
            }
            case 49: {
                virtualKeyCode = 4;
                break;
            }
            case 50: {
                virtualKeyCode = 8;
                break;
            }
            case 51: {
                virtualKeyCode = 16;
                break;
            }
            case 52: {
                virtualKeyCode = 32;
                break;
            }
            case 53: {
                virtualKeyCode = 64;
                break;
            }
            case 54: {
                virtualKeyCode = 128;
                break;
            }
            case 55: {
                virtualKeyCode = 256;
                break;
            }
            case 56: {
                virtualKeyCode = 512;
                break;
            }
            case 57: {
                virtualKeyCode = 1024;
                break;
            }
            case 35: {
                virtualKeyCode = 2048;
                break;
            }
            case 42: {
                virtualKeyCode = 4096;
            }
        }
        if (virtualKeyCode == 0) {
            try {
                int midpGameAction = 0;
                midpGameAction = s_instance.getGameAction(p_rawKeyCode);
                if (p_rawKeyCode == 0) {
                    // empty if block
                }
                if (p_rawKeyCode == 0) {
                    // empty if block
                }
                if (p_rawKeyCode == 0) {
                    // empty if block
                }
                if (p_rawKeyCode == 0) {
                    // empty if block
                }
                if (p_rawKeyCode == 0) {
                    // empty if block
                }
                switch (midpGameAction) {
                    case 2: {
                        virtualKeyCode = 8192;
                        break;
                    }
                    case 5: {
                        virtualKeyCode = 16384;
                        break;
                    }
                    case 1: {
                        virtualKeyCode = 32768;
                        break;
                    }
                    case 6: {
                        virtualKeyCode = 65536;
                        break;
                    }
                    case 8: {
                        virtualKeyCode = 131072;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                virtualKeyCode = 0;
            }
        }
        return virtualKeyCode;
    }

    private static String keyCodeToGameActionString(int p_keyCode) {
        String s = "unknown";
        try {
            switch (s_instance.getGameAction(p_keyCode)) {
                case 2: {
                    s = "LEFT";
                    break;
                }
                case 5: {
                    s = "RIGHT";
                    break;
                }
                case 1: {
                    s = "UP";
                    break;
                }
                case 6: {
                    s = "DOWN";
                    break;
                }
                case 8: {
                    s = "FIRE";
                    break;
                }
                case 9: {
                    s = "GAME_A";
                    break;
                }
                case 10: {
                    s = "GAME_B";
                    break;
                }
                case 11: {
                    s = "GAME_C";
                    break;
                }
                case 12: {
                    s = "GAME_D";
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return s;
    }

    public static void viewportSetBounds(int p_viewportLeft, int p_viewportTop, int p_viewportWidth, int p_viewportHeight) {
        s_viewportWidth = p_viewportWidth;
        s_viewportHeight = p_viewportHeight;
        if (s_activeGraphics != null) {
            s_activeGraphics.translate(-s_activeGraphics.getTranslateX() + p_viewportLeft, -s_activeGraphics.getTranslateY() + p_viewportTop);
            s_activeGraphics.setClip(0, 0, p_viewportWidth, p_viewportHeight);
        }
    }

    public static void rmsSaveData(String p_recordStoreName, int p_recordStoreCacheIndex, byte[] p_recordStoreData) throws RecordStoreException {
        if ((s_rmsStatus & 2) != 0) {
            AALDevice.s_rmsCache[p_recordStoreCacheIndex] = p_recordStoreData;
        }
        if ((s_rmsStatus & 1) == 0) {
            return;
        }
        try {
            RecordStore.deleteRecordStore((String)p_recordStoreName);
        }
        catch (RecordStoreNotFoundException e) {
            // empty catch block
        }
        if (p_recordStoreData == null) {
            return;
        }
        RecordStore recordStore = RecordStore.openRecordStore((String)p_recordStoreName, (boolean)true);
        recordStore.addRecord(p_recordStoreData, 0, p_recordStoreData.length);
        recordStore.closeRecordStore();
    }

    public static byte[] rmsLoadData(String p_recordStoreName, int p_recordStoreCacheIndex) throws RecordStoreException {
        byte[] recordStoreData;
        if ((s_rmsStatus & 8) != 0 && (recordStoreData = s_rmsCache[p_recordStoreCacheIndex]) != null) {
            return recordStoreData;
        }
        if ((s_rmsStatus & 4) == 0) {
            return null;
        }
        RecordStore recordStore = RecordStore.openRecordStore((String)p_recordStoreName, (boolean)false);
        byte[] recordStoreData2 = recordStore.getRecord(1);
        recordStore.closeRecordStore();
        if ((s_rmsStatus & 2) != 0) {
            AALDevice.s_rmsCache[p_recordStoreCacheIndex] = recordStoreData2;
        }
        return recordStoreData2;
    }

    public static void initialize(String[] p_volumeNamesArray, int[] p_volumeTypesArray, String[] p_systemFileNamesArray, int[] p_systemFileSizeArray) {
        s_volumeNamesArray = p_volumeNamesArray;
        s_volumeTypesArray = p_volumeTypesArray;
        s_volumeBufferArray = new byte[p_volumeNamesArray.length][];
        s_systemFileNamesArray = p_systemFileNamesArray;
        s_systemFileSizeArray = p_systemFileSizeArray;
    }

    public static void cleanup() {
        for (int i = 0; i < s_volumeBufferArray.length; ++i) {
            AALDevice.s_volumeBufferArray[i] = null;
        }
    }

    static int getVolumeId(int p_fileId) {
        return p_fileId >>> 24;
    }

    static int getFileIndex(int p_fileId) {
        return p_fileId & 0xFFFFFF;
    }

    static void openVolume(int p_volumeId) throws IOException {
        int volumeType = s_volumeTypesArray[p_volumeId];
        if (volumeType != 0 && volumeType == 1 && s_volumeBufferArray[p_volumeId] == null) {
            DataInputStream bigfileDataInputStream = new DataInputStream(((Object)((Object)s_instance)).getClass().getResourceAsStream(s_volumeNamesArray[p_volumeId]));
            int bigfileLength = bigfileDataInputStream.readInt();
            AALDevice.s_volumeBufferArray[p_volumeId] = new byte[bigfileLength];
            bigfileDataInputStream.readFully(s_volumeBufferArray[p_volumeId]);
            bigfileDataInputStream.close();
            Object var2_2 = null;
        }
    }

    public static DataInputStream openFileAsStream(int p_fileId) throws IOException {
        int fileIndex = AALDevice.getFileIndex(p_fileId);
        int volumeId = AALDevice.getVolumeId(p_fileId);
        int volumeType = s_volumeTypesArray[volumeId];
        AALDevice.openVolume(volumeId);
        DataInputStream fileDataInputStream = null;
        if (volumeType == 0) {
            String filename = s_systemFileNamesArray[fileIndex];
            fileDataInputStream = AALDevice.openFileAsStream(filename);
        } else if (volumeType == 1) {
            fileDataInputStream = new DataInputStream(new ByteArrayInputStream(s_volumeBufferArray[volumeId]));
            int headerChunkLength = fileDataInputStream.readInt();
            fileDataInputStream.readInt();
            fileDataInputStream.skipBytes(fileIndex << 3);
            int fileLength = fileDataInputStream.readInt();
            int fileOffset = fileDataInputStream.readInt();
            fileDataInputStream.reset();
            fileDataInputStream.skipBytes(4 + headerChunkLength + 4 + fileOffset);
        }
        return fileDataInputStream;
    }

    public static DataInputStream openFileAsStream(String p_filename) throws IOException {
        StringBuffer filename = new StringBuffer(p_filename.length() + 1);
        if (p_filename.indexOf(47) != 0) {
            filename.append('/');
        }
        filename.append(p_filename);
        InputStream fileInputStream = ((Object)((Object)s_instance)).getClass().getResourceAsStream(filename.toString());
        return new DataInputStream(fileInputStream);
    }

    public static byte[] openFileAsByteArray(int p_fileId) throws IOException {
        int fileLength = AALDevice.getFileLength(p_fileId);
        DataInputStream fileStream = AALDevice.openFileAsStream(p_fileId);
        byte[] fileArray = new byte[fileLength];
        fileStream.readFully(fileArray, 0, fileLength);
        fileStream.close();
        return fileArray;
    }

    public static int getVolumeTypeFromFile(int p_fileId) {
        return s_volumeTypesArray[AALDevice.getVolumeId(p_fileId)];
    }

    public static int getFileLength(int p_fileId) throws IOException {
        int result = -1;
        int fileIndex = AALDevice.getFileIndex(p_fileId);
        int volumeId = AALDevice.getVolumeId(p_fileId);
        int volumeType = s_volumeTypesArray[volumeId];
        AALDevice.openVolume(volumeId);
        if (volumeType == 0) {
            result = s_systemFileSizeArray[fileIndex];
        } else if (volumeType == 1) {
            DataInputStream fileDataInputStream = new DataInputStream(new ByteArrayInputStream(s_volumeBufferArray[volumeId]));
            fileDataInputStream.readInt();
            fileDataInputStream.readInt();
            fileDataInputStream.skipBytes(fileIndex << 3);
            result = fileDataInputStream.readInt();
            fileDataInputStream.close();
        }
        return result;
    }

    public static int readFilerefChunkIntegerValue(DataInputStream p_filerefChunkInputStream) throws IOException {
        int filerefValue = -1;
        int filerefChunkType = p_filerefChunkInputStream.readUnsignedByte();
        switch (filerefChunkType) {
            case 1: {
                filerefValue = p_filerefChunkInputStream.readUnsignedByte();
                filerefValue = (filerefValue & 0xC0) << 18 | filerefValue & 0x3F;
                break;
            }
            case 2: {
                filerefValue = p_filerefChunkInputStream.readUnsignedShort();
                filerefValue = (filerefValue & 0xF000) << 12 | filerefValue & 0xFFF;
                break;
            }
            case 4: {
                filerefValue = p_filerefChunkInputStream.readInt();
            }
        }
        return filerefValue;
    }

    public static Image createImage(int p_fileId) throws IOException {
        Image image;
        int fileIndex = AALDevice.getFileIndex(p_fileId);
        int volumeId = AALDevice.getVolumeId(p_fileId);
        int volumeType = s_volumeTypesArray[volumeId];
        AALDevice.openVolume(volumeId);
        if (volumeType == 0) {
            String filename = s_systemFileNamesArray[fileIndex];
            image = Image.createImage((String)("/" + filename));
        } else {
            DataInputStream fileDataInputStream = new DataInputStream(new ByteArrayInputStream(s_volumeBufferArray[volumeId]));
            int headerChunkLength = fileDataInputStream.readInt();
            fileDataInputStream.readInt();
            fileDataInputStream.skipBytes(fileIndex << 3);
            int fileLength = fileDataInputStream.readInt();
            int fileOffset = fileDataInputStream.readInt();
            fileDataInputStream.close();
            fileDataInputStream = null;
            image = Image.createImage((byte[])s_volumeBufferArray[volumeId], (int)(4 + headerChunkLength + 4 + fileOffset), (int)fileLength);
        }
        return image;
    }

    public static Image createCustomImage(int p_fileId) throws IOException {
        DataInputStream dataInputStream = AALDevice.openFileAsStream(p_fileId);
        if (dataInputStream == null) {
            return null;
        }
        byte[] data = new byte[dataInputStream.available()];
        int currentOffset = 0;
        dataInputStream.readFully(data);
        if (null != s_rSrc && null != s_gSrc && null != s_bSrc && null != s_rDst && null != s_gDst && null != s_bDst) {
            int j;
            currentOffset = 41;
            int colorsCount = 0;
            if (s_forcePaletteCopy) {
                for (j = 0; j < s_rDst.length; ++j) {
                    data[41 + j * 3] = s_rDst[j];
                    data[41 + j * 3 + 1] = s_gDst[j];
                    data[41 + j * 3 + 2] = s_bDst[j];
                }
                while (data[currentOffset + 2] != 116 || data[currentOffset + 3] != 82 || data[currentOffset + 4] != 78 || data[currentOffset + 5] != 83) {
                    ++colorsCount;
                    currentOffset += 3;
                }
            } else {
                while (data[currentOffset + 2] != 116 || data[currentOffset + 3] != 82 || data[currentOffset + 4] != 78 || data[currentOffset + 5] != 83) {
                    ++colorsCount;
                    for (j = 0; j < s_rSrc.length; ++j) {
                        if (data[currentOffset] != s_rSrc[j] || data[currentOffset + 1] != s_gSrc[j] || data[currentOffset + 2] != s_bSrc[j]) continue;
                        data[currentOffset] = s_rDst[j];
                        data[currentOffset + 1] = s_gDst[j];
                        data[currentOffset + 2] = s_bDst[j];
                    }
                    currentOffset += 3;
                }
            }
            --colorsCount;
            colorsCount *= 3;
            s_rSrc = null;
            s_gSrc = null;
            s_bSrc = null;
            s_rDst = null;
            s_gDst = null;
            s_bDst = null;
            int crcSum = AALDevice.getCrc32(data, 37, ++colorsCount);
            data[37 + colorsCount] = (byte)((crcSum & 0xFF000000) >> 24);
            data[37 + colorsCount + 1] = (byte)((crcSum & 0xFF0000) >> 16);
            data[37 + colorsCount + 2] = (byte)((crcSum & 0xFF00) >> 8);
            data[37 + colorsCount + 3] = (byte)(crcSum & 0xFF);
        }
        Image image = Image.createImage((byte[])data, (int)0, (int)data.length);
        data = null;
        return image;
    }

    public static Image createCustomImage(int p_fileId, byte[] p_data, int[] p_palette) throws IOException {
        if (p_data == null) {
            return null;
        }
        if (null != s_rSrc && null != s_gSrc && null != s_bSrc && null != s_rDst && null != s_gDst && null != s_bDst) {
            int j;
            int currentOffset = 41;
            int availableColorsCount = 0;
            if (s_forcePaletteCopy) {
                for (j = 0; j < s_rDst.length; ++j) {
                    p_data[41 + j * 3] = s_rDst[j];
                    p_data[41 + j * 3 + 1] = s_gDst[j];
                    p_data[41 + j * 3 + 2] = s_bDst[j];
                    ++availableColorsCount;
                }
                ++availableColorsCount;
            } else {
                while (p_data[currentOffset + 2] != 116 || p_data[currentOffset + 3] != 82 || p_data[currentOffset + 4] != 78 || p_data[currentOffset + 5] != 83) {
                    ++availableColorsCount;
                    for (j = 0; j < s_rSrc.length; ++j) {
                        if (p_data[currentOffset] != s_rSrc[j] || p_data[currentOffset + 1] != s_gSrc[j] || p_data[currentOffset + 2] != s_bSrc[j]) continue;
                        p_data[currentOffset] = s_rDst[j];
                        p_data[currentOffset + 1] = s_gDst[j];
                        p_data[currentOffset + 2] = s_bDst[j];
                    }
                    currentOffset += 3;
                }
            }
            --availableColorsCount;
            currentOffset = 41;
            int i = 0;
            while (i < availableColorsCount) {
                p_palette[i] = 0xFF0000 & p_data[currentOffset] << 16;
                int n = i;
                p_palette[n] = p_palette[n] + (0xFF00 & p_data[currentOffset + 1] << 8);
                int n2 = i++;
                p_palette[n2] = p_palette[n2] + (0xFF & p_data[currentOffset + 2]);
                currentOffset += 3;
            }
            s_rSrc = null;
            s_gSrc = null;
            s_bSrc = null;
            s_rDst = null;
            s_gDst = null;
            s_bDst = null;
            availableColorsCount = 0;
            currentOffset = 41;
            while (p_data[currentOffset + 2] != 116 || p_data[currentOffset + 3] != 82 || p_data[currentOffset + 4] != 78 || p_data[currentOffset + 5] != 83) {
                ++availableColorsCount;
                currentOffset += 3;
            }
            --availableColorsCount;
            availableColorsCount *= 3;
            int crcSum = AALDevice.getCrc32(p_data, 37, ++availableColorsCount);
            p_data[37 + availableColorsCount] = (byte)((crcSum & 0xFF000000) >> 24);
            p_data[37 + availableColorsCount + 1] = (byte)((crcSum & 0xFF0000) >> 16);
            p_data[37 + availableColorsCount + 2] = (byte)((crcSum & 0xFF00) >> 8);
            p_data[37 + availableColorsCount + 3] = (byte)(crcSum & 0xFF);
        } else {
            int currentOffset = 41;
            int availableColorsCount = 0;
            while (p_data[currentOffset + 2] != 116 || p_data[currentOffset + 3] != 82 || p_data[currentOffset + 4] != 78 || p_data[currentOffset + 5] != 83) {
                ++availableColorsCount;
                currentOffset += 3;
            }
            --availableColorsCount;
            currentOffset = 41;
            int i = 0;
            while (i < availableColorsCount) {
                p_palette[i] = 0xFF0000 & p_data[currentOffset] << 16;
                int n = i;
                p_palette[n] = p_palette[n] + (0xFF00 & p_data[currentOffset + 1] << 8);
                int n3 = i++;
                p_palette[n3] = p_palette[n3] + (0xFF & p_data[currentOffset + 2]);
                currentOffset += 3;
            }
        }
        Image image = Image.createImage((byte[])p_data, (int)0, (int)p_data.length);
        return image;
    }

    public static void setColorRemap(int[] p_srcPalette, int[] p_dstPalette) {
        if (p_srcPalette.length <= p_dstPalette.length) {
            s_rSrc = new byte[p_srcPalette.length];
            s_gSrc = new byte[p_srcPalette.length];
            s_bSrc = new byte[p_srcPalette.length];
            s_rDst = new byte[p_srcPalette.length];
            s_gDst = new byte[p_srcPalette.length];
            s_bDst = new byte[p_srcPalette.length];
            for (int i = 0; i < p_srcPalette.length; ++i) {
                AALDevice.s_rSrc[i] = (byte)((p_srcPalette[i] & 0xFF0000) >> 16);
                AALDevice.s_gSrc[i] = (byte)((p_srcPalette[i] & 0xFF00) >> 8);
                AALDevice.s_bSrc[i] = (byte)(p_srcPalette[i] & 0xFF);
                AALDevice.s_rDst[i] = (byte)((p_dstPalette[i] & 0xFF0000) >> 16);
                AALDevice.s_gDst[i] = (byte)((p_dstPalette[i] & 0xFF00) >> 8);
                AALDevice.s_bDst[i] = (byte)(p_dstPalette[i] & 0xFF);
            }
        } else {
            AALMidlet.outputDebugString("Error: setColorRemap , bad parameters length ");
        }
    }

    private static int getCrc32(byte[] p_buffer, int p_offset, int p_length) {
        if (s_crc32Table == null) {
            s_crc32Table = new int[256];
            int n = 256;
            while (--n >= 0) {
                int c = n;
                int k = 8;
                while (--k >= 0) {
                    if ((c & 1) != 0) {
                        c = 0xEDB88320 ^ c >>> 1;
                        continue;
                    }
                    c >>>= 1;
                }
                AALDevice.s_crc32Table[n] = c;
            }
        }
        int crc32 = -1;
        while (--p_length >= 0) {
            crc32 = s_crc32Table[(crc32 ^ p_buffer[p_offset]) & 0xFF] ^ crc32 >>> 8;
            ++p_offset;
        }
        return ~crc32;
    }

    private static int writeInt(byte[] p_buffer, int p_offset, int p_value) {
        p_buffer[p_offset++] = (byte)(p_value >>> 24 & 0xFF);
        p_buffer[p_offset++] = (byte)(p_value >>> 16 & 0xFF);
        p_buffer[p_offset++] = (byte)(p_value >>> 8 & 0xFF);
        p_buffer[p_offset++] = (byte)(p_value >>> 0 & 0xFF);
        return p_offset;
    }

    public static AALTileset createTileset(int p_fileId, boolean p_clipTilesetImage) throws IOException {
        AALMidlet.checkLargeElapsedTime();
        DataInputStream tilesetStream = AALDevice.openFileAsStream(p_fileId);
        int tilesetImageResourceIdInteger = AALDevice.readFilerefChunkIntegerValue(tilesetStream);
        int tileRectCount = tilesetStream.readUnsignedByte();
        long[] tileRectArrayShort = new long[tileRectCount];
        for (int i = 0; i < tileRectCount; ++i) {
            tileRectArrayShort[i] = tilesetStream.readLong();
        }
        int tileCount = tilesetStream.readUnsignedByte();
        byte[] indexMap = new byte[tileCount];
        byte[] transMap = new byte[tileCount];
        for (int i = 0; i < tileCount; ++i) {
            indexMap[i] = (byte)tilesetStream.readUnsignedByte();
            transMap[i] = (byte)tilesetStream.readUnsignedByte();
        }
        tilesetStream.close();
        tilesetStream = null;
        AALMidlet.checkLargeElapsedTime();
        AALTileset tileset = AALTileset.createTileset(tilesetImageResourceIdInteger, tileRectArrayShort, indexMap, transMap, p_clipTilesetImage);
        AALMidlet.checkLargeElapsedTime();
        return tileset;
    }

    public static AALTileset createTileset(int p_fileId, boolean p_clipTilesetImage, byte[] p_data, int[] p_palette) throws IOException {
        AALMidlet.checkLargeElapsedTime();
        DataInputStream tilesetStream = AALDevice.openFileAsStream(p_fileId);
        int tilesetImageResourceIdInteger = AALDevice.readFilerefChunkIntegerValue(tilesetStream);
        int tileRectCount = tilesetStream.readUnsignedByte();
        long[] tileRectArrayShort = new long[tileRectCount];
        for (int i = 0; i < tileRectCount; ++i) {
            tileRectArrayShort[i] = tilesetStream.readLong();
        }
        int tileCount = tilesetStream.readUnsignedByte();
        byte[] indexMap = new byte[tileCount];
        byte[] transMap = new byte[tileCount];
        for (int i = 0; i < tileCount; ++i) {
            indexMap[i] = (byte)tilesetStream.readUnsignedByte();
            transMap[i] = (byte)tilesetStream.readUnsignedByte();
        }
        tilesetStream.close();
        tilesetStream = null;
        AALMidlet.checkLargeElapsedTime();
        AALTileset tileset = AALTileset.createTileset(tilesetImageResourceIdInteger, tileRectArrayShort, indexMap, transMap, p_clipTilesetImage, p_data, p_palette);
        AALMidlet.checkLargeElapsedTime();
        return tileset;
    }

    public static void initFill() {
        s_fillLineBuffer = new int[s_width];
    }

    public static void cleanupFill() {
        s_fillLineBuffer = null;
        s_fillColor = 0;
    }

    public static void setFillColor(int p_argb) {
        if (s_fillColor != p_argb) {
            s_fillColor = p_argb;
            int[] buffer = s_fillLineBuffer;
            for (int offset = buffer.length - 1; offset >= 0; --offset) {
                buffer[offset] = p_argb;
            }
        }
    }

    public static void fillRect(int p_x, int p_y, int p_width, int p_height) {
        while (--p_height >= 0) {
            s_activeGraphics.drawRGB(s_fillLineBuffer, 0, s_fillLineBuffer.length, p_x, p_y + p_height, p_width, 1, true);
        }
    }

    public static void fillLine(int p_x, int p_y, int p_width) {
        s_activeGraphics.drawRGB(s_fillLineBuffer, 0, s_fillLineBuffer.length, p_x, p_y, p_width, 1, true);
    }

    static {
        s_width = 400;
        s_width_s = 696;
        s_height = 240;
        s_soundIsSoundEnabled = true;
        s_currentlyLoadedSoundFileId = -1;
        s_soundFileId = -1;
        s_isCurrentSoundLooping = false;
        s_isSoundReloading = false;
        SOUND_RELOAD_INTERVAL = 1000;
        SOUND_RELOAD_DELAY = 1000;
        s_isSoundInterrupted = false;
        s_vibrationEnabled = true;
        s_leftSoftkeyCommandIndex = -1;
        s_rightSoftkeyCommandIndex = -1;
        s_clearSoftkeyCommandIndex = -1;
        s_commandReceivedIndex = -1;
        s_commandReceivedIndexAsync = -1;
        s_pointerPressed = false;
        s_pointerXlastpressed = 0;
        s_pointerYlastpressed = 0;
        s_currentShift = 0;
        s_previousP_X = -1;
        s_previousP_Y = -1;
        wasFirstKeyReleased = true;
        s_maxTimeBetweenPresses = 1000;
        lPointerKeyReleaseTime = 0L;
        s_rmsCache = new byte[5][];
        s_rmsStatus = 15;
        PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        PNG_CHUNK_IEND = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
        PNG_CHUNK_tRNS = new byte[]{0, 0, 0, 1, 116, 82, 78, 83, 0, 64, -26, -40, 102};
        s_forcePaletteCopy = false;
    }
}

