/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class GameRecords {
    public RecordStore gameStore = null;
    private static final byte[] KEY_PLAYER_TURN = new byte[]{(byte)KeyPlayer.PLAY_FIRST};
    private static final byte[] PLAYER2_TURN = new byte[]{(byte)KeyPlayer.PLAY_SECOND};
    private static final byte[] KEY_PLAYER_IS_WHITE = new byte[1];
    private static final byte[] KEY_PLAYER_IS_BLACK = new byte[]{1};
    public static final int KEY_PLAYER = 0;
    public static final int BLUETOOTH_CLIENT_PLAYER = 1;
    public static final int BLUETOOTH_SERVER_PLAYER = 2;
    public static final int SMS_PLAYER = 3;
    public static final int SMS_PLAYER_OFFLINE = 0;
    public static final int SMS_PLAYER_ONLINE = 1;
    public static final String SETTINGS_FILE_NAME = "S_E_T";
    private static final byte[] tempRecord = new byte[1];
    private final byte[] NEW_GAME_PIECE_POS;
    private final byte[] BASE_CASTLE_RIGHT;
    private static final int TURN_RECORD_NUM = 2;
    private static final int KEY_PLAYER_COLOR_RECORD_NUM = 3;
    private static final int PLAYER2_TYPE_RECORD_NUM = 4;
    private static final int CASTLE_RIGHT_RECORD_NUM = 5;
    private static final int LAST_MOVE_RECORD_NUM = 6;
    private static final int TELL_NUMBER_RECORD_NUM = 7;
    public static final int BLACK_RIGHT_CASTLE_OFFSET = 0;
    public static final int BLACK_LEFT_CASTLE_OFFSET = 1;
    public static final int WHITE_RIGHT_CASTLE_OFFSET = 2;
    public static final int WHITE_LEFT_CASTLE_OFFSET = 3;
    public static final byte CAN_CASTLE = 0;
    public static final byte CAN_NOT_CASTLE = 1;

    public GameRecords() {
        byte[] byArray = new byte[64];
        byArray[0] = 2;
        byArray[1] = 3;
        byArray[2] = 4;
        byArray[3] = 5;
        byArray[4] = 6;
        byArray[5] = 4;
        byArray[6] = 3;
        byArray[7] = 2;
        byArray[8] = 1;
        byArray[9] = 1;
        byArray[10] = 1;
        byArray[11] = 1;
        byArray[12] = 1;
        byArray[13] = 1;
        byArray[14] = 1;
        byArray[15] = 1;
        byArray[48] = 7;
        byArray[49] = 7;
        byArray[50] = 7;
        byArray[51] = 7;
        byArray[52] = 7;
        byArray[53] = 7;
        byArray[54] = 7;
        byArray[55] = 7;
        byArray[56] = 8;
        byArray[57] = 9;
        byArray[58] = 10;
        byArray[59] = 11;
        byArray[60] = 12;
        byArray[61] = 10;
        byArray[62] = 9;
        byArray[63] = 8;
        this.NEW_GAME_PIECE_POS = byArray;
        this.BASE_CASTLE_RIGHT = new byte[4];
    }

    public String[] getAllGameNames() {
        String[] gameNames = RecordStore.listRecordStores();
        if (gameNames == null) {
            return new String[0];
        }
        return gameNames;
    }

    public void setGiftOption(String aGiftFor) {
        try {
            RecordStore settings = RecordStore.openRecordStore((String)SETTINGS_FILE_NAME, (boolean)true);
            if (settings.getNumRecords() == 1) {
                settings.addRecord(aGiftFor.getBytes(), 0, aGiftFor.length());
            }
            settings.closeRecordStore();
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getGiftOption() {
        try {
            RecordStore settings = RecordStore.openRecordStore((String)SETTINGS_FILE_NAME, (boolean)true);
            System.out.println(settings.getNumRecords());
            if (settings.getNumRecords() == 2) {
                void var2_5;
                String giftFor = new String(settings.getRecord(2));
                settings.closeRecordStore();
                return var2_5;
            }
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return null;
    }

    public void setSmsOption(int smsOption) {
        try {
            RecordStore settings = RecordStore.openRecordStore((String)SETTINGS_FILE_NAME, (boolean)true);
            GameRecords.tempRecord[0] = (byte)smsOption;
            if (settings.getNumRecords() == 0) {
                settings.addRecord(tempRecord, 0, 1);
            } else {
                settings.setRecord(1, tempRecord, 0, 1);
            }
            settings.closeRecordStore();
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public int getSmsOption() {
        RecordStore settings;
        block5: {
            settings = RecordStore.openRecordStore((String)SETTINGS_FILE_NAME, (boolean)true);
            if (settings.getNumRecords() != 0) break block5;
            return 0;
        }
        try {
            byte smsOption = settings.getRecord(1)[0];
            settings.closeRecordStore();
            return smsOption;
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return 0;
    }

    public boolean openGame(String gameName) {
        this.closeGame();
        try {
            this.gameStore = RecordStore.openRecordStore((String)gameName, (boolean)false);
        }
        catch (RecordStoreFullException e) {
            return false;
        }
        catch (RecordStoreNotFoundException e) {
            return false;
        }
        catch (RecordStoreException e) {
            return false;
        }
        return true;
    }

    public boolean closeGame() {
        if (this.gameStore != null) {
            try {
                this.gameStore.closeRecordStore();
                this.gameStore = null;
            }
            catch (RecordStoreNotOpenException e) {
                return false;
            }
            catch (RecordStoreException e) {
                return false;
            }
        }
        return true;
    }

    public boolean createNewGame(String gameName, int keyPlayerColor, int player2Type) {
        this.closeGame();
        gameName = GameRecords.makeUniqueName(gameName);
        try {
            this.gameStore = RecordStore.openRecordStore((String)gameName, (boolean)true);
            this.gameStore.addRecord(this.NEW_GAME_PIECE_POS, 0, this.NEW_GAME_PIECE_POS.length);
            if (keyPlayerColor == 0) {
                this.gameStore.addRecord(KEY_PLAYER_TURN, 0, 1);
                this.gameStore.addRecord(KEY_PLAYER_IS_WHITE, 0, 1);
            } else {
                this.gameStore.addRecord(PLAYER2_TURN, 0, 1);
                this.gameStore.addRecord(KEY_PLAYER_IS_BLACK, 0, 1);
            }
            GameRecords.tempRecord[0] = (byte)player2Type;
            this.gameStore.addRecord(tempRecord, 0, 1);
            this.gameStore.addRecord(this.BASE_CASTLE_RIGHT, 0, this.BASE_CASTLE_RIGHT.length);
            byte[] lastMove = new byte[6];
            this.gameStore.addRecord(lastMove, 0, lastMove.length);
        }
        catch (RecordStoreNotOpenException e) {
            return false;
        }
        catch (RecordStoreFullException e) {
            return false;
        }
        catch (RecordStoreException e) {
            return false;
        }
        return true;
    }

    public byte[] getPortableGame() {
        byte[] sendMe = new byte[71];
        sendMe[0] = 67;
        try {
            byte[] gameMap = this.gameStore.getRecord(1);
            int i = 0;
            while (i < 64) {
                sendMe[i + 1] = gameMap[i];
                ++i;
            }
            sendMe[65] = this.gameStore.getRecord(2)[0];
            sendMe[66] = this.gameStore.getRecord(3)[0];
            gameMap = this.gameStore.getRecord(5);
            i = 0;
            while (i < 4) {
                sendMe[i + 67] = gameMap[i];
                ++i;
            }
            return sendMe;
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return null;
    }

    public void setPortableGame(byte[] setMe, KeyPlayer keyplayer) {
        try {
            this.gameStore.setRecord(1, setMe, 1, 64);
            if (setMe[65] == KEY_PLAYER_TURN[0]) {
                this.gameStore.setRecord(2, PLAYER2_TURN, 0, 1);
                keyplayer.turn = KeyPlayer.PLAY_SECOND;
            } else {
                this.gameStore.setRecord(2, KEY_PLAYER_TURN, 0, 1);
                keyplayer.turn = KeyPlayer.PLAY_FIRST;
            }
            if (setMe[66] == 0) {
                this.gameStore.setRecord(3, KEY_PLAYER_IS_BLACK, 0, 1);
                keyplayer.type = 1;
            } else {
                this.gameStore.setRecord(3, KEY_PLAYER_IS_WHITE, 0, 1);
                keyplayer.type = 0;
            }
            this.gameStore.setRecord(5, setMe, 67, this.BASE_CASTLE_RIGHT.length);
            GameRecords.tempRecord[0] = 1;
            this.gameStore.setRecord(4, tempRecord, 0, 1);
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public int[][] readGameMap() {
        int[][] gameMap = new int[8][8];
        try {
            byte[] gameMapByte = this.gameStore.getRecord(1);
            int j = 0;
            while (j < 8) {
                int i = 0;
                while (i < 8) {
                    gameMap[j][i] = gameMapByte[j * 8 + i];
                    ++i;
                }
                ++j;
            }
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return gameMap;
    }

    public void changeTurn() {
        try {
            if (this.gameStore.getRecord(2)[0] == KEY_PLAYER_TURN[0]) {
                this.gameStore.setRecord(2, PLAYER2_TURN, 0, 1);
            } else {
                this.gameStore.setRecord(2, KEY_PLAYER_TURN, 0, 1);
            }
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void setTellNum(String num) {
        try {
            if (this.gameStore.getNumRecords() < 7) {
                this.gameStore.addRecord(num.getBytes(), 0, num.length());
            } else {
                this.gameStore.setRecord(7, num.getBytes(), 0, num.length());
            }
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void setLastMove(byte[] lastMoveCode) {
        try {
            this.gameStore.setRecord(6, lastMoveCode, 0, lastMoveCode.length);
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public byte[] getLastMove() {
        try {
            return this.gameStore.getRecord(6);
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return null;
    }

    public void setKeyPlayerColor(int playerColor) {
        try {
            byte[] keyPlayerColor = new byte[]{(byte)playerColor};
            this.gameStore.setRecord(3, keyPlayerColor, 0, 1);
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public byte[] getCastleRight() {
        try {
            return this.gameStore.getRecord(5);
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return null;
    }

    public void setCastleRight(boolean blackCanCastleLeft, boolean blackCanCastleRight, boolean whiteCanCastleLeft, boolean whiteCanCastleRight) {
        byte[] castleRights = new byte[4];
        castleRights[1] = blackCanCastleLeft ? (byte)0 : 1;
        castleRights[0] = blackCanCastleRight ? (byte)0 : 1;
        castleRights[3] = whiteCanCastleLeft ? (byte)0 : 1;
        castleRights[2] = whiteCanCastleRight ? (byte)0 : 1;
        try {
            this.gameStore.setRecord(5, castleRights, 0, castleRights.length);
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void setPlayer2Type(int type) {
        try {
            GameRecords.tempRecord[0] = (byte)type;
            this.gameStore.setRecord(4, tempRecord, 0, 1);
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void deleteGame(String deleteMe) {
        try {
            RecordStore.deleteRecordStore((String)deleteMe);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public String getTellNum() {
        block5: {
            if (this.gameStore != null && this.gameStore.getNumRecords() >= 7) break block5;
            return "09123683523";
        }
        try {
            byte[] tell = this.gameStore.getRecord(7);
            return new String(tell);
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return null;
    }

    public int getTurn() {
        try {
            return this.gameStore.getRecord(2)[0];
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return 0;
    }

    public int getKeyPlayerColor() {
        block6: {
            if (this.gameStore != null) break block6;
            return 0;
        }
        try {
            return this.gameStore.getRecord(3)[0];
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return 0;
    }

    public String getGameName() {
        try {
            if (this.gameStore == null) {
                return GameRecords.makeUniqueName("newGame");
            }
            return this.gameStore.getName();
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            return null;
        }
    }

    public int getPlayer2Type() {
        block6: {
            if (this.gameStore != null) break block6;
            return 0;
        }
        try {
            return this.gameStore.getRecord(4)[0];
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return 0;
    }

    public void movePiece(int fromColumn, int fromRaw, int toColumn, int toRaw) {
        try {
            byte[] map = this.gameStore.getRecord(1);
            map[toColumn + toRaw * 8] = map[fromColumn + fromRaw * 8];
            map[fromColumn + fromRaw * 8] = 0;
            this.gameStore.setRecord(1, map, 0, map.length);
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void changePiece(int inCol, int inRaw, int pieceName) {
        try {
            byte[] map = this.gameStore.getRecord(1);
            map[inCol + inRaw * 8] = (byte)pieceName;
            this.gameStore.setRecord(1, map, 0, map.length);
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private static String makeUniqueName(String gameName) {
        String uniqueName = gameName;
        int i = 2;
        while (GameRecords.isSameName(uniqueName)) {
            uniqueName = String.valueOf(gameName) + "(" + i + ")";
            ++i;
        }
        return uniqueName;
    }

    private static boolean isSameName(String newGame) {
        String[] list = RecordStore.listRecordStores();
        if (list == null) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            if (list[i].equals(newGame)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

