/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class Menu
extends Canvas {
    private int YIndex = 0;
    private Vector list = new Vector();
    private Font articleFont;
    private final Font COMMAND_FONT = Font.getFont((int)0, (int)1, (int)0);
    private int baseIndex = 0;
    private Image backGround = null;
    private String leftCommand = "left";
    private String rightCommand = "right";
    private boolean doEdit = false;
    private int screenWidth = 200;
    private int screenHeight = 200;
    private int articleNumPerPage = 0;
    private int articleBasePos;
    private final char[][] CHARACTERS = new char[][]{{' '}, {'1'}, {'a', 'b', 'c', '2'}, {'d', 'e', 'f', '3'}, {'g', 'h', 'i', '4'}, {'j', 'k', 'l', '5'}, {'m', 'n', 'o', '6'}, {'p', 'q', 'r', 's', '7'}, {'t', 'u', 'v', '8'}, {'w', 'x', 'y', 'z', '9'}, {'#'}, {'*'}};
    private final char[][] NUMBERS = new char[][]{{'0', '+'}, {'1'}, {'2'}, {'3'}, {'4'}, {'5'}, {'6'}, {'7'}, {'8'}, {'9'}, {'#'}, {'*'}};
    private long lastStrokeTime = 0L;
    private int lastKeyStroke = 0;
    private int numOfStroke = 0;
    private static final int STROKE_DELAY = 500;
    private static final int MAX_STRING_SIZE = 16;
    private static final int NOT_SELECTED_ARTICLE_COLOR = 0xFFFFFF;
    private static final int SELECTED_ARTICLE_COLOR = 65297;
    private static final int COMMAND_COLOR = 255;
    public static final int LARG_FONT = 16;
    public static final int MEDIUM_FONT = 0;
    public static final int SMALL_FONT = 8;
    public static final Image MENU_BACK_GROUND = AAChess.createImage("/titulo.png");
    public static final int NOT_EDITABLE = 1;
    public static final int TEXT_FIELD = 2;
    public static final int NUM_FIELD = 3;
    private final Image ARROW_LEFT = AAChess.createImage("/arrow.png");
    private final Image ARROW_RIGHT = Image.createImage((Image)this.ARROW_LEFT, (int)0, (int)0, (int)this.ARROW_LEFT.getWidth(), (int)this.ARROW_LEFT.getHeight(), (int)2);
    private final Image ARROW_UP = Image.createImage((Image)this.ARROW_LEFT, (int)0, (int)0, (int)this.ARROW_LEFT.getWidth(), (int)this.ARROW_LEFT.getHeight(), (int)5);
    private final Image ARROW_DOWN = Image.createImage((Image)this.ARROW_LEFT, (int)0, (int)0, (int)this.ARROW_LEFT.getWidth(), (int)this.ARROW_LEFT.getHeight(), (int)7);
    private final int UNUSED_RAW;
    public static final int LEFT_SOFT = 6;
    public static final int RIGHT_SOFT = 7;
    private MenuListener listener;
    private AAChess midlet;

    public Menu(Image BackGroundImage, AAChess midlet) {
        this.UNUSED_RAW = 4;
        this.setFullScreenMode(true);
        this.midlet = midlet;
        this.articleFont = Font.getFont((int)0, (int)1, (int)0);
        this.backGround = BackGroundImage;
        PlayCanvas.setPieceImage(this.getWidth());
    }

    protected void keyPressed(int keyCode) {
        Article selectedArticle = null;
        if (this.list.size() > 0) {
            selectedArticle = (Article)this.list.elementAt(this.YIndex);
        }
        if (!this.doEdit) {
            this.doMenuMove(keyCode);
            if (selectedArticle == null || selectedArticle.fielType() == 1) {
                this.mapKeyToCommandAtion(keyCode);
            } else if (Menu.leftOrRightSoft(keyCode, this) == 7) {
                this.doEdit = true;
            }
        } else {
            switch (keyCode) {
                case 48: {
                    this.editText(0);
                    break;
                }
                case 49: {
                    this.editText(1);
                    break;
                }
                case 50: {
                    this.editText(2);
                    break;
                }
                case 51: {
                    this.editText(3);
                    break;
                }
                case 52: {
                    this.editText(4);
                    break;
                }
                case 53: {
                    this.editText(5);
                    break;
                }
                case 54: {
                    this.editText(6);
                    break;
                }
                case 55: {
                    this.editText(7);
                    break;
                }
                case 56: {
                    this.editText(8);
                    break;
                }
                case 57: {
                    this.editText(9);
                    break;
                }
                case 35: {
                    this.editText(10);
                    break;
                }
                case 42: {
                    this.editText(11);
                    break;
                }
                default: {
                    this.editText(12);
                }
            }
            if (Menu.leftOrRightSoft(keyCode, this) == 6 || this.getGameAction(keyCode) == 8 && keyCode != 53) {
                this.doEdit = false;
            }
            if (Menu.leftOrRightSoft(keyCode, this) == 7) {
                selectedArticle.clearLastChar();
            }
        }
        this.repaint();
    }

    private void doMenuMove(int keyCode) {
        if (this.list.size() == 0) {
            return;
        }
        Article selectedArticle = (Article)this.list.elementAt(this.YIndex);
        if (this.getGameAction(keyCode) == 2) {
            selectedArticle.previous();
        } else if (this.getGameAction(keyCode) == 5) {
            selectedArticle.next();
        } else if (this.getGameAction(keyCode) == 6) {
            this.YIndex = (this.YIndex + 1) % this.list.size();
            this.setBaseIndex();
        } else if (this.getGameAction(keyCode) == 1) {
            if (--this.YIndex < 0) {
                this.YIndex = this.list.size() - 1;
            }
            this.setBaseIndex();
        }
    }

    private void mapKeyToCommandAtion(int keyCode) {
        if (Menu.leftOrRightSoft(keyCode, this) == 6) {
            this.listener.CommandAction(6);
        } else if (Menu.leftOrRightSoft(keyCode, this) == 7) {
            this.listener.CommandAction(7);
        } else if (this.getGameAction(keyCode) == 8) {
            this.listener.CommandAction(8);
        } else {
            this.listener.CommandAction(keyCode);
        }
    }

    public static int leftOrRightSoft(int keyCode, Canvas myCanvas) {
        if (keyCode == -21) {
            return 6;
        }
        if (keyCode == -22) {
            return 7;
        }
        if (keyCode == -6 && myCanvas.getGameAction(keyCode) != 6) {
            return 6;
        }
        if (keyCode == -7) {
            return 7;
        }
        return keyCode;
    }

    private void editText(int keyCode) {
        Article seletedArticle = (Article)this.list.elementAt(this.YIndex);
        char[][] chart = seletedArticle.getChart();
        if (System.currentTimeMillis() - this.lastStrokeTime < 500L && this.lastKeyStroke == keyCode && keyCode < 12 && chart[keyCode].length > 1) {
            this.numOfStroke = (this.numOfStroke + 1) % chart[keyCode].length;
            char pressChar = chart[keyCode][this.numOfStroke];
            seletedArticle.clearLastChar();
            seletedArticle.addChar(pressChar);
        } else if (keyCode < 12) {
            this.numOfStroke = 0;
            char pressChar = chart[keyCode][this.numOfStroke];
            seletedArticle.addChar(pressChar);
        }
        this.lastKeyStroke = keyCode;
        this.lastStrokeTime = System.currentTimeMillis();
    }

    protected void paint(Graphics graphics) {
        this.screenHeight = this.getHeight();
        this.screenWidth = this.getWidth();
        this.articleNumPerPage = this.screenHeight / this.articleFont.getHeight() - 4;
        this.articleBasePos = 2 * this.articleFont.getHeight();
        boolean addEditCommand = false;
        graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
        graphics.setFont(this.articleFont);
        this.drawBackground(graphics);
        int i = this.baseIndex;
        while (i < this.articleNumPerPage + this.baseIndex && i < this.list.size()) {
            Article drawingArticle = (Article)this.list.elementAt(i);
            int yDrawingPos = this.articleBasePos + (i - this.baseIndex) * this.articleFont.getHeight();
            String printMe = drawingArticle.getString();
            if (i == this.YIndex) {
                graphics.setColor(65297);
                int yPos = yDrawingPos + this.articleFont.getHeight() / 2;
                int articleWidth = this.articleFont.stringWidth(drawingArticle.getString());
                if (drawingArticle.fielType() == 2 | drawingArticle.fielType() == 3) {
                    int maxWidth = this.articleFont.charWidth('a') * 16;
                    if (articleWidth > maxWidth) {
                        maxWidth = articleWidth;
                    }
                    graphics.drawRoundRect((this.screenWidth - maxWidth) / 2, yDrawingPos, maxWidth, this.articleFont.getHeight(), 10, 10);
                    addEditCommand = true;
                }
                if (drawingArticle.size() > 1) {
                    graphics.drawImage(this.ARROW_LEFT, (this.screenWidth - drawingArticle.maxItemsSize) / 2 - 3, yPos, 10);
                    graphics.drawImage(this.ARROW_RIGHT, (this.screenWidth + drawingArticle.maxItemsSize) / 2 + 3, yPos, 6);
                }
            } else {
                graphics.setColor(0xFFFFFF);
            }
            graphics.drawString(printMe, this.screenWidth / 2, yDrawingPos, 17);
            ++i;
        }
        if (this.doEdit) {
            this.drawCommands(graphics, "Ok", "Clear");
        } else if (addEditCommand) {
            this.drawCommands(graphics, "", "Edit");
        } else {
            this.drawCommands(graphics, this.leftCommand, this.rightCommand);
        }
        if (this.list.size() > this.baseIndex + this.articleNumPerPage) {
            graphics.drawImage(this.ARROW_DOWN, this.screenWidth / 2, this.screenHeight, 40);
        }
        if (this.baseIndex > 0) {
            graphics.drawImage(this.ARROW_UP, this.screenWidth / 2, this.screenHeight, 36);
        }
    }

    private void setBaseIndex() {
        if (this.YIndex >= this.baseIndex + this.articleNumPerPage) {
            this.baseIndex = this.YIndex - this.articleNumPerPage + 1;
        }
        if (this.YIndex < this.baseIndex) {
            this.baseIndex = this.YIndex;
        }
    }

    public void setCommands(String left, String right) {
        this.leftCommand = left;
        this.rightCommand = right;
    }

    public void setHeadItem(int rootIndex, int itemInex) {
        ((Article)this.list.elementAt(rootIndex)).XIndex = itemInex;
        this.repaint();
    }

    public void appendRoot(String firstItem, int fieldType) {
        this.list.addElement(new Article(firstItem, fieldType));
        this.repaint();
    }

    public void appendItem(String item, int FieldType) {
        Article lastArticle = (Article)this.list.lastElement();
        lastArticle.append(item, FieldType);
    }

    public int size() {
        return this.list.size();
    }

    public void removeRoot(int index) {
        this.list.removeElementAt(index);
    }

    public String getLeftCommand() {
        return this.leftCommand;
    }

    public String getRightCommand() {
        return this.rightCommand;
    }

    public int getSelectedRoot() {
        return this.YIndex;
    }

    public String readData(int rootIndex, int itemIndex) {
        Article selectedArticle = (Article)this.list.elementAt(rootIndex);
        return selectedArticle.getString(itemIndex);
    }

    public int getSelectedItem(int rootIndex) {
        Article article = (Article)this.list.elementAt(rootIndex);
        return article.XIndex;
    }

    private void drawBackground(Graphics graphics) {
        graphics.drawImage(this.backGround, this.screenWidth / 2, this.screenHeight / 2, 3);
    }

    private void drawCommands(Graphics graphics, String left, String right) {
        graphics.setFont(this.COMMAND_FONT);
        graphics.setColor(255);
        graphics.drawString(left, 0, this.screenHeight, 36);
        graphics.drawString(right, this.screenWidth, this.screenHeight, 40);
    }

    private void removeAll() {
        this.list.removeAllElements();
        this.YIndex = 0;
        this.baseIndex = 0;
    }

    public void gotoStartGameMenu() {
        this.removeAll();
        this.listener = new StartGameMenu(this.midlet);
    }

    public void gotoTopMenu() {
        this.articleFont = Font.getFont((int)0, (int)1, (int)0);
        this.removeAll();
        this.listener = new TopMenu(this.midlet);
    }

    public void gotoLoadGameMenu() {
        this.removeAll();
        this.listener = new LoadGameMenu(this.midlet);
    }

    public void gotoAboutMenu() {
        this.articleFont = Font.getFont((int)0, (int)0, (int)8);
        this.removeAll();
        this.listener = new AboutMenu(this.midlet);
    }

    public void gotoServiceDiscoveryMenu(String uuidString, int inquiryAccessCode, KeyPlayer keyPlayer, String gameName) {
        this.removeAll();
        this.listener = new ServiceDiscoveryMenu(uuidString, inquiryAccessCode, this.midlet, keyPlayer, gameName);
    }

    public void gotoWaitingMenu(KeyPlayer keyPlayer, String gameName) {
        this.removeAll();
        this.listener = new WaitingMenu(this.midlet, keyPlayer, gameName);
    }

    public void gotoAreUSureMenu(String message) {
        this.removeAll();
        this.listener = new AreUSureMenu(this, this.listener, message);
    }

    public void gotoPauseMenu(PlayerManager playerManager) {
        this.removeAll();
        this.listener = new PauseMenu(playerManager, this.midlet);
    }

    public void gotoOptionMenu(GameRecords record) {
        this.removeAll();
        this.listener = new OptionMenu(this, record);
    }

    public void gotoHelpMenu() {
        this.articleFont = Font.getFont((int)0, (int)1, (int)8);
        this.removeAll();
        this.listener = new HelpMenu(this);
    }

    public void startMenu() {
        this.gotoTopMenu();
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
    }

    private class Article {
        private int XIndex = 0;
        private Vector group = new Vector();
        private int maxItemsSize = 0;

        private Article(String firstItem, int fieldType) {
            this.group.addElement(new Item(firstItem, fieldType));
        }

        private void clearLastChar() {
            if (this.getString().length() > 0) {
                this.setString(this.getString().substring(0, this.getString().length() - 1));
            }
        }

        private void addChar(char addMe) {
            if (this.getString().length() < 16) {
                this.setString(String.valueOf(this.getString()) + addMe);
            }
        }

        private void append(String name, int FieldType) {
            int stringSize = Menu.this.articleFont.stringWidth(name);
            this.group.addElement(new Item(name, FieldType));
            if (this.maxItemsSize < stringSize) {
                this.maxItemsSize = stringSize;
            }
        }

        private void next() {
            this.XIndex = (this.XIndex + 1) % this.group.size();
        }

        private void previous() {
            if (--this.XIndex < 0) {
                this.XIndex = this.group.size() - 1;
            }
        }

        private char[][] getChart() {
            if (this.fielType() == 2) {
                return Menu.this.CHARACTERS;
            }
            return Menu.this.NUMBERS;
        }

        private void setString(String changeToMe) {
            ((Item)this.group.elementAt(this.XIndex)).name = changeToMe;
        }

        private String getString() {
            return ((Item)this.group.elementAt(this.XIndex)).name;
        }

        private String getString(int index) {
            return ((Item)this.group.elementAt(index)).name;
        }

        private int size() {
            return this.group.size();
        }

        private int fielType() {
            Item field = (Item)this.group.elementAt(this.XIndex);
            return field.FieldType;
        }

        private class Item {
            private String name;
            private int FieldType;

            private Item(String name, int FieldType) {
                this.name = name;
                this.FieldType = FieldType;
            }
        }
    }
}

