/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.ServiceRecord;
import javax.microedition.io.Connector;
import server.ServerConnectionHandlerListener;

public class ServerConnectionHandler
implements Runnable {
    private static final int WAIT_MILLIS = 250;
    private final ServiceRecord serviceRecord;
    private final int requiredSecurity;
    private final ServerConnectionHandlerListener listener;
    private final Hashtable sendMessages = new Hashtable();
    private L2CAPConnection connection;
    private int transmitMTU;
    private volatile boolean aborting;

    public ServerConnectionHandler(ServerConnectionHandlerListener listener, ServiceRecord serviceRecord, int requiredSecurity) {
        this.listener = listener;
        this.serviceRecord = serviceRecord;
        this.requiredSecurity = requiredSecurity;
        this.aborting = false;
        this.connection = null;
        this.transmitMTU = 0;
        listener = null;
    }

    public ServiceRecord getServiceRecord() {
        return this.serviceRecord;
    }

    public synchronized void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.aborting) {
            Object object = this;
            synchronized (object) {
                this.aborting = true;
            }
            object = this.sendMessages;
            synchronized (object) {
                this.sendMessages.notify();
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                    object = this;
                    synchronized (object) {
                        this.connection = null;
                        this.transmitMTU = 0;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMessageForSending(Integer id, byte[] data) {
        if (data.length > this.transmitMTU) {
            throw new IllegalArgumentException("Message too long: limit is " + this.transmitMTU + " bytes");
        }
        Hashtable hashtable = this.sendMessages;
        synchronized (hashtable) {
            this.sendMessages.put(id, data);
            this.sendMessages.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        url = null;
        try {
            url = this.serviceRecord.getConnectionURL(this.requiredSecurity, false);
            this.connection = (L2CAPConnection)Connector.open((String)url);
            this.transmitMTU = this.connection.getTransmitMTU();
            writer = new Writer(this);
            writeThread = new Thread(writer);
            writeThread.start();
            this.listener.handleOpen(this);
            if (true) ** GOTO lbl54
        }
        catch (IOException e) {
            this.close();
            this.listener.handleOpenError(this, "IOException :'" + e.getMessage() + "'");
            return;
        }
        catch (SecurityException e) {
            this.close();
            this.listener.handleOpenError(this, "SecurityException: '" + e.getMessage() + "'");
            return;
        }
        do {
            ready = false;
            try {
                ready = this.connection.ready();
            }
            catch (IOException e) {
                this.close();
                this.listener.handleClose(this);
            }
            length = 0;
            try {
                if (ready) {
                    mtuLength = this.connection.getReceiveMTU();
                    if (mtuLength <= 0) continue;
                    buffer = new byte[mtuLength];
                    length = this.connection.receive(buffer);
                    readData = new byte[length];
                    System.arraycopy(buffer, 0, readData, 0, length);
                    this.listener.handleReceivedMessage(this, readData);
                    continue;
                }
                try {
                    mtuLength = this;
                    synchronized (mtuLength) {
                        this.wait(250L);
                    }
                }
                catch (InterruptedException mtuLength) {}
            }
            catch (IOException e) {
                this.close();
                if (length == 0) {
                    this.listener.handleClose(this);
                    continue;
                }
                this.listener.handleErrorClose(this, e.getMessage());
            }
lbl54:
            // 7 sources

        } while (!this.aborting);
    }

    private class Writer
    implements Runnable {
        private final ServerConnectionHandler handler;

        Writer(ServerConnectionHandler handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!ServerConnectionHandler.this.aborting) {
                Enumeration e = ServerConnectionHandler.this.sendMessages.keys();
                if (e.hasMoreElements()) {
                    Integer id = (Integer)e.nextElement();
                    byte[] sendData = (byte[])ServerConnectionHandler.this.sendMessages.get(id);
                    try {
                        ServerConnectionHandler.this.connection.send(sendData);
                        ServerConnectionHandler.this.sendMessages.remove(id);
                        ServerConnectionHandler.this.listener.handleQueuedMessageWasSent(this.handler, id);
                    }
                    catch (IOException ex) {
                        ServerConnectionHandler.this.close();
                        ServerConnectionHandler.this.listener.handleErrorClose(this.handler, ex.getMessage());
                    }
                }
                Hashtable hashtable = ServerConnectionHandler.this.sendMessages;
                synchronized (hashtable) {
                    if (ServerConnectionHandler.this.sendMessages.isEmpty()) {
                        try {
                            ServerConnectionHandler.this.sendMessages.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

