/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class World {
    private static GameCanvas gameCanvas;
    public static final int RE_NOREASON = -1;
    public static final int RE_NOMOVES = 0;
    public static final int RE_TIMEUP = 1;
    public int reason4EndGame = -1;
    public int gameType;
    public int gameDifficulty;
    private int leftborder = 8;
    private int topborder = 29;
    public static final int gridSize = 8;
    Piece[][] Pieces = new Piece[8][8];
    Point selection;
    Point ready2moveSelection;
    Point hint1;
    Point hint2;
    public static boolean pictureMoving;
    public static boolean wasSwap;
    public static boolean noMoreMoves;
    private int nChain = 0;
    static int pieceSize;
    public static Random random;
    public int score;
    private static Image imageAmulets;
    private static Image bg;
    private Image blueTimeBar;
    private static Image smallBrownSquare;
    private static Image backBufferImage;
    private Graphics backBuffer;
    public long timeLeft;
    public long timeDiv = 1200L;
    public long timeNoButtonPressed = 0L;
    public static final int TIMESHOWHINT = 50;
    public static final int TIMEWAIT4HINT = 116;
    private boolean needPlaySwapbk = false;
    private boolean needPlayDisapp = false;
    private boolean needPlaySelect = false;
    private boolean needPlaySwap = false;
    private int timeDrawHint = 0;
    private boolean isFirst = true;
    private long counter = 0L;
    int selSize = 4;
    public static boolean willReturnHere;

    public static int getRandom(int low, int high) {
        if (low == high) {
            return low;
        }
        return (random.nextInt() >>> 1) % (high - low + 1) + low;
    }

    public World(int gameType, int gameDifficulty) {
        try {
            this.gameType = gameType;
            this.gameDifficulty = gameDifficulty;
            try {
                if (bg == null) {
                    bg = Image.createImage((String)"/bg1");
                }
                if (imageAmulets == null) {
                    imageAmulets = Image.createImage((String)"/ams");
                    pieceSize = imageAmulets.getHeight() / 4;
                }
                GameCanvas.getInstance.setLoadingProgress(40);
                smallBrownSquare = Image.createImage((int)pieceSize, (int)pieceSize);
                smallBrownSquare.getGraphics().drawImage(bg, -bg.getWidth() / 2, -bg.getHeight() / 2, 20);
            }
            catch (Exception e) {
                GameCanvas.addError("World.loadImages", e);
            }
            backBufferImage = Image.createImage((int)(pieceSize * 8), (int)(pieceSize * 8));
            GameCanvas.getInstance.setLoadingProgress(50);
            this.backBuffer = backBufferImage.getGraphics();
            this.reason4EndGame = -1;
            noMoreMoves = false;
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    this.Pieces[i][j] = new Piece(j, i);
                }
            }
            boolean r = this.checkRows(true);
            boolean c = this.checkColumns(true);
            while (c || r) {
                for (int i = 0; i < 8; ++i) {
                    for (int j = 0; j < 8; ++j) {
                        if (!this.Pieces[i][j].destroy) continue;
                        this.Pieces[i][j] = new Piece(j, i);
                    }
                }
                r = this.checkRows(true);
                c = this.checkColumns(true);
            }
            GameCanvas.getInstance.setLoadingProgress(60);
            this.score = 0;
            this.nChain = 0;
            this.selection = new Point(0, 0);
            this.ready2moveSelection = new Point(-3, -3);
            this.hint1 = new Point(-3, -3);
            this.hint2 = new Point(-3, -3);
            this.checkComplete();
            GameCanvas.getInstance.setLoadingProgress(70);
        }
        catch (Exception e) {
            GameCanvas.addError("World.World()", e);
        }
    }

    public void unloadImages() {
        imageAmulets = null;
        bg = null;
        this.blueTimeBar = null;
        smallBrownSquare = null;
        backBufferImage = null;
    }

    public void draw(Graphics g, int width, int height) {
        try {
            int j;
            int i;
            if (this.isFirst) {
                for (i = 0; i < 8; ++i) {
                    for (j = 0; j < 8; ++j) {
                        this.Pieces[i][j].draw(this.backBuffer);
                    }
                }
                this.isFirst = false;
            }
            if (bg != null) {
                g.drawImage(bg, 0, 0, 20);
            }
            for (i = 0; i < 8; ++i) {
                for (j = 0; j < 8; ++j) {
                    this.Pieces[i][j].process();
                    if (!this.Pieces[i][j].isSelected && !this.Pieces[i][j].isMoving && this.Pieces[i][j].pictureNum == 1 && !this.Pieces[i][j].isJastMoved) continue;
                    this.backBuffer.drawImage(smallBrownSquare, j * pieceSize, i * pieceSize, 20);
                }
            }
            for (i = 0; i < 8; ++i) {
                for (j = 0; j < 8; ++j) {
                    if (!this.Pieces[i][j].isSelected && !this.Pieces[i][j].isMoving && this.Pieces[i][j].pictureNumChange == 0 && this.Pieces[i][j].pictureNum == 1 && !this.Pieces[i][j].isJastMoved) continue;
                    this.Pieces[i][j].draw(this.backBuffer);
                    if (!this.Pieces[i][j].isJastMoved) continue;
                    this.Pieces[i][j].isJastMoved = false;
                }
            }
            g.drawImage(backBufferImage, this.leftborder, this.topborder, 20);
            if (!pictureMoving && !willReturnHere) {
                this.drawSelections(g, width, height);
            }
            if (this.gameType == 0) {
                this.drawTimeProgress(g);
            }
            this.drawScore(g, width, height);
            ++this.counter;
            if (this.timeDrawHint > 0 && this.counter % 8L > 3L) {
                this.Pieces[this.hint1.y][this.hint1.x].isSelected = true;
                this.Pieces[this.hint2.y][this.hint2.x].isSelected = true;
            } else if (this.Pieces[this.hint1.y][this.hint1.x].isSelected && this.Pieces[this.hint2.y][this.hint2.x].isSelected) {
                this.Pieces[this.hint1.y][this.hint1.x].isSelected = false;
                this.Pieces[this.hint2.y][this.hint2.x].isSelected = false;
            }
            g.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
        }
        catch (Exception e) {
            GameCanvas.addError("World.draw()", e);
        }
    }

    private void drawSelections(Graphics g, int width, int height) {
        int d = 1;
        g.setColor(255, 255, 0);
        g.fillRect(this.leftborder + pieceSize * this.selection.x, this.topborder + pieceSize * this.selection.y, this.selSize, this.selSize);
        g.fillRect(this.leftborder + pieceSize * this.selection.x, this.topborder + pieceSize * this.selection.y + pieceSize - this.selSize - d, this.selSize, this.selSize);
        g.fillRect(this.leftborder + pieceSize * this.selection.x + pieceSize - this.selSize - d, this.topborder + pieceSize * this.selection.y, this.selSize, this.selSize);
        g.fillRect(this.leftborder + pieceSize * this.selection.x + pieceSize - this.selSize - d, this.topborder + pieceSize * this.selection.y + pieceSize - this.selSize - d, this.selSize, this.selSize);
        g.setColor(255, 0, 0);
        g.drawRect(this.leftborder + pieceSize * this.selection.x, this.topborder + pieceSize * this.selection.y, this.selSize, this.selSize);
        g.drawRect(this.leftborder + pieceSize * this.selection.x, this.topborder + pieceSize * this.selection.y + pieceSize - this.selSize - d, this.selSize, this.selSize);
        g.drawRect(this.leftborder + pieceSize * this.selection.x + pieceSize - this.selSize - d, this.topborder + pieceSize * this.selection.y, this.selSize, this.selSize);
        g.drawRect(this.leftborder + pieceSize * this.selection.x + pieceSize - this.selSize - d, this.topborder + pieceSize * this.selection.y + pieceSize - this.selSize - d, this.selSize, this.selSize);
        if (this.ready2moveSelection.x != -3) {
            this.Pieces[this.ready2moveSelection.y][this.ready2moveSelection.x].isSelected = true;
            g.setColor(255, 0, 0);
            g.fillRect(this.leftborder + pieceSize * this.ready2moveSelection.x, this.topborder + pieceSize * this.ready2moveSelection.y, this.selSize, this.selSize);
            g.fillRect(this.leftborder + pieceSize * this.ready2moveSelection.x + pieceSize - this.selSize - d, this.topborder + pieceSize * this.ready2moveSelection.y, this.selSize, this.selSize);
            g.fillRect(this.leftborder + pieceSize * this.ready2moveSelection.x + pieceSize - this.selSize - d, this.topborder + pieceSize * this.ready2moveSelection.y + pieceSize - this.selSize - d, this.selSize, this.selSize);
            g.fillRect(this.leftborder + pieceSize * this.ready2moveSelection.x, this.topborder + pieceSize * this.ready2moveSelection.y + pieceSize - this.selSize - d, this.selSize, this.selSize);
            g.setColor(255, 255, 0);
            g.drawRect(this.leftborder + pieceSize * this.ready2moveSelection.x, this.topborder + pieceSize * this.ready2moveSelection.y, this.selSize, this.selSize);
            g.drawRect(this.leftborder + pieceSize * this.ready2moveSelection.x + pieceSize - this.selSize - d, this.topborder + pieceSize * this.ready2moveSelection.y, this.selSize, this.selSize);
            g.drawRect(this.leftborder + pieceSize * this.ready2moveSelection.x + pieceSize - this.selSize - d, this.topborder + pieceSize * this.ready2moveSelection.y + pieceSize - this.selSize - d, this.selSize, this.selSize);
            g.drawRect(this.leftborder + pieceSize * this.ready2moveSelection.x, this.topborder + pieceSize * this.ready2moveSelection.y + pieceSize - this.selSize - d, this.selSize, this.selSize);
        }
    }

    public void drawTimeProgress(Graphics g) {
        if (this.blueTimeBar == null) {
            this.blueTimeBar = Image.createImage((int)100, (int)3);
            Graphics someGraphics = this.blueTimeBar.getGraphics();
            someGraphics.setColor(2045527);
            someGraphics.fillRect(0, 0, 100, 3);
        }
        g.setClip(0, 0, (int)(this.timeLeft / this.timeDiv), GameCanvas.HEIGHT);
        g.drawImage(this.blueTimeBar, this.leftborder + 1, GameCanvas.HEIGHT - 21, 20);
        g.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
    }

    public void drawHint(Graphics g, int width, int height) {
        g.setColor(0, 255, 255);
        g.drawRect(this.leftborder + pieceSize * this.hint1.x, this.topborder + pieceSize * this.hint1.y, pieceSize - 1, pieceSize - 1);
        g.drawRect(this.leftborder + pieceSize * this.hint1.x - 1, this.topborder + pieceSize * this.hint1.y - 1, pieceSize + 1, pieceSize + 1);
        g.drawRect(this.leftborder + pieceSize * this.hint2.x, this.topborder + pieceSize * this.hint2.y, pieceSize - 1, pieceSize - 1);
        g.drawRect(this.leftborder + pieceSize * this.hint2.x - 1, this.topborder + pieceSize * this.hint2.y - 1, pieceSize + 1, pieceSize + 1);
    }

    public void drawHint1(Graphics g, int width, int height) {
        g.setColor(0, 255, 255);
        g.drawRect(this.leftborder + pieceSize * this.hint1.x, this.topborder + pieceSize * this.hint1.y, pieceSize - 1, pieceSize - 1);
        g.drawRect(this.leftborder + pieceSize * this.hint1.x - 1, this.topborder + pieceSize * this.hint1.y - 1, pieceSize + 1, pieceSize + 1);
    }

    public void drawHint2(Graphics g, int width, int height) {
        g.setColor(0, 255, 255);
        g.drawRect(this.leftborder + pieceSize * this.hint2.x, this.topborder + pieceSize * this.hint2.y, pieceSize - 1, pieceSize - 1);
        g.drawRect(this.leftborder + pieceSize * this.hint2.x - 1, this.topborder + pieceSize * this.hint2.y - 1, pieceSize + 1, pieceSize + 1);
    }

    public void drawScore(Graphics g, int width, int height) {
        g.setColor(255, 255, 255);
        GameFont.drawString(String.valueOf(this.score), g, width - 38 - GameFont.getStrWidth(String.valueOf(this.score), 1) / 2, height - 24, 1);
    }

    private void swap() {
        this.Pieces[this.selection.y][this.selection.x].isMoving = true;
        this.Pieces[this.ready2moveSelection.y][this.ready2moveSelection.x].isMoving = true;
        if (this.Pieces[this.selection.y][this.selection.x].nX == this.Pieces[this.ready2moveSelection.y][this.ready2moveSelection.x].nX) {
            this.Pieces[this.selection.y][this.selection.x].newnY = this.ready2moveSelection.y;
            this.Pieces[this.ready2moveSelection.y][this.ready2moveSelection.x].newnY = this.selection.y;
            this.Pieces[this.selection.y][this.selection.x].moveDir = this.Pieces[this.selection.y][this.selection.x].nY < this.Pieces[this.selection.y][this.selection.x].newnY ? 2 : 4;
            this.Pieces[this.ready2moveSelection.y][this.ready2moveSelection.x].moveDir = this.Pieces[this.selection.y][this.selection.x].moveDir == 2 ? 4 : 2;
        } else {
            this.Pieces[this.selection.y][this.selection.x].newnX = this.ready2moveSelection.x;
            this.Pieces[this.ready2moveSelection.y][this.ready2moveSelection.x].newnX = this.selection.x;
            this.Pieces[this.selection.y][this.selection.x].moveDir = this.Pieces[this.selection.y][this.selection.x].nX < this.Pieces[this.selection.y][this.selection.x].newnX ? 1 : 3;
            this.Pieces[this.ready2moveSelection.y][this.ready2moveSelection.x].moveDir = this.Pieces[this.selection.y][this.selection.x].moveDir == 1 ? 3 : 1;
        }
        Piece buf = this.Pieces[this.selection.y][this.selection.x];
        this.Pieces[this.selection.y][this.selection.x] = this.Pieces[this.ready2moveSelection.y][this.ready2moveSelection.x];
        this.Pieces[this.ready2moveSelection.y][this.ready2moveSelection.x] = buf;
    }

    public void process() {
        boolean canDestroy;
        if (this.timeLeft <= 0L && this.gameType == 0) {
            this.reason4EndGame = 1;
        }
        if (!pictureMoving && !willReturnHere) {
            return;
        }
        if (!willReturnHere) {
            int j;
            int i;
            for (i = 0; i < 8; ++i) {
                for (j = 0; j < 8; ++j) {
                    if (!this.Pieces[i][j].isMoving) continue;
                    this.Pieces[i][j].move();
                }
            }
            pictureMoving = false;
            for (i = 0; i < 8; ++i) {
                for (j = 0; j < 8; ++j) {
                    if (!this.Pieces[i][j].isMoving) continue;
                    pictureMoving = true;
                    return;
                }
            }
            if (!pictureMoving) {
                willReturnHere = true;
                return;
            }
        }
        if (willReturnHere) {
            willReturnHere = false;
        }
        boolean c = this.checkColumns(true);
        boolean r = this.checkRows(true);
        boolean bl = canDestroy = c || r;
        if (wasSwap) {
            if (!canDestroy) {
                if (GameCanvas.optionsSoundOn) {
                    this.needPlaySwapbk = true;
                }
                this.swap();
                pictureMoving = true;
            } else {
                this.Pieces[this.selection.y][this.selection.x].setProperties(this.selection.y, this.selection.x);
                this.Pieces[this.ready2moveSelection.y][this.ready2moveSelection.x].setProperties(this.ready2moveSelection.y, this.ready2moveSelection.x);
                this.nChain = 0;
            }
            wasSwap = false;
            this.Pieces[this.selection.y][this.selection.x].isSelected = false;
            this.selection.setPoint(this.ready2moveSelection.x, this.ready2moveSelection.y);
            this.Pieces[this.selection.y][this.selection.x].isSelected = false;
            this.ready2moveSelection.setPoint(-3, -3);
            if (pictureMoving) {
                return;
            }
        }
        if (canDestroy) {
            if (GameCanvas.optionsSoundOn) {
                this.needPlayDisapp = true;
            }
            for (int i = 7; i > -1; --i) {
                for (int j = 0; j < 8; ++j) {
                    if (!this.Pieces[i][j].destroy) continue;
                    if (i == 0) {
                        this.Pieces[i][j] = new Piece(j, -1);
                        this.Pieces[i][j].isMoving = true;
                        this.Pieces[i][j].moveDir = 2;
                        this.Pieces[i][j].newnY = 0;
                        continue;
                    }
                    int m = i;
                    for (int k = i - 1; k > -1; --k) {
                        if (!this.Pieces[k][j].destroy) {
                            this.Pieces[k][j].isMoving = true;
                            this.Pieces[k][j].moveDir = 2;
                            this.Pieces[k][j].newnY = this.Pieces[m][j].nY;
                            this.Pieces[m][j] = this.Pieces[k][j];
                            --m;
                            continue;
                        }
                        this.Pieces[k][j].destroy = false;
                    }
                    int cnt = 1;
                    while (m > -1) {
                        this.Pieces[m][j] = new Piece(j, -cnt);
                        this.Pieces[m][j].setCoords(pieceSize * j, pieceSize * -cnt - 3 * cnt * cnt);
                        this.Pieces[m][j].isMoving = true;
                        this.Pieces[m][j].moveDir = 2;
                        this.Pieces[m][j].newnY = m;
                        ++cnt;
                        --m;
                    }
                }
            }
            ++this.nChain;
            pictureMoving = true;
        } else {
            this.checkComplete();
            if (noMoreMoves) {
                this.reason4EndGame = 0;
            }
            this.nChain = 0;
        }
    }

    public void up() {
        this.timeNoButtonPressed = 0L;
        this.timeDrawHint = 0;
        if (pictureMoving) {
            return;
        }
        --this.selection.y;
        if (this.selection.y < 0) {
            this.selection.y = 7;
        }
    }

    public void down() {
        this.timeNoButtonPressed = 0L;
        this.timeDrawHint = 0;
        if (pictureMoving) {
            return;
        }
        ++this.selection.y;
        if (this.selection.y > 7) {
            this.selection.y = 0;
        }
    }

    public void left() {
        this.timeNoButtonPressed = 0L;
        this.timeDrawHint = 0;
        if (pictureMoving) {
            return;
        }
        --this.selection.x;
        if (this.selection.x < 0) {
            this.selection.x = 7;
        }
    }

    public void right() {
        this.timeNoButtonPressed = 0L;
        this.timeDrawHint = 0;
        if (pictureMoving) {
            return;
        }
        ++this.selection.x;
        if (this.selection.x > 7) {
            this.selection.x = 0;
        }
    }

    public void fire() {
        this.timeNoButtonPressed = 0L;
        this.timeDrawHint = 0;
        if (pictureMoving) {
            return;
        }
        if (this.ready2moveSelection.x == this.selection.x && this.ready2moveSelection.y == this.selection.y || this.ready2moveSelection.x == -3) {
            if (this.ready2moveSelection.x == -3) {
                this.ready2moveSelection.setPoint(this.selection.x, this.selection.y);
            } else {
                this.Pieces[this.ready2moveSelection.y][this.ready2moveSelection.x].isSelected = false;
                this.ready2moveSelection.setPoint(-3, -3);
            }
            if (GameCanvas.optionsSoundOn) {
                this.needPlaySelect = true;
            }
        } else if (this.near(this.selection, this.ready2moveSelection)) {
            if (GameCanvas.optionsSoundOn) {
                this.needPlaySwap = true;
            }
            this.swap();
            pictureMoving = true;
            wasSwap = true;
        } else {
            this.Pieces[this.ready2moveSelection.y][this.ready2moveSelection.x].isSelected = false;
            this.ready2moveSelection.setPoint(-3, -3);
        }
    }

    public void showHint() {
        this.timeNoButtonPressed = 0L;
        if (wasSwap || pictureMoving || willReturnHere) {
            return;
        }
        this.timeDrawHint = 50;
        this.score -= 20;
        if (this.score < 0) {
            this.score = 0;
        }
    }

    private boolean near(Point selection1, Point selection2) {
        if (Math.abs(selection1.x - selection2.x) == 1 && Math.abs(selection1.y - selection2.y) == 1) {
            return false;
        }
        return Math.abs(selection1.x - selection2.x) == 1 && Math.abs(selection1.y - selection2.y) == 0 || Math.abs(selection1.y - selection2.y) == 1 && Math.abs(selection1.x - selection2.x) == 0;
    }

    private boolean checkRows(boolean destroy) {
        boolean result = false;
        int chainLength = 1;
        int prevType = this.Pieces[0][0].type;
        for (int i = 0; i < 8; ++i) {
            chainLength = 1;
            prevType = this.Pieces[i][0].type;
            for (int j = 0; j < 8; ++j) {
                if (this.Pieces[i][j].type == prevType && j != 0) {
                    if (++chainLength < 3) continue;
                    result = true;
                    if (destroy) {
                        ++this.nChain;
                        this.Pieces[i][j].destroy = true;
                        this.Pieces[i][j - 1].destroy = true;
                        this.Pieces[i][j - 2].destroy = true;
                        if (chainLength > 3) {
                            this.score += 3 * (chainLength - 1) * (this.nChain - 1) * (this.gameDifficulty + 1);
                            Game.addTime += Game.addTime + 5000L;
                            continue;
                        }
                        this.score += 3 * chainLength * this.nChain * (this.gameDifficulty + 1);
                        Game.addTime += Game.addTime + 2000L;
                        continue;
                    }
                    return true;
                }
                chainLength = 1;
                prevType = this.Pieces[i][j].type;
            }
        }
        return result;
    }

    private boolean checkColumns(boolean destroy) {
        boolean result = false;
        int chainLength = 1;
        int prevType = this.Pieces[0][0].type;
        for (int j = 0; j < 8; ++j) {
            chainLength = 1;
            prevType = this.Pieces[0][j].type;
            for (int i = 0; i < 8; ++i) {
                if (this.Pieces[i][j].type == prevType && i != 0) {
                    if (++chainLength < 3) continue;
                    result = true;
                    if (destroy) {
                        ++this.nChain;
                        this.Pieces[i][j].destroy = true;
                        this.Pieces[i - 1][j].destroy = true;
                        this.Pieces[i - 2][j].destroy = true;
                        if (chainLength > 3) {
                            this.score += 3 * (chainLength - 1) * (this.nChain - 1) * (this.gameDifficulty + 1);
                            Game.addTime += Game.addTime + 5000L;
                            continue;
                        }
                        this.score += 3 * chainLength * this.nChain * (this.gameDifficulty + 1);
                        Game.addTime += Game.addTime + 2000L;
                        continue;
                    }
                    return true;
                }
                chainLength = 1;
                prevType = this.Pieces[i][j].type;
            }
        }
        return result;
    }

    public boolean isFinished() {
        if (pictureMoving || willReturnHere || wasSwap) {
            return false;
        }
        return this.reason4EndGame != -1;
    }

    private void checkComplete() {
        Piece buf;
        int j;
        int i;
        boolean c1 = true;
        boolean r1 = true;
        boolean c2 = true;
        boolean r2 = true;
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 7; ++j) {
                buf = this.Pieces[i][j];
                this.Pieces[i][j] = this.Pieces[i][j + 1];
                this.Pieces[i][j + 1] = buf;
                c1 = this.checkColumns(false);
                if (c1) {
                    this.hint1.setPoint(j, i);
                    this.hint2.setPoint(j + 1, i);
                    buf = this.Pieces[i][j];
                    this.Pieces[i][j] = this.Pieces[i][j + 1];
                    this.Pieces[i][j + 1] = buf;
                    return;
                }
                r1 = this.checkRows(false);
                buf = this.Pieces[i][j];
                this.Pieces[i][j] = this.Pieces[i][j + 1];
                this.Pieces[i][j + 1] = buf;
                if (!r1) continue;
                this.hint1.setPoint(j, i);
                this.hint2.setPoint(j + 1, i);
                return;
            }
        }
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 8; ++j) {
                buf = this.Pieces[i][j];
                this.Pieces[i][j] = this.Pieces[i + 1][j];
                this.Pieces[i + 1][j] = buf;
                c2 = this.checkColumns(false);
                if (c2) {
                    this.hint1.setPoint(j, i);
                    this.hint2.setPoint(j, i + 1);
                    buf = this.Pieces[i][j];
                    this.Pieces[i][j] = this.Pieces[i + 1][j];
                    this.Pieces[i + 1][j] = buf;
                    return;
                }
                r2 = this.checkRows(false);
                buf = this.Pieces[i][j];
                this.Pieces[i][j] = this.Pieces[i + 1][j];
                this.Pieces[i + 1][j] = buf;
                if (!r2) continue;
                this.hint1.setPoint(j, i);
                this.hint2.setPoint(j, i + 1);
                return;
            }
        }
        noMoreMoves = true;
    }

    public void resume() {
    }

    static {
        pictureMoving = false;
        wasSwap = false;
        noMoreMoves = false;
        pieceSize = 1;
        random = new Random();
        willReturnHere = false;
    }

    class Piece {
        int x;
        int y;
        int nX;
        int nY;
        int type;
        int moveDir;
        boolean destroy = false;
        boolean isMoving = false;
        boolean isJastMoved = false;
        int newnY;
        int newnX;
        static final int dy = 15;
        static final int dx = 13;
        int size = pieceSize;
        Image img;
        public byte pictureNum = 1;
        private byte pictureNumChange = 0;
        private boolean isSelected = false;

        public Piece() {
        }

        public Piece(int nX, int nY) {
            try {
                this.type = World.getRandom(0, World.this.gameDifficulty + 5);
                this.setProperties(nY, nX);
            }
            catch (Exception e) {
                GameCanvas.addError("World.Piece.Piece()", e);
            }
        }

        public void setProperties(int i, int j) {
            this.setCoords(this.size * j, this.size * i);
            this.setNumbersInGrid(j, i);
        }

        public void setCoords(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void setNumbersInGrid(int nX, int nY) {
            this.nX = nX;
            this.nY = nY;
        }

        public void move() {
            if (this.moveDir == 2) {
                this.y += 15;
                if (this.y >= this.size * this.newnY) {
                    this.y = this.size * this.newnY;
                    this.nY = this.newnY;
                    this.isMoving = false;
                    this.isJastMoved = true;
                }
            }
            if (this.moveDir == 4) {
                this.y -= 15;
                if (this.y <= this.size * this.newnY) {
                    this.y = this.size * this.newnY;
                    this.nY = this.newnY;
                    this.isMoving = false;
                    this.isJastMoved = true;
                }
            }
            if (this.moveDir == 1) {
                this.x += 13;
                if (this.x >= this.size * this.newnX) {
                    this.x = this.size * this.newnX;
                    this.nX = this.newnX;
                    this.isMoving = false;
                    this.isJastMoved = true;
                }
            }
            if (this.moveDir == 3) {
                this.x -= 13;
                if (this.x <= this.size * this.newnX) {
                    this.x = this.size * this.newnX;
                    this.nX = this.newnX;
                    this.isMoving = false;
                    this.isJastMoved = true;
                }
            }
        }

        public void process() {
            if (World.getRandom(0, 2000) == 1) {
                this.pictureNumChange = 1;
            }
        }

        public void draw(Graphics g) {
            try {
                if (this.type < World.this.gameDifficulty + 6) {
                    if (!this.isSelected) {
                        this.pictureNum = (byte)(this.pictureNum + this.pictureNumChange);
                        if (this.pictureNum == 4) {
                            this.pictureNum = (byte)3;
                            this.pictureNumChange = (byte)-1;
                        }
                        if (this.pictureNum == 0) {
                            this.pictureNum = 1;
                            this.pictureNumChange = 0;
                        }
                    } else {
                        this.pictureNum = 0;
                        this.pictureNumChange = 1;
                    }
                    if (imageAmulets != null) {
                        if (this.y >= 0) {
                            g.setClip(this.x, this.y, pieceSize, pieceSize);
                        } else if (this.y + pieceSize >= 0) {
                            g.setClip(this.x, 0, pieceSize, pieceSize - (0 - this.y));
                        } else {
                            g.setClip(0, 0, 0, 0);
                        }
                        g.drawImage(imageAmulets, this.x - pieceSize * this.type, this.y - pieceSize * this.pictureNum, 20);
                        g.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
                        return;
                    }
                }
            }
            catch (Exception e) {
                GameCanvas.addError("World.Piece.draw()", e);
            }
        }
    }

    class Point {
        int x;
        int y;

        public Point() {
        }

        public Point(int x, int y) {
            this.setPoint(x, y);
        }

        public void setPoint(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

