/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class GameCanvas
extends Canvas
implements Runnable {
    public Display display;
    public GameMidlet midlet;
    private Menu menu;
    private Game game;
    private Localization local;
    public static GameCanvas getInstance;
    public static long frameTime;
    public static final int FRAME_DURATION_FOR_PAUSE = 5000;
    public static int WIDTH;
    public static int HEIGHT;
    public static final int KEY_JOY_UP = -1;
    public static final int KEY_JOY_DOWN = -2;
    public static final int KEY_JOY_LEFT = -3;
    public static final int KEY_JOY_RIGHT = -4;
    public static final int KEY_FIRE = -5;
    public static final int KEY_LEFT_SOFT = -6;
    public static final int KEY_RIGHT_SOFT = -7;
    public static final int KEY_C = -8;
    public static final int KEY_BACK = -7;
    public static final int KEY_RED_BUTTON = -123654;
    public static boolean primeStart;
    public static final int GAME_TYPE_TRIAL = 0;
    private static final byte STATE_GAME = 1;
    private static final byte STATE_MENU = 2;
    private static final byte STATE_EXIT = 3;
    public static final byte TRANSITION_NONE = 0;
    public static final byte TRANSITION_MENU_MAIN = 1;
    public static final byte TRANSITION_MENU_HI_SCORES = 2;
    public static final byte TRANSITION_MENU_TELLAFRIEND = 3;
    public static final byte TRANSITION_MENU_MOREGAMES = 4;
    public static final byte TRANSITION_GAME_NEW = 5;
    public static final byte TRANSITION_GAME_CONTINUE = 6;
    public static final byte TRANSITION_EXIT = 7;
    public static int state;
    private boolean paused = true;
    private boolean isFirstLoad = true;
    private boolean isLoading = false;
    private int loadingPercent = 0;
    private int exitingCounter = 0;
    private long loadingFrameControl = 0L;
    private boolean isFirstLoadingControl = true;
    public static final int FRAME_DURATION = 60;
    public static final int OPTIONS_POS_NUM = 4;
    public static final int GAME_LEVELS_NUM = 5;
    public static final int GAME_TYPES_NUM = 2;
    public static final int GAME_DIFFICULTY_NUM = 3;
    public static final int LANGUAGES_NUM = 1;
    public static final int HI_SCORES_POS_NUM = 5;
    public static final int PLAYERNAME_LENGTH = 7;
    public static long[][] scores;
    public static String[][] playerNames;
    public static int[] maxLevelAvailable;
    private static char[] lastPlayerName;
    public static int optionsGameLevel;
    public static int optionsGameType;
    public static int optionsGameDifficulty;
    public static boolean optionsSoundOn;
    public static boolean optionsMusicOn;
    public static boolean isGameHasConitnue;
    public static int currentGameType;
    public static int optionsLanguage;
    private static final int keyQueueSize = 10;
    private int[] keyCodeQueue = new int[10];
    private boolean[] keyActionQueue = new boolean[10];
    public static int keyCodeQueueMarker;
    public static Snd soundPlayer;
    public static long user_highscore;
    public static int quantityAppStart;
    public static int quantityTellAFriend;
    public static int quantityMoreGames;
    public static int gc_counter;
    public static int tick_counter;
    public static int load_counter;
    public static Image imageLogo;
    private static final String RS_NAME_SETTINGS = "ChristmasMystery_S";
    private static final String RS_NAME_GAME = "ChristmasMystery_G";
    private static String errorString;

    public GameCanvas(GameMidlet m) {
        this.setFullScreenMode(true);
        getInstance = this;
        primeStart = true;
        this.midlet = m;
        tick_counter = 0;
        load_counter = 0;
        ++quantityAppStart;
        new Thread(this).start();
    }

    public synchronized void paint(Graphics g) {
        block20: {
            try {
                if (load_counter < 4) {
                    this.isLoading = false;
                    switch (load_counter++) {
                        case 0: {
                            try {
                                imageLogo = Image.createImage((String)"/logo");
                            }
                            catch (Exception e) {
                                System.out.println("ERROR!!!   /logo");
                            }
                            g.setClip(0, 0, WIDTH, HEIGHT);
                            g.setColor(51);
                            g.fillRect(0, 0, WIDTH, HEIGHT);
                            g.drawImage(imageLogo, WIDTH / 2, HEIGHT / 2, 3);
                            break;
                        }
                        case 1: 
                        case 2: {
                            g.setColor(51);
                            g.fillRect(0, 0, WIDTH, HEIGHT);
                            g.drawImage(imageLogo, WIDTH / 2, HEIGHT / 2, 3);
                            break;
                        }
                        case 3: {
                            try {
                                imageLogo = Image.createImage((String)"/lft");
                            }
                            catch (Exception e) {
                                System.out.println("ERROR!!!   /lft");
                            }
                            g.drawImage(imageLogo, WIDTH / 2, HEIGHT / 2, 3);
                            Localization.Load();
                            this.loadSettings();
                            Localization.Load();
                            soundPlayer = new Snd();
                            GameFont.initFont();
                            this.menu = new Menu(isGameHasConitnue, this.midlet);
                            this.menu.menuInit();
                            state = 2;
                        }
                    }
                    break block20;
                }
                if (state == 3) {
                    ++this.exitingCounter;
                    if (this.exitingCounter == 2) {
                        this.midlet.notifyDestroyed();
                    }
                    return;
                }
                if (GameCanvas.isError()) {
                    GameCanvas.showError(g);
                    return;
                }
                if (this.isLoading) {
                    this.showLoading(g);
                    return;
                }
                keyCodeQueueMarker = 0;
                switch (state) {
                    case 2: {
                        this.menu.draw(g);
                        break;
                    }
                    case 1: {
                        this.game.draw(g, WIDTH, HEIGHT);
                        g.setColor(0xFF0000);
                    }
                }
            }
            catch (Exception e) {
                GameCanvas.addError("GameCanvas.paint", e);
            }
        }
    }

    public void keyPressed(int aKeyCode) {
        if (state == 3 || this.isLoading) {
            return;
        }
        if (GameCanvas.isError()) {
            GameCanvas.resetError();
        }
        if (keyCodeQueueMarker < 10) {
            this.keyCodeQueue[GameCanvas.keyCodeQueueMarker] = aKeyCode;
            this.keyActionQueue[GameCanvas.keyCodeQueueMarker] = true;
            ++keyCodeQueueMarker;
        }
    }

    public void keyReleased(int aKeyCode) {
        if (state == 3 || this.isLoading) {
            return;
        }
        if (keyCodeQueueMarker < 10) {
            this.keyCodeQueue[GameCanvas.keyCodeQueueMarker] = aKeyCode;
            this.keyActionQueue[GameCanvas.keyCodeQueueMarker] = false;
            ++keyCodeQueueMarker;
        }
    }

    public void keyReaction(int keyCode, boolean isPressed) {
        if (state == 3) {
            return;
        }
        int gameAction = 0;
        try {
            gameAction = this.getGameAction(keyCode);
            if (gameAction == 8 && (keyCode == -7 || keyCode == -6)) {
                gameAction = 0;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int transition = 0;
        switch (state) {
            case 2: {
                transition = this.menu.processKey(keyCode, gameAction, isPressed);
                break;
            }
            case 1: {
                transition = this.game.processKey(keyCode, gameAction, isPressed);
            }
        }
        switch (transition) {
            case 6: {
                getInstance.setLoadingProgress(10);
                this.menu = null;
                System.gc();
                getInstance.setLoadingProgress(30);
                if (this.game == null) {
                    System.out.println("game == null");
                    this.game = new Game(optionsGameType, optionsGameDifficulty, true);
                    this.loadGame();
                }
                state = 1;
                this.game.resume();
                getInstance.setLoadingProgress(100);
                break;
            }
            case 5: {
                getInstance.setLoadingProgress(10);
                this.menu = null;
                this.game = null;
                System.gc();
                getInstance.setLoadingProgress(30);
                this.game = new Game(optionsGameType, optionsGameDifficulty, false);
                isGameHasConitnue = true;
                state = 1;
                this.game.resume();
                getInstance.setLoadingProgress(100);
                break;
            }
            case 1: {
                getInstance.setLoadingProgress(10);
                if (this.game.isGameFinished()) {
                    isGameHasConitnue = false;
                    GameCanvas.saveSettings();
                } else {
                    this.saveGame();
                }
                getInstance.setLoadingProgress(15);
                this.game = null;
                System.gc();
                getInstance.setLoadingProgress(20);
                this.menu = new Menu(isGameHasConitnue, this.midlet);
                this.menu.menuInit();
                state = 2;
                getInstance.setLoadingProgress(100);
                break;
            }
            case 2: {
                getInstance.setLoadingProgress(10);
                isGameHasConitnue = false;
                this.game = null;
                System.gc();
                getInstance.setLoadingProgress(20);
                this.menu = new Menu(false, this.midlet);
                this.menu.setHiScoresState();
                this.menu.menuInit();
                state = 2;
                getInstance.setLoadingProgress(100);
                break;
            }
            case 7: {
                state = 3;
                this.exiting();
                this.menu = null;
                this.game = null;
                System.gc();
            }
        }
    }

    private void showLoading(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, WIDTH, HEIGHT);
        g.setColor(11591910);
        GameFont.drawString(Localization.gameString[Localization.LOADING][0], g, WIDTH / 2 - GameFont.getStrWidth(Localization.gameString[Localization.LOADING][0], 0) / 2, HEIGHT / 2 - GameFont.height(0), 0);
        g.drawRect(WIDTH / 4, HEIGHT / 2 + 5, WIDTH / 2, 5);
        int l = this.loadingPercent * (WIDTH / 2) / 100;
        g.fillRect(WIDTH / 4, HEIGHT / 2 + 5, l, 5);
        GameCanvas.drawSoftKeys(g, 5, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGame() {
        RecordStore rs = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        byte[] data = null;
        try {
            RecordStore.deleteRecordStore((String)RS_NAME_GAME);
            System.out.println("saveGame - new RS opened.");
        }
        catch (Exception e) {
            System.out.println("saveGame - new RS opening aborted.");
        }
        try {
            System.out.println("saveGame - writting...");
            rs = RecordStore.openRecordStore((String)RS_NAME_GAME, (boolean)true);
            this.game.save(dos);
            data = baos.toByteArray();
            rs.addRecord(data, 0, data.length);
            baos.close();
            dos.close();
            rs.closeRecordStore();
            System.out.println("saveGame ended.");
        }
        catch (Exception e) {
        }
        finally {
            rs = null;
            data = null;
            baos = null;
            dos = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGame() {
        RecordStore rs = null;
        ByteArrayInputStream bais = null;
        FilterInputStream dis = null;
        byte[] data = null;
        try {
            rs = RecordStore.openRecordStore((String)RS_NAME_GAME, (boolean)false);
        }
        catch (Exception ex) {
            System.out.println("loadGame - opening aborted.");
        }
        if (rs == null) {
            System.out.println("loadGame - rs == null.");
            isGameHasConitnue = false;
            return;
        }
        try {
            System.out.println("loadGame - reading...");
            data = rs.getRecord(1);
            bais = new ByteArrayInputStream(data);
            dis = new DataInputStream(bais);
            this.game.load((DataInputStream)dis);
            rs.closeRecordStore();
            bais.close();
            dis.close();
            System.out.println("loadGame - ended.");
        }
        catch (Exception ex) {
            try {
                rs.closeRecordStore();
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                bais.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                dis.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        finally {
            rs = null;
            data = null;
            bais = null;
            dis = null;
        }
    }

    public static char[] getLastPlayerName() {
        return lastPlayerName;
    }

    public static boolean canBeAdded(int score, int gameType) {
        return (long)score > scores[gameType][4];
    }

    private void resetSettings() {
        optionsGameType = 0;
        optionsGameDifficulty = 0;
        optionsMusicOn = false;
        optionsSoundOn = true;
        optionsLanguage = 0;
        isGameHasConitnue = false;
        GameCanvas.resetScores();
    }

    public static void resetScores() {
        user_highscore = 0L;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                GameCanvas.playerNames[i][j] = Localization.gameString[Localization.OPPONENTS_NAMES][j];
                GameCanvas.scores[i][j] = 600 * (i * 4 + 1) - j * 100 * (i * 4 + 1);
            }
            GameCanvas.maxLevelAvailable[i] = 1;
        }
        lastPlayerName = Localization.gameString[Localization.DEFAULT_PLAYER_NAME][0].toCharArray();
    }

    public static void addScore(String playerName, long score, int gameType) {
        if (score < scores[gameType][4]) {
            return;
        }
        lastPlayerName = playerName.toCharArray();
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < 5; ++i) {
                if (score <= scores[gameType][i]) continue;
                long tmp = scores[gameType][i];
                GameCanvas.scores[gameType][i] = score;
                score = tmp;
                String tmpString = playerNames[gameType][i];
                GameCanvas.playerNames[gameType][i] = playerName;
                playerName = tmpString;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSettings() {
        RecordStore rs = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        byte[] data = null;
        try {
            RecordStore.deleteRecordStore((String)RS_NAME_SETTINGS);
            System.out.println("saveSettings - delete RS");
        }
        catch (Exception e) {
            System.out.println("saveSettings - delete RS aborted.");
        }
        try {
            int i;
            System.out.println("saveSettings - writting...");
            rs = RecordStore.openRecordStore((String)RS_NAME_SETTINGS, (boolean)true);
            dos.writeInt(optionsGameType);
            dos.writeInt(optionsGameDifficulty);
            dos.writeBoolean(optionsMusicOn);
            dos.writeBoolean(optionsSoundOn);
            dos.writeBoolean(isGameHasConitnue);
            dos.writeInt(optionsLanguage);
            dos.writeInt(quantityAppStart);
            dos.writeInt(quantityTellAFriend);
            dos.writeInt(quantityMoreGames);
            char[] playerName = new char[7];
            for (i = 0; i < 2; ++i) {
                for (int j = 0; j < 5; ++j) {
                    dos.writeLong(scores[i][j]);
                    playerName = playerNames[i][j].toCharArray();
                    for (int k = 0; k < 7; ++k) {
                        dos.writeChar(playerName[k]);
                    }
                }
                dos.writeShort((short)maxLevelAvailable[i]);
            }
            for (i = 0; i < 7; ++i) {
                dos.writeChar(lastPlayerName[i]);
            }
            data = baos.toByteArray();
            rs.addRecord(data, 0, data.length);
            baos.close();
            dos.close();
            rs.closeRecordStore();
            System.out.println("saveSettings ended.");
        }
        catch (Exception e) {
        }
        finally {
            rs = null;
            data = null;
            baos = null;
            dos = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettings() {
        RecordStore rs = null;
        ByteArrayInputStream bais = null;
        FilterInputStream dis = null;
        byte[] data = null;
        try {
            rs = RecordStore.openRecordStore((String)RS_NAME_SETTINGS, (boolean)false);
        }
        catch (Exception ex) {
            try {
                rs.closeRecordStore();
            }
            catch (Exception e1) {
                // empty catch block
            }
            rs = null;
            System.out.println("loadSettings - opening aborted.");
        }
        if (rs == null) {
            System.out.println("loadSettings - creating new RS.");
            this.resetSettings();
            GameCanvas.saveSettings();
            return;
        }
        try {
            int i;
            System.out.println("loadSettings - reading...");
            data = rs.getRecord(1);
            bais = new ByteArrayInputStream(data);
            dis = new DataInputStream(bais);
            optionsGameType = ((DataInputStream)dis).readInt();
            optionsGameDifficulty = ((DataInputStream)dis).readInt();
            optionsMusicOn = ((DataInputStream)dis).readBoolean();
            optionsSoundOn = ((DataInputStream)dis).readBoolean();
            isGameHasConitnue = ((DataInputStream)dis).readBoolean();
            optionsLanguage = ((DataInputStream)dis).readInt();
            quantityAppStart = ((DataInputStream)dis).readInt();
            quantityTellAFriend = ((DataInputStream)dis).readInt();
            quantityMoreGames = ((DataInputStream)dis).readInt();
            for (i = 0; i < 2; ++i) {
                for (int j = 0; j < 5; ++j) {
                    GameCanvas.scores[i][j] = ((DataInputStream)dis).readLong();
                    GameCanvas.playerNames[i][j] = "";
                    for (int k = 0; k < 7; ++k) {
                        String[] stringArray = playerNames[i];
                        int n = j;
                        stringArray[n] = stringArray[n] + ((DataInputStream)dis).readChar();
                    }
                }
                GameCanvas.maxLevelAvailable[i] = ((DataInputStream)dis).readShort();
            }
            for (i = 0; i < 7; ++i) {
                GameCanvas.lastPlayerName[i] = ((DataInputStream)dis).readChar();
            }
            rs.closeRecordStore();
            bais.close();
            dis.close();
            System.out.println("readGameStatus ended.");
        }
        catch (Exception ex) {
            try {
                rs.closeRecordStore();
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                bais.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                dis.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        finally {
            rs = null;
            data = null;
            bais = null;
            dis = null;
        }
    }

    public static void drawSoftKeys(Graphics g, int softkey1, int softkey2) {
        if (softkey1 < Menu.iButtons.length) {
            g.drawImage(Menu.iButtons[softkey1], 0, HEIGHT - Menu.iButtons[softkey1].getHeight(), 0);
        }
        if (softkey2 < Menu.iButtons.length) {
            g.drawImage(Menu.iButtons[softkey2], WIDTH - Menu.iButtons[softkey2].getWidth(), HEIGHT - Menu.iButtons[softkey2].getHeight(), 0);
        }
    }

    public void run() {
        System.out.println("run");
        long time = System.currentTimeMillis();
        try {
            while (true) {
                long timeBuf = System.currentTimeMillis();
                frameTime = timeBuf - time;
                time = timeBuf;
                if (frameTime < 60L) {
                    time += 60L - frameTime;
                    Thread.sleep(60L - frameTime);
                    frameTime = 60L;
                }
                if (state == 1 && !World.pictureMoving && !World.willReturnHere && !Game.keyPause || state == 2 && !primeStart) {
                    for (int i = 0; i < keyCodeQueueMarker; ++i) {
                        this.keyReaction(this.keyCodeQueue[i], this.keyActionQueue[i]);
                        if (state == 3) break;
                    }
                }
                keyCodeQueueMarker = 0;
                this.repaint();
                this.serviceRepaints();
                if (++tick_counter == gc_counter) {
                    tick_counter = 0;
                    System.gc();
                }
                Thread.sleep(50L);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void exiting() {
        if (this.game != null && !this.game.isGameFinished()) {
            this.game.prepareForSave();
            this.game.pause();
            this.saveGame();
        }
        GameCanvas.saveSettings();
    }

    protected void hideNotify() {
        System.out.println("_________________hideNotify");
        System.out.println("state = " + state);
        if (state != 3) {
            this.devicePause();
        }
    }

    protected void showNotify() {
        this.deviceStart();
    }

    void devicePause() {
        System.out.println("devicePause");
        if (this.paused) {
            return;
        }
        this.paused = true;
        if (this.menu != null) {
            this.menu.pause();
        }
        if (this.game != null) {
            this.game.pause();
            this.saveGame();
        }
        this.repaint();
    }

    void deviceStart() {
        System.out.println("deviceStart");
        if (!this.paused) {
            return;
        }
        this.paused = false;
        this.isFirstLoad = false;
        if (this.menu != null) {
            this.menu.resume();
        }
        this.repaint();
    }

    public void setLoadingProgress(int loadingPercent) {
        if (this.isLoading) {
            this.loadingPercent = loadingPercent;
            if (loadingPercent >= 100 || !this.isLoading) {
                loadingPercent = 0;
                this.isLoading = false;
            } else {
                this.loadingFrameControl = System.currentTimeMillis() - this.loadingFrameControl;
                if (this.loadingFrameControl > 60L) {
                    this.repaint();
                    this.serviceRepaints();
                }
                this.loadingFrameControl = System.currentTimeMillis();
            }
        }
    }

    public static boolean isError() {
        return !errorString.equals("");
    }

    public static void addError(String str, Exception e) {
        errorString = errorString + str + "\n";
        System.out.println("Error added : " + str + " " + e.toString());
    }

    public static void showError(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 400, 400);
        g.setColor(0xFFFFFF);
        int lastPos = 0;
        int line = 0;
        GameFont.drawString("Error!", g, 10, 10, 0);
        try {
            for (int i = 0; i < errorString.length(); ++i) {
                if (errorString.charAt(i) != '\n') continue;
                GameFont.drawString("Error : " + errorString.substring(lastPos, i), g, 5, 30 + 20 * line++, 0);
                lastPos = i;
            }
        }
        catch (Exception e) {
            System.out.println("showError - Error !!! " + e.toString());
        }
    }

    public static void resetError() {
        errorString = "";
    }

    static {
        frameTime = 0L;
        WIDTH = 176;
        HEIGHT = 220;
        primeStart = true;
        state = 2;
        scores = new long[2][5];
        playerNames = new String[2][5];
        maxLevelAvailable = new int[2];
        lastPlayerName = new char[7];
        optionsGameLevel = 0;
        optionsGameType = 0;
        optionsGameDifficulty = 0;
        optionsSoundOn = true;
        optionsMusicOn = false;
        isGameHasConitnue = false;
        currentGameType = 0;
        optionsLanguage = 0;
        keyCodeQueueMarker = 0;
        soundPlayer = null;
        user_highscore = 0L;
        quantityAppStart = 0;
        quantityTellAFriend = 0;
        quantityMoreGames = 0;
        gc_counter = 90;
        imageLogo = null;
        errorString = "";
    }
}

